/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.BasicModelRegistry;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.SynchronizeHandler;
import com.intellij.database.actions.ActionStatus;
import com.intellij.database.actions.RefreshActionsLogic;
import com.intellij.database.actions.diagnostic.DiagnosticRefresh;
import com.intellij.database.dataSource.DataSourceFun;
import com.intellij.database.dataSource.DataSourceSchemaMapping;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.SyncQueue;
import com.intellij.database.introspection.DBIntrospectorFeatures;
import com.intellij.database.introspection.IndefiniteIntrospectionTask;
import com.intellij.database.introspection.IntrospectionTask;
import com.intellij.database.introspection.IntrospectionTasks;
import com.intellij.database.introspection.RunIntrospection;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModDatabase;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.HostFamily;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.DatabaseNodeWrappingService;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.structure.DvHostNode;
import com.intellij.database.view.structure.DvTreeNodeRank;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u00aa\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\u001a$\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u0001\u001a\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0001\u001a\u0014\u0010\b\u001a\u00020\u0005*\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0001\u001a\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0010\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a$\u0010\u0013\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\n\b\u0001\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0000\u001a\u001c\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a\u001a\u0015\u0010\u001c\u001a\u00020\u0005*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001bH\u0086\u0002\u001a,\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010 2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001a\u001a4\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010 2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\"2\u0006\u0010$\u001a\u00020%2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001a\u001a\u001e\u0010&\u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010 2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\"\u001a\u0018\u0010'\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\u001e\u0010(\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\u001e\u0010)\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a4\u0010*\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010$\u001a\u00020+2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000f0,H\u0002\u001a*\u0010-\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001a\u001a&\u0010.\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010$\u001a\u00020+H\u0002\u001a,\u0010/\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000f0,H\u0002\u001a(\u00100\u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010 2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020+2\u0006\u00101\u001a\u00020\u000fH\u0002\u001a\u001e\u00102\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000f03H\u0007\u001a.\u00102\u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010 2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020+2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001aH\u0007\u001a(\u00104\u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010 2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u00105\u001a\n\u0012\u0004\u0012\u000207\u0018\u000106H\u0001\u001a\u0018\u00108\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u001e\u00109\u001a\u00020\r2\u0006\u0010$\u001a\u00020+2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002\u001a \u0010:\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010;\u001a\u00020\u0005H\u0000\u001a(\u0010<\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\u00182\u0006\u0010;\u001a\u00020\u0005H\u0002\u001a0\u0010@\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010!0 2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\u00182\u0006\u0010;\u001a\u00020\u0005H\u0002\u001a \u0010<\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010A\u001a\u00020B2\u0006\u0010;\u001a\u00020\u0005H\u0002\u001a(\u0010@\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010!0 2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010A\u001a\u00020B2\u0006\u0010;\u001a\u00020\u0005H\u0002\u001a\u0012\u0010E\u001a\u0004\u0018\u00010F2\u0006\u0010G\u001a\u00020\u0015H\u0002\"\u000e\u0010C\u001a\u00020DX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"refreshCheck", "Lcom/intellij/database/actions/ActionStatus;", "ctx", "Lcom/intellij/openapi/actionSystem/DataContext;", "requireSingleDataSource", "", "requiresConnect", "checkForgetModelIsPossible", "canBeConnectedRightNow", "Lcom/intellij/database/view/DataSourceNode;", "project", "Lcom/intellij/openapi/project/Project;", "regularRefreshPerform", "", "adjustNodeToElement", "Lcom/intellij/database/model/basic/BasicElement;", "node", "Lcom/intellij/database/model/basic/BasicNode;", "diagnosticRefreshCheck", "diagnosticRefreshPerform", "progressTemplateText", "", "extendIntrospectionScopeIfNeeded", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "namespaces", "", "Lcom/intellij/database/model/basic/BasicNamespace;", "contains", "Lcom/intellij/database/util/TreePattern;", "namespace", "runRegularRefresh", "Lcom/intellij/database/util/AsyncTask;", "Lcom/intellij/database/dataSource/SyncQueue$SyncResult;", "Lcom/intellij/database/model/RawDataSource;", "elementsToRefresh", "model", "Lcom/intellij/database/model/DasModel;", "runDataSourceGeneralRefresh", "performPluginsExtensionOperations", "runInitialForLocalDataSourceWithEmptyModel", "runGeneralForLocalDataSource", "runRegularRefreshForLocalDataSourceWithModel", "Lcom/intellij/database/model/basic/BasicModel;", "Lkotlin/sequences/Sequence;", "refreshToComplete", "refreshWholeModelAutomatically", "refreshGivenElementsAutomatically", "refreshThisObject", "objectToRefresh", "refreshSpecificFragments", "", "runDbElementsRefresh", "selection", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/database/psi/DbElement;", "forgetSchemas", "forgetSchemasInOneModel", "forgetModelAndRefresh", "refresh", "doForgetModelAndRefreshForDataSource", "storage", "Lcom/intellij/database/dataSource/DataSourceStorage;", "localDataSource", "asyncForgetModelAndRefreshForDataSource", "sqlDataSource", "Lcom/intellij/sql/database/SqlDataSource;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "logFailed", "", "message", "intellij.database.impl"})
@JvmName(name="RefreshActionsLogic")
@SourceDebugExtension(value={"SMAP\nRefreshActionsLogic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RefreshActionsLogic.kt\ncom/intellij/database/actions/RefreshActionsLogic\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 DatabaseContextFun.kt\ncom/intellij/database/view/DatabaseContextFun\n*L\n1#1,574:1\n1786#2,3:575\n1512#2:578\n1538#2,3:579\n1541#2,3:589\n812#2,12:592\n1512#2:619\n1538#2,3:620\n1541#2,3:630\n383#3,7:582\n383#3,7:608\n383#3,7:623\n1011#4:604\n1041#4,3:605\n1044#4,3:615\n353#5:618\n*S KotlinDebug\n*F\n+ 1 RefreshActionsLogic.kt\ncom/intellij/database/actions/RefreshActionsLogic\n*L\n54#1:575,3\n109#1:578\n109#1:579,3\n109#1:589,3\n114#1:592,12\n465#1:619\n465#1:620,3\n465#1:630,3\n109#1:582,7\n412#1:608,7\n465#1:623,7\n412#1:604\n412#1:605,3\n412#1:615,3\n463#1:618\n*E\n"})
public final class RefreshActionsLogic {
    @NotNull
    private static final Logger logger;

    @ApiStatus.Internal
    @NotNull
    public static final ActionStatus refreshCheck(@NotNull DataContext ctx, boolean requireSingleDataSource, boolean requiresConnect) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Set<DvTreeNodeRank> ranks = DatabaseContextFun.getSelectedTreeNodeRanks(ctx);
        if (!((Collection)ranks).isEmpty()) {
            boolean bl;
            block9: {
                if (ranks.contains(DvTreeNodeRank.TL_FOLDER)) {
                    return ranks.size() == 1 ? ActionStatus.HIDDEN : ActionStatus.DISABLED;
                }
                List<DataSourceNode> dsns = DatabaseContextFun.getSelectionRelatedDataSources(ctx);
                if (dsns.isEmpty()) {
                    return ActionStatus.HIDDEN;
                }
                if (requireSingleDataSource && dsns.size() > 1) {
                    return ActionStatus.DISABLED;
                }
                Project project = DatabaseContextFun.getProject(ctx);
                if (project == null) {
                    return ActionStatus.DISABLED;
                }
                Project project2 = project;
                Iterable $this$all$iv = dsns;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        DataSourceNode it = (DataSourceNode)element$iv;
                        boolean bl2 = false;
                        if (it.isIntrospectable() && !DataSourceFun.isLoading((RawDataSource)it.dataSource, (Project)project2) && (!requiresConnect || RefreshActionsLogic.canBeConnectedRightNow(it, project2))) continue;
                        bl = false;
                        break block9;
                    }
                    bl = true;
                }
            }
            boolean allOk = bl;
            return allOk ? ActionStatus.ENABLED : ActionStatus.DISABLED;
        }
        if (!DatabaseContextFun.fromDatabaseTree(ctx)) {
            BasicElement editorObject;
            BasicElement basicElement = editorObject = DatabaseContextFun.getEditorObject(ctx);
            BasicModel model = basicElement != null ? basicElement.getModel() : null;
            return model != null ? ActionStatus.ENABLED : ActionStatus.HIDDEN;
        }
        return ActionStatus.HIDDEN;
    }

    public static /* synthetic */ ActionStatus refreshCheck$default(DataContext dataContext, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        return RefreshActionsLogic.refreshCheck(dataContext, bl, bl2);
    }

    @ApiStatus.Internal
    @NotNull
    public static final ActionStatus checkForgetModelIsPossible(@NotNull DataContext ctx) {
        boolean neg;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Set<DvTreeNodeRank> ranks = DatabaseContextFun.getSelectedTreeNodeRanks(ctx);
        boolean pos = ranks.contains(DvTreeNodeRank.TL_ROOT);
        boolean bl = neg = ranks.size() > 1;
        ActionStatus status = pos && !neg ? RefreshActionsLogic.refreshCheck(ctx, false, false) : (pos ? ActionStatus.DISABLED : ActionStatus.HIDDEN);
        return status;
    }

    private static final boolean canBeConnectedRightNow(DataSourceNode $this$canBeConnectedRightNow, Project project) {
        RawDataSource ds = $this$canBeConnectedRightNow.dataSource;
        return ds instanceof SqlDataSource ? true : (ds instanceof LocalDataSource ? DbImplUtilCore.canConnectTo((LocalDataSource)((LocalDataSource)ds), (Project)project) : false);
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    public static final void regularRefreshPerform(@NotNull Project project, @NotNull DataContext ctx) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Set<DvTreeNodeRank> ranks = DatabaseContextFun.getSelectedTreeNodeRanks(ctx);
        if (!((Collection)ranks).isEmpty()) {
            List<DataSourceNode> dsns = DatabaseContextFun.getSelectionRelatedDataSources(ctx);
            if (dsns.isEmpty()) {
                return;
            }
            if (ranks.contains(DvTreeNodeRank.TL_ROOT)) {
                for (DataSourceNode dsn : dsns) {
                    RefreshActionsLogic.runDataSourceGeneralRefresh(project, dsn.dataSource);
                }
            } else {
                Object element$iv$iv;
                Map.Entry $this$groupByTo$iv$iv2;
                void $this$groupBy$iv;
                JBIterable jBIterable = DatabaseContextFun.getSelectedNodes(ctx).filterMap(arg_0 -> RefreshActionsLogic.regularRefreshPerform$lambda$1(RefreshActionsLogic::regularRefreshPerform$lambda$0, arg_0)).filter(arg_0 -> RefreshActionsLogic.regularRefreshPerform$lambda$3(RefreshActionsLogic::regularRefreshPerform$lambda$2, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
                Iterable dsn = (Iterable)jBIterable;
                boolean $i$f$groupBy = false;
                void var7_14 = $this$groupBy$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                Iterator iterator = $this$groupByTo$iv$iv2.iterator();
                while (iterator.hasNext()) {
                    Object object;
                    void $this$getOrPut$iv$iv$iv;
                    BasicModel key$iv$iv;
                    element$iv$iv = iterator.next();
                    BasicElement it = (BasicElement)element$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it.getModel());
                    Map map2 = destination$iv$iv;
                    BasicModel key$iv$iv$iv = key$iv$iv;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl2 = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object;
                    list$iv$iv.add(element$iv$iv);
                }
                Map selection = destination$iv$iv;
                BasicModelRegistry registry = BasicModelRegistry.Companion.instance();
                for (Map.Entry $this$groupByTo$iv$iv2 : selection.entrySet()) {
                    RawDataSource ds;
                    BasicModel model = (BasicModel)$this$groupByTo$iv$iv2.getKey();
                    List elements = (List)$this$groupByTo$iv$iv2.getValue();
                    if (registry.getDataSource(model) == null) continue;
                    if (ranks.contains(DvTreeNodeRank.TL_NAMESPACE) && ds instanceof LocalDataSource) {
                        void $this$filterIsInstanceTo$iv$iv;
                        void $this$filterIsInstance$iv;
                        element$iv$iv = elements;
                        LocalDataSource localDataSource = (LocalDataSource)ds;
                        boolean $i$f$filterIsInstance = false;
                        void bl = $this$filterIsInstance$iv;
                        Collection destination$iv$iv2 = new ArrayList();
                        boolean $i$f$filterIsInstanceTo = false;
                        for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
                            if (!(element$iv$iv2 instanceof BasicNamespace)) continue;
                            destination$iv$iv2.add(element$iv$iv2);
                        }
                        RefreshActionsLogic.extendIntrospectionScopeIfNeeded(localDataSource, (List)destination$iv$iv2);
                    }
                    RefreshActionsLogic.runRegularRefresh(project, ds, (DasModel)model, elements);
                }
            }
        } else if (!DatabaseContextFun.fromDatabaseTree(ctx)) {
            BasicElement editorObject = DatabaseContextFun.getEditorObject(ctx);
            if (editorObject != null) {
                BasicModel model = editorObject.getModel();
                if (model != null) {
                    BasicSchema schema = editorObject.getSchema();
                    if (schema != null) {
                        v2 = RefreshActionsLogic.refreshThisObject(project, model, editorObject);
                    } else {
                        RawDataSource dataSource;
                        BasicModelRegistry registry = BasicModelRegistry.Companion.instance();
                        RawDataSource rawDataSource = dataSource = registry.getDataSource(model);
                        if (rawDataSource != null) {
                            v2 = RefreshActionsLogic.runRegularRefresh(project, rawDataSource, (DasModel)model, SetsKt.setOf((Object)editorObject));
                        } else {
                            throw new IllegalStateException("Cannot refresh object " + editorObject + ": no data source");
                        }
                    }
                }
                return;
            }
            logger.warn("Cannot run refresh because unknown what to refresh.");
        } else {
            logger.warn("Cannot run refresh because unknown what to refresh and what is the source of the action.");
        }
    }

    private static final BasicElement adjustNodeToElement(BasicNode node) {
        BasicNode basicNode = node;
        return basicNode instanceof BasicElement ? (BasicElement)node : (basicNode instanceof HostFamily ? ((HostFamily)node).getHost() : (basicNode instanceof DvHostNode ? ((DvHostNode)node).host : (basicNode instanceof DataSourceNode ? (BasicElement)((DataSourceNode)node).getModelRoot() : null)));
    }

    @NotNull
    public static final ActionStatus diagnosticRefreshCheck(@NotNull DataContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        return RefreshActionsLogic.refreshCheck$default(ctx, true, false, 4, null);
    }

    public static final void diagnosticRefreshPerform(@NotNull Project project, @NotNull DataContext ctx, @Nls @Nullable String progressTemplateText) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Ref.ObjectRef dataSource = new Ref.ObjectRef();
        BasicModel model = null;
        Ref.ObjectRef elementsToRefresh = new Ref.ObjectRef();
        elementsToRefresh.element = SetsKt.emptySet();
        boolean fromTree = DatabaseContextFun.fromDatabaseTree(ctx);
        if (fromTree) {
            DataSourceNode dataSourceNode = DatabaseContextFun.getSelectionRelatedSingleDataSource(ctx);
            if (dataSourceNode == null) {
                logger.warn("Diagnostic Refresh: no single related data source");
                return;
            }
            DataSourceNode dsn = dataSourceNode;
            dataSource.element = dsn.dataSource;
            model = dsn.getModel();
            List list = DatabaseContextFun.getSelectedElements(ctx).filter(arg_0 -> RefreshActionsLogic.diagnosticRefreshPerform$lambda$1(arg_0 -> RefreshActionsLogic.diagnosticRefreshPerform$lambda$0(model, arg_0), arg_0)).toList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
            elementsToRefresh.element = list;
        } else {
            BasicElement editorObject;
            BasicElement basicElement = editorObject = DatabaseContextFun.getEditorObject(ctx);
            Object object = model = basicElement != null ? basicElement.getModel() : null;
            if (editorObject != null && model != null) {
                RawDataSource ds;
                BasicModelRegistry modelRegistry = BasicModelRegistry.Companion.instance();
                RawDataSource rawDataSource = ds = modelRegistry.getDataSource(model);
                if (rawDataSource == null) {
                    logger.warn("Diagnostic Refresh: cannot get the data source of the editor object");
                    return;
                }
                dataSource.element = rawDataSource;
                elementsToRefresh.element = CollectionsKt.listOf((Object)editorObject);
            }
        }
        if ((RawDataSource)dataSource.element == null) {
            logger.warn("Diagnostic Refresh: cannot find a data source");
            return;
        }
        if (model == null) {
            logger.warn("Diagnostic Refresh: cannot obtain a model (when the data source is: " + dataSource.element + ")");
            return;
        }
        String string = ((RawDataSource)dataSource.element).getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueId(...)");
        DiagnosticRefresh.performDiagnosticRefreshOperation(project, string, progressTemplateText, () -> RefreshActionsLogic.diagnosticRefreshPerform$lambda$2(project, dataSource, model, elementsToRefresh));
    }

    public static final void extendIntrospectionScopeIfNeeded(@NotNull LocalDataSource dataSource, @NotNull Collection<? extends BasicNamespace> namespaces) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter(namespaces, (String)"namespaces");
        if (namespaces.isEmpty()) {
            return;
        }
        TreePattern treePattern = dataSource.getIntrospectionScope();
        Intrinsics.checkNotNullExpressionValue((Object)treePattern, (String)"getIntrospectionScope(...)");
        TreePattern oldScope = treePattern;
        JBIterable jBIterable = UtilKt.asJBIterable((Iterable)namespaces).filter(arg_0 -> RefreshActionsLogic.extendIntrospectionScopeIfNeeded$lambda$1(arg_0 -> RefreshActionsLogic.extendIntrospectionScopeIfNeeded$lambda$0(oldScope, arg_0), arg_0)).map(arg_0 -> RefreshActionsLogic.extendIntrospectionScopeIfNeeded$lambda$3(RefreshActionsLogic::extendIntrospectionScopeIfNeeded$lambda$2, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"map(...)");
        JBIterable entriesToAdd = jBIterable;
        if (entriesToAdd.isEmpty()) {
            return;
        }
        Object[] objectArray = JBIterable.of((Object)oldScope).append((Iterable)entriesToAdd).toArray((Object[])new TreePattern[0]);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"toArray(...)");
        TreePattern[] newScopePatterns = (TreePattern[])objectArray;
        TreePattern treePattern2 = TreePatternUtils.union((TreePattern[])Arrays.copyOf(newScopePatterns, newScopePatterns.length));
        Intrinsics.checkNotNullExpressionValue((Object)treePattern2, (String)"union(...)");
        TreePattern newScope = treePattern2;
        dataSource.setIntrospectionScope(newScope);
    }

    public static final boolean contains(@NotNull TreePattern $this$contains, @NotNull BasicNamespace namespace) {
        Intrinsics.checkNotNullParameter((Object)$this$contains, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        return DataSourceSchemaMapping.matches((TreePattern)$this$contains, (DasObject)((DasObject)namespace));
    }

    @Nullable
    public static final AsyncTask<SyncQueue.SyncResult> runRegularRefresh(@NotNull Project project, @NotNull RawDataSource dataSource, @NotNull Collection<? extends BasicElement> elementsToRefresh) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter(elementsToRefresh, (String)"elementsToRefresh");
        DasModel dasModel = dataSource.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)dasModel, (String)"getModel(...)");
        DasModel model = dasModel;
        return RefreshActionsLogic.runRegularRefresh(project, dataSource, model, elementsToRefresh);
    }

    @Nullable
    public static final AsyncTask<SyncQueue.SyncResult> runRegularRefresh(@NotNull Project project, @NotNull RawDataSource dataSource, @NotNull DasModel model, @NotNull Collection<? extends BasicElement> elementsToRefresh) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter(elementsToRefresh, (String)"elementsToRefresh");
        RawDataSource rawDataSource = dataSource;
        if (rawDataSource instanceof LocalDataSource) {
            return model instanceof BasicModel ? RefreshActionsLogic.runRegularRefreshForLocalDataSourceWithModel(project, (LocalDataSource)dataSource, (BasicModel)model, (Sequence<? extends BasicElement>)CollectionsKt.asSequence((Iterable)elementsToRefresh)) : (Intrinsics.areEqual((Object)model.getMetaModel(), (Object)MetaModel.EMPTY) ? RefreshActionsLogic.runInitialForLocalDataSourceWithEmptyModel(project, (LocalDataSource)dataSource) : (AsyncTask)RefreshActionsLogic.logFailed("Unknown how to refresh a LocalDataSource with a model of class " + model.getClass().getName()));
        }
        if (rawDataSource instanceof SqlDataSource) {
            DataSourceSyncManager dataSourceSyncManager = DataSourceSyncManager.Companion.getInstance();
            return dataSourceSyncManager.tryPerformAsync((SqlDataSource)dataSource, true, true);
        }
        return null;
    }

    @Nullable
    public static final AsyncTask<SyncQueue.SyncResult> runDataSourceGeneralRefresh(@NotNull Project project, @NotNull RawDataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        RawDataSource rawDataSource = dataSource;
        if (rawDataSource instanceof LocalDataSource) {
            return RefreshActionsLogic.runGeneralForLocalDataSource(project, (LocalDataSource)dataSource);
        }
        if (rawDataSource instanceof SqlDataSource) {
            DataSourceSyncManager dataSourceSyncManager = DataSourceSyncManager.Companion.getInstance();
            return dataSourceSyncManager.tryPerformAsync((SqlDataSource)dataSource, true, true);
        }
        return null;
    }

    private static final void performPluginsExtensionOperations(Project project, LocalDataSource dataSource) {
        for (SynchronizeHandler extension : (SynchronizeHandler[])SynchronizeHandler.EP_NAME.getExtensions()) {
            try {
                extension.beforeSynchronize(project, (DasDataSource)dataSource);
            }
            catch (Exception e) {
                String string;
                String string2 = e.getMessage();
                if (string2 != null) {
                    CharSequence charSequence = string2;
                    Regex regex = new Regex("\\r?\\n");
                    String string3 = "\n\t";
                    string = regex.replace(charSequence, string3);
                } else {
                    string = null;
                }
                String exceptionMessage = string;
                String message = "Extension error while refreshing data source: " + dataSource + "\nException class: " + e.getClass() + "\nMessage: " + exceptionMessage;
                logger.error(message, (Throwable)e);
            }
        }
    }

    private static final AsyncTask<SyncQueue.SyncResult> runInitialForLocalDataSourceWithEmptyModel(Project project, LocalDataSource dataSource) {
        String string = dataSource.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueId(...)");
        IndefiniteIntrospectionTask task = IntrospectionTasks.prepareGeneralTask((String)string);
        return RunIntrospection.runAsyncIntrospection((Project)project, (LocalDataSource)dataSource, (IntrospectionTask)((IntrospectionTask)task));
    }

    private static final AsyncTask<SyncQueue.SyncResult> runGeneralForLocalDataSource(Project project, LocalDataSource dataSource) {
        String string = dataSource.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueId(...)");
        IndefiniteIntrospectionTask task = IntrospectionTasks.prepareGeneralTask((String)string);
        return RunIntrospection.runAsyncIntrospection((Project)project, (LocalDataSource)dataSource, (IntrospectionTask)((IntrospectionTask)task));
    }

    private static final AsyncTask<SyncQueue.SyncResult> runRegularRefreshForLocalDataSourceWithModel(Project project, LocalDataSource dataSource, BasicModel model, Sequence<? extends BasicElement> elementsToRefresh) {
        BasicRoot basicRoot = model.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)basicRoot, (String)"getRoot(...)");
        BasicRoot root = basicRoot;
        if (SequencesKt.contains(elementsToRefresh, (Object)root)) {
            return RefreshActionsLogic.refreshWholeModelAutomatically(project, dataSource, model);
        }
        return RefreshActionsLogic.refreshGivenElementsAutomatically(project, dataSource, elementsToRefresh);
    }

    @NotNull
    public static final AsyncTask<SyncQueue.SyncResult> refreshToComplete(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull Collection<? extends BasicElement> elementsToRefresh) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter(elementsToRefresh, (String)"elementsToRefresh");
        BasicModel basicModel = DataSourceFun.getBasicModel((RawDataSource)((RawDataSource)dataSource));
        if (basicModel == null) {
            throw new IllegalStateException("Cannot refresh to complete: the given data source has no model");
        }
        BasicModel model = basicModel;
        int alienElements = 0;
        for (BasicElement basicElement : elementsToRefresh) {
            if (Intrinsics.areEqual((Object)basicElement.getModel(), (Object)model)) continue;
            ++alienElements;
        }
        if (alienElements > 0) {
            throw new IllegalArgumentException("Cannot refresh to complete: " + alienElements + " of total " + elementsToRefresh.size() + " don't belong to the given model");
        }
        return RefreshActionsLogic.refreshGivenElementsAutomatically(project, dataSource, (Sequence<? extends BasicElement>)CollectionsKt.asSequence((Iterable)elementsToRefresh));
    }

    private static final AsyncTask<SyncQueue.SyncResult> refreshWholeModelAutomatically(Project project, LocalDataSource dataSource, BasicModel model) {
        RefreshActionsLogic.performPluginsExtensionOperations(project, dataSource);
        String string = dataSource.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueId(...)");
        IndefiniteIntrospectionTask task = IntrospectionTasks.prepareGeneralTask((String)string);
        return RunIntrospection.runAsyncIntrospection((Project)project, (LocalDataSource)dataSource, (IntrospectionTask)((IntrospectionTask)task));
    }

    private static final AsyncTask<SyncQueue.SyncResult> refreshGivenElementsAutomatically(Project project, LocalDataSource dataSource, Sequence<? extends BasicElement> elementsToRefresh) {
        String string = dataSource.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueId(...)");
        List tasks = IntrospectionTasks.prepareManyElementsRefreshTasks((String)string, elementsToRefresh);
        RefreshActionsLogic.performPluginsExtensionOperations(project, dataSource);
        return RunIntrospection.runAsyncIntrospection((Project)project, (LocalDataSource)dataSource, (List)tasks);
    }

    private static final AsyncTask<SyncQueue.SyncResult> refreshThisObject(Project project, BasicModel model, BasicElement objectToRefresh) {
        LocalDataSource ds;
        BasicModelRegistry basicModelRegistry = BasicModelRegistry.Companion.instance();
        RawDataSource dataSource = basicModelRegistry.getDataSource(model);
        if (dataSource == null) {
            return (AsyncTask)RefreshActionsLogic.logFailed("Cannot refresh this object: no data source for model " + model);
        }
        RawDataSource rawDataSource = dataSource;
        LocalDataSource localDataSource = ds = rawDataSource instanceof LocalDataSource ? (LocalDataSource)rawDataSource : null;
        if (ds == null) {
            return (AsyncTask)RefreshActionsLogic.logFailed("Cannot refresh this object: the data source class is " + dataSource.getClass().getSimpleName());
        }
        String string = ((LocalDataSource)dataSource).getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueId(...)");
        IntrospectionTask introspectionTask = IntrospectionTasks.prepareOneElementRefreshTask((String)string, (BasicElement)objectToRefresh);
        if (introspectionTask == null) {
            throw new IllegalArgumentException("Unknown how to refresh this element: " + objectToRefresh + " (of class " + objectToRefresh.getClass().getName() + ")");
        }
        return RunIntrospection.runAsyncIntrospection((Project)project, (LocalDataSource)ds, (IntrospectionTask)introspectionTask);
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Experimental
    public static final void refreshSpecificFragments(@NotNull Project project, @NotNull Iterable<? extends BasicElement> elementsToRefresh) {
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(elementsToRefresh, (String)"elementsToRefresh");
        Sequence $this$groupBy$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence(elementsToRefresh), RefreshActionsLogic::refreshSpecificFragments$lambda$0);
        boolean $i$f$groupBy = false;
        Sequence sequence = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            BasicModel key$iv$iv;
            BasicElement it = (BasicElement)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it.getModel());
            Map map2 = destination$iv$iv;
            BasicModel key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map elementsGroupedByModel = destination$iv$iv;
        for (Map.Entry entry : elementsGroupedByModel.entrySet()) {
            BasicModel model = (BasicModel)entry.getKey();
            Collection elements = (Collection)entry.getValue();
            RefreshActionsLogic.refreshSpecificFragments(project, model, elements);
        }
    }

    @ApiStatus.Experimental
    @Nullable
    public static final AsyncTask<SyncQueue.SyncResult> refreshSpecificFragments(@NotNull Project project, @NotNull BasicModel model, @NotNull Collection<? extends BasicElement> elementsToRefresh) {
        LocalDataSource ds;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter(elementsToRefresh, (String)"elementsToRefresh");
        BasicModelRegistry basicModelRegistry = BasicModelRegistry.Companion.instance();
        RawDataSource dataSource = basicModelRegistry.getDataSource(model);
        if (dataSource == null) {
            return (AsyncTask)RefreshActionsLogic.logFailed("Cannot refresh fragments: no data source for model " + model);
        }
        RawDataSource rawDataSource = dataSource;
        LocalDataSource localDataSource = ds = rawDataSource instanceof LocalDataSource ? (LocalDataSource)rawDataSource : null;
        if (ds == null) {
            return (AsyncTask)RefreshActionsLogic.logFailed("Cannot refresh fragments: the data source class is " + dataSource.getClass().getSimpleName());
        }
        if (!DBIntrospectorFeatures.supportsFragmentIntrospection((LocalDataSource)ds)) {
            return (AsyncTask)RefreshActionsLogic.logFailed("This data source doesn't support fragment introspection: rdbms is " + ds.getDbms() + ", use jdbc is " + ds.useJdbcIntrospector());
        }
        String string = ((LocalDataSource)dataSource).getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueId(...)");
        List introspectionTasks = IntrospectionTasks.prepareManyElementsRefreshTasks((String)string, (Sequence)CollectionsKt.asSequence((Iterable)elementsToRefresh));
        return RunIntrospection.runAsyncIntrospection((Project)project, (LocalDataSource)ds, (List)introspectionTasks);
    }

    @ApiStatus.Internal
    @Nullable
    public static final AsyncTask<SyncQueue.SyncResult> runDbElementsRefresh(@NotNull Project project, @Nullable JBIterable<DbElement> selection) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        DatabaseNodeWrappingService wrappingService = (DatabaseNodeWrappingService)project.getService(DatabaseNodeWrappingService.class);
        JBIterable jBIterable = selection.filterMap(arg_0 -> RefreshActionsLogic.runDbElementsRefresh$lambda$1(arg_0 -> RefreshActionsLogic.runDbElementsRefresh$lambda$0(wrappingService, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filterMap(...)");
        JBIterable selectedNodes = jBIterable;
        JBIterable jBIterable2 = selectedNodes.filter(DataSourceNode.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
        JBIterable selectedDataSources = jBIterable2;
        if (selectedDataSources.isNotEmpty()) {
            DataSourceNode dataSourceNode = (DataSourceNode)selectedDataSources.single();
            if (dataSourceNode == null) {
                return (AsyncTask)RefreshActionsLogic.logFailed("We cannot refresh elements from different models at the same time!");
            }
            DataSourceNode theDSN = dataSourceNode;
            return RefreshActionsLogic.runDataSourceGeneralRefresh(project, theDSN.dataSource);
        }
        JBIterable jBIterable3 = selectedNodes.filter(BasicElement.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"filter(...)");
        JBIterable selectedElements = jBIterable3;
        if (selectedElements.isEmpty()) {
            return null;
        }
        BasicModel model = (BasicModel)selectedElements.filterMap(arg_0 -> RefreshActionsLogic.runDbElementsRefresh$lambda$3(RefreshActionsLogic::runDbElementsRefresh$lambda$2, arg_0)).unique().single();
        if (model == null) {
            return (AsyncTask)RefreshActionsLogic.logFailed("We cannot refresh elements from different models at the same time!");
        }
        BasicModelRegistry modelRegistry = BasicModelRegistry.Companion.instance();
        RawDataSource rawDataSource = modelRegistry.getDataSource(model);
        if (rawDataSource == null) {
            return null;
        }
        RawDataSource dataSource = rawDataSource;
        DasModel dasModel = (DasModel)model;
        List list = selectedElements.toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        return RefreshActionsLogic.runRegularRefresh(project, dataSource, dasModel, list);
    }

    /*
     * WARNING - void declaration
     */
    public static final void forgetSchemas(@NotNull Project project, @NotNull DataContext ctx) {
        void $this$groupByTo$iv$iv;
        void $this$filterBy$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        JBIterable<BasicElement> jBIterable = DatabaseContextFun.getSelectedElements(ctx);
        boolean $i$f$filterBy22 = false;
        JBIterable jBIterable2 = $this$filterBy$iv.filter(BasicNamespace.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
        JBIterable jBIterable3 = jBIterable2.filter(arg_0 -> RefreshActionsLogic.forgetSchemas$lambda$1(RefreshActionsLogic::forgetSchemas$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"filter(...)");
        Iterable $this$groupBy$iv = (Iterable)jBIterable3;
        boolean $i$f$groupBy = false;
        Iterable $i$f$filterBy22 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            void $this$getOrPut$iv$iv$iv;
            BasicModel key$iv$iv;
            BasicNamespace it = (BasicNamespace)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it.getModel());
            Map map2 = destination$iv$iv;
            BasicModel key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map namespaceGroups = destination$iv$iv;
        if (namespaceGroups.isEmpty()) {
            return;
        }
        String string = DatabaseBundle.message((String)"action.DatabaseView.ForgetSchemaAction.taskText", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String taskText = string;
        Application application = ApplicationManagerEx.getApplication();
        for (Map.Entry entry : namespaceGroups.entrySet()) {
            BasicModel model = (BasicModel)entry.getKey();
            List namespaces = (List)entry.getValue();
            Task.Backgroundable bgTask2 = new Task.Backgroundable(project, taskText, model, application, namespaces){
                final /* synthetic */ Project $project;
                final /* synthetic */ BasicModel $model;
                final /* synthetic */ Application $application;
                final /* synthetic */ List<BasicNamespace> $namespaces;
                {
                    this.$project = $project;
                    this.$model = $model;
                    this.$application = $application;
                    this.$namespaces = $namespaces;
                    super($project, $taskText, false);
                }

                public void run(ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    DbImplUtilCore.performSrcOperation(null, (DasModel)((DasModel)this.$model), (ModalityState)ModalityState.defaultModalityState(), (boolean)false, () -> forgetSchemas.bgTask.1.run$lambda$0(this.$model, this.$namespaces));
                    this.$application.invokeLater(() -> forgetSchemas.bgTask.1.run$lambda$1(this.$project, this.$namespaces));
                }

                private static final void run$lambda$0(BasicModel $model, List $namespaces) {
                    RefreshActionsLogic.access$forgetSchemasInOneModel($model, $namespaces);
                }

                private static final void run$lambda$1(Project $project, List $namespaces) {
                    DatabaseView.collapseNodes($project, $namespaces);
                }
            };
            bgTask2.queue();
        }
    }

    private static final void forgetSchemasInOneModel(BasicModel model, Collection<? extends BasicNamespace> namespaces) {
        if (model instanceof BasicModModel) {
            ((BasicModModel)model).modify(BasicModRoot.class, new ModelModifier(namespaces, model){
                final /* synthetic */ Collection<BasicNamespace> $namespaces;
                final /* synthetic */ BasicModel $model;
                {
                    this.$namespaces = $namespaces;
                    this.$model = $model;
                }

                public final void perform(BasicModRoot it) {
                    for (BasicNamespace namespace : this.$namespaces) {
                        boolean bl;
                        boolean bl2 = bl = namespace.getModel() == this.$model;
                        if (_Assertions.ENABLED && !bl) {
                            String string = "Assertion failed";
                            throw new AssertionError((Object)string);
                        }
                        BasicNamespace basicNamespace = namespace;
                        if (basicNamespace instanceof BasicModDatabase) {
                            Iterable $this$forEach$iv;
                            Intrinsics.checkNotNullExpressionValue((Object)((BasicModDatabase)namespace).getAllSchemasInDatabase(), (String)"getAllSchemasInDatabase(...)");
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                BasicModSchema it2 = (BasicModSchema)element$iv;
                                boolean bl3 = false;
                                it2.forgetStuff();
                            }
                            continue;
                        }
                        if (!(basicNamespace instanceof BasicModSchema)) continue;
                        ((BasicModSchema)namespace).forgetStuff();
                    }
                }
            });
        }
    }

    public static final void forgetModelAndRefresh(@NotNull Project project, @NotNull DataContext ctx, boolean refresh2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        DataSourceStorage storage = DataSourceStorage.getProjectStorage((Project)project);
        JBIterable<RawDataSource> dss = DatabaseContextFun.getSelectedDataSources(ctx);
        for (RawDataSource ds : dss) {
            RawDataSource rawDataSource = ds;
            if (rawDataSource instanceof SqlDataSource) {
                RefreshActionsLogic.doForgetModelAndRefreshForDataSource(project, (SqlDataSource)ds, refresh2);
                continue;
            }
            if (!(rawDataSource instanceof LocalDataSource)) continue;
            Intrinsics.checkNotNull((Object)storage);
            RefreshActionsLogic.doForgetModelAndRefreshForDataSource(project, storage, (LocalDataSource)ds, refresh2);
        }
    }

    private static final void doForgetModelAndRefreshForDataSource(Project project, DataSourceStorage storage, LocalDataSource localDataSource, boolean refresh2) {
        String string;
        boolean bl = refresh2;
        if (bl) {
            Object[] objectArray = new Object[]{localDataSource.getName()};
            string = DatabaseBundle.message((String)"action.DatabaseView.ForceRefreshAction.progress", (Object[])objectArray);
        } else if (!bl) {
            string = DatabaseBundle.message((String)"action.DatabaseView.ForgetModelAction.progress", (Object[])new Object[0]);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        String progressTitle = string2;
        AsyncTask.Frame frame = AsyncTask.Companion.frame(progressTitle);
        AsyncTask.Companion.withBgIndicatorIfNeeded(frame, project, null).computeAsync(() -> RefreshActionsLogic.doForgetModelAndRefreshForDataSource$lambda$0(project, storage, localDataSource, refresh2));
    }

    private static final AsyncTask<SyncQueue.SyncResult> asyncForgetModelAndRefreshForDataSource(Project project, DataSourceStorage storage, LocalDataSource localDataSource, boolean refresh2) {
        AsyncTask asyncTask;
        AsyncTask stage = DataSourceSyncManager.Companion.getInstance().stopSynchronization((DasDataSource)localDataSource).whenComplete(AsyncUtil.getPoolExecutor(), () -> RefreshActionsLogic.asyncForgetModelAndRefreshForDataSource$lambda$0(localDataSource)).whenComplete(AsyncUtil.getEdtExecutor(), () -> RefreshActionsLogic.asyncForgetModelAndRefreshForDataSource$lambda$1(storage, localDataSource));
        boolean bl = refresh2;
        if (bl) {
            asyncTask = stage.applyAsync(null, arg_0 -> RefreshActionsLogic.asyncForgetModelAndRefreshForDataSource$lambda$2(project, localDataSource, arg_0));
        } else if (!bl) {
            asyncTask = stage;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return asyncTask;
    }

    private static final void doForgetModelAndRefreshForDataSource(Project project, SqlDataSource sqlDataSource, boolean refresh2) {
        String string;
        if (refresh2) {
            Object[] objectArray = new Object[]{sqlDataSource.getName()};
            string = DatabaseBundle.message((String)"action.DatabaseView.ForceRefreshAction.progress", (Object[])objectArray);
        } else {
            string = DatabaseBundle.message((String)"action.DatabaseView.ForgetModelAction.progress", (Object[])new Object[0]);
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        String progressTitle = string2;
        AsyncTask.Frame frame = AsyncTask.Companion.frame(progressTitle);
        AsyncTask.Companion.withBgIndicatorIfNeeded(frame, project, null).computeAsync(() -> RefreshActionsLogic.doForgetModelAndRefreshForDataSource$lambda$1(project, sqlDataSource, refresh2));
    }

    private static final AsyncTask<SyncQueue.SyncResult> asyncForgetModelAndRefreshForDataSource(Project project, SqlDataSource sqlDataSource, boolean refresh2) {
        AsyncTask asyncTask;
        AsyncTask stage = DataSourceSyncManager.Companion.getInstance().stopSynchronization((DasDataSource)sqlDataSource).whenComplete(AsyncUtil.getPoolExecutor(), () -> RefreshActionsLogic.asyncForgetModelAndRefreshForDataSource$lambda$3(sqlDataSource));
        boolean bl = refresh2;
        if (bl) {
            asyncTask = stage.applyAsync(null, arg_0 -> RefreshActionsLogic.asyncForgetModelAndRefreshForDataSource$lambda$4(project, sqlDataSource, arg_0));
        } else if (!bl) {
            asyncTask = stage;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return asyncTask;
    }

    private static final Void logFailed(String message) {
        logger.warn(message);
        return null;
    }

    private static final BasicElement regularRefreshPerform$lambda$0(BasicNode it) {
        Intrinsics.checkNotNull((Object)it);
        return RefreshActionsLogic.adjustNodeToElement(it);
    }

    private static final BasicElement regularRefreshPerform$lambda$1(Function1 $tmp0, Object p0) {
        return (BasicElement)$tmp0.invoke(p0);
    }

    private static final boolean regularRefreshPerform$lambda$2(BasicElement it) {
        return it.getModel() != null;
    }

    private static final boolean regularRefreshPerform$lambda$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean diagnosticRefreshPerform$lambda$0(BasicModel $model, BasicElement el) {
        return el.getModel() == $model;
    }

    private static final boolean diagnosticRefreshPerform$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final AsyncTask diagnosticRefreshPerform$lambda$2(Project $project, Ref.ObjectRef $dataSource, BasicModel $model, Ref.ObjectRef $elementsToRefresh) {
        return RefreshActionsLogic.runRegularRefresh($project, (RawDataSource)$dataSource.element, (DasModel)$model, (Collection)$elementsToRefresh.element);
    }

    private static final boolean extendIntrospectionScopeIfNeeded$lambda$0(TreePattern $oldScope, BasicNamespace it) {
        Intrinsics.checkNotNull((Object)it);
        return !RefreshActionsLogic.contains($oldScope, it);
    }

    private static final boolean extendIntrospectionScopeIfNeeded$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final TreePattern extendIntrospectionScopeIfNeeded$lambda$2(BasicNamespace it) {
        return TreePatternUtils.create((ObjectPath)ObjectPaths.of((DasObject)((DasObject)it)));
    }

    private static final TreePattern extendIntrospectionScopeIfNeeded$lambda$3(Function1 $tmp0, Object p0) {
        return (TreePattern)$tmp0.invoke(p0);
    }

    private static final boolean refreshSpecificFragments$lambda$0(BasicElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getModel() != null;
    }

    private static final BasicNode runDbElementsRefresh$lambda$0(DatabaseNodeWrappingService $wrappingService, DbElement o) {
        Intrinsics.checkNotNull((Object)o, (String)"null cannot be cast to non-null type com.intellij.psi.PsiElement");
        return $wrappingService.unwrap((PsiElement)o);
    }

    private static final BasicNode runDbElementsRefresh$lambda$1(Function1 $tmp0, Object p0) {
        return (BasicNode)$tmp0.invoke(p0);
    }

    private static final BasicModel runDbElementsRefresh$lambda$2(BasicElement e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return e.getModel();
    }

    private static final BasicModel runDbElementsRefresh$lambda$3(Function1 $tmp0, Object p0) {
        return (BasicModel)$tmp0.invoke(p0);
    }

    private static final boolean forgetSchemas$lambda$0(BasicNamespace it) {
        return it.getModel() != null && !(it instanceof BasicRoot);
    }

    private static final boolean forgetSchemas$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final AsyncTask doForgetModelAndRefreshForDataSource$lambda$0(Project $project, DataSourceStorage $storage, LocalDataSource $localDataSource, boolean $refresh) {
        return RefreshActionsLogic.asyncForgetModelAndRefreshForDataSource($project, $storage, $localDataSource, $refresh);
    }

    private static final SyncQueue.SyncResult asyncForgetModelAndRefreshForDataSource$lambda$2$0(SyncQueue.SyncResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final Unit asyncForgetModelAndRefreshForDataSource$lambda$0(LocalDataSource $localDataSource) {
        $localDataSource.clearModel();
        return Unit.INSTANCE;
    }

    private static final Unit asyncForgetModelAndRefreshForDataSource$lambda$1(DataSourceStorage $storage, LocalDataSource $localDataSource) {
        $storage.updateDataSource($localDataSource);
        return Unit.INSTANCE;
    }

    private static final AsyncTask asyncForgetModelAndRefreshForDataSource$lambda$2(Project $project, LocalDataSource $localDataSource, SyncQueue.SyncResult it) {
        AsyncTask asyncTask = RefreshActionsLogic.runDataSourceGeneralRefresh($project, (RawDataSource)$localDataSource);
        if (asyncTask == null || (asyncTask = asyncTask.apply(null, RefreshActionsLogic::asyncForgetModelAndRefreshForDataSource$lambda$2$0)) == null) {
            asyncTask = AsyncTask.Companion.completed(null);
        }
        return asyncTask;
    }

    private static final AsyncTask doForgetModelAndRefreshForDataSource$lambda$1(Project $project, SqlDataSource $sqlDataSource, boolean $refresh) {
        return RefreshActionsLogic.asyncForgetModelAndRefreshForDataSource($project, $sqlDataSource, $refresh);
    }

    private static final SyncQueue.SyncResult asyncForgetModelAndRefreshForDataSource$lambda$4$0(SyncQueue.SyncResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final Unit asyncForgetModelAndRefreshForDataSource$lambda$3(SqlDataSource $sqlDataSource) {
        $sqlDataSource.clearModel();
        return Unit.INSTANCE;
    }

    private static final AsyncTask asyncForgetModelAndRefreshForDataSource$lambda$4(Project $project, SqlDataSource $sqlDataSource, SyncQueue.SyncResult it) {
        AsyncTask asyncTask = RefreshActionsLogic.runDataSourceGeneralRefresh($project, (RawDataSource)$sqlDataSource);
        if (asyncTask == null || (asyncTask = asyncTask.apply(null, RefreshActionsLogic::asyncForgetModelAndRefreshForDataSource$lambda$4$0)) == null) {
            asyncTask = AsyncTask.Companion.completed(null);
        }
        return asyncTask;
    }

    public static final /* synthetic */ void access$forgetSchemasInOneModel(BasicModel model, Collection namespaces) {
        RefreshActionsLogic.forgetSchemasInOneModel(model, namespaces);
    }

    static {
        Logger logger = Logger.getInstance((String)"com.intellij.database.actions.Refresh");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RefreshActionsLogic.logger = logger;
    }
}

