/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.console.QueryFilesUtilsKt;
import com.intellij.database.dataSource.DataSourcePerFileMappingsImpl;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.database.view.DatabaseColorManager;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.SqlFileType;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ(\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/console/QueryVirtualFileDecorator;", "", "<init>", "()V", "overwriteDecoration", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "data", "Lcom/intellij/ide/projectView/PresentationData;", "appendDecoration", "localDataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "appendDataSourceName", "isQueryFile", "", "intellij.database.impl"})
public final class QueryVirtualFileDecorator {
    @NotNull
    public static final QueryVirtualFileDecorator INSTANCE = new QueryVirtualFileDecorator();

    private QueryVirtualFileDecorator() {
    }

    public final void overwriteDecoration(@NotNull Project project, @NotNull VirtualFile file, @NotNull PresentationData data) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!QueryFilesUtilsKt.isQueryFilesFlagEnabled()) {
            return;
        }
        if (!this.isQueryFile(file)) {
            return;
        }
        LocalDataSource localDataSource = DataSourcePerFileMappingsImpl.Companion.getDataSourcePerFileMapping(project, file);
        if (localDataSource != null) {
            String presentableText = data.getPresentableText();
            data.clearText();
            data.addText(presentableText, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            this.appendDecoration(project, file, localDataSource, data);
        }
    }

    public final void appendDecoration(@NotNull Project project, @NotNull VirtualFile file, @NotNull PresentationData data) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!QueryFilesUtilsKt.isQueryFilesFlagEnabled()) {
            return;
        }
        if (!this.isQueryFile(file)) {
            return;
        }
        LocalDataSource localDataSource = DataSourcePerFileMappingsImpl.Companion.getDataSourcePerFileMapping(project, file);
        if (localDataSource != null) {
            this.appendDecoration(project, file, localDataSource, data);
        }
    }

    private final void appendDecoration(Project project, VirtualFile file, LocalDataSource localDataSource, PresentationData data) {
        this.appendDataSourceName(localDataSource, data);
        Color color = DatabaseColorManager.getColor(project, file);
        if (color == null) {
            color = data.getBackground();
        }
        data.setBackground(color);
    }

    private final void appendDataSourceName(LocalDataSource localDataSource, PresentationData data) {
        data.addText(" [" + localDataSource.getName() + "]", SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
    }

    private final boolean isQueryFile(VirtualFile file) {
        return file.getFileType() instanceof SqlFileType && !DbVFSUtils.isConsoleFile((VirtualFile)file);
    }
}

