/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.queryFiles;

import com.intellij.database.console.QueryFilesUtilsKt;
import com.intellij.database.dataSource.DataSourcePerFileMappingsImpl;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.ide.FileIconProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.SqlFileType;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/database/console/queryFiles/QueryFileIconProvider;", "Lcom/intellij/ide/FileIconProvider;", "<init>", "()V", "getIcon", "Ljavax/swing/Icon;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "flags", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.database.impl"})
final class QueryFileIconProvider
implements FileIconProvider {
    @Nullable
    public Icon getIcon(@NotNull VirtualFile file, int flags, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!QueryFilesUtilsKt.isQueryFilesFlagEnabled()) {
            return null;
        }
        if (!(file.getFileType() instanceof SqlFileType)) {
            return null;
        }
        if (project == null) {
            return null;
        }
        LocalDataSource localDataSource = DataSourcePerFileMappingsImpl.Companion.getDataSourcePerFileMapping(project, file);
        return localDataSource != null ? localDataSource.getIcon() : null;
    }
}

