/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.queryFiles;

import com.intellij.database.console.QueryFilesUtilsKt;
import com.intellij.database.dataSource.DataSourcePerFileMappingsImpl;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.settings.QueryFileSettings;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.impl.EditorTabTitleProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.sql.SqlFileType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/database/console/queryFiles/QueryFileTabTitleProvider;", "Lcom/intellij/openapi/fileEditor/impl/EditorTabTitleProvider;", "<init>", "()V", "getEditorTabTitle", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isSuitableForFile", "", "intellij.database.impl"})
public final class QueryFileTabTitleProvider
implements EditorTabTitleProvider {
    @Nullable
    public String getEditorTabTitle(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!QueryFilesUtilsKt.isQueryFilesFlagEnabled()) {
            return null;
        }
        if (!QueryFileSettings.Companion.getInstance(project).getShowDataSourceInTabs()) {
            return null;
        }
        if (!this.isSuitableForFile(project, file)) {
            return null;
        }
        LocalDataSource localDataSource = (LocalDataSource)ReadAction.compute(() -> QueryFileTabTitleProvider.getEditorTabTitle$lambda$0(project, file));
        if (localDataSource == null) {
            return null;
        }
        LocalDataSource dataSource = localDataSource;
        return file.getPresentableName() + " [" + dataSource.getName() + "]";
    }

    private final boolean isSuitableForFile(Project project, VirtualFile file) {
        if (file.getFileType() instanceof SqlFileType) {
            return true;
        }
        return DbVFSUtils.getInstance().isJSAttachedToMongo(project, file);
    }

    private static final LocalDataSource getEditorTabTitle$lambda$0(Project $project, VirtualFile $file) {
        return DataSourcePerFileMappingsImpl.Companion.getDataSourcePerFileMapping($project, $file);
    }
}

