/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.queryFiles;

import com.intellij.database.dataSource.DataSourcePerFileMappingsImpl;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.actions.ChooseSchemaAction;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a8\u0006\u0006"}, d2={"getDbElementForVirtualFile", "Lcom/intellij/database/psi/DbElement;", "project", "Lcom/intellij/openapi/project/Project;", "vFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.database.impl"})
public final class QueryFileUtilsKt {
    @Nullable
    public static final DbElement getDbElementForVirtualFile(@NotNull Project project, @NotNull VirtualFile vFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        LocalDataSource localDataSource = DataSourcePerFileMappingsImpl.Companion.getDataSourcePerFileMapping(project, vFile);
        if (localDataSource == null) {
            return null;
        }
        LocalDataSource lds = localDataSource;
        DbDataSource dbDataSource = DbPsiFacade.getInstance((Project)project).findDataSource(lds.getUniqueId());
        if (dbDataSource == null) {
            return null;
        }
        DbDataSource dataSource = dbDataSource;
        SearchPath searchPath = ChooseSchemaAction.getSelectedSearchPath(project, vFile, lds);
        if (searchPath == null) {
            return (DbElement)dataSource;
        }
        SearchPath path = searchPath;
        DbElement dbElement = dataSource.findElement(path.getCurrent());
        if (dbElement == null) {
            dbElement = (DbElement)dataSource;
        }
        return dbElement;
    }
}

