/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.Dbms;
import com.intellij.database.DbmsExtension;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.DataTypeConversion;
import com.intellij.database.data.types.DbDataTypeConversion;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.PredicatesHelperKt;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.CoreGridHelper;
import com.intellij.database.datagrid.DataBusGridDataHookUp;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridPomTarget;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.DbElementTreeElement;
import com.intellij.database.datagrid.DbGridHelper;
import com.intellij.database.datagrid.DbGridHelperKt;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.datagrid.GridHelperPropertyProvider;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.RowSortOrder;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.datagrid.objects.DasGridDataHookUp;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dump.DbGridHandler;
import com.intellij.database.dump.DumpHandler;
import com.intellij.database.dump.ExtractionHelper;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.run.actions.DumpSource;
import com.intellij.database.run.actions.DumpSourceNameProvider;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.GridEditGuard;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbGridPageSizePropertyKt;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbeTierUtilCore;
import com.intellij.database.util.GridTablesModel;
import com.intellij.database.util.Version;
import com.intellij.database.view.DbNodeDescriptor;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.StartupUiUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00de\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \\2\u00020\u0001:\u0001\\B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001c\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J0\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J,\u0010\u001d\u001a\u00020\u001e2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001f2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J:\u0010&\u001a\u0004\u0018\u00010'2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001f2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020 0)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020!0)H\u0016JJ\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\"\u001a\u00020#2\u0006\u0010-\u001a\u00020.2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001f2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020 0)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020!0)H\u0016J,\u0010/\u001a\u0004\u0018\u00010#2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001f2\f\u00100\u001a\b\u0012\u0004\u0012\u00020!0)H\u0017J\b\u00101\u001a\u000202H\u0016J\u001c\u00107\u001a\u0002082\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001fH\u0016J\u001e\u00109\u001a\u0004\u0018\u00010:2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001fH\u0016J\u001c\u0010;\u001a\u0002082\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001fH\u0016J\u001c\u0010<\u001a\u0002082\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001fH\u0016J\b\u0010=\u001a\u000208H\u0016J\"\u0010>\u001a\u00020\u001e2\u0006\u0010-\u001a\u00020.2\u0006\u0010?\u001a\u00020@2\b\u0010A\u001a\u0004\u0018\u00010BH\u0016J\"\u0010C\u001a\b\u0012\u0004\u0012\u00020#0D2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001fH\u0016J\u001c\u0010E\u001a\u0002082\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001fH\u0016J\u001c\u0010F\u001a\u0002082\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001fH\u0016J\u001e\u0010G\u001a\u0004\u0018\u00010#2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001fH\u0016J\u0012\u0010H\u001a\u0004\u0018\u00010#2\u0006\u0010\u0016\u001a\u00020\u0011H\u0016J\u0012\u0010I\u001a\u0004\u0018\u00010#2\u0006\u0010\u0016\u001a\u00020\u0011H\u0016J\u0010\u0010J\u001a\u0002082\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J$\u0010K\u001a\u00020\u001e2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001f2\u0006\u0010A\u001a\u00020LH\u0016J\u001c\u0010M\u001a\u00020\u001e2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001fH\u0016J\"\u0010N\u001a\b\u0012\u0004\u0012\u00020P0O2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001fH\u0016J\u0014\u0010Q\u001a\u0004\u0018\u00010#2\b\u0010R\u001a\u0004\u0018\u00010SH\u0016J*\u0010T\u001a\u0002082\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001f2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020!0VH\u0016J.\u0010W\u001a\u0004\u0018\u00010X2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001f2\u0006\u0010*\u001a\u00020!2\u0006\u0010Y\u001a\u000208H\u0016J,\u0010Z\u001a\u0004\u0018\u00010!2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001f2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020!0VH\u0016J\u001e\u0010[\u001a\u0004\u0018\u00010#2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001fH\u0017R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u00103\u001a\u0002048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106\u00a8\u0006]"}, d2={"Lcom/intellij/database/datagrid/DbGridHelper;", "Lcom/intellij/database/datagrid/GridHelper;", "dbmsSupplier", "Lkotlin/Function0;", "Lcom/intellij/database/Dbms;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "dbms", "getDbms", "()Lcom/intellij/database/Dbms;", "properties", "Lcom/intellij/database/datagrid/GridHelperPropertyProvider;", "getProperties", "()Lcom/intellij/database/datagrid/GridHelperPropertyProvider;", "createDumpSource", "Lcom/intellij/database/run/actions/DumpSource;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createDumpHandler", "Lcom/intellij/database/dump/DumpHandler;", "source", "manager", "Lcom/intellij/database/dump/ExtractionHelper;", "factory", "Lcom/intellij/database/extractors/DataExtractorFactory;", "config", "Lcom/intellij/database/extractors/ExtractionConfig;", "setFilterText", "", "Lcom/intellij/database/datagrid/CoreGrid;", "Lcom/intellij/database/datagrid/GridRow;", "Lcom/intellij/database/datagrid/GridColumn;", "text", "", "caretPosition", "", "getCellLanguage", "Lcom/intellij/lang/Language;", "row", "Lcom/intellij/database/datagrid/ModelIndex;", "column", "createCellCodeFragment", "Lcom/intellij/psi/PsiCodeFragment;", "project", "Lcom/intellij/openapi/project/Project;", "getColumnTooltipHtml", "columnIdx", "createDataTypeConversionBuilder", "Lcom/intellij/database/data/types/DataTypeConversion$Builder;", "defaultMode", "Lcom/intellij/database/extractors/ObjectFormatterMode;", "getDefaultMode", "()Lcom/intellij/database/extractors/ObjectFormatterMode;", "canMutateColumns", "", "getVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isEditable", "isMixedTypeColumns", "isSortingApplicable", "applyFix", "fix", "Lcom/intellij/database/connection/throwable/info/ErrorInfo$Fix;", "editor", "", "getUnambiguousColumnNames", "", "canAddRow", "hasTargetForEditing", "getTableName", "getNameForDump", "getQueryText", "isDatabaseHookUp", "setFilterSortHighlighter", "Lcom/intellij/openapi/editor/Editor;", "updateFilterSortPSI", "getChildrenFromModel", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/ide/util/treeView/smartTree/TreeElement;", "getLocationString", "element", "Lcom/intellij/psi/PsiElement;", "canEditTogether", "columns", "", "getColumnIcon", "Ljavax/swing/Icon;", "forDisplay", "findUniqueColumn", "getDatabaseSystemName", "Companion", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDbGridHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbGridHelper.kt\ncom/intellij/database/datagrid/DbGridHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,330:1\n1786#2,3:331\n1#3:334\n*S KotlinDebug\n*F\n+ 1 DbGridHelper.kt\ncom/intellij/database/datagrid/DbGridHelper\n*L\n184#1:331,3\n*E\n"})
public final class DbGridHelper
implements GridHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function0<Dbms> dbmsSupplier;
    @NotNull
    private final GridHelperPropertyProvider properties;
    @NotNull
    private static final DbmsExtension<CoreGridHelper> EP = new DbmsExtension("com.intellij.database.gridHelper");

    public DbGridHelper(@NotNull Function0<Dbms> dbmsSupplier) {
        Intrinsics.checkNotNullParameter(dbmsSupplier, (String)"dbmsSupplier");
        this.dbmsSupplier = dbmsSupplier;
        this.properties = new GridHelperPropertyProvider(this){
            static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
            private final properties.MyProperty defaultPageSize$delegate;
            private final properties.MyProperty defaultLimitPageSize$delegate;
            final /* synthetic */ DbGridHelper this$0;
            {
                this.this$0 = $receiver;
                this.defaultPageSize$delegate = new properties.MyProperty<T>(this, DbGridPageSizePropertyKt.DB_GRID_PAGE_SIZE);
                this.defaultLimitPageSize$delegate = new properties.MyProperty<T>(this, DbGridPageSizePropertyKt.DB_GRID_LIMIT_PAGE_SIZE);
            }

            public int getDefaultPageSize() {
                return ((Number)this.defaultPageSize$delegate.getValue(this, $$delegatedProperties[0])).intValue();
            }

            public void setDefaultPageSize(int n) {
                this.defaultPageSize$delegate.setValue(this, $$delegatedProperties[0], n);
            }

            public boolean getDefaultLimitPageSize() {
                return (Boolean)this.defaultLimitPageSize$delegate.getValue(this, $$delegatedProperties[1]);
            }

            public void setDefaultLimitPageSize(boolean bl) {
                this.defaultLimitPageSize$delegate.setValue(this, $$delegatedProperties[1], bl);
            }

            static {
                KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(properties.1.class, "defaultPageSize", "getDefaultPageSize()I", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(properties.1.class, "defaultLimitPageSize", "getDefaultLimitPageSize()Z", 0)))};
                $$delegatedProperties = kPropertyArray;
            }
        };
    }

    private final Dbms getDbms() {
        return (Dbms)this.dbmsSupplier.invoke();
    }

    @NotNull
    public GridHelperPropertyProvider getProperties() {
        return this.properties;
    }

    @NotNull
    public DumpSource<?> createDumpSource(@NotNull DataGrid grid, @NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return (DumpSource)new DumpSource.DataGridSource(grid);
    }

    @NotNull
    public DumpHandler<?> createDumpHandler(@NotNull DumpSource<?> source, @NotNull ExtractionHelper manager, @NotNull DataExtractorFactory factory, @NotNull ExtractionConfig config) {
        Intrinsics.checkNotNullParameter(source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        DumpSource.DataGridSource cfr_ignored_0 = (DumpSource.DataGridSource)source;
        return (DumpHandler)new DbGridHandler(((DumpSource.DataGridSource)source).getGrid().getProject(), ((DumpSource.DataGridSource)source).getGrid(), (DumpSourceNameProvider<DataGrid>)((DumpSource.DataGridSource)source).getNameProvider(), manager, factory, config);
    }

    public void setFilterText(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull String text, int caretPosition) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        DbGridHelper.Companion.get(this.getDbms()).setFilterText(grid, text, caretPosition);
    }

    @Nullable
    public Language getCellLanguage(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        Intrinsics.checkNotNullParameter(row, (String)"row");
        Intrinsics.checkNotNullParameter(column, (String)"column");
        return DbGridHelper.Companion.get(this.getDbms()).getCellLanguage(grid, row, column);
    }

    @Nullable
    public PsiCodeFragment createCellCodeFragment(@NotNull String text, @NotNull Project project, @NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        Intrinsics.checkNotNullParameter(row, (String)"row");
        Intrinsics.checkNotNullParameter(column, (String)"column");
        return DbGridHelper.Companion.get(this.getDbms()).createCellCodeFragment(text, project, grid, row, column);
    }

    @NlsContexts.Tooltip
    @Nullable
    public String getColumnTooltipHtml(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull ModelIndex<GridColumn> columnIdx) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        Intrinsics.checkNotNullParameter(columnIdx, (String)"columnIdx");
        return DbGridHelperKt.getDbColumnTooltipHtml(grid, columnIdx);
    }

    @NotNull
    public DataTypeConversion.Builder createDataTypeConversionBuilder() {
        return (DataTypeConversion.Builder)new DbDataTypeConversion.Builder();
    }

    @NotNull
    public ObjectFormatterMode getDefaultMode() {
        return PredicatesHelperKt.predicatesHelper((Dbms)this.getDbms()).getMode();
    }

    public boolean canMutateColumns(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        return DbGridHelper.Companion.get(this.getDbms()).canMutateColumns(grid);
    }

    @Nullable
    public VirtualFile getVirtualFile(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        return DataGridUtil.getVirtualFile(grid);
    }

    public boolean isEditable(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        return !DbeTierUtilCore.isFreeTier() && !grid.getDataHookup().isReadOnly() && GridEditGuard.get(grid) == null;
    }

    public boolean isMixedTypeColumns(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        return !(grid.getDataHookup() instanceof DasGridDataHookUp) && !(grid.getDataHookup() instanceof DataBusGridDataHookUp) || DbGridHelper.Companion.get(this.getDbms()).isMixedTypeColumns(grid);
    }

    public boolean isSortingApplicable() {
        return DbGridHelper.Companion.get(this.getDbms()).isSortingApplicable();
    }

    public void applyFix(@NotNull Project project, @NotNull ErrorInfo.Fix fix, @Nullable Object editor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fix, (String)"fix");
        DataSourceUiUtil.applyFix(project, fix, editor2 instanceof DatabaseConfigEditor ? (DatabaseConfigEditor)editor2 : null);
    }

    @NotNull
    public List<String> getUnambiguousColumnNames(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        DatabaseGridDataHookUp hookup = DataGridUtil.getDatabaseHookUp(grid);
        DatabaseGridDataHookUp databaseGridDataHookUp = hookup;
        if (databaseGridDataHookUp == null || (databaseGridDataHookUp = databaseGridDataHookUp.getTableType()) == null) {
            List list = ContainerUtil.emptyList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"emptyList(...)");
            return list;
        }
        DatabaseGridDataHookUp type = databaseGridDataHookUp;
        List list = DbSqlUtil.getUnambiguousColumnNames((Project)grid.getProject(), (DatabaseDialectEx)hookup.getDatabaseDialect(), (SqlTableType)type, null);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getUnambiguousColumnNames(...)");
        return list;
    }

    public boolean canAddRow(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        boolean bl;
        block8: {
            Intrinsics.checkNotNullParameter(grid, (String)"grid");
            DasObject dasObject = DataGridUtilCore.getDatabaseTable(grid);
            if (dasObject == null) {
                return false;
            }
            DasObject table = dasObject;
            if (this.getDbms().eq(Dbms.MSSQL)) {
                return true;
            }
            Map map2 = CollectionFactory.createCaseInsensitiveStringMap();
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"createCaseInsensitiveStringMap(...)");
            Map nameToModelIndex = map2;
            GridModel gridModel = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
            Intrinsics.checkNotNullExpressionValue((Object)gridModel, (String)"getDataModel(...)");
            GridModel gridModel2 = gridModel;
            DatabaseGridDataHookUp databaseGridDataHookUp = DataGridUtil.getDatabaseHookUp(grid);
            GridTablesModel gridTablesModel = databaseGridDataHookUp != null ? databaseGridDataHookUp.getGridTablesModel() : null;
            for (ModelIndex columnIdx : gridModel2.getColumnIndices().asIterable()) {
                String columnName;
                GridColumn column = (GridColumn)gridModel2.getColumn(columnIdx);
                if (gridTablesModel != null && gridTablesModel.isColumnWithSynonym(columnIdx.value)) {
                    v4 = gridTablesModel.getRealColumnName(columnIdx.value);
                } else {
                    GridColumn gridColumn = column;
                    v4 = columnName = gridColumn != null ? gridColumn.getName() : null;
                }
                if (column == null) continue;
                nameToModelIndex.put(columnName, columnIdx);
            }
            ModelHelper modelHelper = DbImplUtil.getModelHelper((Dbms)this.getDbms());
            Intrinsics.checkNotNullExpressionValue((Object)modelHelper, (String)"getModelHelper(...)");
            ModelHelper helper = modelHelper;
            JBIterable jBIterable = DasUtil.getColumns((DasObject)table);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"getColumns(...)");
            Iterable $this$all$iv = (Iterable)jBIterable;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    DasColumn column = (DasColumn)element$iv;
                    boolean bl2 = false;
                    ModelIndex index = (ModelIndex)nameToModelIndex.get(column.getName());
                    if (index != null && index.isValid(grid) || !helper.mustParticipateInInsert(column)) continue;
                    bl = false;
                    break block8;
                }
                bl = true;
            }
        }
        return bl;
    }

    public boolean hasTargetForEditing(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        return DataGridUtilCore.getDatabaseTable(grid) != null;
    }

    @Nullable
    public String getTableName(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        DasObject dasObject = DataGridUtilCore.getDatabaseTable(grid);
        return dasObject != null ? dasObject.getName() : null;
    }

    @Nullable
    public String getNameForDump(@NotNull DataGrid source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        String tabTitle = DataGridUtil.getResultSetName(source.getProject(), source);
        if (tabTitle != null) {
            return tabTitle;
        }
        DasObject table = DataGridUtilCore.getDatabaseTable((CoreGrid)((CoreGrid)source));
        if (table != null) {
            return table.getName();
        }
        String query = this.getQueryText(source);
        if (query != null) {
            String string = query.substring(0, Math.min(40, query.length()));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }
        return GridUtil.getEditorTabName((DataGrid)source);
    }

    @Nullable
    public String getQueryText(@NotNull DataGrid source) {
        String string;
        DataBusGridDataHookUp hookUp;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        DataBusGridDataHookUp dataBusGridDataHookUp = hookUp = DataGridUtil.getDataBusHookUp(source);
        if (dataBusGridDataHookUp != null) {
            string = dataBusGridDataHookUp.getUnlimitedQueryText(true);
        } else {
            Object object = GridUtil.getVirtualFile((CoreGrid)((CoreGrid)source));
            if (object != null && (object = object.getName()) != null) {
                Object it = object;
                boolean bl = false;
                string = FileUtil.getNameWithoutExtension((String)it);
            } else {
                string = null;
            }
        }
        return string;
    }

    public boolean isDatabaseHookUp(@NotNull DataGrid grid) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        return DataGridUtil.getDataBusHookUp(grid) != null;
    }

    public void setFilterSortHighlighter(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull Editor editor2) {
        block0: {
            Intrinsics.checkNotNullParameter(grid, (String)"grid");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Language language = grid.getDataHookup().getFilterSortLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getFilterSortLanguage(...)");
            Language filterSortLanguage = language;
            SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)filterSortLanguage, (Project)grid.getProject(), null);
            LexerEditorHighlighter lexerHighlighter = new LexerEditorHighlighter(highlighter, (EditorColorsScheme)((DataGrid)grid).getColorsScheme());
            EditorEx editorEx = editor2 instanceof EditorEx ? (EditorEx)editor2 : null;
            if (editorEx == null) break block0;
            editorEx.setHighlighter((EditorHighlighter)lexerHighlighter);
        }
    }

    public void updateFilterSortPSI(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        grid.getDataHookup().updateFilterSortFully();
        DataGridUtil.doWhenDataSourceIsLoaded(grid, () -> DbGridHelper.updateFilterSortPSI$lambda$0(grid));
    }

    @NotNull
    public JBIterable<TreeElement> getChildrenFromModel(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        DasObject table = DataGridUtilCore.getDatabaseTable(grid);
        DasObject dasObject = table;
        if (dasObject == null || (dasObject = dasObject.getDasChildren(ObjectKind.COLUMN)) == null || (dasObject = dasObject.filter(DbElement.class)) == null || (dasObject = dasObject.map(arg_0 -> DbGridHelper.getChildrenFromModel$lambda$1(DbGridHelper::getChildrenFromModel$lambda$0, arg_0))) == null) {
            JBIterable jBIterable = JBIterable.empty();
            dasObject = jBIterable;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"empty(...)");
        }
        return dasObject;
    }

    @Nullable
    public String getLocationString(@Nullable PsiElement element) {
        DataGridPomTarget.Column column = DataGridPomTarget.unwrapColumn((PsiElement)element);
        if (column == null) {
            return null;
        }
        DataGridPomTarget.Column target = column;
        DataGrid dataGrid = target.dataGrid;
        String string = DataGridUtil.getSqlType((CoreGrid<GridRow, GridColumn>)((CoreGrid)dataGrid), target.getColumn());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSqlType(...)");
        String sqlType = string;
        Object result2 = StringUtil.isEmpty((String)sqlType) ? "" : sqlType + " ";
        RowSortOrder.Type type = dataGrid.getSortOrder(target.column);
        Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getSortOrder(...)");
        RowSortOrder.Type sortOrder = type;
        int thenBySortOrder = dataGrid.getThenBySortOrder(target.column);
        if (sortOrder != RowSortOrder.Type.UNSORTED && thenBySortOrder != 0) {
            char arrow;
            boolean isAscending = sortOrder == RowSortOrder.Type.ASC;
            char c2 = arrow = isAscending ? (char)'\u2191' : '\u2193';
            String ordering = StartupUiUtil.getLabelFont().canDisplay(arrow) ? String.valueOf(arrow) : (isAscending ? "A-" : "D-");
            result2 = (String)result2 + ordering + thenBySortOrder;
        }
        if (UISettings.Companion.getInstance().getShowInplaceComments()) {
            String comment;
            DasColumn dasColumn;
            DasColumn dasColumn2 = dasColumn = DataGridUtilCore.getDatabaseColumn((CoreGrid)((CoreGrid)dataGrid), (GridColumn)target.getColumn());
            String string2 = comment = dasColumn2 != null ? dasColumn2.getComment() : null;
            if (comment != null) {
                result2 = (String)result2 + "  " + DbNodeDescriptor.adjustCommentString(comment);
            }
        }
        return result2;
    }

    public boolean canEditTogether(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull List<GridColumn> columns) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        if (columns.size() == 1) {
            return true;
        }
        DbDataSource system = DataGridUtilCore.getDatabaseSystem(grid);
        if (system == null || system.getDbms().in(Dbms.DOCUMENT_ORIENTED)) {
            return true;
        }
        DomainRegistry domainRegistry = BaseDomainRegistry.get((Dbms)this.getDbms(), (Version)system.getVersion());
        Intrinsics.checkNotNullExpressionValue((Object)domainRegistry, (String)"get(...)");
        DomainRegistry registry = domainRegistry;
        int n = ((Collection)columns).size();
        for (int i = 0; i < n; ++i) {
            GridColumn outer = columns.get(i);
            if (registry.getDomain((ColumnDescriptor)outer) == null) {
                return false;
            }
            int n2 = columns.size();
            for (int j = i + 1; j < n2; ++j) {
                Compatibility compatibility;
                Domain innerDomain;
                Domain outerDomain;
                GridColumn inner = columns.get(j);
                if (registry.getDomain((ColumnDescriptor)inner) == null) {
                    return false;
                }
                Intrinsics.checkNotNullExpressionValue((Object)outerDomain.getCompatibility(innerDomain), (String)"getCompatibility(...)");
                if (compatibility.isCompatible()) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    public Icon getColumnIcon(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull GridColumn column, boolean forDisplay) {
        DasColumn c2;
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        DasColumn dasColumn = c2 = forDisplay ? DataGridUtilCore.getDatabaseColumn(grid, (GridColumn)column) : null;
        return dasColumn != null ? DbPresentationCore.getIcon((DasObject)((DasObject)dasColumn)) : DbPresentationCore.getIcon((Dbms)this.getDbms(), (ObjectKind)ObjectKind.COLUMN);
    }

    @Nullable
    public GridColumn findUniqueColumn(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull List<GridColumn> columns) {
        Object v2;
        block5: {
            DasObject dasTable;
            Intrinsics.checkNotNullParameter(grid, (String)"grid");
            Intrinsics.checkNotNullParameter(columns, (String)"columns");
            DasObject dasObject = dasTable = DataGridUtilCore.getDatabaseTable(grid);
            JBIterable indices = dasObject == null ? JBIterable.empty() : DasUtil.getIndices((DasObject)dasObject);
            Iterable iterable = columns;
            for (Object t : iterable) {
                boolean bl;
                block4: {
                    GridColumn column = (GridColumn)t;
                    boolean bl2 = false;
                    DasColumn dasColumn = DataGridUtilCore.getDatabaseColumn(grid, (GridColumn)column);
                    if (dasColumn == null || DasUtil.isPrimary((DasColumn)dasColumn) || DasUtil.isAutoGenerated((DasColumn)dasColumn)) {
                        bl = dasColumn != null;
                    } else {
                        for (DasIndex index : indices) {
                            if (!DasUtil.containsName((String)dasColumn.getName(), (MultiRef)index.getColumnsRef()) || !index.isUnique()) continue;
                            bl = true;
                            break block4;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                v2 = t;
                break block5;
            }
            v2 = null;
        }
        return v2;
    }

    @NlsSafe
    @Nullable
    public String getDatabaseSystemName(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        DbDataSource dbDataSource = DataGridUtilCore.getDatabaseSystem(grid);
        return dbDataSource != null ? dbDataSource.getName() : null;
    }

    private static final void updateFilterSortPSI$lambda$0(CoreGrid $grid) {
        $grid.getDataHookup().updateFilterSortFully();
    }

    private static final TreeElement getChildrenFromModel$lambda$0(DbElement it) {
        return (TreeElement)new DbElementTreeElement(it);
    }

    private static final TreeElement getChildrenFromModel$lambda$1(Function1 $tmp0, Object p0) {
        return (TreeElement)$tmp0.invoke(p0);
    }

    @JvmStatic
    private static final CoreGridHelper get(Dbms dbms) {
        return DbGridHelper.Companion.get(dbms);
    }

    public static final /* synthetic */ Dbms access$getDbms(DbGridHelper $this) {
        return $this.getDbms();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/database/datagrid/DbGridHelper$Companion;", "", "<init>", "()V", "EP", "Lcom/intellij/database/DbmsExtension;", "Lcom/intellij/database/datagrid/CoreGridHelper;", "get", "dbms", "Lcom/intellij/database/Dbms;", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private final CoreGridHelper get(Dbms dbms) {
            Object object = EP.forDbms(dbms);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"forDbms(...)");
            return (CoreGridHelper)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

