/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.model.DasColumn;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.GridCellEditorHelper;
import com.intellij.database.view.DbNodeDescriptor;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a,\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u0007\u001a$\u0010\b\u001a\u00020\t2\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\n\u001a\u00020\u0005H\u0002\u00a8\u0006\u000b"}, d2={"getDbColumnTooltipHtml", "", "grid", "Lcom/intellij/database/datagrid/CoreGrid;", "Lcom/intellij/database/datagrid/GridRow;", "Lcom/intellij/database/datagrid/GridColumn;", "columnIdx", "Lcom/intellij/database/datagrid/ModelIndex;", "getColumnComment", "Lcom/intellij/openapi/util/text/HtmlChunk;", "column", "intellij.database.impl"})
public final class DbGridHelperKt {
    @NlsContexts.Tooltip
    @Nullable
    public static final String getDbColumnTooltipHtml(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull ModelIndex<GridColumn> columnIdx) {
        Intrinsics.checkNotNullParameter(grid, (String)"grid");
        Intrinsics.checkNotNullParameter(columnIdx, (String)"columnIdx");
        GridColumn gridColumn = (GridColumn)grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(columnIdx);
        if (gridColumn == null) {
            return null;
        }
        GridColumn column = gridColumn;
        String string = DataGridUtil.getSqlType(grid, column);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSqlType(...)");
        String type = string;
        return new HtmlBuilder().append((HtmlChunk)HtmlChunk.text((String)grid.getUnambiguousColumnName(columnIdx)).bold()).append((String)(StringUtil.isNotEmpty((String)type) ? ": " + type : "")).append(GridCellEditorHelper.get(grid).getDateFormatSuffix(grid, columnIdx)).append(DbGridHelperKt.getColumnComment(grid, column)).wrapWith("html").toString();
    }

    private static final HtmlChunk getColumnComment(CoreGrid<GridRow, GridColumn> grid, GridColumn column) {
        HtmlChunk htmlChunk;
        DasColumn dasColumn;
        DasColumn dasColumn2 = dasColumn = DataGridUtilCore.getDatabaseColumn(grid, (GridColumn)column);
        String comment = dasColumn2 != null ? dasColumn2.getComment() : null;
        CharSequence charSequence = comment;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            HtmlChunk htmlChunk2 = HtmlChunk.empty();
            htmlChunk = htmlChunk2;
            Intrinsics.checkNotNullExpressionValue((Object)htmlChunk2, (String)"empty(...)");
        } else {
            HtmlChunk htmlChunk3 = new HtmlBuilder().br().append((HtmlChunk)HtmlChunk.text((String)DbNodeDescriptor.adjustCommentString(comment)).wrapWith("pre")).toFragment();
            htmlChunk = htmlChunk3;
            Intrinsics.checkNotNullExpressionValue((Object)htmlChunk3, (String)"toFragment(...)");
        }
        return htmlChunk;
    }
}

