/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.schemaEditor.DbEditorModality;
import com.intellij.database.schemaEditor.DbEditorModelSynchronizer;
import com.intellij.database.schemaEditor.DbEditorSynchronizer;
import com.intellij.database.schemaEditor.DbModelTransactionManager;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.DbEditorModelListener;
import com.intellij.database.schemaEditor.model.DbEditorModelTracker;
import com.intellij.database.schemaEditor.model.DbModelIdentity;
import com.intellij.database.schemaEditor.model.DbModelIdentityRef;
import com.intellij.database.schemaEditor.model.DbModelLiteRef;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.applier.DbObjectModelApplier;
import com.intellij.database.schemaEditor.model.applier.DbStructureFamilyModelApplier;
import com.intellij.database.schemaEditor.model.applier.DbStructureObjectModelApplier;
import com.intellij.database.schemaEditor.model.state.DbModelState;
import com.intellij.database.schemaEditor.model.state.DbObjectModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureObjectModelState;
import com.intellij.database.schemaEditor.ui.DbEditor;
import com.intellij.database.schemaEditor.ui.DbEditorApplyHelper;
import com.intellij.database.schemaEditor.ui.DbEditorController;
import com.intellij.database.schemaEditor.ui.DbEditorListener;
import com.intellij.database.schemaEditor.ui.DbEditorResetHelper;
import com.intellij.database.schemaEditor.ui.DbEditorTracker;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 R2\u00020\u0001:\u0002QRB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u001c\u0010\u0006\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010)\u001a\u00020\tH\u0002J\u000e\u0010*\u001a\u00020\tH\u0082@\u00a2\u0006\u0002\u0010+J\u0016\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020.H\u0086@\u00a2\u0006\u0002\u0010/J\u0016\u00100\u001a\u00020\t2\u0006\u0010-\u001a\u00020.H\u0086@\u00a2\u0006\u0002\u0010/J\u001e\u00101\u001a\u00020\t2\u0006\u0010-\u001a\u00020.2\u0006\u00102\u001a\u00020\u0019H\u0082@\u00a2\u0006\u0002\u00103J&\u00101\u001a\u00020\t2\u0006\u0010-\u001a\u00020.2\u0006\u00102\u001a\u00020\u00192\u0006\u00104\u001a\u000205H\u0082@\u00a2\u0006\u0002\u00106J\b\u00107\u001a\u00020\tH\u0002J\u001e\u00108\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001d0(2\u0006\u00102\u001a\u00020\u0019H\u0002J4\u00109\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00130(2\u0006\u00102\u001a\u00020\u00192\u0014\u0010:\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030;0(H\u0002J&\u0010<\u001a\u00020\t2\u0006\u00102\u001a\u00020\u00192\u0014\u0010:\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030;0(H\u0002J<\u0010=\u001a\u0010\u0012\u0004\u0012\u0002H>\u0012\u0004\u0012\u0002H?\u0018\u00010\u001d\"\b\b\u0000\u0010>*\u00020@\"\b\b\u0001\u0010?*\u00020A2\u0012\u0010B\u001a\u000e\u0012\u0004\u0012\u0002H>\u0012\u0004\u0012\u0002H?0\u001dJ\b\u0010C\u001a\u00020\tH\u0003J\u001e\u0010D\u001a\u00020\t2\u0014\u0010E\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00130FH\u0002J\u001c\u0010G\u001a\u00020\t2\u0006\u0010H\u001a\u00020I2\n\u0010J\u001a\u00060Kj\u0002`LH\u0002J\u0016\u0010M\u001a\u00020\t2\u0006\u0010-\u001a\u00020.H\u0086@\u00a2\u0006\u0002\u0010/J,\u0010N\u001a\u00020\t2\u001c\u0010J\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0007H\u0083@\u00a2\u0006\u0002\u0010OJ\b\u0010P\u001a\u00020\tH\u0016R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0014\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001b\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001d0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010 \u001aB\u0012\u0016\u0012\u0014\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001d\u00a2\u0006\u0002\b\"\u00a2\u0006\u0002\b# %*\u001f\u0012\u0016\u0012\u0014\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001d\u00a2\u0006\u0002\b\"\u00a2\u0006\u0002\b#0$\u00a2\u0006\u0002\b\"0!\u00a2\u0006\u0002\b\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000RR\u0010&\u001aF\u0012\u001c\u0012\u001a\u0012\u0002\b\u0003\u0012\u0002\b\u0003 %*\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00130\u0013 %*\"\u0012\u001c\u0012\u001a\u0012\u0002\b\u0003\u0012\u0002\b\u0003 %*\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00130\u0013\u0018\u00010(0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lcom/intellij/database/schemaEditor/DbEditorSynchronizer;", "Lcom/intellij/openapi/Disposable;", "editorController", "Lcom/intellij/database/schemaEditor/ui/DbEditorController;", "modelController", "Lcom/intellij/database/schemaEditor/model/DbEditorModelController;", "onChanged", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "", "", "<init>", "(Lcom/intellij/database/schemaEditor/ui/DbEditorController;Lcom/intellij/database/schemaEditor/model/DbEditorModelController;Lkotlin/jvm/functions/Function1;)V", "myCurrentOnModified", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/database/schemaEditor/DbEditorSynchronizer$MyUpdate;", "myEditorController", "myEditorModelTracker", "Lcom/intellij/database/schemaEditor/model/DbEditorModelTracker;", "Lcom/intellij/database/schemaEditor/model/DbModelLiteRef;", "myOnChanged", "Lkotlin/jvm/functions/Function1;", "myEditorTracker", "Lcom/intellij/database/schemaEditor/ui/DbEditorTracker;", "myUpdating", "", "myTransferBackModifications", "myModifiedBackModels", "Ljava/util/LinkedHashSet;", "Lcom/intellij/database/schemaEditor/model/DbModelRef;", "myModelSynchronizer", "Lcom/intellij/database/schemaEditor/DbEditorModelSynchronizer;", "myRegisteredModels", "", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "", "kotlin.jvm.PlatformType", "myForgotten", "", "", "onModified", "onUiChanged", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "applyTo", "owner", "Lcom/intellij/database/schemaEditor/ElementOwner;", "(Lcom/intellij/database/schemaEditor/ElementOwner;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "applyAllTo", "applyToImpl", "incremental", "(Lcom/intellij/database/schemaEditor/ElementOwner;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "transaction", "Lcom/intellij/database/schemaEditor/DbModelTransactionManager$DbModelTransaction;", "(Lcom/intellij/database/schemaEditor/ElementOwner;ZLcom/intellij/database/schemaEditor/DbModelTransactionManager$DbModelTransaction;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "performScheduledBackModelModificationTransfer", "transferBackModelModification", "applyEditorsToModel", "modifiedEditors", "Lcom/intellij/database/schemaEditor/ui/DbEditor;", "updateEditorsFromModel", "getEditorModelRef", "E", "S", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/schemaEditor/model/state/DbModelState;", "ref", "resetEditorsWithDirectlyModifiedModels", "reapplyModifiedModels", "extra", "", "noModelModificationHere", "message", "", "r", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "resetFrom", "performUpdate", "(Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dispose", "MyUpdate", "Companion", "intellij.database.impl"})
public final class DbEditorSynchronizer
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicReference<MyUpdate> myCurrentOnModified;
    @NotNull
    private final DbEditorController myEditorController;
    @NotNull
    private final DbEditorModelTracker<DbModelLiteRef<?, ?>> myEditorModelTracker;
    @NotNull
    private final Function1<Continuation<? super Unit>, Object> myOnChanged;
    @NotNull
    private final DbEditorTracker myEditorTracker;
    private volatile boolean myUpdating;
    private volatile boolean myTransferBackModifications;
    @NotNull
    private final LinkedHashSet<DbModelRef<?, ?>> myModifiedBackModels;
    @NotNull
    private final DbEditorModelSynchronizer myModelSynchronizer;
    @NotNull
    private final Set<DbModelRef<?, ?>> myRegisteredModels;
    private final List<DbModelLiteRef<?, ?>> myForgotten;

    public DbEditorSynchronizer(@NotNull DbEditorController editorController, @NotNull DbEditorModelController modelController, @NotNull Function1<? super Continuation<? super Unit>, ? extends Object> onChanged2) {
        Intrinsics.checkNotNullParameter((Object)editorController, (String)"editorController");
        Intrinsics.checkNotNullParameter((Object)modelController, (String)"modelController");
        Intrinsics.checkNotNullParameter(onChanged2, (String)"onChanged");
        this.myCurrentOnModified = new AtomicReference<Object>(null);
        this.myModifiedBackModels = new LinkedHashSet();
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
        this.myRegisteredModels = set;
        this.myForgotten = Collections.synchronizedList(new ArrayList());
        if (editorController.getModelController() == modelController) {
            throw new AssertionError((Object)"Use separate model controller");
        }
        this.myEditorController = editorController;
        Disposer.register((Disposable)this.myEditorController, (Disposable)this);
        this.myOnChanged = onChanged2;
        DbEditorModelController dbEditorModelController = editorController.getModelController();
        this.myEditorModelTracker = new DbEditorModelTracker<DbModelLiteRef<?, ?>>(dbEditorModelController){

            @Override
            public void forgotten(DbModelIdentity<?, ?> modelId) {
                Intrinsics.checkNotNullParameter(modelId, (String)"modelId");
                this.addImpl(new DbModelIdentityRef(modelId));
            }

            @Override
            protected void add(DbModelRef<?, ?> model) {
                Intrinsics.checkNotNullParameter(model, (String)"model");
                this.addImpl(model);
            }
        };
        Disposer.register((Disposable)this, (Disposable)this.myEditorModelTracker);
        this.myEditorTracker = new DbEditorTracker(editorController);
        Disposer.register((Disposable)this, (Disposable)this.myEditorTracker);
        this.myModelSynchronizer = new DbEditorModelSynchronizer(editorController.getModelController(), modelController);
        Disposer.register((Disposable)this, (Disposable)this.myModelSynchronizer);
        modelController.getTransactionManager().whenFinished(() -> DbEditorSynchronizer._init_$lambda$0(this, modelController), this);
        this.myEditorController.getEventDispatcher().addListener((EventListener)new DbEditorListener(){

            @Override
            public void modified(DbEditor<?, ?> editor2) {
                Intrinsics.checkNotNullParameter(editor2, (String)"editor");
                this.onModified();
            }
        }, (Disposable)this);
        this.myEditorController.getModelController().getEventDispatcher().addListener((EventListener)new DbEditorModelListener(){

            @Override
            public void modified(DbEditorModel<?, ?> model) {
                Intrinsics.checkNotNullParameter(model, (String)"model");
                this.onModified();
            }

            @Override
            public void forgotten(DbModelIdentity<?, ?> modelId) {
                Intrinsics.checkNotNullParameter(modelId, (String)"modelId");
                myForgotten.add(new DbModelIdentityRef(modelId));
            }
        }, (Disposable)this);
        Set<DbModelRef<?, ?>> set2 = modelController.getAllModelsRefs();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"getAllModelsRefs(...)");
        this.myRegisteredModels.addAll((Collection)set2);
        modelController.getEventDispatcher().addListener((EventListener)new DbEditorModelListener(){

            @Override
            public void modified(DbEditorModel<?, ?> model) {
                Intrinsics.checkNotNullParameter(model, (String)"model");
                this.onModified();
            }

            @Override
            public void created(DbEditorModel<?, ?> model) {
                Intrinsics.checkNotNullParameter(model, (String)"model");
                myRegisteredModels.add(new DbModelRef(model));
            }

            @Override
            public void removed(DbEditorModel<?, ?> model) {
                Intrinsics.checkNotNullParameter(model, (String)"model");
                myRegisteredModels.remove(new DbModelRef(model));
            }
        }, (Disposable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onModified() {
        Job job;
        DbEditorSynchronizer lock = this;
        MyUpdate prev2 = null;
        DbEditorSynchronizer dbEditorSynchronizer = lock;
        synchronized (dbEditorSynchronizer) {
            MyUpdate myUpdate;
            Job job2;
            MyUpdate currentUpdate;
            block10: {
                block9: {
                    boolean bl = false;
                    currentUpdate = this.myCurrentOnModified.get();
                    if (this.myUpdating) break block9;
                    MyUpdate myUpdate2 = currentUpdate;
                    boolean bl2 = myUpdate2 != null ? !myUpdate2.isStarted() : false;
                    if (!bl2) break block10;
                }
                return;
            }
            if (currentUpdate != null && !currentUpdate.isComplete()) {
                currentUpdate.setRunAgain(true);
                return;
            }
            Ref.ObjectRef update2 = new Ref.ObjectRef();
            DbEditorModelController dbEditorModelController = this.myEditorController.getModelController();
            Intrinsics.checkNotNullExpressionValue((Object)dbEditorModelController, (String)"getModelController(...)");
            DbEditorModelController controller = dbEditorModelController;
            CoroutineScope coroutineScope = controller.getCoroutineScope();
            Intrinsics.checkNotNullExpressionValue((Object)coroutineScope, (String)"getCoroutineScope(...)");
            CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
            ModalityState modalityState = controller.getModalityState();
            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"getModalityState(...)");
            Job it = job2 = BuildersKt.launch((CoroutineScope)coroutineScope, (CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)).plus((CoroutineContext)new CoroutineName("DbEditorSynchronizer.onModified")).plus((CoroutineContext)SupervisorKt.SupervisorJob((Job)((Job)controller.getCoroutineScope().getCoroutineContext().get((CoroutineContext.Key)Job.Key)))), (CoroutineStart)CoroutineStart.LAZY, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Ref.ObjectRef<MyUpdate>)update2, this, lock, null){
                int label;
                final /* synthetic */ Ref.ObjectRef<MyUpdate> $update;
                final /* synthetic */ DbEditorSynchronizer this$0;
                final /* synthetic */ DbEditorSynchronizer $lock;
                {
                    this.$update = $update;
                    this.this$0 = $receiver;
                    this.$lock = $lock;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            if (this.$update.element == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"update");
                                v0 = null;
                            } else {
                                v0 = (MyUpdate)this.$update.element;
                            }
                            v0.setStarted(true);
                            this.label = 1;
                            v1 = DbEditorSynchronizer.access$onUiChanged(this.this$0, (Continuation)this);
                            if (v1 == var8_2) {
                                return var8_2;
                            }
                            ** GOTO lbl19
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl19:
                            // 2 sources

                            var2_3 = this.$lock;
                            var3_4 = this.this$0;
                            var4_5 = this.$update;
                            var5_6 = var2_3;
                            synchronized (var5_6) {
                                $i$a$-synchronized-DbEditorSynchronizer$onModified$1$1$1 = false;
                                v2 = DbEditorSynchronizer.access$getMyCurrentOnModified$p(var3_4);
                                if (var4_5.element == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"update");
                                    v3 = null;
                                } else {
                                    v3 = (MyUpdate)var4_5.element;
                                }
                                var6_7 = v2.compareAndSet(v3, null);
                            }
                            if (this.$update.element == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"update");
                                v4 = null;
                            } else {
                                v4 = (MyUpdate)this.$update.element;
                            }
                            if (v4.getRunAgain()) {
                                DbEditorSynchronizer.access$onModified(this.this$0);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
            boolean bl = false;
            update2.element = new MyUpdate(it, false, false, 4, null);
            if (update2.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"update");
                myUpdate = null;
            } else {
                myUpdate = (MyUpdate)update2.element;
            }
            prev2 = this.myCurrentOnModified.getAndSet(myUpdate);
            job = job2;
        }
        job.start();
    }

    private final Object onUiChanged(Continuation<? super Unit> $completion) {
        if (!this.myUpdating) {
            Object object = this.myOnChanged.invoke($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object applyTo(@NotNull ElementOwner owner, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.applyToImpl(owner, true, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object applyAllTo(@NotNull ElementOwner owner, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.applyToImpl(owner, false, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Object applyToImpl(ElementOwner owner, boolean incremental, Continuation<? super Unit> $completion) {
        DbEditorModality.assertDialogModality(ModalityKt.contextModality((CoroutineContext)$completion.getContext()));
        Object object = this.performUpdate((Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this, owner, incremental, null){
            int label;
            final /* synthetic */ DbEditorSynchronizer this$0;
            final /* synthetic */ ElementOwner $owner;
            final /* synthetic */ boolean $incremental;
            {
                this.this$0 = $receiver;
                this.$owner = $owner;
                this.$incremental = $incremental;
                super(1, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        DbModelTransactionManager dbModelTransactionManager = DbEditorSynchronizer.access$getMyModelSynchronizer$p(this.this$0).getModelController().getTransactionManager();
                        String string = DatabaseBundle.message((String)"dialog.title.applying.editor.state", (Object[])new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        this.label = 1;
                        Object object2 = dbModelTransactionManager.inTransaction(string, this.this$0, (Function2)new Function2<DbModelTransactionManager.DbModelTransaction, Continuation<? super Unit>, Object>(this.this$0, this.$owner, this.$incremental, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ DbEditorSynchronizer this$0;
                            final /* synthetic */ ElementOwner $owner;
                            final /* synthetic */ boolean $incremental;
                            {
                                this.this$0 = $receiver;
                                this.$owner = $owner;
                                this.$incremental = $incremental;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                DbModelTransactionManager.DbModelTransaction dbModelTransaction = (DbModelTransactionManager.DbModelTransaction)this.L$0;
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void transaction;
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)transaction);
                                        this.label = 1;
                                        Object object2 = DbEditorSynchronizer.access$applyToImpl(this.this$0, this.$owner, this.$incremental, (DbModelTransactionManager.DbModelTransaction)transaction, (Continuation)this);
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(DbModelTransactionManager.DbModelTransaction p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Object applyToImpl(ElementOwner owner, boolean incremental, DbModelTransactionManager.DbModelTransaction transaction, Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, incremental, owner, transaction, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ DbEditorSynchronizer this$0;
            final /* synthetic */ boolean $incremental;
            final /* synthetic */ ElementOwner $owner;
            final /* synthetic */ DbModelTransactionManager.DbModelTransaction $transaction;
            {
                this.this$0 = $receiver;
                this.$incremental = $incremental;
                this.$owner = $owner;
                this.$transaction = $transaction;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        DbEditorSynchronizer.access$performScheduledBackModelModificationTransfer(this.this$0);
                        DbEditorSynchronizer.access$resetEditorsWithDirectlyModifiedModels(this.this$0);
                        v0 = ContainerUtil.newArrayList(this.$incremental != false ? DbEditorSynchronizer.access$getMyEditorTracker$p(this.this$0).getModified() : DbEditorSynchronizer.access$getMyEditorController$p(this.this$0).getAllEditors());
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"newArrayList(...)");
                        modifiedEditors = v0;
                        DbEditorSynchronizer.access$getMyEditorTracker$p(this.this$0).setAssertionOnModification("Editor modifications are not expected");
                        modifiedModels = DbEditorSynchronizer.access$applyEditorsToModel(this.this$0, this.$incremental, modifiedEditors);
                        v1 = DbEditorSynchronizer.access$getMyEditorController$p(this.this$0).getModelController();
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getModelController(...)");
                        v2 = modifiedModels;
                        v3 = DbEditorSynchronizer.access$getMyModelSynchronizer$p(this.this$0).getModelController();
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getModelController(...)");
                        com.intellij.database.schemaEditor.DbEditorSynchronizer$Companion.access$copyStates(DbEditorSynchronizer.Companion, v1, v2, v3);
                        this.L$0 = modifiedEditors;
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)modifiedModels);
                        this.label = 1;
                        v4 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$owner, this.$incremental, this.$transaction, null){
                            int label;
                            final /* synthetic */ DbEditorSynchronizer this$0;
                            final /* synthetic */ ElementOwner $owner;
                            final /* synthetic */ boolean $incremental;
                            final /* synthetic */ DbModelTransactionManager.DbModelTransaction $transaction;
                            {
                                this.this$0 = $receiver;
                                this.$owner = $owner;
                                this.$incremental = $incremental;
                                this.$transaction = $transaction;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        DbEditorSynchronizer.access$getMyModelSynchronizer$p(this.this$0).addModifications(DbEditorSynchronizer.access$getMyModifiedBackModels$p(this.this$0));
                                        DbEditorSynchronizer.access$getMyModifiedBackModels$p(this.this$0).clear();
                                        DbEditorSynchronizer.access$getMyModelSynchronizer$p(this.this$0).applyToImpl(this.$owner, this.$incremental, this.$transaction);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        ** if (v4 != var5_2) goto lbl26
lbl25:
                        // 1 sources

                        return var5_2;
lbl26:
                        // 1 sources

                        ** GOTO lbl34
                    }
                    case 1: {
                        modifiedModels = (List)this.L$1;
                        modifiedEditors = (List)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v4 = $result;
lbl34:
                            // 2 sources

                            DbEditorSynchronizer.access$transferBackModelModification(this.this$0, this.$incremental);
                        }
                        catch (Throwable var4_6) {
                            throw var4_6;
                        }
                        finally {
                            DbEditorSynchronizer.access$getMyEditorTracker$p(this.this$0).setAssertionOnModification(null);
                        }
                        DbEditorSynchronizer.access$updateEditorsFromModel(this.this$0, this.$incremental, modifiedEditors);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void performScheduledBackModelModificationTransfer() {
        if (this.myTransferBackModifications) {
            this.myModifiedBackModels.addAll((Collection)this.transferBackModelModification(true));
            this.myTransferBackModifications = false;
        }
    }

    private final List<DbModelRef<?, ?>> transferBackModelModification(boolean incremental) {
        List<DbModelRef<?, ?>> list = this.myModelSynchronizer.finish(incremental);
        Intrinsics.checkNotNullExpressionValue(list, (String)"finish(...)");
        List<DbModelRef<?, ?>> modifiedBackModels = list;
        DbEditorModelController dbEditorModelController = this.myModelSynchronizer.getModelController();
        Intrinsics.checkNotNullExpressionValue((Object)dbEditorModelController, (String)"getModelController(...)");
        Iterable iterable = modifiedBackModels;
        DbEditorModelController dbEditorModelController2 = this.myEditorController.getModelController();
        Intrinsics.checkNotNullExpressionValue((Object)dbEditorModelController2, (String)"getModelController(...)");
        DbEditorSynchronizer.Companion.copyStates(dbEditorModelController, iterable, dbEditorModelController2);
        return modifiedBackModels;
    }

    private final List<DbModelLiteRef<?, ?>> applyEditorsToModel(boolean incremental, List<? extends DbEditor<?, ?>> modifiedEditors) {
        this.myEditorTracker.clearModified();
        DbEditorApplyHelper.apply(this.myEditorController, (Iterable)modifiedEditors);
        ArrayList arrayList = ContainerUtil.newArrayList(incremental ? this.myEditorModelTracker.getModified() : (Iterable)this.myEditorController.getModelController().getAllModelsRefs());
        Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayList(...)");
        ArrayList modifiedModels = arrayList;
        this.myEditorModelTracker.clearModified();
        return modifiedModels;
    }

    private final void updateEditorsFromModel(boolean incremental, List<? extends DbEditor<?, ?>> modifiedEditors) {
        ArrayList arrayList = ContainerUtil.newArrayList(incremental ? this.myEditorModelTracker.getModified() : (Iterable)this.myEditorController.getModelController().getAllModelsRefs());
        Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayList(...)");
        ArrayList modifiedModels = arrayList;
        if (this.myEditorTracker.hasModifications()) {
            throw new AssertionError((Object)"Unexpected editor modification happened during model apply");
        }
        LinkedHashSet crossModelModifications = new LinkedHashSet(modifiedModels);
        for (DbEditor<?, ?> editor2 : modifiedEditors) {
            crossModelModifications.remove(editor2.getModelRef());
        }
        if (this.myEditorModelTracker.hasModifications() || !((Collection)crossModelModifications).isEmpty()) {
            this.reapplyModifiedModels(crossModelModifications);
        }
        if (this.myEditorModelTracker.hasModifications() || this.myEditorTracker.hasModifications()) {
            throw new AssertionError((Object)("Modifications left in tracker:\n\tmodel = " + this.myEditorModelTracker.hasModifications() + "\n\teditor = " + this.myEditorTracker.hasModifications()));
        }
        this.myEditorController.getAllEditors().forEach(DbEditorSynchronizer::updateEditorsFromModel$lambda$0);
    }

    @Nullable
    public final <E extends BasicElement, S extends DbModelState> DbModelRef<E, S> getEditorModelRef(@NotNull DbModelRef<E, S> ref) {
        Intrinsics.checkNotNullParameter(ref, (String)"ref");
        DbEditorModelController dbEditorModelController = this.myModelSynchronizer.getModelController();
        Intrinsics.checkNotNullExpressionValue((Object)dbEditorModelController, (String)"getModelController(...)");
        DbEditorModelController modelController = dbEditorModelController;
        if (!ref.isBoundTo(modelController)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        DbModelLiteRef dbModelLiteRef = ref;
        DbEditorModelController dbEditorModelController2 = this.myEditorController.getModelController();
        Intrinsics.checkNotNullExpressionValue((Object)dbEditorModelController2, (String)"getModelController(...)");
        DbModelLiteRef dbModelLiteRef2 = Companion.transferModel(dbModelLiteRef, modelController, dbEditorModelController2);
        return dbModelLiteRef2 instanceof DbModelRef ? (DbModelRef)dbModelLiteRef2 : null;
    }

    @RequiresEdt
    private final void resetEditorsWithDirectlyModifiedModels() {
        HashSet hashSet = ContainerUtil.newHashSet(this.myEditorModelTracker.getModified());
        Intrinsics.checkNotNullExpressionValue((Object)hashSet, (String)"newHashSet(...)");
        HashSet allModifiedModels = hashSet;
        if (allModifiedModels.isEmpty()) {
            return;
        }
        List modifiedEditors = new ArrayList();
        for (DbEditor<?, ?> editor2 : this.myEditorController.getAllEditors()) {
            DbModelRef<?, ?> model;
            Intrinsics.checkNotNullExpressionValue(editor2.getModelRef(), (String)"getModelRef(...)");
            if (!allModifiedModels.contains(model)) continue;
            Intrinsics.checkNotNull(editor2);
            modifiedEditors.add(editor2);
        }
        DbEditorResetHelper.reset(this.myEditorController, modifiedEditors);
    }

    private final void reapplyModifiedModels(Iterable<? extends DbModelLiteRef<?, ?>> extra) {
        HashSet hashSet = ContainerUtil.newHashSet(this.myEditorModelTracker.getModified());
        Intrinsics.checkNotNullExpressionValue((Object)hashSet, (String)"newHashSet(...)");
        HashSet modifiedModels = hashSet;
        ContainerUtil.addAll((Collection)modifiedModels, extra);
        this.myEditorModelTracker.clearModified();
        this.noModelModificationHere("Unexpected model modification happened during editor reset", () -> DbEditorSynchronizer.reapplyModifiedModels$lambda$0(this, modifiedModels));
        ArrayList arrayList = ContainerUtil.newArrayList(this.myEditorTracker.getModified());
        Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayList(...)");
        List modifiedEditors = arrayList;
        this.myEditorTracker.clearModified();
        this.noModelModificationHere("Unexpected model modification happened when editor is reapplied", () -> DbEditorSynchronizer.reapplyModifiedModels$lambda$1(this, modifiedEditors));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void noModelModificationHere(String message, Runnable r) {
        try {
            this.myEditorModelTracker.setAssertionOnModification(message);
            r.run();
            if (this.myEditorModelTracker.hasModifications()) {
                throw new AssertionError((Object)message);
            }
        }
        finally {
            this.myEditorModelTracker.setAssertionOnModification(null);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object resetFrom(@NotNull ElementOwner owner, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof resetFrom.1)) ** GOTO lbl-1000
        var4_3 = $completion;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ DbEditorSynchronizer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.resetFrom(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                DbEditorModality.assertDialogModality(ModalityKt.contextModality((CoroutineContext)$continuation.getContext()));
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)owner);
                $continuation.label = 1;
                v0 = this.performUpdate((Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(this, owner, null){
                    int label;
                    final /* synthetic */ DbEditorSynchronizer this$0;
                    final /* synthetic */ ElementOwner $owner;
                    {
                        this.this$0 = $receiver;
                        this.$owner = $owner;
                        super(1, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                DbModelTransactionManager dbModelTransactionManager = DbEditorSynchronizer.access$getMyModelSynchronizer$p(this.this$0).getModelController().getTransactionManager();
                                String string = DatabaseBundle.message((String)"dialog.title.resetting.editor.state", (Object[])new Object[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                this.label = 1;
                                Object object2 = dbModelTransactionManager.inTransaction(string, new Pair((Object)this.this$0, (Object)"reset"), (Function2)new Function2<DbModelTransactionManager.DbModelTransaction, Continuation<? super Unit>, Object>(this.this$0, this.$owner, null){
                                    int label;
                                    final /* synthetic */ DbEditorSynchronizer this$0;
                                    final /* synthetic */ ElementOwner $owner;
                                    {
                                        this.this$0 = $receiver;
                                        this.$owner = $owner;
                                        super(2, $completion);
                                    }

                                    /*
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    public final Object invokeSuspend(Object $result) {
                                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                this.label = 1;
                                                Object object2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$owner, null){
                                                    int label;
                                                    final /* synthetic */ DbEditorSynchronizer this$0;
                                                    final /* synthetic */ ElementOwner $owner;
                                                    {
                                                        this.this$0 = $receiver;
                                                        this.$owner = $owner;
                                                        super(2, $completion);
                                                    }

                                                    public final Object invokeSuspend(Object $result) {
                                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                        switch (this.label) {
                                                            case 0: {
                                                                ResultKt.throwOnFailure((Object)$result);
                                                                DbEditorSynchronizer.access$getMyModelSynchronizer$p(this.this$0).resetFrom(this.$owner);
                                                                Set allRefs = new LinkedHashSet<E>(DbEditorSynchronizer.access$getMyModelSynchronizer$p(this.this$0).finish(false));
                                                                Set<DbModelRef<?, ?>> set = DbEditorSynchronizer.access$getMyEditorController$p(this.this$0).getModelController().getAllModelsRefs();
                                                                Intrinsics.checkNotNullExpressionValue(set, (String)"getAllModelsRefs(...)");
                                                                allRefs.addAll((Collection)set);
                                                                DbEditorModelController dbEditorModelController = DbEditorSynchronizer.access$getMyModelSynchronizer$p(this.this$0).getModelController();
                                                                Intrinsics.checkNotNullExpressionValue((Object)dbEditorModelController, (String)"getModelController(...)");
                                                                Iterable iterable = allRefs;
                                                                DbEditorModelController dbEditorModelController2 = DbEditorSynchronizer.access$getMyEditorController$p(this.this$0).getModelController();
                                                                Intrinsics.checkNotNullExpressionValue((Object)dbEditorModelController2, (String)"getModelController(...)");
                                                                com.intellij.database.schemaEditor.DbEditorSynchronizer$Companion.access$copyStates(DbEditorSynchronizer.Companion, dbEditorModelController, iterable, dbEditorModelController2);
                                                                DbEditorResetHelper.resetAll(DbEditorSynchronizer.access$getMyEditorController$p(this.this$0));
                                                                return Unit.INSTANCE;
                                                            }
                                                        }
                                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                    }

                                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                    }

                                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                    }
                                                }), (Continuation)((Continuation)this));
                                                if (object2 != object) return Unit.INSTANCE;
                                                return object;
                                            }
                                            case 1: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                Object object2 = $result;
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(DbModelTransactionManager.DbModelTransaction p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }, (Continuation)this);
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(Continuation<? super Unit> p1) {
                        return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation<? super Unit>)$continuation);
                if (v0 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl24
            }
            case 1: {
                owner = (ElementOwner)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)owner);
                $continuation.label = 2;
                v1 = this.onUiChanged((Continuation<? super Unit>)$continuation);
                if (v1 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl34
            }
            case 2: {
                owner = (ElementOwner)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl34:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @RequiresEdt
    private final Object performUpdate(Function1<? super Continuation<? super Unit>, ? extends Object> r, Continuation<? super Unit> $completion) {
        if (!($completion instanceof performUpdate.1)) ** GOTO lbl-1000
        var5_3 = $completion;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ DbEditorSynchronizer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DbEditorSynchronizer.access$performUpdate(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.myUpdating) {
                    return Unit.INSTANCE;
                }
                this.myUpdating = true;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)r);
                $continuation.label = 1;
                v0 = r.invoke((Object)$continuation);
                ** if (v0 != var6_5) goto lbl22
lbl21:
                // 1 sources

                return var6_5;
lbl22:
                // 1 sources

                ** GOTO lbl35
            }
            case 1: {
                r = (Function1)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                }
                catch (Throwable var3_6) {
                    throw var3_6;
                }
                finally {
                    this.myUpdating = false;
                }
lbl35:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public void dispose() {
    }

    private static final void _init_$lambda$0(DbEditorSynchronizer this$0, DbEditorModelController $modelController) {
        if (!this$0.myTransferBackModifications && this$0.myModelSynchronizer.hasModifications()) {
            this$0.myTransferBackModifications = true;
            CoroutineScope coroutineScope = $modelController.getCoroutineScope();
            Intrinsics.checkNotNullExpressionValue((Object)coroutineScope, (String)"getCoroutineScope(...)");
            CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
            ModalityState modalityState = $modelController.getModalityState();
            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"getModalityState(...)");
            BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
                int label;
                final /* synthetic */ DbEditorSynchronizer this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = DbEditorSynchronizer.access$performUpdate(this.this$0, (Function1)new Function1<Continuation<? super Unit>, Object>(this.this$0, null){
                                int label;
                                final /* synthetic */ DbEditorSynchronizer this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(1, $completion);
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            DbModelTransactionManager dbModelTransactionManager = DbEditorSynchronizer.access$getMyModelSynchronizer$p(this.this$0).getModelController().getTransactionManager();
                                            String string = DatabaseBundle.message((String)"dialog.title.applying.editor.state", (Object[])new Object[0]);
                                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                            this.label = 1;
                                            Object object2 = dbModelTransactionManager.inTransaction(string, this.this$0, (Function2)new Function2<DbModelTransactionManager.DbModelTransaction, Continuation<? super Unit>, Object>(this.this$0, null){
                                                int label;
                                                final /* synthetic */ DbEditorSynchronizer this$0;
                                                {
                                                    this.this$0 = $receiver;
                                                    super(2, $completion);
                                                }

                                                /*
                                                 * Enabled force condition propagation
                                                 * Lifted jumps to return sites
                                                 */
                                                public final Object invokeSuspend(Object $result) {
                                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            this.label = 1;
                                                            Object object2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                                                int label;
                                                                final /* synthetic */ DbEditorSynchronizer this$0;
                                                                {
                                                                    this.this$0 = $receiver;
                                                                    super(2, $completion);
                                                                }

                                                                public final Object invokeSuspend(Object $result) {
                                                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                                    switch (this.label) {
                                                                        case 0: {
                                                                            ResultKt.throwOnFailure((Object)$result);
                                                                            DbEditorSynchronizer.access$performScheduledBackModelModificationTransfer(this.this$0);
                                                                            return Unit.INSTANCE;
                                                                        }
                                                                    }
                                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                                }

                                                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                                }

                                                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                                }
                                                            }), (Continuation)((Continuation)this));
                                                            if (object2 != object) return Unit.INSTANCE;
                                                            return object;
                                                        }
                                                        case 1: {
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            Object object2 = $result;
                                                            return Unit.INSTANCE;
                                                        }
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                }

                                                public final Object invoke(DbModelTransactionManager.DbModelTransaction p1, Continuation<? super Unit> p2) {
                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }, (Continuation)this);
                                            if (object2 != object) return Unit.INSTANCE;
                                            return object;
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object2 = $result;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(Continuation<? super Unit> p1) {
                                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            this$0.onModified();
        }
    }

    private static final void updateEditorsFromModel$lambda$0(DbEditor obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        obj.updateState();
    }

    private static final boolean reapplyModifiedModels$lambda$0$0(HashSet $modifiedModels, DbEditor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        return $modifiedModels.contains(editor2.getModelRef());
    }

    private static final boolean reapplyModifiedModels$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void reapplyModifiedModels$lambda$0(DbEditorSynchronizer this$0, HashSet $modifiedModels) {
        List list = JBIterable.from(this$0.myEditorController.getAllEditors()).filter(arg_0 -> DbEditorSynchronizer.reapplyModifiedModels$lambda$0$1(arg_0 -> DbEditorSynchronizer.reapplyModifiedModels$lambda$0$0($modifiedModels, arg_0), arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"toList(...)");
        List editorsWithModifiedModels = list;
        DbEditorResetHelper.reset(this$0.myEditorController, editorsWithModifiedModels);
    }

    private static final void reapplyModifiedModels$lambda$1(DbEditorSynchronizer this$0, List $modifiedEditors) {
        DbEditorApplyHelper.apply(this$0.myEditorController, $modifiedEditors);
    }

    @JvmStatic
    public static final void transferObject(@Nullable ElementIdentity<?> id, @NotNull DbEditorModelController from, @NotNull DbEditorModelController to) {
        Companion.transferObject(id, from, to);
    }

    public static final /* synthetic */ Object access$onUiChanged(DbEditorSynchronizer $this, Continuation $completion) {
        return $this.onUiChanged((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ AtomicReference access$getMyCurrentOnModified$p(DbEditorSynchronizer $this) {
        return $this.myCurrentOnModified;
    }

    public static final /* synthetic */ Object access$applyToImpl(DbEditorSynchronizer $this, ElementOwner owner, boolean incremental, Continuation $completion) {
        return $this.applyToImpl(owner, incremental, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ DbEditorModelSynchronizer access$getMyModelSynchronizer$p(DbEditorSynchronizer $this) {
        return $this.myModelSynchronizer;
    }

    public static final /* synthetic */ Object access$applyToImpl(DbEditorSynchronizer $this, ElementOwner owner, boolean incremental, DbModelTransactionManager.DbModelTransaction transaction, Continuation $completion) {
        return $this.applyToImpl(owner, incremental, transaction, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ void access$performScheduledBackModelModificationTransfer(DbEditorSynchronizer $this) {
        $this.performScheduledBackModelModificationTransfer();
    }

    public static final /* synthetic */ void access$resetEditorsWithDirectlyModifiedModels(DbEditorSynchronizer $this) {
        $this.resetEditorsWithDirectlyModifiedModels();
    }

    public static final /* synthetic */ DbEditorTracker access$getMyEditorTracker$p(DbEditorSynchronizer $this) {
        return $this.myEditorTracker;
    }

    public static final /* synthetic */ DbEditorController access$getMyEditorController$p(DbEditorSynchronizer $this) {
        return $this.myEditorController;
    }

    public static final /* synthetic */ List access$applyEditorsToModel(DbEditorSynchronizer $this, boolean incremental, List modifiedEditors) {
        return $this.applyEditorsToModel(incremental, modifiedEditors);
    }

    public static final /* synthetic */ LinkedHashSet access$getMyModifiedBackModels$p(DbEditorSynchronizer $this) {
        return $this.myModifiedBackModels;
    }

    public static final /* synthetic */ List access$transferBackModelModification(DbEditorSynchronizer $this, boolean incremental) {
        return $this.transferBackModelModification(incremental);
    }

    public static final /* synthetic */ void access$updateEditorsFromModel(DbEditorSynchronizer $this, boolean incremental, List modifiedEditors) {
        $this.updateEditorsFromModel(incremental, modifiedEditors);
    }

    public static final /* synthetic */ Object access$performUpdate(DbEditorSynchronizer $this, Function1 r, Continuation $completion) {
        return $this.performUpdate((Function1<? super Continuation<? super Unit>, ? extends Object>)r, (Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0007JP\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u0002H\u000e\u0018\u00010\f\"\b\b\u0000\u0010\r*\u00020\u000f\"\b\b\u0001\u0010\u000e*\u00020\u00102\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u0002H\u000e\u0018\u00010\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0007J.\u0010\u0012\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0014\u0010\u0013\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\f0\u00142\u0006\u0010\n\u001a\u00020\tH\u0002J@\u0010\u0015\u001a\u00020\u0016\"\b\b\u0000\u0010\r*\u00020\u000f\"\b\b\u0001\u0010\u000e*\u00020\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u0002H\u000e0\fH\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/schemaEditor/DbEditorSynchronizer$Companion;", "", "<init>", "()V", "transferObject", "", "id", "Lcom/intellij/database/schemaEditor/ElementIdentity;", "from", "Lcom/intellij/database/schemaEditor/model/DbEditorModelController;", "to", "transferModel", "Lcom/intellij/database/schemaEditor/model/DbModelLiteRef;", "E", "S", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/schemaEditor/model/state/DbModelState;", "ref", "copyStates", "refs", "", "copyModelState", "", "modelRef", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDbEditorSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbEditorSynchronizer.kt\ncom/intellij/database/schemaEditor/DbEditorSynchronizer$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,411:1\n1651#2:412\n1915#2:413\n1916#2:415\n1652#2:416\n1#3:414\n*S KotlinDebug\n*F\n+ 1 DbEditorSynchronizer.kt\ncom/intellij/database/schemaEditor/DbEditorSynchronizer$Companion\n*L\n376#1:412\n376#1:413\n376#1:415\n376#1:416\n376#1:414\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void transferObject(@Nullable ElementIdentity<?> id, @NotNull DbEditorModelController from, @NotNull DbEditorModelController to) {
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            DbEditorModel model = id == null ? null : from.resolveRegisteredOrCachedModel(new DbModelIdentity(id, DbObjectModelApplier.ID));
            this.transferModel(DbModelRef.create(model), from, to);
        }

        @Contract(value="!null,_,_->!null")
        @Nullable
        public final <E extends BasicElement, S extends DbModelState> DbModelLiteRef<E, S> transferModel(@Nullable DbModelLiteRef<E, S> ref, @NotNull DbEditorModelController from, @NotNull DbEditorModelController to) {
            DbEditorModel<E, S> res2;
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            if (ref == null) {
                return null;
            }
            if (ref instanceof DbModelRef) {
                if (((DbModelRef)ref).isBoundTo(to)) {
                    return ref;
                }
                if (!((DbModelRef)ref).isBoundTo(from)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
            }
            if ((res2 = ref.resolveOpt(to)) != null) {
                if (ref.isRegistered(from)) {
                    res2.register();
                }
                return new DbModelRef<E, S>(res2);
            }
            ElementIdentity<E> elementIdentity = ref.getIdentity();
            Intrinsics.checkNotNullExpressionValue(elementIdentity, (String)"getIdentity(...)");
            ElementIdentity<E> identity = elementIdentity;
            if (Intrinsics.areEqual((Object)ref.getModelInternalKey(), (Object)DbStructureObjectModelApplier.ID) || DbStructureFamilyModelApplier.isFamilyId(ref.getModelInternalKey())) {
                DbEditorModel ps;
                ElementIdentity parentId;
                ElementIdentity elementIdentity2 = parentId = from.getMatcher().getParent(identity);
                DbEditorModel dbEditorModel = ps = elementIdentity2 == null ? null : from.getStructureNodeModel(elementIdentity2);
                if (ps != null) {
                    this.transferModel(new DbModelRef(ps), from, to);
                }
                DbEditorModel<E, DbStructureObjectModelState<E>> dbEditorModel2 = to.createStructureNodeModel(identity);
                Intrinsics.checkNotNull(dbEditorModel2);
            } else if (ref.getModelInternalKey() == DbStructureModelState.ID) {
                to.getBuilder().createStructureModel(to, identity).register();
            } else {
                DbEditorModel<E, DbStructureObjectModelState<E>> sn = from.getStructureNodeModel(identity);
                if (sn != null) {
                    this.transferModel(new DbModelRef<E, DbStructureObjectModelState<E>>(sn), from, to);
                }
                DbEditorModel<E, DbObjectModelState<E>> dbEditorModel = to.createObjectEditorModel(identity);
                Intrinsics.checkNotNull(dbEditorModel);
            }
            res2 = ref.resolveOpt(to);
            if (res2 == null) {
                if (!(ref instanceof DbModelRef)) {
                    return ref;
                }
                throw new AssertionError((Object)"Failed to copy model");
            }
            return new DbModelRef<E, S>(res2);
        }

        /*
         * WARNING - void declaration
         */
        private final void copyStates(DbEditorModelController from, Iterable<? extends DbModelLiteRef<?, ?>> refs, DbEditorModelController to) {
            void $this$mapNotNullTo$iv;
            LinkedHashSet linkedHashSet = ContainerUtil.newLinkedHashSet(refs);
            Intrinsics.checkNotNullExpressionValue((Object)linkedHashSet, (String)"newLinkedHashSet(...)");
            LinkedHashSet toCopy = linkedHashSet;
            Iterable iterable = toCopy;
            Collection destination$iv = new LinkedHashSet();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv.iterator();
            while (iterator.hasNext()) {
                ElementIdentity it$iv;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator.next();
                boolean bl = false;
                DbModelLiteRef it = (DbModelLiteRef)element$iv;
                boolean bl2 = false;
                if (it.getIdentity() == null) continue;
                boolean bl3 = false;
                destination$iv.add(it$iv);
            }
            Iterator iterator2 = ((LinkedHashSet)destination$iv).iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            Iterator iterator3 = iterator2;
            while (iterator3.hasNext()) {
                DbEditorModel it;
                Object e = iterator3.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                ElementIdentity identity = (ElementIdentity)e;
                if (from.getObjectModel(identity) == null) continue;
                boolean bl = false;
                toCopy.add(new DbModelRef(it));
            }
            Iterator iterator4 = toCopy.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator4, (String)"iterator(...)");
            iterator3 = iterator4;
            while (iterator3.hasNext()) {
                DbModelLiteRef r = (DbModelLiteRef)iterator3.next();
                this.transferModel(r, from, to);
            }
            Iterator iterator5 = toCopy.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator5, (String)"iterator(...)");
            iterator3 = iterator5;
            while (iterator3.hasNext()) {
                DbModelLiteRef ref = (DbModelLiteRef)iterator3.next();
                Intrinsics.checkNotNull((Object)ref);
                boolean copied = this.copyModelState(from, to, ref);
                if (!copied) {
                    throw new AssertionError((Object)"failed to copy model state");
                }
            }
        }

        private final <E extends BasicElement, S extends DbModelState> boolean copyModelState(DbEditorModelController from, DbEditorModelController to, DbModelLiteRef<E, S> modelRef) {
            DbModelLiteRef<E, S> r2 = this.transferModel(modelRef, from, to);
            DbEditorModel<E, S> srcModel = modelRef.resolveOpt(from);
            DbModelLiteRef<E, S> dbModelLiteRef = r2;
            if (dbModelLiteRef == null || (dbModelLiteRef = dbModelLiteRef.resolveOpt(to)) == null) {
                return srcModel == null;
            }
            DbModelLiteRef<E, S> tgtModel = dbModelLiteRef;
            if (srcModel != null) {
                tgtModel.getApplier().copyState(srcModel, (DbEditorModel<E, S>)((Object)tgtModel));
            }
            boolean bl = srcModel == null || !from.isModelRegistered(srcModel) ? tgtModel.unregister() : tgtModel.register();
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0011\u001a\u00020\u0005J\u0006\u0010\u0012\u001a\u00020\u0005J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u0017\u001a\u00020\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0019\u001a\u00020\u001aH\u00d6\u0081\u0004J\n\u0010\u001b\u001a\u00020\u001cH\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\f\"\u0004\b\u0010\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcom/intellij/database/schemaEditor/DbEditorSynchronizer$MyUpdate;", "", "job", "Lkotlinx/coroutines/Job;", "started", "", "runAgain", "<init>", "(Lkotlinx/coroutines/Job;ZZ)V", "getJob", "()Lkotlinx/coroutines/Job;", "getStarted", "()Z", "setStarted", "(Z)V", "getRunAgain", "setRunAgain", "isStarted", "isComplete", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.database.impl"})
    private static final class MyUpdate {
        @NotNull
        private final Job job;
        private volatile boolean started;
        private volatile boolean runAgain;

        public MyUpdate(@NotNull Job job, boolean started, boolean runAgain) {
            Intrinsics.checkNotNullParameter((Object)job, (String)"job");
            this.job = job;
            this.started = started;
            this.runAgain = runAgain;
        }

        public /* synthetic */ MyUpdate(Job job, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl2 = false;
            }
            this(job, bl, bl2);
        }

        @NotNull
        public final Job getJob() {
            return this.job;
        }

        public final boolean getStarted() {
            return this.started;
        }

        public final void setStarted(boolean bl) {
            this.started = bl;
        }

        public final boolean getRunAgain() {
            return this.runAgain;
        }

        public final void setRunAgain(boolean bl) {
            this.runAgain = bl;
        }

        public final boolean isStarted() {
            return this.started || this.isComplete();
        }

        public final boolean isComplete() {
            return this.job.isCompleted();
        }

        @NotNull
        public final Job component1() {
            return this.job;
        }

        public final boolean component2() {
            return this.started;
        }

        public final boolean component3() {
            return this.runAgain;
        }

        @NotNull
        public final MyUpdate copy(@NotNull Job job, boolean started, boolean runAgain) {
            Intrinsics.checkNotNullParameter((Object)job, (String)"job");
            return new MyUpdate(job, started, runAgain);
        }

        public static /* synthetic */ MyUpdate copy$default(MyUpdate myUpdate, Job job, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                job = myUpdate.job;
            }
            if ((n & 2) != 0) {
                bl = myUpdate.started;
            }
            if ((n & 4) != 0) {
                bl2 = myUpdate.runAgain;
            }
            return myUpdate.copy(job, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "MyUpdate(job=" + this.job + ", started=" + this.started + ", runAgain=" + this.runAgain + ")";
        }

        public int hashCode() {
            int result2 = this.job.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.started);
            result2 = result2 * 31 + Boolean.hashCode(this.runAgain);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MyUpdate)) {
                return false;
            }
            MyUpdate myUpdate = (MyUpdate)other;
            if (!Intrinsics.areEqual((Object)this.job, (Object)myUpdate.job)) {
                return false;
            }
            if (this.started != myUpdate.started) {
                return false;
            }
            return this.runAgain == myUpdate.runAgain;
        }
    }
}

