/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor;

import com.intellij.database.model.basic.BasicArrangedElement;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.state.DbStructureFamilyModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureObjectModelState;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0005\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u001f\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0002\b\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\u0012\u001a\u00020\u00132\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000f0\rJ\u0016\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018H\u0002J\u001d\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018H\u0002\u00a2\u0006\u0002\u0010\u001bJ\"\u0010\u001c\u001a\u00020\u00132\u001a\u0010\u001d\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000f\u0018\u00010\rJ\u0006\u0010\u001e\u001a\u00020\u0013R!\u0010\u0004\u001a\u0012\u0012\u0002\b\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0090\u0001\u0010\u000b\u001a\u0080\u0001\u0012|\u0012z\u0012\f\u0012\n \u000e*\u0004\u0018\u00018\u00008\u0000\u0012(\u0012&\u0012\f\u0012\n \u000e*\u0004\u0018\u00018\u00008\u0000 \u000e*\u0012\u0012\f\u0012\n \u000e*\u0004\u0018\u00018\u00008\u0000\u0018\u00010\u000f0\u000f \u000e*<\u0012\f\u0012\n \u000e*\u0004\u0018\u00018\u00008\u0000\u0012(\u0012&\u0012\f\u0012\n \u000e*\u0004\u0018\u00018\u00008\u0000 \u000e*\u0012\u0012\f\u0012\n \u000e*\u0004\u0018\u00018\u00008\u0000\u0018\u00010\u000f0\u000f\u0018\u00010\r0\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/schemaEditor/FamilyBatch;", "T", "Lcom/intellij/database/model/basic/BasicElement;", "", "family", "Lcom/intellij/database/schemaEditor/model/DbEditorModel;", "Lcom/intellij/database/schemaEditor/model/state/DbStructureFamilyModelState;", "<init>", "(Lcom/intellij/database/schemaEditor/model/DbEditorModel;)V", "getFamily", "()Lcom/intellij/database/schemaEditor/model/DbEditorModel;", "children", "", "Lcom/intellij/database/schemaEditor/model/DbModelRef;", "kotlin.jvm.PlatformType", "Lcom/intellij/database/schemaEditor/model/state/DbStructureObjectModelState;", "getChildren", "()Ljava/util/List;", "handleCreation", "", "newObj", "findInsertPosition", "", "identity", "Lcom/intellij/database/schemaEditor/ElementIdentity;", "getOriginalPosition", "", "(Lcom/intellij/database/schemaEditor/ElementIdentity;)Ljava/lang/Short;", "handleRemoval", "remObj", "apply", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDbObjectEditorModelSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbObjectEditorModelSynchronizer.kt\ncom/intellij/database/schemaEditor/FamilyBatch\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,127:1\n1924#2,3:128\n*S KotlinDebug\n*F\n+ 1 DbObjectEditorModelSynchronizer.kt\ncom/intellij/database/schemaEditor/FamilyBatch\n*L\n104#1:128,3\n*E\n"})
public final class FamilyBatch<T extends BasicElement> {
    @NotNull
    private final DbEditorModel<?, DbStructureFamilyModelState<T>> family;
    @NotNull
    private final List<DbModelRef<T, DbStructureObjectModelState<T>>> children;

    public FamilyBatch(@NotNull DbEditorModel<?, DbStructureFamilyModelState<T>> family) {
        Intrinsics.checkNotNullParameter(family, (String)"family");
        this.family = family;
        List list = this.family.getState().getCollection();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getCollection(...)");
        this.children = CollectionsKt.toMutableList((Collection)list);
    }

    @NotNull
    public final DbEditorModel<?, DbStructureFamilyModelState<T>> getFamily() {
        return this.family;
    }

    @NotNull
    public final List<DbModelRef<T, DbStructureObjectModelState<T>>> getChildren() {
        return this.children;
    }

    public final void handleCreation(@NotNull DbModelRef<T, DbStructureObjectModelState<T>> newObj) {
        Intrinsics.checkNotNullParameter(newObj, (String)"newObj");
        ElementIdentity elementIdentity = newObj.getIdentity();
        Intrinsics.checkNotNullExpressionValue(elementIdentity, (String)"getIdentity(...)");
        int pos = this.findInsertPosition(elementIdentity);
        this.children.add(pos, newObj);
    }

    /*
     * WARNING - void declaration
     */
    private final int findInsertPosition(ElementIdentity<T> identity) {
        Short s = this.getOriginalPosition(identity);
        if (s == null) {
            return this.children.size();
        }
        short position = s;
        int idx = 0;
        Iterable $this$forEachIndexed$iv = this.children;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void c2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            DbModelRef dbModelRef = (DbModelRef)item$iv;
            int cIdx = n;
            boolean bl = false;
            ElementIdentity elementIdentity = c2.getIdentity();
            Intrinsics.checkNotNullExpressionValue(elementIdentity, (String)"getIdentity(...)");
            Short p = this.getOriginalPosition(elementIdentity);
            if (p == null || p <= 0) continue;
            if (p >= position) {
                return idx + 1;
            }
            idx = cIdx;
        }
        return idx + 1;
    }

    private final Short getOriginalPosition(ElementIdentity<T> identity) {
        ElementOwner elementOwner = this.family.getController().getActualOwner();
        BasicElement basicElement = elementOwner != null && (elementOwner = elementOwner.getOriginal()) != null ? elementOwner.find(identity) : null;
        BasicArrangedElement basicArrangedElement = basicElement instanceof BasicArrangedElement ? (BasicArrangedElement)basicElement : null;
        return basicArrangedElement != null ? Short.valueOf(basicArrangedElement.getPosition()) : null;
    }

    public final void handleRemoval(@Nullable DbModelRef<T, DbStructureObjectModelState<T>> remObj) {
        if (remObj == null) {
            return;
        }
        remObj.getState().getObjectRef().getState().setDropped(true);
        this.children.remove(remObj);
    }

    public final void apply() {
        this.family.getState().setCollection(this.family.getController(), this.children);
    }
}

