/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.openapi.util.registry.Registry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0010\b\u0016\u0018\u0000 I2\u00020\u0001:\u0005IJKLMB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010(\u001a\u00020)2\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010*\u001a\u00020)J\b\u0010+\u001a\u00020)H\u0002J\b\u0010,\u001a\u00020)H\u0002J\b\u0010-\u001a\u00020)H\u0002J\b\u0010.\u001a\u00020)H\u0002J\u001a\u0010/\u001a\u00020\u00142\b\u00100\u001a\u0004\u0018\u00010\u00102\u0006\u00101\u001a\u00020\u000fH\u0004J'\u00102\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u0001032\b\u00104\u001a\u0004\u0018\u00010\u00102\u0006\u00101\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u00105J\u0012\u00106\u001a\u0004\u0018\u00010\u00142\u0006\u00101\u001a\u00020\u000fH\u0002J\u0010\u00107\u001a\u00020\u001d2\u0006\u00101\u001a\u00020\u000fH\u0002J\u0006\u00108\u001a\u00020)J\b\u00109\u001a\u00020)H\u0002J\n\u0010:\u001a\u0004\u0018\u00010\u000fH\u0016J\u001a\u0010;\u001a\u0004\u0018\u00010\u000f2\u0006\u0010<\u001a\u00020\u000f2\u0006\u0010=\u001a\u00020>H\u0016J\u0010\u0010?\u001a\u00020>2\u0006\u0010<\u001a\u00020\u000fH\u0016J\u0010\u0010@\u001a\u00020\u001d2\u0006\u00101\u001a\u00020\u000fH\u0016J\u0018\u0010A\u001a\u00020)2\u0006\u0010B\u001a\u00020\u00102\u0006\u0010C\u001a\u00020\u000fH\u0016J\u001c\u0010D\u001a\u00020>2\b\u0010<\u001a\u0004\u0018\u00010\u000f2\b\u0010E\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010F\u001a\u00020)2\u0006\u0010G\u001a\u00020&H\u0016J\u0010\u0010H\u001a\u00020)2\u0006\u0010G\u001a\u00020&H\u0016R\u0010\u0010\u0002\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000ej\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00140\u0013j\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0014`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0015\u0010\"\u001a\u00020\u001d8\u00c4\u0002X\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u001fR\u001e\u0010$\u001a\u0012\u0012\u0004\u0012\u00020&0%j\b\u0012\u0004\u0012\u00020&`'X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lcom/intellij/database/view/TreeFilterModel;", "Ljavax/swing/tree/TreeModel;", "originModel", "jTree", "Ljavax/swing/JTree;", "<init>", "(Ljavax/swing/tree/TreeModel;Ljavax/swing/JTree;)V", "matcher", "Lcom/intellij/database/view/TreeFilterModel$Matcher;", "getMatcher", "()Lcom/intellij/database/view/TreeFilterModel$Matcher;", "setMatcher", "(Lcom/intellij/database/view/TreeFilterModel$Matcher;)V", "expandedNodes", "Ljava/util/LinkedHashMap;", "", "Ljavax/swing/tree/TreePath;", "Lkotlin/collections/LinkedHashMap;", "cache", "Ljava/util/HashMap;", "Lcom/intellij/database/view/TreeFilterModel$Row;", "Lkotlin/collections/HashMap;", "input", "", "getInput", "()Ljava/lang/String;", "setInput", "(Ljava/lang/String;)V", "filtering", "", "getFiltering", "()Z", "setFiltering", "(Z)V", "passing", "getPassing", "listeners", "Ljava/util/ArrayList;", "Ljavax/swing/event/TreeModelListener;", "Lkotlin/collections/ArrayList;", "filter", "", "reset", "saveExpandedNodes", "restoreExpandedNodes", "invalidateTreeComponent", "processTreeNodes", "processNode", "parentPath", "node", "gatherNodeChildren", "", "nodePath", "(Ljavax/swing/tree/TreePath;Ljava/lang/Object;)[Lcom/intellij/database/view/TreeFilterModel$Row;", "obtainRow", "checkNodeMatches", "expandAllNodesInTheTree", "clearAllCaches", "getRoot", "getChild", "parent", "index", "", "getChildCount", "isLeaf", "valueForPathChanged", "path", "newValue", "getIndexOfChild", "child", "addTreeModelListener", "l", "removeTreeModelListener", "Companion", "Matcher", "SimpleMatcher", "Row", "OriginModelListener", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nTreeFilterModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TreeFilterModel.kt\ncom/intellij/database/view/TreeFilterModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,293:1\n86#1:298\n86#1:299\n86#1:300\n86#1:301\n1915#2,2:294\n37#3,2:296\n*S KotlinDebug\n*F\n+ 1 TreeFilterModel.kt\ncom/intellij/database/view/TreeFilterModel\n*L\n228#1:298\n234#1:299\n240#1:300\n250#1:301\n146#1:294,2\n183#1:296,2\n*E\n"})
public class TreeFilterModel
implements TreeModel {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final TreeModel originModel;
    @NotNull
    private final JTree jTree;
    @NotNull
    private Matcher matcher;
    @NotNull
    private final LinkedHashMap<Object, TreePath> expandedNodes;
    @NotNull
    private final HashMap<Object, Row> cache;
    @Nullable
    private String input;
    private boolean filtering;
    @NotNull
    private final ArrayList<TreeModelListener> listeners;
    @Deprecated
    public static final int noIndex = -1;
    private static final int limitExpandingTotalRows = Registry.Companion.intValue("database.view.filter.limit.expanding.total.rows", 10000);
    private static final int limitExpandingExpandedNodes = Registry.Companion.intValue("database.view.filter.limit.expanding.expanded.nodes", 1000);

    public TreeFilterModel(@NotNull TreeModel originModel, @NotNull JTree jTree) {
        Intrinsics.checkNotNullParameter((Object)originModel, (String)"originModel");
        Intrinsics.checkNotNullParameter((Object)jTree, (String)"jTree");
        this.originModel = originModel;
        this.jTree = jTree;
        this.matcher = SimpleMatcher.INSTANCE;
        this.expandedNodes = new LinkedHashMap();
        this.cache = new HashMap();
        this.listeners = new ArrayList();
        this.originModel.addTreeModelListener(new OriginModelListener());
    }

    @NotNull
    public final Matcher getMatcher() {
        return this.matcher;
    }

    public final void setMatcher(@NotNull Matcher matcher) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"<set-?>");
        this.matcher = matcher;
    }

    @Nullable
    protected final String getInput() {
        return this.input;
    }

    protected final void setInput(@Nullable String string) {
        this.input = string;
    }

    protected final boolean getFiltering() {
        return this.filtering;
    }

    protected final void setFiltering(boolean bl) {
        this.filtering = bl;
    }

    protected final boolean getPassing() {
        boolean $i$f$getPassing = false;
        return !this.filtering;
    }

    public final void filter(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (Intrinsics.areEqual((Object)this.input, (Object)input)) {
            return;
        }
        if (!this.filtering) {
            this.saveExpandedNodes();
            this.filtering = true;
            this.clearAllCaches();
        }
        this.input = input;
        this.processTreeNodes();
        this.invalidateTreeComponent();
        this.expandAllNodesInTheTree();
    }

    public final void reset() {
        this.input = null;
        if (this.filtering) {
            this.filtering = false;
            this.invalidateTreeComponent();
            this.restoreExpandedNodes();
        }
        this.clearAllCaches();
    }

    private final void saveExpandedNodes() {
        this.expandedNodes.clear();
        int n = this.jTree.getRowCount();
        for (int i = 0; i < n; ++i) {
            if (!this.jTree.isExpanded(i)) continue;
            TreePath p = this.jTree.getPathForRow(i);
            ((Map)this.expandedNodes).put(p.getLastPathComponent(), p);
        }
    }

    private final void restoreExpandedNodes() {
        Iterator<TreePath> iterator = this.expandedNodes.values().iterator();
        while (iterator.hasNext()) {
            TreePath path;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            this.jTree.expandPath(path);
        }
    }

    private final void invalidateTreeComponent() {
        Object[] objectArray = new Object[]{this.originModel.getRoot()};
        TreeModelEvent eventInfo = new TreeModelEvent((Object)this.jTree, objectArray);
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TreeModelListener it = (TreeModelListener)element$iv;
            boolean bl = false;
            it.treeStructureChanged(eventInfo);
        }
        this.jTree.repaint();
    }

    private final void processTreeNodes() {
        this.cache.clear();
        Object object = this.originModel.getRoot();
        if (object == null) {
            return;
        }
        Object rootNode = object;
        Row rootRow = this.processNode(null, rootNode);
        rootRow.visible = true;
    }

    @NotNull
    protected final Row processNode(@Nullable TreePath parentPath, @NotNull Object node) {
        Row[] children;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        boolean matches = this.checkNodeMatches(node);
        TreePath treePath = parentPath;
        TreePath nodePath = treePath != null ? treePath.pathByAddingChild(node) : new TreePath(node);
        boolean leaf = this.originModel.isLeaf(node) || parentPath != null && !this.jTree.isExpanded(nodePath) && !this.expandedNodes.containsKey(node);
        Row[] rowArray = children = !leaf ? this.gatherNodeChildren(nodePath, node) : null;
        if (!leaf && children == null) {
            leaf = true;
        }
        boolean visible = matches || !leaf;
        Row row = new Row(node, matches);
        row.visible = visible;
        row.leaf = leaf;
        row.children = children;
        ((Map)this.cache).put(node, row);
        return row;
    }

    private final Row[] gatherNodeChildren(TreePath nodePath, Object node) {
        Row[] rowArray;
        int n = this.originModel.getChildCount(node);
        if (n < 1) {
            return null;
        }
        ArrayList childrenRows = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            Object childNode;
            if (this.originModel.getChild(node, i) == null) continue;
            Row childRow = this.processNode(nodePath, childNode);
            if (!childRow.visible) continue;
            ((Collection)childrenRows).add(childRow);
        }
        if (!((Collection)childrenRows).isEmpty()) {
            Collection $this$toTypedArray$iv = childrenRows;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            rowArray = thisCollection$iv.toArray(new Row[0]);
        } else {
            rowArray = null;
        }
        return rowArray;
    }

    private final Row obtainRow(Object node) {
        return this.cache.get(node);
    }

    private final boolean checkNodeMatches(Object node) {
        String string = this.input;
        if (string == null) {
            return false;
        }
        String input = string;
        return this.matcher.matches(node, input);
    }

    public final void expandAllNodesInTheTree() {
        int n = this.jTree.getRowCount();
        int expanded = 0;
        for (int i = 0; i < n && n < limitExpandingTotalRows && expanded < limitExpandingExpandedNodes; ++i) {
            if (!this.jTree.isCollapsed(i)) continue;
            this.jTree.expandRow(i);
            int n2 = this.jTree.getRowCount();
            if (n2 > n) {
                ++expanded;
            }
            n = n2;
        }
    }

    private final void clearAllCaches() {
        this.cache.clear();
    }

    @Override
    @Nullable
    public Object getRoot() {
        return this.originModel.getRoot();
    }

    @Override
    @Nullable
    public Object getChild(@NotNull Object parent2, int index) {
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        TreeFilterModel this_$iv = this;
        boolean $i$f$getPassing = false;
        if (!this_$iv.filtering) {
            return this.originModel.getChild(parent2, index);
        }
        Row row = this.obtainRow(parent2);
        if (row == null) {
            return null;
        }
        Row row2 = row;
        Row row3 = row2.getChild(index);
        return row3 != null ? row3.node : null;
    }

    @Override
    public int getChildCount(@NotNull Object parent2) {
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        TreeFilterModel this_$iv = this;
        boolean $i$f$getPassing = false;
        if (!this_$iv.filtering) {
            return this.originModel.getChildCount(parent2);
        }
        Row row = this.obtainRow(parent2);
        if (row == null) {
            return 0;
        }
        Row row2 = row;
        return row2.getChildrenCount();
    }

    @Override
    public boolean isLeaf(@NotNull Object node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        TreeFilterModel this_$iv = this;
        boolean $i$f$getPassing = false;
        if (!this_$iv.filtering) {
            return this.originModel.isLeaf(node);
        }
        Row row = this.obtainRow(node);
        if (row == null) {
            return true;
        }
        Row row2 = row;
        return row2.leaf;
    }

    @Override
    public void valueForPathChanged(@NotNull TreePath path, @NotNull Object newValue) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        this.originModel.valueForPathChanged(path, newValue);
    }

    @Override
    public int getIndexOfChild(@Nullable Object parent2, @Nullable Object child) {
        TreeFilterModel this_$iv = this;
        boolean $i$f$getPassing = false;
        if (!this_$iv.filtering) {
            return this.originModel.getIndexOfChild(parent2, child);
        }
        if (parent2 == null || child == null) {
            return -1;
        }
        if (this.obtainRow(parent2) == null) {
            return -1;
        }
        Row row = this.obtainRow(child);
        if (row == null) {
            return -1;
        }
        Row childRow = row;
        return childRow.index;
    }

    @Override
    public void addTreeModelListener(@NotNull TreeModelListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.listeners.add(0, l);
    }

    @Override
    public void removeTreeModelListener(@NotNull TreeModelListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.listeners.remove(l);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/database/view/TreeFilterModel$Companion;", "", "<init>", "()V", "noIndex", "", "limitExpandingTotalRows", "limitExpandingExpandedNodes", "intellij.database.impl"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/view/TreeFilterModel$Matcher;", "", "matches", "", "node", "input", "", "intellij.database.impl"})
    public static interface Matcher {
        public boolean matches(@NotNull Object var1, @NotNull String var2);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\f\u0010\u000b\u001a\u00020\u0007*\u00020\u0007H\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/database/view/TreeFilterModel$OriginModelListener;", "Ljavax/swing/event/TreeModelListener;", "<init>", "(Lcom/intellij/database/view/TreeFilterModel;)V", "treeNodesChanged", "", "e", "Ljavax/swing/event/TreeModelEvent;", "treeNodesInserted", "treeNodesRemoved", "treeStructureChanged", "adjustEvent", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nTreeFilterModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TreeFilterModel.kt\ncom/intellij/database/view/TreeFilterModel$OriginModelListener\n+ 2 TreeFilterModel.kt\ncom/intellij/database/view/TreeFilterModel\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,293:1\n86#2:294\n86#2:297\n86#2:300\n86#2:303\n1915#3,2:295\n1915#3,2:298\n1915#3,2:301\n1915#3,2:304\n*S KotlinDebug\n*F\n+ 1 TreeFilterModel.kt\ncom/intellij/database/view/TreeFilterModel$OriginModelListener\n*L\n271#1:294\n275#1:297\n279#1:300\n283#1:303\n271#1:295,2\n275#1:298,2\n279#1:301,2\n283#1:304,2\n*E\n"})
    private final class OriginModelListener
    implements TreeModelListener {
        @Override
        public void treeNodesChanged(@NotNull TreeModelEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            TreeFilterModel this_$iv = TreeFilterModel.this;
            boolean $i$f$getPassing = false;
            if (!this_$iv.filtering) {
                Iterable $this$forEach$iv = TreeFilterModel.this.listeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TreeModelListener it = (TreeModelListener)element$iv;
                    boolean bl = false;
                    it.treeNodesChanged(this.adjustEvent(e));
                }
            }
        }

        @Override
        public void treeNodesInserted(@NotNull TreeModelEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            TreeFilterModel this_$iv = TreeFilterModel.this;
            boolean $i$f$getPassing = false;
            if (!this_$iv.filtering) {
                Iterable $this$forEach$iv = TreeFilterModel.this.listeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TreeModelListener it = (TreeModelListener)element$iv;
                    boolean bl = false;
                    it.treeNodesInserted(this.adjustEvent(e));
                }
            }
        }

        @Override
        public void treeNodesRemoved(@NotNull TreeModelEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            TreeFilterModel this_$iv = TreeFilterModel.this;
            boolean $i$f$getPassing = false;
            if (!this_$iv.filtering) {
                Iterable $this$forEach$iv = TreeFilterModel.this.listeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TreeModelListener it = (TreeModelListener)element$iv;
                    boolean bl = false;
                    it.treeNodesRemoved(this.adjustEvent(e));
                }
            }
        }

        @Override
        public void treeStructureChanged(@NotNull TreeModelEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            TreeFilterModel this_$iv = TreeFilterModel.this;
            boolean $i$f$getPassing = false;
            if (!this_$iv.filtering) {
                Iterable $this$forEach$iv = TreeFilterModel.this.listeners;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TreeModelListener it = (TreeModelListener)element$iv;
                    boolean bl = false;
                    it.treeStructureChanged(this.adjustEvent(e));
                }
            }
        }

        private final TreeModelEvent adjustEvent(TreeModelEvent $this$adjustEvent) {
            return $this$adjustEvent.getSource() == TreeFilterModel.this.originModel ? new TreeModelEvent((Object)TreeFilterModel.this, $this$adjustEvent.getTreePath(), $this$adjustEvent.getChildIndices(), $this$adjustEvent.getChildren()) : $this$adjustEvent;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00002\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000f\u001a\u00020\nJ\n\u0010\u0010\u001a\u00020\u0011H\u0096\u0080\u0004R\u0010\u0010\u0002\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/view/TreeFilterModel$Row;", "", "node", "matches", "", "<init>", "(Ljava/lang/Object;Z)V", "visible", "leaf", "index", "", "children", "", "[Lcom/intellij/database/view/TreeFilterModel$Row;", "getChild", "getChildrenCount", "toString", "", "intellij.database.impl"})
    protected static final class Row {
        @JvmField
        @NotNull
        public final Object node;
        @JvmField
        public final boolean matches;
        @JvmField
        public boolean visible;
        @JvmField
        public boolean leaf;
        @JvmField
        public int index;
        @JvmField
        @Nullable
        public Row[] children;

        public Row(@NotNull Object node, boolean matches) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.node = node;
            this.matches = matches;
            this.index = -1;
        }

        @Nullable
        public final Row getChild(int index) {
            if (this.leaf || !this.visible) {
                return null;
            }
            if (this.children == null) {
                return null;
            }
            Row[] children = this.children;
            if (index >= 0 && index < children.length) {
                return children[index];
            }
            return null;
        }

        public final int getChildrenCount() {
            if (this.leaf || !this.visible) {
                return 0;
            }
            if (this.children == null) {
                return 0;
            }
            Row[] children = this.children;
            return children.length;
        }

        @NotNull
        public String toString() {
            return this.visible ? (this.leaf ? (char)'\u2013' : '+') + "[" + this.index + "] " + this.node : "[x] " + this.node;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/database/view/TreeFilterModel$SimpleMatcher;", "Lcom/intellij/database/view/TreeFilterModel$Matcher;", "<init>", "()V", "matches", "", "node", "", "input", "", "intellij.database.impl"})
    public static final class SimpleMatcher
    implements Matcher {
        @NotNull
        public static final SimpleMatcher INSTANCE = new SimpleMatcher();

        private SimpleMatcher() {
        }

        @Override
        public boolean matches(@NotNull Object node, @NotNull String input) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return StringsKt.contains$default((CharSequence)node.toString(), (CharSequence)input, (boolean)false, (int)2, null);
        }
    }
}

