/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.actions;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.view.actions.UiDslFunKt;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.LabelPosition;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextAreaKt;
import com.intellij.ui.dsl.builder.TextFieldKt;
import java.awt.Color;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0017\u001a\u00020\u0018H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0010\u001a\f0\t\u00a2\u0006\u0002\b\u0011\u00a2\u0006\u0002\b\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/view/actions/ConfigureLayoutDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "ds", "Lcom/intellij/database/dataSource/LocalDataSource;", "configuringNode", "Lcom/intellij/database/model/basic/BasicNode;", "configurationKey", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/LocalDataSource;Lcom/intellij/database/model/basic/BasicNode;Ljava/lang/String;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getDs", "()Lcom/intellij/database/dataSource/LocalDataSource;", "configurationText", "Lorg/jetbrains/annotations/Nullable;", "Lcom/intellij/openapi/util/NlsSafe;", "getConfigurationText", "()Ljava/lang/String;", "setConfigurationText", "(Ljava/lang/String;)V", "createCenterPanel", "Ljavax/swing/JComponent;", "intellij.database.impl"})
public final class ConfigureLayoutDialog
extends DialogWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final LocalDataSource ds;
    @NotNull
    private final BasicNode configuringNode;
    @NotNull
    private final String configurationKey;
    @NotNull
    private String configurationText;

    public ConfigureLayoutDialog(@NotNull Project project, @NotNull LocalDataSource ds, @NotNull BasicNode configuringNode, @NotNull String configurationKey) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        Intrinsics.checkNotNullParameter((Object)configuringNode, (String)"configuringNode");
        Intrinsics.checkNotNullParameter((Object)configurationKey, (String)"configurationKey");
        super(project, null, true, DialogWrapper.IdeModalityType.PROJECT, true);
        this.project = project;
        this.ds = ds;
        this.configuringNode = configuringNode;
        this.configurationKey = configurationKey;
        String string = this.ds.getLayoutConfigurationFor(this.configurationKey);
        if (string == null) {
            string = "";
        }
        this.configurationText = string;
        this.setTitle("Database Tree Layout Configuration");
        this.init();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final LocalDataSource getDs() {
        return this.ds;
    }

    @NotNull
    public final String getConfigurationText() {
        return this.configurationText;
    }

    public final void setConfigurationText(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.configurationText = string;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        Font font = EditorFontType.getGlobalPlainFont();
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getGlobalPlainFont(...)");
        Font textFont = font;
        Border simpleBorder = BorderFactory.createLineBorder(Color.LIGHT_GRAY);
        DialogPanel form2 = BuilderKt.panel(arg_0 -> ConfigureLayoutDialog.createCenterPanel$lambda$0(this, textFont, simpleBorder, arg_0));
        return (JComponent)form2;
    }

    private static final Unit createCenterPanel$lambda$0$1$0(ConfigureLayoutDialog this$0, Font $textFont, Border $simpleBorder, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = this$0.ds.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        Cell cell = UiDslFunKt.font(Row.text$default((Row)$this$row, (String)string, (int)0, null, (int)6, null).align((Align)AlignX.FILL.INSTANCE), $textFont);
        Intrinsics.checkNotNull((Object)$simpleBorder);
        UiDslFunKt.border(cell, $simpleBorder);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$1$1(ConfigureLayoutDialog this$0, Font $textFont, Border $simpleBorder, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = this$0.configuringNode.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        Cell cell = UiDslFunKt.font(Row.text$default((Row)$this$row, (String)string, (int)0, null, (int)6, null).align((Align)AlignX.FILL.INSTANCE), $textFont);
        Intrinsics.checkNotNull((Object)$simpleBorder);
        UiDslFunKt.border(cell, $simpleBorder);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.label("What is configured:");
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$1(ConfigureLayoutDialog this$0, Font $textFont, Border $simpleBorder, Panel $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        $this$indent.row("Data Source:", arg_0 -> ConfigureLayoutDialog.createCenterPanel$lambda$0$1$0(this$0, $textFont, $simpleBorder, arg_0));
        $this$indent.row("Element:", arg_0 -> ConfigureLayoutDialog.createCenterPanel$lambda$0$1$1(this$0, $textFont, $simpleBorder, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$2(Font $textFont, ConfigureLayoutDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        TextFieldKt.bindText(UiDslFunKt.font(TextAreaKt.columns((Cell)TextAreaKt.rows((Cell)$this$row.textArea(), (int)7), (int)44).label("Configuration:", LabelPosition.TOP).align(Align.FILL), $textFont), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

            public Object get() {
                return ((ConfigureLayoutDialog)((Object)this.receiver)).getConfigurationText();
            }

            public void set(Object value) {
                ((ConfigureLayoutDialog)((Object)this.receiver)).setConfigurationText((String)value);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0(ConfigureLayoutDialog this$0, Font $textFont, Border $simpleBorder, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, ConfigureLayoutDialog::createCenterPanel$lambda$0$0, (int)1, null);
        $this$panel.indent(arg_0 -> ConfigureLayoutDialog.createCenterPanel$lambda$0$1(this$0, $textFont, $simpleBorder, arg_0));
        Row.rowComment$default((Row)Panel.row$default((Panel)$this$panel, null, arg_0 -> ConfigureLayoutDialog.createCenterPanel$lambda$0$2($textFont, this$0, arg_0), (int)1, null).resizableRow(), (String)"There should be instructions how to configure using regular expressions", (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }
}

