/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.structure;

import com.intellij.database.util.sequences.SequenceFun;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.structure.DvDeleteFolders;
import com.intellij.database.view.structure.DvDeleteSingleEmptyFolder;
import com.intellij.database.view.structure.DvFolderDeleteProvider$canDeleteElement$;
import com.intellij.database.view.structure.DvForestCommand;
import com.intellij.database.view.structure.DvTreeNodeRank;
import com.intellij.database.view.structure.forest.DvForest;
import com.intellij.database.view.structure.forest.DvForestService;
import com.intellij.database.view.structure.forest.DvNiceFolder;
import com.intellij.ide.DeleteProvider;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/view/structure/DvFolderDeleteProvider;", "Lcom/intellij/ide/DeleteProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "canDeleteElement", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "deleteElement", "", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDvFolderDeleteProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvFolderDeleteProvider.kt\ncom/intellij/database/view/structure/DvFolderDeleteProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,62:1\n812#2,12:63\n812#2,12:78\n30#3,2:75\n479#4:77\n*S KotlinDebug\n*F\n+ 1 DvFolderDeleteProvider.kt\ncom/intellij/database/view/structure/DvFolderDeleteProvider\n*L\n30#1:63,12\n49#1:78,12\n34#1:75,2\n39#1:77\n*E\n"})
public final class DvFolderDeleteProvider
implements DeleteProvider {
    @NotNull
    private final Project project;

    public DvFolderDeleteProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    /*
     * WARNING - void declaration
     */
    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        DvTreeNodeRank theSingleRank = (DvTreeNodeRank)CollectionsKt.singleOrNull((Iterable)DatabaseContextFun.getSelectedTreeNodeRanks(dataContext));
        if (theSingleRank != DvTreeNodeRank.TL_FOLDER) {
            return false;
        }
        Iterable iterable = (Iterable)DatabaseContextFun.getSelectedNodes(dataContext);
        boolean $i$f$filterIsInstance = false;
        Iterator iterator = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof DvNiceFolder)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List selectedFolders = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        if (selectedFolders.isEmpty()) {
            return false;
        }
        boolean hasDataSources = false;
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Sequence serviceClass$iv = DvForestService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        DvForest forest = ((DvForestService)object).getForest();
        for (DvNiceFolder folder : selectedFolders) {
            void $this$filterIsInstance$iv2;
            serviceClass$iv = SequencesKt.asSequence((Iterator)forest.getVisibleTree().traverseBreadthFirst((Object)folder));
            boolean $i$f$filterIsInstance2 = false;
            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv2, (Function1)canDeleteElement$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            hasDataSources = SequenceFun.isNotEmpty((Sequence)sequence);
            if (!hasDataSources) continue;
        }
        return !hasDataSources;
    }

    /*
     * WARNING - void declaration
     */
    public void deleteElement(@NotNull DataContext dataContext) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Iterable $this$filterIsInstance$iv = (Iterable)DatabaseContextFun.getSelectedNodes(dataContext);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof DvNiceFolder)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List foldersToDelete = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        if (foldersToDelete.isEmpty()) {
            return;
        }
        DvNiceFolder singleFolder = (DvNiceFolder)CollectionsKt.singleOrNull((List)foldersToDelete);
        DvForestCommand command = singleFolder != null && singleFolder.isEmpty() ? (DvForestCommand)new DvDeleteSingleEmptyFolder(this.project, singleFolder) : (DvForestCommand)new DvDeleteFolders(this.project, foldersToDelete);
        command.doIt();
    }
}

