/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.config.utils.presentation;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.lang.properties.PropertiesHighlighter;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKeyLookupElementBuilder;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiType;
import com.intellij.ui.JBColor;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u001e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0080@\u00a2\u0006\u0002\u0010\u0007\u001a.\u0010\b\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\fH\u0002\u001a\u001c\u0010\u0010\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0014\u0010\u0011\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0014\u0010\u0012\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0016\u0010\u0013\u001a\u00020\u0001*\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\fH\u0002\u001a\u0014\u0010\u0014\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\u0016"}, d2={"metaConfigKeyRenderFast", "", "element", "Lcom/intellij/codeInsight/lookup/LookupElement;", "presentation", "Lcom/intellij/codeInsight/lookup/LookupElementPresentation;", "metaConfigKeyExpensiveRender", "(Lcom/intellij/codeInsight/lookup/LookupElement;Lcom/intellij/codeInsight/lookup/LookupElementPresentation;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "metaConfigKeyRender", "configKey", "Lcom/intellij/microservices/jvm/config/MetaConfigKey;", "lookupString", "", "deprecation", "Lcom/intellij/microservices/jvm/config/MetaConfigKey$Deprecation;", "defaultValue", "setItemText", "setType", "setDescription", "setDefaultValue", "setDeprecation", "getConfigKeyFromContext", "intellij.microservices.config"})
public final class MetaConfigKeyLookupPresentationUtilsKt {
    public static final void metaConfigKeyRenderFast(@NotNull LookupElement element, @NotNull LookupElementPresentation presentation2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        MetaConfigKey configKey = MetaConfigKeyLookupPresentationUtilsKt.getConfigKeyFromContext(element);
        String string = element.getLookupString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLookupString(...)");
        MetaConfigKey.Deprecation deprecation = configKey.getDeprecationFast();
        Intrinsics.checkNotNullExpressionValue((Object)deprecation, (String)"getDeprecationFast(...)");
        MetaConfigKeyLookupPresentationUtilsKt.metaConfigKeyRender(presentation2, configKey, string, deprecation, configKey.getDefaultValueFast());
    }

    @Nullable
    public static final Object metaConfigKeyExpensiveRender(@NotNull LookupElement element, @NotNull LookupElementPresentation presentation2, @NotNull Continuation<? super Unit> $completion) {
        Object object = CoroutinesKt.readAction(() -> MetaConfigKeyLookupPresentationUtilsKt.metaConfigKeyExpensiveRender$lambda$0(element, presentation2), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final void metaConfigKeyRender(LookupElementPresentation $this$metaConfigKeyRender, MetaConfigKey configKey, String lookupString, MetaConfigKey.Deprecation deprecation, String defaultValue) {
        $this$metaConfigKeyRender.setIcon(configKey.getPresentation().getIcon());
        MetaConfigKeyLookupPresentationUtilsKt.setDeprecation($this$metaConfigKeyRender, deprecation);
        MetaConfigKeyLookupPresentationUtilsKt.setItemText($this$metaConfigKeyRender, lookupString, configKey);
        MetaConfigKeyLookupPresentationUtilsKt.setDefaultValue($this$metaConfigKeyRender, defaultValue);
        MetaConfigKeyLookupPresentationUtilsKt.setDescription($this$metaConfigKeyRender, configKey);
        MetaConfigKeyLookupPresentationUtilsKt.setType($this$metaConfigKeyRender, configKey);
    }

    private static final void setItemText(LookupElementPresentation $this$setItemText, String lookupString, MetaConfigKey configKey) {
        $this$setItemText.setItemText(lookupString);
        if (!Intrinsics.areEqual((Object)lookupString, (Object)configKey.getName())) {
            $this$setItemText.setItemTextBold(true);
        }
    }

    private static final void setType(LookupElementPresentation $this$setType, MetaConfigKey configKey) {
        PsiType psiType = configKey.getType();
        if (psiType == null) {
            return;
        }
        PsiType psiType2 = psiType;
        $this$setType.setTypeText(psiType2.getPresentableText());
        if (configKey.getDeclarationResolveResult() == MetaConfigKey.DeclarationResolveResult.JSON_UNRESOLVED_SOURCE_TYPE) {
            $this$setType.setTypeGrayed(true);
        }
    }

    private static final void setDescription(LookupElementPresentation $this$setDescription, MetaConfigKey configKey) {
        String string = configKey.getDescriptionText().getShortText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getShortText(...)");
        String shortDescription = string;
        if (((CharSequence)shortDescription).length() > 0) {
            $this$setDescription.appendTailText(" (" + shortDescription + ")", true);
        }
    }

    private static final void setDefaultValue(LookupElementPresentation $this$setDefaultValue, String defaultValue) {
        if (defaultValue == null) {
            return;
        }
        String string = StringUtil.shortenTextWithEllipsis((String)defaultValue, (int)60, (int)0, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenTextWithEllipsis(...)");
        String shortenedDefaultValue = string;
        TextAttributes attrs = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(PropertiesHighlighter.PropertiesComponent.PROPERTY_VALUE.getTextAttributesKey());
        $this$setDefaultValue.setTailText("=" + shortenedDefaultValue, attrs.getForegroundColor());
    }

    private static final void setDeprecation(LookupElementPresentation $this$setDeprecation, MetaConfigKey.Deprecation deprecation) {
        $this$setDeprecation.setStrikeout(!Intrinsics.areEqual((Object)deprecation, (Object)MetaConfigKey.Deprecation.NOT_DEPRECATED));
        if (deprecation.getLevel() == MetaConfigKey.Deprecation.DeprecationLevel.ERROR) {
            $this$setDeprecation.setItemTextForeground((Color)JBColor.RED);
        }
    }

    private static final MetaConfigKey getConfigKeyFromContext(LookupElement element) {
        MetaConfigKey configKey;
        MetaConfigKey metaConfigKey = configKey = (MetaConfigKey)element.getUserData(MetaConfigKeyLookupElementBuilder.MY_KEY);
        if (metaConfigKey == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        return metaConfigKey;
    }

    private static final Unit metaConfigKeyExpensiveRender$lambda$0(LookupElement $element, LookupElementPresentation $presentation) {
        MetaConfigKey configKey = MetaConfigKeyLookupPresentationUtilsKt.getConfigKeyFromContext($element);
        MetaConfigKey.Deprecation deprecation = configKey.getDeprecation();
        Intrinsics.checkNotNullExpressionValue((Object)deprecation, (String)"getDeprecation(...)");
        MetaConfigKey.Deprecation deprecation2 = deprecation;
        String defaultValue = configKey.getDefaultValue();
        String string = $element.getLookupString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLookupString(...)");
        MetaConfigKeyLookupPresentationUtilsKt.metaConfigKeyRender($presentation, configKey, string, deprecation2, defaultValue);
        return Unit.INSTANCE;
    }
}

