/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\b\u00a8\u0006\n"}, d2={"Lcom/intellij/database/datagrid/DataGridStartupActivity;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "DataEditorConfigurator", "intellij.grid.impl"})
public final class DataGridStartupActivity
implements ProjectActivity {
    @Nullable
    public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        DataEditorConfigurator.INSTANCE.configure(project);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\t\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\n0\n0\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u000b\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\n0\n0\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/datagrid/DataGridStartupActivity$DataEditorConfigurator;", "", "<init>", "()V", "LAUNCH_ID", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "SAFE_LOADING_KEY", "", "LOADING_DELAYED_KEY", "configure", "", "project", "Lcom/intellij/openapi/project/Project;", "isSafeToLoadData", "isLoadingDelayed", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "delayLoading", "disableLoadingDelay", "initLaunchId", "getLaunchId", "intellij.grid.impl"})
    public static final class DataEditorConfigurator {
        @NotNull
        public static final DataEditorConfigurator INSTANCE = new DataEditorConfigurator();
        @NotNull
        private static final Key<String> LAUNCH_ID;
        @NotNull
        private static final Key<Boolean> SAFE_LOADING_KEY;
        @NotNull
        private static final Key<Boolean> LOADING_DELAYED_KEY;

        private DataEditorConfigurator() {
        }

        public final void configure(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            SAFE_LOADING_KEY.set((UserDataHolder)project, (Object)true);
            this.initLaunchId(project);
        }

        @JvmStatic
        public static final boolean isSafeToLoadData(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return Intrinsics.areEqual((Object)true, (Object)SAFE_LOADING_KEY.get((UserDataHolder)project));
        }

        @JvmStatic
        public static final boolean isLoadingDelayed(@NotNull DataGrid grid) {
            Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
            return Intrinsics.areEqual((Object)true, (Object)LOADING_DELAYED_KEY.get((UserDataHolder)grid));
        }

        @JvmStatic
        public static final void delayLoading(@NotNull DataGrid grid) {
            Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
            LOADING_DELAYED_KEY.set((UserDataHolder)grid, (Object)true);
            grid.loadingDelayed();
        }

        @JvmStatic
        public static final void disableLoadingDelay(@NotNull DataGrid grid) {
            Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
            LOADING_DELAYED_KEY.set((UserDataHolder)grid, null);
            grid.loadingDelayDisabled();
        }

        private final String initLaunchId(Project project) {
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String restartId = string;
            LAUNCH_ID.set((UserDataHolder)project, (Object)restartId);
            return restartId;
        }

        @JvmStatic
        @NotNull
        public static final String getLaunchId(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String launchId = (String)LAUNCH_ID.get((UserDataHolder)project);
            String string = launchId;
            if (string == null) {
                string = INSTANCE.initLaunchId(project);
            }
            return string;
        }

        static {
            Key key = Key.create((String)"DATABASE_PROJECT_LAUNCH_ID");
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
            LAUNCH_ID = key;
            Key key2 = Key.create((String)"DATA_GRID_SAFE_LOADING_KEY");
            Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
            SAFE_LOADING_KEY = key2;
            Key key3 = Key.create((String)"DATA_GRID_LOADING_DELAYED_KEY");
            Intrinsics.checkNotNullExpressionValue((Object)key3, (String)"create(...)");
            LOADING_DELAYED_KEY = key3;
        }
    }
}

