/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.run.actions.AddColumnAction;
import com.intellij.database.run.actions.DeleteColumnsAction;
import com.intellij.database.run.actions.GridEditAction;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import org.jetbrains.annotations.NotNull;

public class CloneColumnAction
extends DumbAwareAction
implements GridEditAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            CloneColumnAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        DataGrid dataGrid;
        if (e == null) {
            CloneColumnAction.$$$reportNull$$$0(1);
        }
        boolean singleColumnSelected = (dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) != null && DeleteColumnsAction.getColumns(dataGrid).size() == 1;
        boolean canAddColumn = GridUtil.canMutateColumns((DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY));
        e.getPresentation().setEnabledAndVisible(singleColumnSelected && canAddColumn && !GridHelper.get(dataGrid).isModifyColumnAcrossCollection());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataGrid dataGrid;
        ModelIndexSet<GridColumn> columns;
        if (e == null) {
            CloneColumnAction.$$$reportNull$$$0(2);
        }
        ModelIndexSet<GridColumn> modelIndexSet = columns = (dataGrid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) != null ? DeleteColumnsAction.getColumns(dataGrid) : null;
        if (columns == null || columns.size() != 1) {
            return;
        }
        ModelIndex selectedColumn = (ModelIndex)columns.asIterable().first();
        if (selectedColumn != null && selectedColumn.isValid((CoreGrid)dataGrid)) {
            CloneColumnAction.cloneColumn(dataGrid, (ModelIndex<GridColumn>)selectedColumn);
        }
    }

    public static void cloneColumn(@NotNull DataGrid grid, @NotNull ModelIndex<GridColumn> selectedColumn) {
        GridMutator.ColumnsMutator<GridRow, GridColumn> mutator;
        if (grid == null) {
            CloneColumnAction.$$$reportNull$$$0(3);
        }
        if (selectedColumn == null) {
            CloneColumnAction.$$$reportNull$$$0(4);
        }
        if ((mutator = GridUtil.getColumnsMutator(grid)) == null) {
            return;
        }
        if (mutator.isUpdateImmediately() && mutator.hasPendingChanges()) {
            grid.submit().doWhenDone(() -> mutator.cloneColumn(AddColumnAction.newInsertOrCloneColumnRequestSource(grid), selectedColumn));
            return;
        }
        mutator.cloneColumn(AddColumnAction.newInsertOrCloneColumnRequestSource(grid), selectedColumn);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/CloneColumnAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedColumn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/CloneColumnAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "cloneColumn";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

