/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.treetable;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.treetable.Node;
import com.intellij.database.run.ui.treetable.NodeWithCache;
import com.intellij.database.run.ui.treetable.ValueWrapper;
import com.intellij.database.run.ui.treetable.ValueWrapperKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B3\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0014R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/run/ui/treetable/ColumnNode;", "Lcom/intellij/database/run/ui/treetable/NodeWithCache;", "Lcom/intellij/database/run/ui/treetable/Node;", "name", "", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "rowIdx", "Lcom/intellij/database/datagrid/ModelIndex;", "Lcom/intellij/database/datagrid/GridRow;", "columnIdx", "Lcom/intellij/database/datagrid/GridColumn;", "<init>", "(Ljava/lang/String;Lcom/intellij/database/datagrid/DataGrid;Lcom/intellij/database/datagrid/ModelIndex;Lcom/intellij/database/datagrid/ModelIndex;)V", "getName", "()Ljava/lang/String;", "getColumnIdx", "()Lcom/intellij/database/datagrid/ModelIndex;", "createWrapper", "Lcom/intellij/database/run/ui/treetable/ValueWrapper;", "intellij.grid.impl"})
@SourceDebugExtension(value={"SMAP\nNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Node.kt\ncom/intellij/database/run/ui/treetable/ColumnNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,99:1\n1#2:100\n*E\n"})
public final class ColumnNode
extends NodeWithCache<Node> {
    @NotNull
    private final String name;
    @NotNull
    private final DataGrid grid;
    @NotNull
    private final ModelIndex<GridRow> rowIdx;
    @NotNull
    private final ModelIndex<GridColumn> columnIdx;

    public ColumnNode(@NotNull String name, @NotNull DataGrid grid, @NotNull ModelIndex<GridRow> rowIdx, @NotNull ModelIndex<GridColumn> columnIdx) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter(rowIdx, (String)"rowIdx");
        Intrinsics.checkNotNullParameter(columnIdx, (String)"columnIdx");
        this.name = name;
        this.grid = grid;
        this.rowIdx = rowIdx;
        this.columnIdx = columnIdx;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final ModelIndex<GridColumn> getColumnIdx() {
        return this.columnIdx;
    }

    @Override
    @NotNull
    protected ValueWrapper<Node> createWrapper() {
        Object object;
        GridRow row;
        GridModel gridModel = this.grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        Intrinsics.checkNotNullExpressionValue((Object)gridModel, (String)"getDataModel(...)");
        GridModel dataModel = gridModel;
        GridRow gridRow = row = (GridRow)dataModel.getRow(this.rowIdx);
        if (gridRow != null) {
            GridRow it = gridRow;
            boolean bl = false;
            GridColumn gridColumn = (GridColumn)dataModel.getColumn(this.columnIdx);
            object = gridColumn != null ? gridColumn.getValue(row) : null;
        } else {
            object = null;
        }
        Object value = object;
        return ValueWrapperKt.wrap(value);
    }
}

