/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes;

import com.intellij.kubernetes.DownloadManager;
import com.intellij.kubernetes.KubernetesSpecManager;
import com.intellij.kubernetes.KubernetesSpecManagerKt;
import com.intellij.kubernetes.MiscUtilKt;
import com.intellij.kubernetes.SpecModificationListener;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.model.ExternalSpecInfo;
import com.intellij.kubernetes.ui.NotificationsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.io.File;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0004)*+,B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00102\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0012\u0010\u001b\u001a\u00020\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0010\u0010 \u001a\u0004\u0018\u00010\u00112\u0006\u0010!\u001a\u00020\u0010J.\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00132\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00100&2\b\b\u0002\u0010'\u001a\u00020\u0013H\u0086@\u00a2\u0006\u0002\u0010(R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\"\u0010\u001d\u001a\u0004\u0018\u00010\u00112\b\u0010\u001c\u001a\u0004\u0018\u00010\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006-"}, d2={"Lcom/intellij/kubernetes/KubernetesSpecManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "listener", "Lcom/intellij/kubernetes/SpecModificationListener;", "getListener$intellij_clouds_kubernetes_backend", "()Lcom/intellij/kubernetes/SpecModificationListener;", "lock", "Lkotlinx/coroutines/sync/Mutex;", "currentDownloadJob", "Lkotlinx/coroutines/Job;", "externalSpecAvailabilityInfo", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/kubernetes/KubernetesSpecManager$AvailabilityInfo;", "specErrorsReported", "", "getSpecErrorsReported", "()Z", "setExternalSpecAvailabilityStatus", "", "sourceSpec", "e", "", "makeAvailabilityInfo", "value", "clusterSpecAvailabilityInfo", "getClusterSpecAvailabilityInfo", "()Lcom/intellij/kubernetes/KubernetesSpecManager$AvailabilityInfo;", "getSpecErrorStatus", "specSource", "prepareSpecs", "Lcom/intellij/kubernetes/KubernetesSpecManager$SpecResults;", "getSpecFromCluster", "specSources", "", "reportToEventLog", "(ZLjava/util/List;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "SpecResults", "AvailabilityStatus", "AvailabilityInfo", "UserDefinedSpecInfos", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nKubernetesSpecManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesSpecManager.kt\ncom/intellij/kubernetes/KubernetesSpecManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 MiscUtil.kt\ncom/intellij/kubernetes/MiscUtilKt\n+ 4 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,324:1\n1#2:325\n133#3:326\n116#4,8:327\n125#4,2:339\n1915#5,2:335\n1915#5,2:337\n*S KotlinDebug\n*F\n+ 1 KubernetesSpecManager.kt\ncom/intellij/kubernetes/KubernetesSpecManager\n*L\n75#1:326\n92#1:327,8\n92#1:339,2\n107#1:335,2\n108#1:337,2\n*E\n"})
public final class KubernetesSpecManager {
    @NotNull
    private final Project project;
    @NotNull
    private final SpecModificationListener listener;
    @NotNull
    private final Mutex lock;
    @Nullable
    private Job currentDownloadJob;
    @NotNull
    private final ConcurrentHashMap<String, AvailabilityInfo> externalSpecAvailabilityInfo;
    @Nullable
    private AvailabilityInfo clusterSpecAvailabilityInfo;

    public KubernetesSpecManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.listener = new SpecModificationListener(this.project);
        this.lock = MutexKt.Mutex$default((boolean)false, (int)1, null);
        this.externalSpecAvailabilityInfo = new ConcurrentHashMap();
    }

    @NotNull
    public final SpecModificationListener getListener$intellij_clouds_kubernetes_backend() {
        return this.listener;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean getSpecErrorsReported() {
        Object t;
        AvailabilityInfo it;
        AvailabilityInfo availabilityInfo = this.clusterSpecAvailabilityInfo;
        if ((availabilityInfo != null ? availabilityInfo.getStatus() : null) == AvailabilityStatus.UNAVAILABLE) return true;
        Collection<AvailabilityInfo> collection = this.externalSpecAvailabilityInfo.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable iterable = collection;
        Iterator iterator = iterable.iterator();
        do {
            if (!iterator.hasNext()) return false;
            t = iterator.next();
            it = (AvailabilityInfo)t;
            boolean bl = false;
        } while (!(it.getStatus() == AvailabilityStatus.UNAVAILABLE));
        Object v2 = t;
        if (v2 == null) return false;
        return true;
    }

    private final void setExternalSpecAvailabilityStatus(String sourceSpec, Throwable e) {
        ((Map)this.externalSpecAvailabilityInfo).put(sourceSpec, this.makeAvailabilityInfo(e));
    }

    private final AvailabilityInfo makeAvailabilityInfo(Throwable e) {
        AvailabilityStatus availabilityStatus;
        AvailabilityStatus availabilityStatus2;
        boolean condition$iv = e != null;
        boolean $i$f$doIf = false;
        if (condition$iv) {
            boolean bl = false;
            availabilityStatus2 = AvailabilityStatus.UNAVAILABLE;
        } else {
            availabilityStatus2 = availabilityStatus = null;
        }
        if (availabilityStatus2 == null) {
            availabilityStatus = AvailabilityStatus.AVAILABLE;
        }
        Throwable throwable = e;
        AvailabilityStatus availabilityStatus3 = availabilityStatus;
        return new AvailabilityInfo(availabilityStatus3, throwable);
    }

    @Nullable
    public final AvailabilityInfo getClusterSpecAvailabilityInfo() {
        return this.clusterSpecAvailabilityInfo;
    }

    @Nullable
    public final AvailabilityInfo getSpecErrorStatus(@NotNull String specSource) {
        Intrinsics.checkNotNullParameter((Object)specSource, (String)"specSource");
        return this.externalSpecAvailabilityInfo.get(specSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object prepareSpecs(boolean getSpecFromCluster, @NotNull List<String> specSources, boolean reportToEventLog, @NotNull Continuation<? super SpecResults> $completion) {
        if (!($completion instanceof prepareSpecs.1)) ** GOTO lbl-1000
        var19_5 = $completion;
        if ((var19_5.label & -2147483648) != 0) {
            var19_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                boolean Z$0;
                boolean Z$1;
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ KubernetesSpecManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.prepareSpecs(false, null, false, (Continuation<? super SpecResults>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var20_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                specInfos = new UserDefinedSpecInfos(specSources);
                $this$withLock_u24default$iv = this.lock;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable(specSources);
                $continuation.L$1 = specInfos;
                $continuation.L$2 = $this$withLock_u24default$iv;
                $continuation.Z$0 = getSpecFromCluster;
                $continuation.Z$1 = reportToEventLog;
                $continuation.I$0 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var20_7) {
                    return var20_7;
                }
                ** GOTO lbl37
            }
            case 1: {
                $i$f$withLock = $continuation.I$0;
                reportToEventLog = $continuation.Z$1;
                getSpecFromCluster = $continuation.Z$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$2;
                specInfos = (UserDefinedSpecInfos)$continuation.L$1;
                specSources = (List)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl37:
                // 2 sources

                try {
                    $i$a$-withLock$default-KubernetesSpecManager$prepareSpecs$2 = false;
                    if (this.currentDownloadJob != null) {
                        v1 = this.currentDownloadJob;
                        Intrinsics.checkNotNull((Object)v1);
                        Job.DefaultImpls.cancel$default((Job)v1, null, (int)1, null);
                        this.currentDownloadJob = null;
                    }
                    this.clusterSpecAvailabilityInfo = null;
                    this.externalSpecAvailabilityInfo.clear();
                    this.listener.update(CollectionsKt.emptyList());
                    specInfos.analyzeSpecs();
                    this.listener.update(specInfos.getListenableFiles());
                    $this$forEach$iv = specInfos.getInvalidSpecs();
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (String)element$iv;
                        $i$a$-forEach-KubernetesSpecManager$prepareSpecs$2$1 = false;
                        this.setExternalSpecAvailabilityStatus(it, new Exception("File does not exist"));
                    }
                    $this$forEach$iv = specInfos.getValidSpecs();
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (String)element$iv;
                        $i$a$-forEach-KubernetesSpecManager$prepareSpecs$2$2 = false;
                        this.setExternalSpecAvailabilityStatus(it, null);
                    }
                    var16_22 = Unit.INSTANCE;
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                if (reportToEventLog && specInfos.getInvalidSpecs().isEmpty() == false) {
                    NotificationsKt.createModelLoadingErrorNotification((String)(KubernetesBundle.message((String)"KubernetesModelProvider.model.loading.missing.files.error", (Object[])new Object[0]) + CollectionsKt.joinToString$default((Iterable)specInfos.getInvalidSpecs(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null))).notify(this.project);
                }
                if (!getSpecFromCluster && specInfos.getUrlsToDownload().isEmpty()) {
                    return new SpecResults(null, specInfos.extractExternalSpecInfos(), this.getSpecErrorsReported());
                }
                mainApiSpec = new Ref.ObjectRef();
                mainCrdSpec = new Ref.ObjectRef();
                v2 = KubernetesBundle.message((String)"KubernetesModelProvider.model.loading.background.task.title", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"message(...)");
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)specSources);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)specInfos);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)mainApiSpec);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)mainCrdSpec);
                $continuation.Z$0 = getSpecFromCluster;
                $continuation.Z$1 = reportToEventLog;
                $continuation.label = 2;
                v3 = TasksKt.withBackgroundProgress((Project)this.project, (String)v2, (boolean)true, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super SpecResults>, Object>(this, getSpecFromCluster != false, (Ref.ObjectRef<ExternalSpecInfo>)mainApiSpec, (Ref.ObjectRef<ExternalSpecInfo>)mainCrdSpec, specInfos, reportToEventLog != false, null){
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    Object L$6;
                    Object L$7;
                    Object L$8;
                    Object L$9;
                    Object L$10;
                    int I$0;
                    int I$1;
                    int I$2;
                    int I$3;
                    int I$4;
                    boolean Z$0;
                    boolean Z$1;
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ KubernetesSpecManager this$0;
                    final /* synthetic */ boolean $getSpecFromCluster;
                    final /* synthetic */ Ref.ObjectRef<ExternalSpecInfo> $mainApiSpec;
                    final /* synthetic */ Ref.ObjectRef<ExternalSpecInfo> $mainCrdSpec;
                    final /* synthetic */ UserDefinedSpecInfos $specInfos;
                    final /* synthetic */ boolean $reportToEventLog;
                    {
                        this.this$0 = $receiver;
                        this.$getSpecFromCluster = $getSpecFromCluster;
                        this.$mainApiSpec = $mainApiSpec;
                        this.$mainCrdSpec = $mainCrdSpec;
                        this.$specInfos = $specInfos;
                        this.$reportToEventLog = $reportToEventLog;
                        super(2, $completion);
                    }

                    /*
                     * Exception decompiling
                     */
                    public final Object invokeSuspend(Object $result) {
                        /*
                         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                         * 
                         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[CASE], 12[SWITCH]], but top level block is 7[TRYBLOCK]
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                         *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                         *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                         *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                         *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.dump(StructuredAssignment.java:69)
                         *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                         *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredCase.dump(StructuredCase.java:94)
                         *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                         *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredSwitch.dump(StructuredSwitch.java:59)
                         *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                         *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                         *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                         *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                         *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                         *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                         *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                         *     at org.benf.cfr.reader.Main.main(Main.java:54)
                         */
                        throw new IllegalStateException("Decompilation failed");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super SpecResults> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v3 == var20_7) {
                    return var20_7;
                }
                ** GOTO lbl97
            }
            case 2: {
                reportToEventLog = $continuation.Z$1;
                getSpecFromCluster = $continuation.Z$0;
                mainCrdSpec = (Ref.ObjectRef)$continuation.L$3;
                mainApiSpec = (Ref.ObjectRef)$continuation.L$2;
                specInfos = (UserDefinedSpecInfos)$continuation.L$1;
                specSources = (List)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl97:
                // 2 sources

                return v3;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object prepareSpecs$default(KubernetesSpecManager kubernetesSpecManager, boolean bl, List list, boolean bl2, Continuation continuation, int n, Object object) {
        if ((n & 4) != 0) {
            bl2 = true;
        }
        return kubernetesSpecManager.prepareSpecs(bl, list, bl2, (Continuation<? super SpecResults>)continuation);
    }

    public static final /* synthetic */ Mutex access$getLock$p(KubernetesSpecManager $this) {
        return $this.lock;
    }

    public static final /* synthetic */ Job access$getCurrentDownloadJob$p(KubernetesSpecManager $this) {
        return $this.currentDownloadJob;
    }

    public static final /* synthetic */ void access$setCurrentDownloadJob$p(KubernetesSpecManager $this, Job job2) {
        $this.currentDownloadJob = job2;
    }

    public static final /* synthetic */ void access$setClusterSpecAvailabilityInfo$p(KubernetesSpecManager $this, AvailabilityInfo availabilityInfo) {
        $this.clusterSpecAvailabilityInfo = availabilityInfo;
    }

    public static final /* synthetic */ AvailabilityInfo access$makeAvailabilityInfo(KubernetesSpecManager $this, Throwable e) {
        return $this.makeAvailabilityInfo(e);
    }

    public static final /* synthetic */ boolean access$getSpecErrorsReported(KubernetesSpecManager $this) {
        return $this.getSpecErrorsReported();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/kubernetes/KubernetesSpecManager$AvailabilityInfo;", "", "status", "Lcom/intellij/kubernetes/KubernetesSpecManager$AvailabilityStatus;", "error", "", "<init>", "(Lcom/intellij/kubernetes/KubernetesSpecManager$AvailabilityStatus;Ljava/lang/Throwable;)V", "getStatus", "()Lcom/intellij/kubernetes/KubernetesSpecManager$AvailabilityStatus;", "getError", "()Ljava/lang/Throwable;", "errorMessage", "", "getErrorMessage", "()Ljava/lang/String;", "intellij.clouds.kubernetes.backend"})
    public static final class AvailabilityInfo {
        @NotNull
        private final AvailabilityStatus status;
        @Nullable
        private final Throwable error;

        public AvailabilityInfo(@NotNull AvailabilityStatus status, @Nullable Throwable error) {
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            this.status = status;
            this.error = error;
        }

        public /* synthetic */ AvailabilityInfo(AvailabilityStatus availabilityStatus, Throwable throwable, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                throwable = null;
            }
            this(availabilityStatus, throwable);
        }

        @NotNull
        public final AvailabilityStatus getStatus() {
            return this.status;
        }

        @Nullable
        public final Throwable getError() {
            return this.error;
        }

        @Nullable
        public final String getErrorMessage() {
            Object object;
            if (this.error instanceof UnknownHostException) {
                object = "Unknown host: " + ((UnknownHostException)this.error).getMessage();
            } else {
                Throwable throwable = this.error;
                object = throwable != null ? throwable.getLocalizedMessage() : null;
            }
            return object;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/kubernetes/KubernetesSpecManager$AvailabilityStatus;", "", "<init>", "(Ljava/lang/String;I)V", "AVAILABLE", "UNAVAILABLE", "intellij.clouds.kubernetes.backend"})
    public static final class AvailabilityStatus
    extends Enum<AvailabilityStatus> {
        public static final /* enum */ AvailabilityStatus AVAILABLE = new AvailabilityStatus();
        public static final /* enum */ AvailabilityStatus UNAVAILABLE = new AvailabilityStatus();
        private static final /* synthetic */ AvailabilityStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static AvailabilityStatus[] values() {
            return (AvailabilityStatus[])$VALUES.clone();
        }

        public static AvailabilityStatus valueOf(String value) {
            return Enum.valueOf(AvailabilityStatus.class, value);
        }

        @NotNull
        public static EnumEntries<AvailabilityStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = availabilityStatusArray = new AvailabilityStatus[]{AvailabilityStatus.AVAILABLE, AvailabilityStatus.UNAVAILABLE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\u00020\u0001B'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/kubernetes/KubernetesSpecManager$SpecResults;", "", "mainSpec", "Lcom/intellij/kubernetes/model/ExternalSpecInfo;", "auxSpecs", "", "withErrors", "", "<init>", "(Lcom/intellij/kubernetes/model/ExternalSpecInfo;Ljava/util/List;Z)V", "getMainSpec", "()Lcom/intellij/kubernetes/model/ExternalSpecInfo;", "getAuxSpecs", "()Ljava/util/List;", "getWithErrors", "()Z", "intellij.clouds.kubernetes.backend"})
    public static final class SpecResults {
        @Nullable
        private final ExternalSpecInfo mainSpec;
        @NotNull
        private final List<ExternalSpecInfo> auxSpecs;
        private final boolean withErrors;

        public SpecResults(@Nullable ExternalSpecInfo mainSpec, @NotNull List<ExternalSpecInfo> auxSpecs, boolean withErrors) {
            Intrinsics.checkNotNullParameter(auxSpecs, (String)"auxSpecs");
            this.mainSpec = mainSpec;
            this.auxSpecs = auxSpecs;
            this.withErrors = withErrors;
        }

        @Nullable
        public final ExternalSpecInfo getMainSpec() {
            return this.mainSpec;
        }

        @NotNull
        public final List<ExternalSpecInfo> getAuxSpecs() {
            return this.auxSpecs;
        }

        public final boolean getWithErrors() {
            return this.withErrors;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0001)B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u0011J\u0010\u0010\"\u001a\u0004\u0018\u00010\u00042\u0006\u0010!\u001a\u00020\u0011J,\u0010#\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0012\u0012\u0010\u0012\f\u0012\n0\nR\u00060\u0000R\u00020\u000b0\t\u0018\u00010\b2\u0006\u0010!\u001a\u00020\u0011H\u0002J\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u0003J\u0018\u0010&\u001a\n0\nR\u00060\u0000R\u00020\u000b2\u0006\u0010'\u001a\u00020\u0004H\u0002J\u001c\u0010&\u001a\f\u0018\u00010\nR\u00060\u0000R\u00020\u000b2\b\u0010!\u001a\u0004\u0018\u00010\u0011H\u0002J\u001c\u0010&\u001a\f\u0018\u00010\nR\u00060\u0000R\u00020\u000b2\b\u0010(\u001a\u0004\u0018\u00010\u0013H\u0002R.\u0010\u0007\u001a\"\u0012\u001e\u0012\u001c\u0012\u0004\u0012\u00020\u0004\u0012\u0012\u0012\u0010\u0012\f\u0012\n0\nR\u00060\u0000R\u00020\u000b0\t0\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u00040\rj\b\u0012\u0004\u0012\u00020\u0004`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00040\rj\b\u0012\u0004\u0012\u00020\u0004`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00110\rj\b\u0012\u0004\u0012\u00020\u0011`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00130\rj\b\u0012\u0004\u0012\u00020\u0013`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0017R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0017\u00a8\u0006*"}, d2={"Lcom/intellij/kubernetes/KubernetesSpecManager$UserDefinedSpecInfos;", "", "specSources", "", "", "<init>", "(Lcom/intellij/kubernetes/KubernetesSpecManager;Ljava/util/List;)V", "sourceSpecInfos", "Lkotlin/Pair;", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/kubernetes/KubernetesSpecManager$UserDefinedSpecInfos$LocalFileInfo;", "Lcom/intellij/kubernetes/KubernetesSpecManager;", "_validSpecs", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "_invalidSpecs", "_urlsToDownload", "Lcom/intellij/util/Url;", "_listenableFiles", "Lcom/intellij/openapi/vfs/VirtualFile;", "validSpecs", "", "getValidSpecs", "()Ljava/util/Collection;", "invalidSpecs", "getInvalidSpecs", "urlsToDownload", "getUrlsToDownload", "listenableFiles", "getListenableFiles", "analyzeSpecs", "", "update", "url", "findSpecSourceByUrl", "findSpecSourceRecordByUrl", "extractExternalSpecInfos", "Lcom/intellij/kubernetes/model/ExternalSpecInfo;", "getLocalFileInfo", "pathOrUrl", "file", "LocalFileInfo", "intellij.clouds.kubernetes.backend"})
    @SourceDebugExtension(value={"SMAP\nKubernetesSpecManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesSpecManager.kt\ncom/intellij/kubernetes/KubernetesSpecManager$UserDefinedSpecInfos\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,324:1\n1586#2:325\n1661#2,3:326\n1586#2:329\n1661#2,3:330\n1642#2,10:334\n1915#2:344\n1916#2:346\n1652#2:347\n1#3:333\n1#3:345\n*S KotlinDebug\n*F\n+ 1 KubernetesSpecManager.kt\ncom/intellij/kubernetes/KubernetesSpecManager$UserDefinedSpecInfos\n*L\n239#1:325\n239#1:326,3\n249#1:329\n249#1:330,3\n292#1:334,10\n292#1:344\n292#1:346\n292#1:347\n292#1:345\n*E\n"})
    private final class UserDefinedSpecInfos {
        @NotNull
        private final List<Pair<String, Ref<LocalFileInfo>>> sourceSpecInfos;
        @NotNull
        private final ArrayList<String> _validSpecs;
        @NotNull
        private final ArrayList<String> _invalidSpecs;
        @NotNull
        private final ArrayList<Url> _urlsToDownload;
        @NotNull
        private final ArrayList<VirtualFile> _listenableFiles;

        /*
         * WARNING - void declaration
         */
        public UserDefinedSpecInfos(List<String> specSources) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(specSources, (String)"specSources");
            Iterable iterable = CollectionsKt.distinct((Iterable)specSources);
            UserDefinedSpecInfos userDefinedSpecInfos = this;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new Pair((Object)it, (Object)new Ref(null)));
            }
            userDefinedSpecInfos.sourceSpecInfos = (List)destination$iv$iv;
            this._validSpecs = new ArrayList();
            this._invalidSpecs = new ArrayList();
            this._urlsToDownload = new ArrayList();
            this._listenableFiles = new ArrayList();
        }

        @NotNull
        public final Collection<String> getValidSpecs() {
            return this._validSpecs;
        }

        @NotNull
        public final Collection<String> getInvalidSpecs() {
            return this._invalidSpecs;
        }

        @NotNull
        public final Collection<Url> getUrlsToDownload() {
            return this._urlsToDownload;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Collection<String> getListenableFiles() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this._listenableFiles;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(p0.getPath());
            }
            return (List)destination$iv$iv;
        }

        public final void analyzeSpecs() {
            for (Pair<String, Ref<LocalFileInfo>> specInfo : this.sourceSpecInfos) {
                boolean bl;
                String absolutePathOrUrl;
                String string = KubernetesSpecManager.this.project.getBasePath();
                Intrinsics.checkNotNull((Object)string);
                Intrinsics.checkNotNull((Object)MiscUtilKt.toAbsolutePathOrUrl$default((String)string, (String)((String)specInfo.getFirst()), (boolean)false, (int)4, null));
                LocalFileInfo localFileInfo = this.getLocalFileInfo(absolutePathOrUrl);
                ((Ref)specInfo.getSecond()).set((Object)localFileInfo);
                if (localFileInfo.getUrl() != null) {
                    if (localFileInfo.isUpToDate()) {
                        bl = this._validSpecs.add((String)specInfo.getFirst());
                        continue;
                    }
                    bl = this._urlsToDownload.add(localFileInfo.getUrl());
                    continue;
                }
                if (localFileInfo.getLocalFile() != null) {
                    this._validSpecs.add((String)specInfo.getFirst());
                    bl = this._listenableFiles.add(localFileInfo.getLocalFile());
                    continue;
                }
                bl = this._invalidSpecs.add(absolutePathOrUrl);
            }
        }

        public final void update(@NotNull Url url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            LocalFileInfo localFileInfo = this.getLocalFileInfo(url);
            if (localFileInfo != null) {
                Pair<String, Ref<LocalFileInfo>> pair = this.findSpecSourceRecordByUrl(url);
                if (pair != null) {
                    Pair<String, Ref<LocalFileInfo>> pair2 = pair;
                    KubernetesSpecManager kubernetesSpecManager = KubernetesSpecManager.this;
                    Pair<String, Ref<LocalFileInfo>> it = pair2;
                    boolean bl = false;
                    ((Ref)it.getSecond()).set((Object)localFileInfo);
                    kubernetesSpecManager.setExternalSpecAvailabilityStatus((String)it.getFirst(), null);
                }
            } else {
                KubernetesSpecManagerKt.access$getLOG$p().warn("Missing just downloaded file for url: " + url);
            }
        }

        @Nullable
        public final String findSpecSourceByUrl(@NotNull Url url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Pair<String, Ref<LocalFileInfo>> pair = this.findSpecSourceRecordByUrl(url);
            return pair != null ? (String)pair.getFirst() : null;
        }

        private final Pair<String, Ref<LocalFileInfo>> findSpecSourceRecordByUrl(Url url) {
            Object v0;
            block1: {
                Iterable iterable = this.sourceSpecInfos;
                for (Object t : iterable) {
                    Pair it = (Pair)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)((LocalFileInfo)((Ref)it.getSecond()).get()).getUrl(), (Object)url)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<ExternalSpecInfo> extractExternalSpecInfos() {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = this.sourceSpecInfos;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                ExternalSpecInfo externalSpecInfo;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Pair pair = (Pair)element$iv$iv;
                boolean bl2 = false;
                if (((LocalFileInfo)((Ref)pair.getSecond()).get()).getLocalFile() != null) {
                    VirtualFile it;
                    boolean bl3 = false;
                    externalSpecInfo = new ExternalSpecInfo(it, (String)pair.getFirst());
                } else {
                    externalSpecInfo = null;
                }
                if (externalSpecInfo == null) continue;
                ExternalSpecInfo it$iv$iv = externalSpecInfo;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final LocalFileInfo getLocalFileInfo(String pathOrUrl) {
            LocalFileInfo localFileInfo = MiscUtilKt.isUrl((String)pathOrUrl) ? this.getLocalFileInfo(Urls.parse((String)pathOrUrl, (boolean)false)) : this.getLocalFileInfo(LocalFileSystem.getInstance().findFileByIoFile(new File(pathOrUrl)));
            if (localFileInfo == null) {
                localFileInfo = new LocalFileInfo(null, false, null);
            }
            return localFileInfo;
        }

        private final LocalFileInfo getLocalFileInfo(Url url) {
            if (url == null) {
                return null;
            }
            DownloadManager.LocalFileInfo downloadFileInfo = DownloadManager.Companion.getInstance().getLocalFileInfo(url);
            return downloadFileInfo != null ? new LocalFileInfo(downloadFileInfo.getContentFile(), downloadFileInfo.isUpToDate(), url) : new LocalFileInfo(null, false, url);
        }

        private final LocalFileInfo getLocalFileInfo(VirtualFile file) {
            VirtualFile virtualFile = file;
            if (virtualFile == null) {
                return null;
            }
            return new LocalFileInfo(virtualFile, true, null);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0082\u0004\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/kubernetes/KubernetesSpecManager$UserDefinedSpecInfos$LocalFileInfo;", "", "localFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isUpToDate", "", "url", "Lcom/intellij/util/Url;", "<init>", "(Lcom/intellij/kubernetes/KubernetesSpecManager$UserDefinedSpecInfos;Lcom/intellij/openapi/vfs/VirtualFile;ZLcom/intellij/util/Url;)V", "getLocalFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "()Z", "getUrl", "()Lcom/intellij/util/Url;", "intellij.clouds.kubernetes.backend"})
        private final class LocalFileInfo {
            @Nullable
            private final VirtualFile localFile;
            private final boolean isUpToDate;
            @Nullable
            private final Url url;

            public LocalFileInfo(VirtualFile localFile, @Nullable boolean isUpToDate, Url url) {
                this.localFile = localFile;
                this.isUpToDate = isUpToDate;
                this.url = url;
            }

            @Nullable
            public final VirtualFile getLocalFile() {
                return this.localFile;
            }

            public final boolean isUpToDate() {
                return this.isUpToDate;
            }

            @Nullable
            public final Url getUrl() {
                return this.url;
            }
        }
    }
}

