/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.model;

import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.helm.CustomChartSupport;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.model.HelmModel;
import com.intellij.kubernetes.helm.model.HelmObjectMetaClass;
import com.intellij.kubernetes.helm.model.spec.Definition;
import com.intellij.kubernetes.helm.model.spec.ModelSpecKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.model.Field;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;

@Service
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0010\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0012\u0010\u000e\u001a\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\b\u0012\u00060\u0015R\u00020\u00000\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00170\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001e"}, d2={"Lcom/intellij/kubernetes/helm/model/HelmModelProvider;", "", "<init>", "()V", "chartYamlTypeProvider", "Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider;", "requirementsYamlTypeProvider", "getMetaTypeProvider", "psiFile", "Lcom/intellij/psi/PsiFile;", "getModel", "Lcom/intellij/kubernetes/helm/model/HelmModel;", "apiVersion", "", "getModelByChartFile", "apiVersions", "", "getApiVersions", "()Ljava/util/Set;", "models", "", "Lcom/intellij/kubernetes/helm/model/HelmModelProvider$HelmModelImpl;", "allFunctions", "Lcom/intellij/kubernetes/helm/model/spec/Definition;", "getAllFunctions", "()Ljava/util/Map;", "allFunctions$delegate", "Lkotlin/Lazy;", "Companion", "HelmModelImpl", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nHelmModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmModel.kt\ncom/intellij/kubernetes/helm/model/HelmModelProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n1#2:75\n*E\n"})
public final class HelmModelProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final YamlMetaTypeProvider chartYamlTypeProvider = new YamlMetaTypeProvider(arg_0 -> HelmModelProvider.chartYamlTypeProvider$lambda$0(this, arg_0), HelmModelProvider::chartYamlTypeProvider$lambda$1);
    @NotNull
    private final YamlMetaTypeProvider requirementsYamlTypeProvider = new YamlMetaTypeProvider(arg_0 -> HelmModelProvider.requirementsYamlTypeProvider$lambda$0(this, arg_0), HelmModelProvider::requirementsYamlTypeProvider$lambda$1);
    @NotNull
    private final Map<String, HelmModelImpl> models;
    @NotNull
    private final Lazy allFunctions$delegate;

    public HelmModelProvider() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"v1", (Object)new HelmModelImpl("v1")), TuplesKt.to((Object)"v2", (Object)new HelmModelImpl("v2"))};
        this.models = MapsKt.mapOf((Pair[])pairArray);
        this.allFunctions$delegate = LazyKt.lazy(HelmModelProvider::allFunctions_delegate$lambda$0);
    }

    @Nullable
    public final YamlMetaTypeProvider getMetaTypeProvider(@Nullable PsiFile psiFile) {
        PsiFile psiFile2 = psiFile;
        if (psiFile2 == null || (psiFile2 = YamlUtilKt.getVfsFile((PsiElement)((PsiElement)psiFile2))) == null) {
            return null;
        }
        PsiFile file = psiFile2;
        return Chart.Companion.isChartFile((VirtualFile)file) ? this.chartYamlTypeProvider : (Chart.Companion.isRequirementsFile((VirtualFile)file) ? this.requirementsYamlTypeProvider : (YamlMetaTypeProvider)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)CustomChartSupport.Companion.getAll$intellij_clouds_kubernetes_backend()), arg_0 -> HelmModelProvider.getMetaTypeProvider$lambda$0(psiFile, arg_0))));
    }

    @NotNull
    public final HelmModel getModel(@Nullable String apiVersion) {
        HelmModelImpl helmModelImpl = this.models.get(apiVersion);
        return helmModelImpl != null ? (HelmModel)helmModelImpl : (HelmModel)MapsKt.getValue(this.models, (Object)"v1");
    }

    private final HelmModel getModelByChartFile(PsiFile psiFile) {
        YAMLKeyValue yAMLKeyValue;
        YAMLMapping yAMLMapping = YamlUtilKt.getTopLevelMapping((YAMLFile)(psiFile instanceof YAMLFile ? (YAMLFile)psiFile : null));
        String apiVersionSpecified = yAMLMapping != null && (yAMLKeyValue = YamlUtilKt.getKeyValueByKeyIgnoreSpaces((YAMLMapping)yAMLMapping, (String)"apiVersion")) != null ? yAMLKeyValue.getValueText() : null;
        return this.getModel(apiVersionSpecified);
    }

    @NotNull
    public final Set<String> getApiVersions() {
        return this.models.keySet();
    }

    private final Map<String, Definition> getAllFunctions() {
        Lazy lazy = this.allFunctions$delegate;
        return (Map)lazy.getValue();
    }

    private static final Field chartYamlTypeProvider$lambda$0(HelmModelProvider this$0, YAMLDocument it) {
        Field field2;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Definition def = (Definition)MapsKt.getValue(this$0.getModelByChartFile(it.getContainingFile()).getObjectSchemas(), (Object)"Chart");
        Field $this$chartYamlTypeProvider_u24lambda_u240_u240 = field2 = new Field("Chart", (YamlMetaType)new HelmObjectMetaClass("Chart", def));
        boolean bl = false;
        $this$chartYamlTypeProvider_u24lambda_u240_u240.setRequired();
        return field2;
    }

    private static final long chartYamlTypeProvider$lambda$1() {
        return 0L;
    }

    private static final Field requirementsYamlTypeProvider$lambda$0(HelmModelProvider this$0, YAMLDocument it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Definition def = (Definition)MapsKt.getValue(this$0.getModel("v1").getObjectSchemas(), (Object)"Requirements");
        return new Field("Requirements", (YamlMetaType)new HelmObjectMetaClass("Requirements", def));
    }

    private static final long requirementsYamlTypeProvider$lambda$1() {
        return 0L;
    }

    private static final YamlMetaTypeProvider getMetaTypeProvider$lambda$0(PsiFile $psiFile, CustomChartSupport it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getMetaTypeProvider($psiFile);
    }

    private static final Map allFunctions_delegate$lambda$0() {
        return ModelSpecKt.loadFunctions();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/kubernetes/helm/model/HelmModelProvider$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/kubernetes/helm/model/HelmModelProvider;", "intellij.clouds.kubernetes.backend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HelmModelProvider getInstance() {
            Object object = ApplicationManager.getApplication().getService(HelmModelProvider.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (HelmModelProvider)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R'\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\t8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR \u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/intellij/kubernetes/helm/model/HelmModelProvider$HelmModelImpl;", "Lcom/intellij/kubernetes/helm/model/HelmModel;", "apiVersion", "", "<init>", "(Lcom/intellij/kubernetes/helm/model/HelmModelProvider;Ljava/lang/String;)V", "getApiVersion", "()Ljava/lang/String;", "objectSchemas", "", "Lcom/intellij/kubernetes/helm/model/spec/Definition;", "getObjectSchemas", "()Ljava/util/Map;", "objectSchemas$delegate", "Lkotlin/Lazy;", "functions", "getFunctions", "intellij.clouds.kubernetes.backend"})
    private final class HelmModelImpl
    implements HelmModel {
        @NotNull
        private final String apiVersion;
        @NotNull
        private final Lazy objectSchemas$delegate;

        public HelmModelImpl(String apiVersion) {
            Intrinsics.checkNotNullParameter((Object)apiVersion, (String)"apiVersion");
            this.apiVersion = apiVersion;
            this.objectSchemas$delegate = LazyKt.lazy(() -> HelmModelImpl.objectSchemas_delegate$lambda$0(this));
        }

        @Override
        @NotNull
        public String getApiVersion() {
            return this.apiVersion;
        }

        @Override
        @NotNull
        public Map<String, Definition> getObjectSchemas() {
            Lazy lazy = this.objectSchemas$delegate;
            return (Map)lazy.getValue();
        }

        @Override
        @NotNull
        public Map<String, Definition> getFunctions() {
            return HelmModelProvider.this.getAllFunctions();
        }

        private static final Map objectSchemas_delegate$lambda$0(HelmModelImpl this$0) {
            return ModelSpecKt.loadHelmObjects(this$0.getApiVersion());
        }
    }
}

