/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.model;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.kubernetes.GoTemplateInfoProvider;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.model.InSourcesMapResourceDataAdapter;
import com.intellij.kubernetes.model.KubernetesResourceDefinition;
import com.intellij.kubernetes.model.MapResourceValidator;
import com.intellij.kubernetes.model.SchemaSpecInfo;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.inspections.YAMLAddQuoteQuickFix;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.psi.impl.YAMLPlainTextImpl;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0010\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/kubernetes/model/MapResourceValidator;", "Lcom/intellij/kubernetes/model/KubernetesResourceDefinition;", "typeName", "", "specInfo", "Lcom/intellij/kubernetes/model/SchemaSpecInfo;", "adapter", "Lcom/intellij/kubernetes/model/InSourcesMapResourceDataAdapter;", "<init>", "(Ljava/lang/String;Lcom/intellij/kubernetes/model/SchemaSpecInfo;Lcom/intellij/kubernetes/model/InSourcesMapResourceDataAdapter;)V", "validateValue", "", "value", "Lorg/jetbrains/yaml/psi/YAMLValue;", "problemsHolder", "Lcom/intellij/codeInspection/ProblemsHolder;", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nMapResourceDefinitions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapResourceDefinitions.kt\ncom/intellij/kubernetes/model/MapResourceValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,640:1\n1220#2,2:641\n1249#2,4:643\n1220#2,2:647\n1249#2,4:649\n1915#2,2:653\n1342#3,2:655\n1#4:657\n*S KotlinDebug\n*F\n+ 1 MapResourceDefinitions.kt\ncom/intellij/kubernetes/model/MapResourceValidator\n*L\n67#1:641,2\n67#1:643,4\n69#1:647,2\n69#1:649,4\n74#1:653,2\n107#1:655,2\n*E\n"})
public class MapResourceValidator
extends KubernetesResourceDefinition {
    @NotNull
    private final InSourcesMapResourceDataAdapter adapter;

    public MapResourceValidator(@NotNull String typeName, @Nullable SchemaSpecInfo specInfo, @NotNull InSourcesMapResourceDataAdapter adapter) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        super(typeName, specInfo);
        this.adapter = adapter;
    }

    /*
     * WARNING - void declaration
     */
    public void validateValue(@NotNull YAMLValue value, @NotNull ProblemsHolder problemsHolder) {
        void $this$forEach$iv;
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Map map2;
        YAMLKeyValue yAMLKeyValue;
        void $this$associateByTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)problemsHolder, (String)"problemsHolder");
        super.validateValue(value, problemsHolder);
        if (!(value instanceof YAMLMapping)) {
            return;
        }
        if (YamlUtilKt.containsSpecialGoTemplateStatements((YAMLPsiElement)((YAMLPsiElement)value))) {
            return;
        }
        Iterable $this$associateBy$iv2 = this.adapter.findMappingKeyValues((YAMLMapping)value, this.adapter.getStringDataKey());
        boolean $i$f$associateBy22 = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv2, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv2;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv2) {
            void it;
            yAMLKeyValue = (YAMLKeyValue)element$iv$iv;
            map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(YamlUtilKt.getEffectiveKeyText((YAMLKeyValue)it), element$iv$iv);
        }
        Map dataMapping1 = MapsKt.toMutableMap((Map)destination$iv$iv);
        Iterable $i$f$associateBy22 = this.adapter.findMappingKeyValues((YAMLMapping)value, this.adapter.getBinaryOrEncodedDataKey());
        boolean $i$f$associateBy = false;
        int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv2);
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            YAMLKeyValue bl = (YAMLKeyValue)element$iv$iv;
            map2 = destination$iv$iv2;
            boolean bl2 = false;
            map2.put(YamlUtilKt.getEffectiveKeyText((YAMLKeyValue)it), element$iv$iv);
        }
        Map dataMapping2 = MapsKt.toMutableMap((Map)destination$iv$iv2);
        dataMapping1.keySet().retainAll(dataMapping2.keySet());
        dataMapping2.keySet().retainAll(dataMapping1.keySet());
        Iterable $this$forEach$iv2 = CollectionsKt.plus(dataMapping1.values(), (Iterable)dataMapping2.values());
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv2) {
            Object element$iv$iv;
            YAMLKeyValue it = (YAMLKeyValue)element$iv;
            boolean bl = false;
            PsiElement psiElement = it.getKey();
            Intrinsics.checkNotNull((Object)psiElement);
            element$iv$iv = new Object[]{this.adapter.getResourceKind()};
            String string = KubernetesBundle.message((String)"MapObjectValidator.duplicate.entry", (Object[])element$iv$iv);
            element$iv$iv = new LocalQuickFix[]{new LocalQuickFixOnPsiElement(it){

                public String getFamilyName() {
                    String string = KubernetesBundle.message((String)"MapObjectValidator.quickfix.name", (Object[])new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    return string;
                }

                public String getText() {
                    return this.getFamilyName();
                }

                public void invoke(Project project, PsiFile psiFile, PsiElement startElement, PsiElement endElement) {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
                    Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
                    Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
                    YAMLKeyValue yamlKeyValue = (YAMLKeyValue)startElement;
                    PostprocessReformattingAspect.getInstance((Project)project).disablePostprocessFormattingInside(() -> validateValue.1.1.invoke$lambda$0(yamlKeyValue));
                }

                private static final void invoke$lambda$0(YAMLKeyValue $yamlKeyValue) {
                    YAMLUtil.deleteSurroundingWhitespace((PsiElement)((PsiElement)$yamlKeyValue));
                    $yamlKeyValue.delete();
                }
            }};
            problemsHolder.registerProblem(psiElement, string, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])element$iv$iv);
        }
        GoTemplateInfoProvider goTemplateInfoProvider = (GoTemplateInfoProvider)CollectionsKt.firstOrNull((List)GoTemplateInfoProvider.Companion.getEP_NAME().getExtensionList());
        if (goTemplateInfoProvider == null) {
            return;
        }
        GoTemplateInfoProvider goTplInfoProvider = goTemplateInfoProvider;
        Sequence $i$f$forEach22 = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.adapter.findMappingKeyValues((YAMLMapping)value, this.adapter.getStringDataKey())), arg_0 -> MapResourceValidator.validateValue$lambda$3(goTplInfoProvider, arg_0));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair;
            PsiElement yamlValue = (PsiElement)element$iv;
            boolean bl = false;
            if (yamlValue instanceof OuterLanguageElement) {
                PsiElement psiElement = goTplInfoProvider.goStmtFromOuterLanguageElement((OuterLanguageElement)yamlValue);
                if (psiElement == null) {
                    return;
                }
                String string = KubernetesBundle.message((String)"MapObjectValidator.unquoted.value.helm.quickfix.name", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                pair = new Pair((Object)psiElement, (Object)goTplInfoProvider.helmQuoteStmtModCmd(string));
            } else {
                String string = KubernetesBundle.message((String)"MapObjectValidator.unquoted.value.quickfix.name", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                pair = new Pair((Object)yamlValue, (Object)new YAMLAddQuoteQuickFix(yamlValue, string, false, 4, null));
            }
            yAMLKeyValue = pair;
            PsiElement problemElement = (PsiElement)yAMLKeyValue.component1();
            ModCommandAction quickFix = (ModCommandAction)yAMLKeyValue.component2();
            Object[] objectArray = new Object[]{this.adapter.getStringDataKey()};
            problemsHolder.problem(problemElement, KubernetesBundle.message((String)"MapObjectValidator.unquoted.value.entry", (Object[])objectArray)).highlight(ProblemHighlightType.GENERIC_ERROR_OR_WARNING).fix(quickFix).register();
        }
    }

    private static final PsiElement validateValue$lambda$3(GoTemplateInfoProvider $goTplInfoProvider, YAMLKeyValue keyValue) {
        PsiElement psiElement;
        Object object;
        Intrinsics.checkNotNullParameter((Object)keyValue, (String)"keyValue");
        YAMLValue yamlValue = keyValue.getValue();
        OuterLanguageElement outerLanguageElement = YamlUtilKt.getOtherLanguageElementFromSiblingIfAny((YAMLPsiElement)((YAMLPsiElement)keyValue));
        if (outerLanguageElement != null) {
            OuterLanguageElement outerLanguageElement2;
            OuterLanguageElement it = outerLanguageElement2 = outerLanguageElement;
            boolean bl = false;
            object = $goTplInfoProvider.isGoTemplateElement((PsiElement)it) ? outerLanguageElement2 : null;
        } else {
            object = null;
        }
        OuterLanguageElement goTemplateElement = object;
        if (yamlValue == null) {
            Object object2;
            OuterLanguageElement outerLanguageElement3 = goTemplateElement;
            if (outerLanguageElement3 != null) {
                OuterLanguageElement outerLanguageElement4;
                OuterLanguageElement it = outerLanguageElement4 = outerLanguageElement3;
                boolean bl = false;
                object2 = !$goTplInfoProvider.isQuotedByFunction((PsiElement)it) ? outerLanguageElement4 : null;
            } else {
                object2 = null;
            }
            psiElement = (PsiElement)object2;
        } else {
            YAMLValue yAMLValue;
            psiElement = goTemplateElement == null && !YamlUtilKt.containsOtherLanguageElement((YAMLPsiElement)((YAMLPsiElement)yamlValue), (Function1)((Function1)new Function1<PsiElement, Boolean>((Object)$goTplInfoProvider){

                public final Boolean invoke(PsiElement p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((GoTemplateInfoProvider)this.receiver).isGoTemplateElement(p0);
                }
            })) ? (PsiElement)((yAMLValue = yamlValue) instanceof YAMLPlainTextImpl ? (YAMLPlainTextImpl)yAMLValue : null) : null;
        }
        return psiElement;
    }
}

