/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.model;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.psi.PsiElement;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.meta.model.YamlScalarType;
import org.jetbrains.yaml.psi.YAMLScalar;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/intellij/kubernetes/model/OpenApiSchemaPatternValidator;", "Lorg/jetbrains/yaml/meta/model/YamlScalarType;", "patternString", "", "<init>", "(Ljava/lang/String;)V", "pattern", "Lkotlin/text/Regex;", "getPattern", "()Lkotlin/text/Regex;", "pattern$delegate", "Lkotlin/Lazy;", "validateScalarValue", "", "value", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "Companion", "intellij.clouds.kubernetes.backend"})
public final class OpenApiSchemaPatternValidator
extends YamlScalarType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String patternString;
    @NotNull
    private final Lazy pattern$delegate;
    @NotNull
    private static final Regex allMatchingRegex = new Regex("[\\s\\S]*");

    public OpenApiSchemaPatternValidator(@NotNull String patternString) {
        Intrinsics.checkNotNullParameter((Object)patternString, (String)"patternString");
        super("pattern validator");
        this.patternString = patternString;
        this.pattern$delegate = LazyKt.lazy(() -> OpenApiSchemaPatternValidator.pattern_delegate$lambda$0(this));
    }

    private final Regex getPattern() {
        Lazy lazy = this.pattern$delegate;
        return (Regex)lazy.getValue();
    }

    protected void validateScalarValue(@NotNull YAMLScalar value, @NotNull ProblemsHolder holder) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            String string = YamlUtilKt.getAsStrictString((YAMLScalar)value);
            if (string == null) break block1;
            String it = string;
            boolean bl = false;
            if (!this.getPattern().matches((CharSequence)it)) {
                Object[] objectArray = new Object[]{this.patternString};
                holder.registerProblem((PsiElement)value, KubernetesBundle.message((String)"KubernetesModelDefinition.value.should.match.error", (Object[])objectArray), new LocalQuickFix[0]);
            }
        }
    }

    private static final Regex pattern_delegate$lambda$0(OpenApiSchemaPatternValidator this$0) {
        Regex regex;
        try {
            regex = new Regex(this$0.patternString);
        }
        catch (Exception e) {
            regex = allMatchingRegex;
        }
        return regex;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/kubernetes/model/OpenApiSchemaPatternValidator$Companion;", "", "<init>", "()V", "allMatchingRegex", "Lkotlin/text/Regex;", "intellij.clouds.kubernetes.backend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

