/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.ui;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.kubernetes.config.HelmParameters;
import com.intellij.kubernetes.config.KubernetesProjectSettings;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.chart.EffectiveHelmParameters;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBTextArea;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.LabelPosition;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextAreaKt;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLFileType;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B.\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\r\u0010\u0006\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u0007H\u0014J\b\u0010\u001e\u001a\u00020\u001fH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0006\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0014\u00a8\u0006 "}, d2={"Lcom/intellij/kubernetes/ui/HelmCommandParametersDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "chart", "Lcom/intellij/kubernetes/helm/chart/Chart;", "commandTitle", "", "Lorg/jetbrains/annotations/Nls;", "initialHelmParams", "Lcom/intellij/kubernetes/helm/chart/EffectiveHelmParameters;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/kubernetes/helm/chart/Chart;Ljava/lang/String;Lcom/intellij/kubernetes/helm/chart/EffectiveHelmParameters;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getChart", "()Lcom/intellij/kubernetes/helm/chart/Chart;", "getCommandTitle", "()Ljava/lang/String;", "getInitialHelmParams", "()Lcom/intellij/kubernetes/helm/chart/EffectiveHelmParameters;", "valuesFilesModel", "Lcom/intellij/util/ui/ListTableModel;", "Lcom/intellij/openapi/vfs/VirtualFile;", "valuesText", "helmParameters", "getHelmParameters", "createCenterPanel", "Ljavax/swing/JComponent;", "getHelpId", "doOKAction", "", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nHelmCommandParametersDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmCommandParametersDialog.kt\ncom/intellij/kubernetes/ui/HelmCommandParametersDialog\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,131:1\n1342#2,2:132\n14060#3,2:134\n*S KotlinDebug\n*F\n+ 1 HelmCommandParametersDialog.kt\ncom/intellij/kubernetes/ui/HelmCommandParametersDialog\n*L\n128#1:132,2\n90#1:134,2\n*E\n"})
public final class HelmCommandParametersDialog
extends DialogWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final Chart chart;
    @Nullable
    private final String commandTitle;
    @NotNull
    private final EffectiveHelmParameters initialHelmParams;
    @NotNull
    private final ListTableModel<VirtualFile> valuesFilesModel;
    @NotNull
    private String valuesText;

    public HelmCommandParametersDialog(@NotNull Project project, @NotNull Chart chart, @Nullable String commandTitle, @NotNull EffectiveHelmParameters initialHelmParams) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)chart, (String)"chart");
        Intrinsics.checkNotNullParameter((Object)initialHelmParams, (String)"initialHelmParams");
        super(project, false);
        this.project = project;
        this.chart = chart;
        this.commandTitle = commandTitle;
        this.initialHelmParams = initialHelmParams;
        this.valuesText = "";
        String string = this.commandTitle;
        if (string == null) {
            String string2 = KubernetesBundle.message((String)"HelmCommandParametersDialog.default.title", (Object[])new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        }
        this.setTitle(string);
        if (this.commandTitle != null) {
            this.setOKButtonText(KubernetesBundle.message((String)"HelmCommandParametersDialog.ok.button.title", (Object[])new Object[0]));
        }
        this.setDoNotAskOption((DoNotAskOption)new DoNotAskOption.Adapter(){

            public String getDoNotShowMessage() {
                String string = KubernetesBundle.message((String)"HelmCommandParametersDialog.do.not.show.message", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            public boolean isSelectedByDefault() {
                HelmParameters helmParameters2 = KubernetesProjectSettings.Companion.getInstance(this.getProject()).getHelmParameters(this.getChart().getBaseDir());
                return helmParameters2 != null ? !helmParameters2.getShowConfigDialog() : false;
            }

            public void rememberChoice(boolean isSelected, int exitCode2) {
                KubernetesProjectSettings.Companion.getInstance(this.getProject()).getOrCreateHelmParameters(this.getChart().getBaseDir()).setShowConfigDialog(!isSelected);
            }
        });
        ColumnInfo[] columnInfoArray = new ColumnInfo[]{new ColumnInfo<VirtualFile, String>(){

            public String valueOf(VirtualFile item) {
                Object object = item;
                return object != null && (object = object.getPresentableUrl()) != null ? StringsKt.removePrefix((String)object, (CharSequence)(this.getChart().getBaseDir().getPresentableUrl() + File.separator)) : null;
            }
        }};
        this.valuesFilesModel = new ListTableModel(columnInfoArray);
        this.valuesFilesModel.addRows((Collection)this.initialHelmParams.getValuesFiles());
        if (this.initialHelmParams.getValues() != null) {
            this.valuesText = this.initialHelmParams.getValues();
        }
        super.init();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Chart getChart() {
        return this.chart;
    }

    @Nullable
    public final String getCommandTitle() {
        return this.commandTitle;
    }

    @NotNull
    public final EffectiveHelmParameters getInitialHelmParams() {
        return this.initialHelmParams;
    }

    @NotNull
    public final EffectiveHelmParameters getHelmParameters() {
        List list = this.valuesFilesModel.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        return new EffectiveHelmParameters(list, this.valuesText);
    }

    @NotNull
    protected JComponent createCenterPanel() {
        TableView tableView;
        TableView $this$createCenterPanel_u24lambda_u240 = tableView = new TableView(this.valuesFilesModel);
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u240.setVisibleRowCount(5);
        $this$createCenterPanel_u24lambda_u240.setShowGrid(false);
        $this$createCenterPanel_u24lambda_u240.setTableHeader(null);
        $this$createCenterPanel_u24lambda_u240.getEmptyText().setText(this.chart.getEffectiveHelmParameters().getValuesFiles().isEmpty() ? KubernetesBundle.message((String)"HelmCommandParametersDialog.values.files.table.empty.text.no.files.exist", (Object[])new Object[0]) : KubernetesBundle.message((String)"HelmCommandParametersDialog.values.files.table.empty.text", (Object[])new Object[0]));
        TableView valuesFileTable = tableView;
        JPanel jPanel = ToolbarDecorator.createDecorator((JTable)((JTable)valuesFileTable)).setAddAction(arg_0 -> HelmCommandParametersDialog.createCenterPanel$lambda$1(this, arg_0)).setRemoveActionUpdater(arg_0 -> HelmCommandParametersDialog.createCenterPanel$lambda$2(this, arg_0)).createPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createPanel(...)");
        JPanel valuesFilesPanel = jPanel;
        return (JComponent)BuilderKt.panel(arg_0 -> HelmCommandParametersDialog.createCenterPanel$lambda$3(valuesFilesPanel, this, arg_0));
    }

    @NotNull
    protected String getHelpId() {
        return "Kubernetes.helm.parameters";
    }

    protected void doOKAction() {
        super.doOKAction();
        List list = this.valuesFilesModel.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        this.chart.saveHelmParameters(new EffectiveHelmParameters(list, this.valuesText));
        VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)this.project).getOpenFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getOpenFiles(...)");
        Sequence $this$forEach$iv = SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])virtualFileArray), HelmCommandParametersDialog::doOKAction$lambda$0), arg_0 -> HelmCommandParametersDialog.doOKAction$lambda$1(this, arg_0));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiFile psiFile = (PsiFile)element$iv;
            boolean bl = false;
            DaemonCodeAnalyzer.getInstance((Project)this.project).restart(psiFile, (Object)this);
        }
    }

    private static final Unit createCenterPanel$lambda$3$1$0(JPanel $valuesFilesPanel, JBTextArea $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setBorder($valuesFilesPanel.getBorder());
        $this$applyToComponent.getEmptyText().setText("outer.inner=value");
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$3$0(JPanel $valuesFilesPanel, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell.comment$default((Cell)$this$row.cell((JComponent)$valuesFilesPanel).align(Align.FILL).label(KubernetesBundle.message((String)"HelmCommandParametersDialog.values.files.table.label", (Object[])new Object[0]) + ":", LabelPosition.TOP), (String)KubernetesBundle.message((String)"HelmCommandParametersDialog.values.files.table.comment", (Object[])new Object[0]), (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$3$1(HelmCommandParametersDialog this$0, JPanel $valuesFilesPanel, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell.comment$default((Cell)TextFieldKt.bindText((Cell)TextAreaKt.rows((Cell)$this$row.scrollCell((JComponent)new JBTextArea()).align(Align.FILL), (int)5), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)this$0){

            public Object get() {
                return HelmCommandParametersDialog.access$getValuesText$p((HelmCommandParametersDialog)((Object)this.receiver));
            }

            public void set(Object value) {
                HelmCommandParametersDialog.access$setValuesText$p((HelmCommandParametersDialog)((Object)this.receiver), (String)value);
            }
        })).label(KubernetesBundle.message((String)"HelmCommandParametersDialog.additional.values.label", (Object[])new Object[0]) + ":", LabelPosition.TOP), (String)KubernetesBundle.message((String)"HelmCommandParametersDialog.additional.values.comment", (Object[])new Object[0]), (int)-1, null, (int)4, null).applyToComponent(arg_0 -> HelmCommandParametersDialog.createCenterPanel$lambda$3$1$0($valuesFilesPanel, arg_0));
        return Unit.INSTANCE;
    }

    private static final void createCenterPanel$lambda$1(HelmCommandParametersDialog this$0, AnActionButton it) {
        VirtualFile[] virtualFileArray = FileChooser.chooseFiles((FileChooserDescriptor)FileChooserDescriptorFactory.multiFiles().withExtensionFilter((FileType)YAMLFileType.YML), (Project)this$0.project, null);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"chooseFiles(...)");
        Object[] $this$forEach$iv = virtualFileArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile it2 = (VirtualFile)element$iv;
            boolean bl = false;
            this$0.valuesFilesModel.addRow((Object)it2);
        }
    }

    private static final boolean createCenterPanel$lambda$2(HelmCommandParametersDialog this$0, AnActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.valuesFilesModel.getItems().size() > 1;
    }

    private static final Unit createCenterPanel$lambda$3(JPanel $valuesFilesPanel, HelmCommandParametersDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> HelmCommandParametersDialog.createCenterPanel$lambda$3$0($valuesFilesPanel, arg_0), (int)1, null).resizableRow();
        Panel.row$default((Panel)$this$panel, null, arg_0 -> HelmCommandParametersDialog.createCenterPanel$lambda$3$1(this$0, $valuesFilesPanel, arg_0), (int)1, null).resizableRow();
        return Unit.INSTANCE;
    }

    private static final boolean doOKAction$lambda$0(VirtualFile vf) {
        return Chart.Companion.isChartsTemplateFile(vf);
    }

    private static final PsiFile doOKAction$lambda$1(HelmCommandParametersDialog this$0, VirtualFile vf) {
        Intrinsics.checkNotNull((Object)vf);
        return VirtualFileUtil.findPsiFile((VirtualFile)vf, (Project)this$0.project);
    }

    public static final /* synthetic */ String access$getValuesText$p(HelmCommandParametersDialog $this) {
        return $this.valuesText;
    }

    public static final /* synthetic */ void access$setValuesText$p(HelmCommandParametersDialog $this, String string) {
        $this.valuesText = string;
    }
}

