/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.ui;

import com.intellij.kubernetes.KubernetesResolver;
import com.intellij.kubernetes.KubernetesUtilKt;
import com.intellij.kubernetes.MiscUtilKt;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.ui.KustomizePatchNotificationProvider;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.JBColor;
import com.intellij.util.IconUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.SwingHelper;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLFile;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\u0006\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0003J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0003\u00a8\u0006\u0012"}, d2={"Lcom/intellij/kubernetes/ui/KustomizePatchNotificationProvider;", "Lcom/intellij/ui/EditorNotificationProvider;", "<init>", "()V", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createNotificationPanel", "Lcom/intellij/ui/EditorNotificationPanel;", "psiFile", "Lcom/intellij/psi/PsiFile;", "goToKustomization", "", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nKustomizePatchNotificationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KustomizePatchNotificationProvider.kt\ncom/intellij/kubernetes/ui/KustomizePatchNotificationProvider\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n19#2:102\n30#3,2:103\n1#4:105\n1#4:117\n1642#5,10:106\n1915#5:116\n1916#5:118\n1652#5:119\n1586#5:120\n1661#5,3:121\n777#5:124\n873#5,2:125\n*S KotlinDebug\n*F\n+ 1 KustomizePatchNotificationProvider.kt\ncom/intellij/kubernetes/ui/KustomizePatchNotificationProvider\n*L\n61#1:102\n62#1:103,2\n71#1:117\n71#1:106,10\n71#1:116\n71#1:118\n71#1:119\n75#1:120\n75#1:121,3\n76#1:124\n76#1:125,2\n*E\n"})
public final class KustomizePatchNotificationProvider
implements EditorNotificationProvider {
    @Nullable
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (DumbService.Companion.isDumb(project)) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            return null;
        }
        PsiFile psiFile2 = psiFile;
        if (!KubernetesUtilKt.isKustomizeStrategicMergePatch(psiFile2)) {
            return null;
        }
        return arg_0 -> KustomizePatchNotificationProvider.collectNotificationData$lambda$0(this, psiFile2, project, arg_0);
    }

    @RequiresEdt
    private final EditorNotificationPanel createNotificationPanel(PsiFile psiFile, Project project) {
        EditorNotificationPanel panel2 = new EditorNotificationPanel(JBColor.PanelBackground, EditorNotificationPanel.Status.Info);
        panel2.setText(KubernetesBundle.message((String)"KustomizePatchNotificationProvider.message", (Object[])new Object[0]));
        panel2.createActionLabel(KubernetesBundle.message((String)"KustomizePatchNotificationProvider.popup.title", (Object[])new Object[0]), () -> KustomizePatchNotificationProvider.createNotificationPanel$lambda$0(this, project, psiFile));
        return panel2;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    private final void goToKustomization(Project project, PsiFile psiFile) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        PsiElement it;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        PsiFile $this$asSafely$iv = psiFile;
        boolean $i$f$asSafely = false;
        PsiFile psiFile2 = $this$asSafely$iv;
        if (!(psiFile2 instanceof YAMLFile)) {
            psiFile2 = null;
        }
        YAMLFile yAMLFile = (YAMLFile)psiFile2;
        if (yAMLFile == null) {
            return;
        }
        YAMLFile yamlFile = yAMLFile;
        Object $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<KubernetesResolver> serviceClass$iv = KubernetesResolver.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Object it2 = $this$service$iv = ((KubernetesResolver)object).findKustomizeStrategicMergePatchReferences(yamlFile).toList();
        boolean bl = false;
        Object object2 = !((Collection)it2).isEmpty() ? $this$service$iv : null;
        if (object2 == null) {
            return;
        }
        Object references = object2;
        if (references.size() == 1) {
            PsiElement psiElement = ((PsiReference)CollectionsKt.first((List)references)).getElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
            MiscUtilKt.openInEditor((PsiElement)psiElement);
            return;
        }
        it2 = (Iterable)references;
        Object object3 = project;
        boolean $i$f$mapNotNull22 = false;
        void var9_14 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            PsiReference it3 = (PsiReference)element$iv$iv;
            boolean bl3 = false;
            PsiElement psiElement = it3.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
            if (YamlUtilKt.getVfsFile((PsiElement)psiElement) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.filesScope((Project)object3, (Collection)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"filesScope(...)");
        GlobalSearchScope searchScope = globalSearchScope;
        UniqueVFilePathBuilder uniqueVFilePathBuilder = UniqueVFilePathBuilder.getInstance();
        Iterable $i$f$mapNotNull22 = (Iterable)references;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            element$iv$iv$iv = (PsiReference)item$iv$iv;
            object3 = destination$iv$iv2;
            boolean bl5 = false;
            object3.add(it.getElement());
        }
        $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (PsiElement)element$iv$iv;
            boolean bl6 = false;
            if (!(it.getContainingFile() != null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv2;
        BaseListPopupStep<PsiElement> step2 = new BaseListPopupStep<PsiElement>((List<? extends PsiElement>)list, uniqueVFilePathBuilder, project, searchScope){
            final /* synthetic */ UniqueVFilePathBuilder $uniqueVFilePathBuilder;
            final /* synthetic */ Project $project;
            final /* synthetic */ GlobalSearchScope $searchScope;
            {
                this.$uniqueVFilePathBuilder = $uniqueVFilePathBuilder;
                this.$project = $project;
                this.$searchScope = $searchScope;
                super(null, $list);
            }

            public String getTextFor(PsiElement value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                VirtualFile virtualFile = YamlUtilKt.getVfsFile((PsiElement)value);
                if (virtualFile == null) {
                    String string = value.getContainingFile().getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    return string;
                }
                VirtualFile vfsFile = virtualFile;
                String string = this.$uniqueVFilePathBuilder.getUniqueVirtualFilePath(this.$project, vfsFile, this.$searchScope);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueVirtualFilePath(...)");
                return string;
            }

            public PopupStep<?> onChosen(PsiElement selectedValue, boolean finalChoice) {
                Intrinsics.checkNotNullParameter((Object)selectedValue, (String)"selectedValue");
                return this.doFinalStep(() -> goToKustomization.step.1.onChosen$lambda$0(selectedValue));
            }

            public Icon getIconFor(PsiElement value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                VirtualFile virtualFile = YamlUtilKt.getVfsFile((PsiElement)value);
                if (virtualFile == null) {
                    return null;
                }
                VirtualFile vfsFile = virtualFile;
                return IconUtil.getIcon((VirtualFile)vfsFile, (int)0, (Project)this.$project);
            }

            private static final void onChosen$lambda$0(PsiElement $selectedValue) {
                MiscUtilKt.openInEditor((PsiElement)$selectedValue);
            }
        };
        ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step2);
        Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createListPopup(...)");
        ListPopup popup = listPopup;
        Component component = SwingHelper.getComponentFromRecentMouseEvent();
        if (component != null) {
            popup.showUnderneathOf(component);
        }
    }

    private static final EditorNotificationPanel collectNotificationData$lambda$0(KustomizePatchNotificationProvider this$0, PsiFile $psiFile, Project $project, FileEditor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.createNotificationPanel($psiFile, $project);
    }

    private static final void createNotificationPanel$lambda$0(KustomizePatchNotificationProvider this$0, Project $project, PsiFile $psiFile) {
        this$0.goToKustomization($project, $psiFile);
    }
}

