/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.ui.intentions;

import com.intellij.kubernetes.K8sYamlMappings;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.vfs.UtilsKt;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.PsiBasedModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.psi.YAMLFile;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0014J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0002H\u0014J\r\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/kubernetes/ui/intentions/MarkAsNonK8sFileModCommandAction;", "Lcom/intellij/modcommand/PsiBasedModCommandAction;", "Lcom/intellij/psi/PsiElement;", "<init>", "()V", "isElementApplicable", "", "element", "context", "Lcom/intellij/modcommand/ActionContext;", "perform", "Lcom/intellij/modcommand/ModCommand;", "getFamilyName", "", "Lorg/jetbrains/annotations/Nls;", "intellij.clouds.kubernetes.backend"})
public final class MarkAsNonK8sFileModCommandAction
extends PsiBasedModCommandAction<PsiElement> {
    public MarkAsNonK8sFileModCommandAction() {
        super(PsiElement.class);
    }

    protected boolean isElementApplicable(@NotNull PsiElement element, @NotNull ActionContext context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return false;
        }
        PsiFile containingFile = psiFile;
        return UtilsKt.isPlainKubernetesFile(containingFile);
    }

    @NotNull
    protected ModCommand perform(@NotNull ActionContext context2, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        ModCommand modCommand = ModCommand.psiUpdate((PsiElement)((PsiElement)context2.file()), arg_0 -> MarkAsNonK8sFileModCommandAction.perform$lambda$0(context2, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"psiUpdate(...)");
        return modCommand;
    }

    @NotNull
    public String getFamilyName() {
        String string = KubernetesBundle.message((String)"MarkAsNonK8sFileModCommandAction.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private static final void perform$lambda$0(ActionContext $context, PsiFile file) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        YAMLElementGenerator yamlGen = YAMLElementGenerator.getInstance((Project)$context.project());
        YAMLFile yAMLFile = yamlGen.createDummyYamlWithText("# " + CollectionsKt.first(K8sYamlMappings.INSTANCE.getNO_K8S_DIRECTIVES()));
        Intrinsics.checkNotNullExpressionValue((Object)yAMLFile, (String)"createDummyYamlWithText(...)");
        YAMLFile tmpYaml = yAMLFile;
        Class[] classArray = new Class[]{PsiComment.class};
        Collection collection = PsiTreeUtil.collectElementsOfType((PsiElement)((PsiElement)tmpYaml), (Class[])classArray);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"collectElementsOfType(...)");
        PsiComment psiComment = (PsiComment)CollectionsKt.firstOrNull((Iterable)collection);
        if (psiComment == null) {
            return;
        }
        PsiComment comment = psiComment;
        PsiElement insertedComment = psiElement = file.addBefore((PsiElement)comment, file.getFirstChild());
        boolean bl = false;
        file.addAfter(yamlGen.createEol(), insertedComment);
    }
}

