/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.DelegateLexer;
import com.intellij.lexer.XmlLexerKt;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;
import kotlin.Metadata;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0002\u00a8\u0006\b"}, d2={"Lcom/intellij/lexer/XmlHighlightingLexer;", "Lcom/intellij/lexer/DelegateLexer;", "<init>", "()V", "getTokenType", "Lcom/intellij/psi/tree/IElementType;", "fixWrongTokenTypes", "tokenType", "intellij.xml.parser"})
public final class XmlHighlightingLexer
extends DelegateLexer {
    public XmlHighlightingLexer() {
        super(XmlLexerKt.createXmlLexer$default(false, 1, null));
    }

    @Nullable
    public IElementType getTokenType() {
        IElementType iElementType = this.getDelegate().getTokenType();
        if (iElementType == null) {
            return null;
        }
        IElementType tokenType = iElementType;
        tokenType = this.fixWrongTokenTypes(tokenType);
        return tokenType;
    }

    private final IElementType fixWrongTokenTypes(IElementType tokenType) {
        int state = this.getState() & 0x1F;
        if (tokenType == XmlTokenType.XML_NAME) {
            switch (state) {
                case 2: 
                case 8: {
                    return XmlTokenType.XML_TAG_NAME;
                }
            }
        } else {
            if (tokenType == XmlTokenType.XML_WHITE_SPACE) {
                return switch (state) {
                    case 12, 14 -> XmlTokenType.TAG_WHITE_SPACE;
                    default -> XmlTokenType.XML_REAL_WHITE_SPACE;
                };
            }
            if ((tokenType == XmlTokenType.XML_CHAR_ENTITY_REF || tokenType == XmlTokenType.XML_ENTITY_REF_TOKEN) && state == 10) {
                return XmlTokenType.XML_COMMENT_CHARACTERS;
            }
        }
        return tokenType;
    }
}

