/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions.workingTree;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import git4idea.GitReference;
import git4idea.GitWorkingTree;
import git4idea.actions.ref.GitSingleRefAction;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.workingTrees.GitWorkingTreesService;
import git4idea.workingTrees.GitWorkingTreesUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0014J.\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0011\u001a\u00020\u0002H\u0016\u00a8\u0006\u0012"}, d2={"Lgit4idea/actions/workingTree/GitOpenExistingWorkingTreeForLocalBranchAction;", "Lgit4idea/actions/ref/GitSingleRefAction;", "Lgit4idea/GitReference;", "<init>", "()V", "isEnabledForRef", "", "ref", "repositories", "", "Lgit4idea/repo/GitRepository;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "reference", "intellij.vcs.git"})
public final class GitOpenExistingWorkingTreeForLocalBranchAction
extends GitSingleRefAction<GitReference> {
    public GitOpenExistingWorkingTreeForLocalBranchAction() {
        super(GitOpenExistingWorkingTreeForLocalBranchAction::_init_$lambda$0);
    }

    @Override
    protected boolean isEnabledForRef(@NotNull GitReference ref, @NotNull List<? extends GitRepository> repositories) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        GitRepository gitRepository = (GitRepository)CollectionsKt.singleOrNull(repositories);
        if (gitRepository == null) {
            return false;
        }
        GitRepository repository2 = gitRepository;
        return GitWorkingTreesUtil.INSTANCE.getWorkingTreeWithRef(ref, repository2, true) != null;
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e, @NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull GitReference reference) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(repositories, (String)"repositories");
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        GitRepository gitRepository = (GitRepository)CollectionsKt.singleOrNull(repositories);
        if (gitRepository == null) {
            return;
        }
        GitRepository repository2 = gitRepository;
        GitWorkingTree gitWorkingTree = GitWorkingTreesUtil.INSTANCE.getWorkingTreeWithRef(reference, repository2, true);
        if (gitWorkingTree == null) {
            return;
        }
        GitWorkingTree workingTree = gitWorkingTree;
        Project project2 = repository2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        GitWorkingTreesService gitWorkingTreesService = GitWorkingTreesService.Companion.getInstance(project2);
        CoroutineScope coroutineScope = e.getCoroutineScope();
        Intrinsics.checkNotNullExpressionValue((Object)coroutineScope, (String)"getCoroutineScope(...)");
        gitWorkingTreesService.openWorkingTreeProject(workingTree, coroutineScope);
    }

    private static final String _init_$lambda$0() {
        return GitBundle.message((String)"action.open.worktree.for.a.branch.text", (Object[])new Object[0]);
    }
}

