/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkin;

import com.intellij.dvcs.commit.AmendCommitService;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitVersionSpecialty;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\r\u0010\f\u001a\u00070\t\u00a2\u0006\u0002\b\rH\u0002\u00a8\u0006\u000e"}, d2={"Lgit4idea/checkin/GitAmendCommitService;", "Lcom/intellij/dvcs/commit/AmendCommitService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "isAmendCommitSupported", "", "getLastCommitMessage", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "getCommitMessageFormatPattern", "Lorg/jetbrains/annotations/NonNls;", "intellij.vcs.git"})
public final class GitAmendCommitService
extends AmendCommitService {
    public GitAmendCommitService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    public boolean isAmendCommitSupported() {
        return true;
    }

    @NotNull
    public String getLastCommitMessage(@NotNull VirtualFile root) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        GitLineHandler h = new GitLineHandler(this.getProject(), root, GitCommand.LOG);
        String[] stringArray = new String[]{"--max-count=1"};
        h.addParameters(stringArray);
        stringArray = new String[]{"--encoding=UTF-8"};
        h.addParameters(stringArray);
        stringArray = new String[]{"--pretty=format:" + this.getCommitMessageFormatPattern()};
        h.addParameters(stringArray);
        String string = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOutputOrThrow(...)");
        return string;
    }

    private final String getCommitMessageFormatPattern() {
        return GitVersionSpecialty.STARTED_USING_RAW_BODY_IN_FORMAT.existsIn(this.getProject()) ? "%B" : "%s%n%n%-b";
    }
}

