/*
 * Decompiled with CFR 0.152.
 */
package git4idea.conflicts;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.impl.BackgroundableActionLock;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.Alarm;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EventDispatcher;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.DisposableUpdate;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import git4idea.GitUtil;
import git4idea.conflicts.GitConflictsUtil;
import git4idea.conflicts.GitMergeHandler;
import git4idea.conflicts.MyChangesTree;
import git4idea.merge.GitMergeUtil;
import git4idea.repo.GitConflict;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.status.GitStagingAreaHolder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0002./B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u000e\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u0016J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000e0#H\u0002J\b\u0010$\u001a\u00020\u001fH\u0002J\u0006\u0010%\u001a\u00020&J\u0006\u0010'\u001a\u00020\u001fJ\u0006\u0010(\u001a\u00020&J\u000e\u0010)\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020&J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0014\u001a\u0015\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00160\u00160\u0015\u00a2\u0006\u0002\b\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001b\u00a8\u00060"}, d2={"Lgit4idea/conflicts/GitConflictsPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "mergeHandler", "Lgit4idea/conflicts/GitMergeHandler;", "<init>", "(Lcom/intellij/openapi/project/Project;Lgit4idea/conflicts/GitMergeHandler;)V", "panel", "Ljavax/swing/JComponent;", "conflictsTree", "Lgit4idea/conflicts/MyChangesTree;", "conflicts", "", "Lgit4idea/repo/GitConflict;", "reversedRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "updateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lgit4idea/conflicts/GitConflictsPanel$Listener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "component", "getComponent", "()Ljavax/swing/JComponent;", "preferredFocusableComponent", "getPreferredFocusableComponent", "dispose", "", "addListener", "listener", "getSelectedConflicts", "", "updateConflicts", "canShowMergeWindowForSelection", "", "showMergeWindowForSelection", "canAcceptConflictSideForSelection", "acceptConflictSideForSelection", "takeTheirs", "getConflictOperationLock", "Lcom/intellij/openapi/vcs/impl/BackgroundableActionLock;", "conflict", "MainPanel", "Listener", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitConflictsPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitConflictsPanel.kt\ngit4idea/conflicts/GitConflictsPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,233:1\n1807#2,3:234\n1807#2,3:237\n*S KotlinDebug\n*F\n+ 1 GitConflictsPanel.kt\ngit4idea/conflicts/GitConflictsPanel\n*L\n136#1:234,3\n146#1:237,3\n*E\n"})
public final class GitConflictsPanel
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final GitMergeHandler mergeHandler;
    @NotNull
    private final JComponent panel;
    @NotNull
    private final MyChangesTree conflictsTree;
    @NotNull
    private final List<GitConflict> conflicts;
    @NotNull
    private final Set<VirtualFile> reversedRoots;
    @NotNull
    private final MergingUpdateQueue updateQueue;
    @NotNull
    private final EventDispatcher<Listener> eventDispatcher;

    /*
     * WARNING - void declaration
     */
    public GitConflictsPanel(@NotNull Project project, @NotNull GitMergeHandler mergeHandler) {
        void $this$_init__u24lambda_u240;
        MainPanel mainPanel;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mergeHandler, (String)"mergeHandler");
        this.project = project;
        this.mergeHandler = mergeHandler;
        this.conflictsTree = new MyChangesTree(this.project);
        this.conflicts = new ArrayList();
        this.reversedRoots = new HashSet();
        EventDispatcher eventDispatcher = EventDispatcher.create(Listener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.eventDispatcher = eventDispatcher;
        this.conflictsTree.setKeepTreeState(true);
        this.updateQueue = new MergingUpdateQueue("GitConflictsView", 300, true, (JComponent)((Object)this.conflictsTree), (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD, null, 128, null);
        MainPanel mainPanel2 = mainPanel = new MainPanel();
        GitConflictsPanel gitConflictsPanel = this;
        boolean bl = false;
        $this$_init__u24lambda_u240.add((Component)ScrollPaneFactory.createScrollPane((Component)((Component)((Object)this.conflictsTree))), "Center");
        gitConflictsPanel.panel = mainPanel;
        this.conflictsTree.setDoubleClickHandler(arg_0 -> GitConflictsPanel._init_$lambda$2(arg_0 -> GitConflictsPanel._init_$lambda$1(this, arg_0), arg_0));
        this.conflictsTree.setEnterKeyHandler(arg_0 -> GitConflictsPanel._init_$lambda$4(arg_0 -> GitConflictsPanel._init_$lambda$3(this, arg_0), arg_0));
        MessageBusConnection connection = this.project.getMessageBus().connect((Disposable)this);
        Topic<GitStagingAreaHolder.StagingAreaListener> topic = GitStagingAreaHolder.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        connection.subscribe(topic, arg_0 -> GitConflictsPanel._init_$lambda$5(this, arg_0));
        Topic<GitRepositoryChangeListener> topic2 = GitRepository.GIT_REPO_CHANGE;
        Intrinsics.checkNotNullExpressionValue(topic2, (String)"GIT_REPO_CHANGE");
        connection.subscribe(topic2, arg_0 -> GitConflictsPanel._init_$lambda$6(this, arg_0));
        this.updateConflicts();
        this.updateQueue.sendFlush();
    }

    @NotNull
    public final JComponent getComponent() {
        return this.panel;
    }

    @NotNull
    public final JComponent getPreferredFocusableComponent() {
        return (JComponent)((Object)this.conflictsTree);
    }

    public void dispose() {
    }

    public final void addListener(@NotNull Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.eventDispatcher.addListener((EventListener)listener2);
    }

    private final List<GitConflict> getSelectedConflicts() {
        List list = this.conflictsTree.getSelectedChanges();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSelectedChanges(...)");
        return list;
    }

    private final void updateConflicts() {
        DisposableUpdate disposableUpdate = DisposableUpdate.createDisposable((Disposable)this, (Object)"update", () -> GitConflictsPanel.updateConflicts$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue((Object)disposableUpdate, (String)"createDisposable(...)");
        this.updateQueue.queue((Update)disposableUpdate);
    }

    public final boolean canShowMergeWindowForSelection() {
        boolean bl;
        block3: {
            List<GitConflict> selectedConflicts = this.getSelectedConflicts();
            Iterable $this$any$iv = selectedConflicts;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GitConflict it = (GitConflict)element$iv;
                    boolean bl2 = false;
                    if (!(this.mergeHandler.canResolveConflict(it) && !this.getConflictOperationLock(it).isLocked())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void showMergeWindowForSelection() {
        HashSet reversed = new HashSet(this.reversedRoots);
        GitConflictsUtil.INSTANCE.showMergeWindow$intellij_vcs_git(this.project, this.mergeHandler, this.getSelectedConflicts(), (Function1<? super VirtualFile, Boolean>)((Function1)new Function1<VirtualFile, Boolean>(reversed){

            public final Boolean invoke(VirtualFile p0) {
                return ((HashSet)this.receiver).contains(p0);
            }
        }));
    }

    public final boolean canAcceptConflictSideForSelection() {
        boolean bl;
        block3: {
            List<GitConflict> selectedConflicts = this.getSelectedConflicts();
            Iterable $this$any$iv = selectedConflicts;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GitConflict it = (GitConflict)element$iv;
                    boolean bl2 = false;
                    if (!(!this.getConflictOperationLock(it).isLocked())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void acceptConflictSideForSelection(boolean takeTheirs) {
        HashSet reversed = new HashSet(this.reversedRoots);
        GitConflictsUtil.INSTANCE.acceptConflictSide$intellij_vcs_git(this.project, this.mergeHandler, this.getSelectedConflicts(), takeTheirs, (Function1<? super VirtualFile, Boolean>)((Function1)new Function1<VirtualFile, Boolean>(reversed){

            public final Boolean invoke(VirtualFile p0) {
                return ((HashSet)this.receiver).contains(p0);
            }
        }));
    }

    private final BackgroundableActionLock getConflictOperationLock(GitConflict conflict) {
        return GitConflictsUtil.INSTANCE.getConflictOperationLock$intellij_vcs_git(this.project, conflict);
    }

    private static final boolean _init_$lambda$1(GitConflictsPanel this$0, MouseEvent e) {
        boolean bl;
        JTree jTree = (JTree)((Object)this$0.conflictsTree);
        Intrinsics.checkNotNull((Object)e);
        if (EditSourceOnDoubleClickHandler.isToggleEvent((JTree)jTree, (MouseEvent)e)) {
            bl = false;
        } else {
            this$0.showMergeWindowForSelection();
            bl = true;
        }
        return bl;
    }

    private static final boolean _init_$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean _init_$lambda$3(GitConflictsPanel this$0, KeyEvent it) {
        this$0.showMergeWindowForSelection();
        return true;
    }

    private static final boolean _init_$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void _init_$lambda$5(GitConflictsPanel this$0, GitRepository it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateConflicts();
    }

    private static final void _init_$lambda$6(GitConflictsPanel this$0, GitRepository it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateConflicts();
    }

    private static final void updateConflicts$lambda$0$0$0(GitConflictsPanel this$0) {
        if (this$0.conflictsTree.getSelectionCount() == 0) {
            TreeUtil.promiseSelectFirstLeaf((JTree)((JTree)((Object)this$0.conflictsTree)));
        }
    }

    private static final Unit updateConflicts$lambda$0$0(GitConflictsPanel this$0, String $description, ArrayList $newConflicts, ArrayList $newReversedRoots) {
        ((Listener)this$0.eventDispatcher.getMulticaster()).onDescriptionChange($description);
        this$0.conflicts.clear();
        this$0.conflicts.addAll($newConflicts);
        this$0.reversedRoots.clear();
        this$0.reversedRoots.addAll($newReversedRoots);
        this$0.conflictsTree.setChangesToDisplay(this$0.conflicts);
        this$0.conflictsTree.invokeAfterRefresh(() -> GitConflictsPanel.updateConflicts$lambda$0$0$0(this$0));
        return Unit.INSTANCE;
    }

    private static final void updateConflicts$lambda$0(GitConflictsPanel this$0) {
        String string = this$0.mergeHandler.loadMergeDescription();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadMergeDescription(...)");
        String description = string;
        ArrayList newConflicts = new ArrayList();
        ArrayList<VirtualFile> newReversedRoots = new ArrayList<VirtualFile>();
        Collection<GitRepository> collection = GitUtil.getRepositories(this$0.project);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getRepositories(...)");
        Collection<GitRepository> repos = collection;
        for (GitRepository repo : repos) {
            if (GitMergeUtil.isReverseRoot(repo)) {
                newReversedRoots.add(repo.getRoot());
            }
            newConflicts.addAll(repo.getStagingAreaHolder().getAllConflicts());
        }
        ActionsKt.runInEdt$default(null, () -> GitConflictsPanel.updateConflicts$lambda$0$0(this$0, description, newConflicts, newReversedRoots), (int)1, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0015\u0010\u0002\u001a\u00020\u00032\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lgit4idea/conflicts/GitConflictsPanel$Listener;", "Ljava/util/EventListener;", "onDescriptionChange", "", "description", "", "Lorg/jetbrains/annotations/Nls;", "intellij.vcs.git"})
    public static interface Listener
    extends EventListener {
        default public void onDescriptionChange(@NotNull String description) {
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lgit4idea/conflicts/GitConflictsPanel$MainPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "<init>", "(Lgit4idea/conflicts/GitConflictsPanel;)V", "uiDataSnapshot", "", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitConflictsPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitConflictsPanel.kt\ngit4idea/conflicts/GitConflictsPanel$MainPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,233:1\n1642#2,10:234\n1915#2:244\n1916#2:246\n1652#2:247\n1#3:245\n*S KotlinDebug\n*F\n+ 1 GitConflictsPanel.kt\ngit4idea/conflicts/GitConflictsPanel$MainPanel\n*L\n160#1:234,10\n160#1:244\n160#1:246\n160#1:247\n160#1:245\n*E\n"})
    private final class MainPanel
    extends JPanel
    implements UiDataProvider {
        public MainPanel() {
            super(new BorderLayout());
        }

        /*
         * WARNING - void declaration
         */
        public void uiDataSnapshot(@NotNull DataSink sink) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            DataKey dataKey = CommonDataKeys.NAVIGATABLE_ARRAY;
            Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"NAVIGATABLE_ARRAY");
            Iterable iterable = GitConflictsPanel.this.getSelectedConflicts();
            Project project = GitConflictsPanel.this.project;
            DataKey dataKey2 = dataKey;
            DataSink dataSink = sink;
            boolean $i$f$mapNotNull = false;
            void var4_7 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                VirtualFile it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                GitConflict it = (GitConflict)element$iv$iv;
                boolean bl2 = false;
                if (it.getFilePath().getVirtualFile() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list = (List)destination$iv$iv;
            dataSink.set(dataKey2, (Object)ChangesUtil.getNavigatableArray((Project)project, (Iterable)list));
        }
    }
}

