/*
 * Decompiled with CFR 0.152.
 */
package git4idea.console;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.vcs.console.VcsConsoleFolding;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lgit4idea/console/GitConsoleFolding;", "Lcom/intellij/vcs/console/VcsConsoleFolding;", "gitLinePattern", "Ljava/util/regex/Pattern;", "<init>", "(Ljava/util/regex/Pattern;)V", "CONFIG_OPTIONS_REGEX", "getFoldingsForLine", "", "Lcom/intellij/vcs/console/VcsConsoleFolding$Placeholder;", "project", "Lcom/intellij/openapi/project/Project;", "line", "", "isGitCommandLine", "", "intellij.vcs.git"})
@ApiStatus.Internal
public final class GitConsoleFolding
implements VcsConsoleFolding {
    @NotNull
    private final Pattern gitLinePattern;
    @NotNull
    private final Pattern CONFIG_OPTIONS_REGEX;

    public GitConsoleFolding(@NotNull Pattern gitLinePattern) {
        Intrinsics.checkNotNullParameter((Object)gitLinePattern, (String)"gitLinePattern");
        this.gitLinePattern = gitLinePattern;
        Pattern pattern = Pattern.compile("(\\s-c\\s[\\w.]+=[^ ]*)+");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        this.CONFIG_OPTIONS_REGEX = pattern;
    }

    @NotNull
    public List<VcsConsoleFolding.Placeholder> getFoldingsForLine(@NotNull Project project, @NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        if (!this.isGitCommandLine(line)) {
            return CollectionsKt.emptyList();
        }
        List result2 = new ArrayList();
        Matcher matcher = this.CONFIG_OPTIONS_REGEX.matcher(line);
        Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher(...)");
        Matcher matcher2 = matcher;
        while (matcher2.find()) {
            int end;
            int start = matcher2.start();
            if (start < (end = matcher2.end()) && StringUtil.isWhiteSpace((char)line.charAt(start))) {
                ++start;
            }
            if (start >= end) continue;
            result2.add(new VcsConsoleFolding.Placeholder("-c ...", new TextRange(start, end)));
        }
        return result2;
    }

    private final boolean isGitCommandLine(String line) {
        return this.gitLinePattern.matcher(line).find();
    }
}

