/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ignore;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.NotIgnored;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.IgnoreSettingsType;
import com.intellij.openapi.vcs.changes.IgnoredFileContentProvider;
import com.intellij.openapi.vcs.changes.IgnoredFileDescriptor;
import com.intellij.openapi.vcs.changes.IgnoredFileProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.ignore.GitIgnoreChecker;
import git4idea.ignore.GitIgnoredFileContentProviderKt;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J#\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u000eH\u0002J:\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J6\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020!H\u0002J6\u0010\"\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020!H\u0002J\u001e\u0010#\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u0018\u0010$\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u000bH\u0016J\u0010\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u0011H\u0016J\u0018\u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u001bH\u0016J\u0012\u0010,\u001a\u00020\u000b2\b\b\u0001\u0010-\u001a\u00020\u000bH\u0003J\b\u0010.\u001a\u00020\u001eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lgit4idea/ignore/GitIgnoredFileContentProvider;", "Lcom/intellij/openapi/vcs/changes/IgnoredFileContentProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "gitIgnoreChecker", "Lgit4idea/ignore/GitIgnoreChecker;", "getSupportedVcs", "Lcom/intellij/openapi/vcs/VcsKey;", "getFileName", "", "buildIgnoreFileContent", "ignoreFileRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "ignoredFileProviders", "", "Lcom/intellij/openapi/vcs/changes/IgnoredFileProvider;", "(Lcom/intellij/openapi/vfs/VirtualFile;[Lcom/intellij/openapi/vcs/changes/IgnoredFileProvider;)Ljava/lang/String;", "getUntrackedFiles", "", "Lcom/intellij/openapi/vcs/FilePath;", "ignoreFileVcsRoot", "ignoreBeansToRelativePaths", "", "iterable", "", "Lcom/intellij/openapi/vcs/changes/IgnoredFileDescriptor;", "untrackedFiles", "shouldIgnoreUnderDir", "", "ignoredBean", "vcsContextFactory", "Lcom/intellij/openapi/vcs/actions/VcsContextFactory;", "shouldIgnoreFile", "shouldIgnoreByMask", "shouldNotConsiderInternalIgnoreFile", "buildUnignoreContent", "ignorePattern", "buildIgnoreGroupDescription", "ignoredFileProvider", "buildIgnoreEntryContent", "ignoreEntryRoot", "ignoredFileDescriptor", "prependCommentHashCharacterIfNeeded", "description", "canCreateIgnoreFileInStateStoreDir", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitIgnoredFileContentProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitIgnoredFileContentProvider.kt\ngit4idea/ignore/GitIgnoredFileContentProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,167:1\n1807#2,3:168\n1807#2,3:171\n1807#2,3:174\n1#3:177\n*S KotlinDebug\n*F\n+ 1 GitIgnoredFileContentProvider.kt\ngit4idea/ignore/GitIgnoredFileContentProvider\n*L\n107#1:168,3\n121#1:171,3\n129#1:174,3\n*E\n"})
public class GitIgnoredFileContentProvider
implements IgnoredFileContentProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final GitIgnoreChecker gitIgnoreChecker;

    public GitIgnoredFileContentProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.gitIgnoreChecker = new GitIgnoreChecker();
    }

    @NotNull
    public VcsKey getSupportedVcs() {
        VcsKey vcsKey = GitVcs.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)vcsKey, (String)"getKey(...)");
        return vcsKey;
    }

    @NotNull
    public String getFileName() {
        return ".gitignore";
    }

    @NotNull
    public String buildIgnoreFileContent(@NotNull VirtualFile ignoreFileRoot, @NotNull IgnoredFileProvider[] ignoredFileProviders) {
        Intrinsics.checkNotNullParameter((Object)ignoreFileRoot, (String)"ignoreFileRoot");
        Intrinsics.checkNotNullParameter((Object)ignoredFileProviders, (String)"ignoredFileProviders");
        if (!GitUtil.isUnderGit(ignoreFileRoot)) {
            return "";
        }
        VirtualFile virtualFile = VcsUtil.getVcsRootFor((Project)this.project, (VirtualFile)ignoreFileRoot);
        if (virtualFile == null) {
            return "";
        }
        VirtualFile ignoreFileVcsRoot = virtualFile;
        StringBuilder content = new StringBuilder();
        String lineSeparator = System.lineSeparator();
        Set<FilePath> untrackedFiles = this.getUntrackedFiles(ignoreFileVcsRoot);
        if (untrackedFiles.isEmpty()) {
            return "";
        }
        for (IgnoredFileProvider provider : ignoredFileProviders) {
            String description;
            Set set = provider.getIgnoredFiles(this.project);
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getIgnoredFiles(...)");
            List<String> ignoredFiles = this.ignoreBeansToRelativePaths(set, ignoreFileVcsRoot, ignoreFileRoot, untrackedFiles);
            if (ignoredFiles.isEmpty()) continue;
            if (((CharSequence)content).length() > 0) {
                content.append(lineSeparator).append(lineSeparator);
            }
            Intrinsics.checkNotNullExpressionValue((Object)provider.getIgnoredGroupDescription(), (String)"getIgnoredGroupDescription(...)");
            if (!StringsKt.isBlank((CharSequence)description)) {
                content.append(this.buildIgnoreGroupDescription(provider));
                content.append(lineSeparator);
            }
            Iterable iterable = ignoredFiles;
            Intrinsics.checkNotNull((Object)lineSeparator);
            content.append(CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)lineSeparator, null, null, (int)0, null, null, (int)62, null));
        }
        String string = content.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final Set<FilePath> getUntrackedFiles(VirtualFile ignoreFileVcsRoot) {
        try {
            GitRepository gitRepository = (GitRepository)GitRepositoryManager.getInstance(this.project).getRepositoryForRoot(ignoreFileVcsRoot);
            if (gitRepository == null) {
                return SetsKt.emptySet();
            }
            GitRepository repo = gitRepository;
            return CollectionsKt.toSet((Iterable)repo.getUntrackedFilesHolder().retrieveUntrackedFilePaths());
        }
        catch (VcsException e) {
            GitIgnoredFileContentProviderKt.access$getLOG$p().warn("Cannot get untracked files: ", (Throwable)e);
            return SetsKt.emptySet();
        }
    }

    private final List<String> ignoreBeansToRelativePaths(Iterable<? extends IgnoredFileDescriptor> iterable, VirtualFile ignoreFileVcsRoot, VirtualFile ignoreFileRoot, Set<? extends FilePath> untrackedFiles) {
        VcsContextFactory vcsContextFactory = VcsContextFactory.getInstance();
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence(iterable), arg_0 -> GitIgnoredFileContentProvider.ignoreBeansToRelativePaths$lambda$0(this, untrackedFiles, ignoreFileRoot, ignoreFileVcsRoot, vcsContextFactory, arg_0)), arg_0 -> GitIgnoredFileContentProvider.ignoreBeansToRelativePaths$lambda$1(this, ignoreFileRoot, arg_0)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldIgnoreUnderDir(IgnoredFileDescriptor ignoredBean, Set<? extends FilePath> untrackedFiles, VirtualFile ignoreFileRoot, VirtualFile ignoreFileVcsRoot, VcsContextFactory vcsContextFactory) {
        FilePath it;
        String string = ignoredBean.getPath();
        if (string == null) {
            return false;
        }
        String path = string;
        Path file = Paths.get(path, new String[0]);
        if (!Files.exists(file, new LinkOption[0])) return false;
        Iterable $this$any$iv = untrackedFiles;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (FilePath)element$iv;
            boolean bl = false;
        } while (!FileUtil.isAncestor((String)path, (String)it.getPath(), (boolean)true));
        boolean bl = true;
        if (!bl) return false;
        if (!FileUtil.isAncestor((String)ignoreFileRoot.getPath(), (String)path, (boolean)false)) return false;
        if (!Comparing.equal((Object)ignoreFileVcsRoot, (Object)VcsUtil.getVcsRootFor((Project)this.project, (FilePath)vcsContextFactory.createFilePath(path, true)))) return false;
        Intrinsics.checkNotNull((Object)file);
        if (!(this.gitIgnoreChecker.isIgnored(ignoreFileVcsRoot, file) instanceof NotIgnored)) return false;
        if (!this.shouldNotConsiderInternalIgnoreFile(ignoredBean, ignoreFileRoot)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldIgnoreFile(IgnoredFileDescriptor ignoredBean, Set<? extends FilePath> untrackedFiles, VirtualFile ignoreFileRoot, VirtualFile ignoreFileVcsRoot, VcsContextFactory vcsContextFactory) {
        FilePath it;
        if (!FileUtil.exists((String)ignoredBean.getPath())) return false;
        Iterable $this$any$iv = untrackedFiles;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (FilePath)element$iv;
            boolean bl = false;
        } while (!ignoredBean.matchesFile(it));
        boolean bl = true;
        if (!bl) return false;
        String string = ignoreFileRoot.getPath();
        String string2 = ignoredBean.getPath();
        Intrinsics.checkNotNull((Object)string2);
        if (!FileUtil.isAncestor((String)string, (String)string2, (boolean)false)) return false;
        String string3 = ignoredBean.getPath();
        Intrinsics.checkNotNull((Object)string3);
        if (!Comparing.equal((Object)ignoreFileVcsRoot, (Object)VcsUtil.getVcsRootFor((Project)this.project, (FilePath)vcsContextFactory.createFilePath(string3, false)))) return false;
        if (!this.shouldNotConsiderInternalIgnoreFile(ignoredBean, ignoreFileRoot)) return false;
        return true;
    }

    private final boolean shouldIgnoreByMask(IgnoredFileDescriptor ignoredBean, Set<? extends FilePath> untrackedFiles) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = untrackedFiles;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FilePath it = (FilePath)element$iv;
                    boolean bl2 = false;
                    if (!ignoredBean.matchesFile(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean shouldNotConsiderInternalIgnoreFile(IgnoredFileDescriptor ignoredBean, VirtualFile ignoreFileRoot) {
        boolean insideDirectoryStore;
        String string = ignoredBean.getPath();
        boolean bl = insideDirectoryStore = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)".idea", (boolean)false, (int)2, null) : false;
        if (insideDirectoryStore) {
            Path path = ProjectKt.getStateStore((Project)this.project).getDirectoryStorePath();
            if (path == null) {
                Path path2;
                String string2 = this.project.getProjectFilePath();
                if (string2 != null) {
                    String it = string2;
                    boolean bl2 = false;
                    path2 = Paths.get(it, new String[0]).getParent();
                } else {
                    path2 = path = null;
                }
                if (path2 == null) {
                    return false;
                }
            }
            Path directoryStoreOrProjectFileLocation = path;
            return FileUtil.isAncestor((String)((Object)directoryStoreOrProjectFileLocation).toString(), (String)FileUtil.toSystemDependentName((String)ignoreFileRoot.getPath()), (boolean)false);
        }
        return true;
    }

    @NotNull
    public String buildUnignoreContent(@NotNull String ignorePattern) {
        Intrinsics.checkNotNullParameter((Object)ignorePattern, (String)"ignorePattern");
        StringBuilder builder = new StringBuilder();
        builder.append(System.lineSeparator());
        builder.append('!').append(ignorePattern);
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public String buildIgnoreGroupDescription(@NotNull IgnoredFileProvider ignoredFileProvider) {
        Intrinsics.checkNotNullParameter((Object)ignoredFileProvider, (String)"ignoredFileProvider");
        String string = ignoredFileProvider.getIgnoredGroupDescription();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIgnoredGroupDescription(...)");
        return this.prependCommentHashCharacterIfNeeded(string);
    }

    @NotNull
    public String buildIgnoreEntryContent(@NotNull VirtualFile ignoreEntryRoot, @NotNull IgnoredFileDescriptor ignoredFileDescriptor) {
        Intrinsics.checkNotNullParameter((Object)ignoreEntryRoot, (String)"ignoreEntryRoot");
        Intrinsics.checkNotNullParameter((Object)ignoredFileDescriptor, (String)"ignoredFileDescriptor");
        String string = ignoreEntryRoot.getPath();
        String string2 = ignoredFileDescriptor.getPath();
        Intrinsics.checkNotNull((Object)string2);
        String string3 = FileUtil.getRelativePath((String)string, (String)string2, (char)'/');
        if (string3 == null) {
            string3 = "";
        }
        return "/" + string3;
    }

    @NlsContexts.DetailedDescription
    private final String prependCommentHashCharacterIfNeeded(@NlsContexts.DetailedDescription String description) {
        return StringsKt.startsWith$default((String)description, (String)"#", (boolean)false, (int)2, null) ? description : "# " + description;
    }

    public boolean canCreateIgnoreFileInStateStoreDir() {
        return false;
    }

    private static final boolean ignoreBeansToRelativePaths$lambda$0(GitIgnoredFileContentProvider this$0, Set $untrackedFiles, VirtualFile $ignoreFileRoot, VirtualFile $ignoreFileVcsRoot, VcsContextFactory $vcsContextFactory, IgnoredFileDescriptor ignoredBean) {
        Intrinsics.checkNotNullParameter((Object)ignoredBean, (String)"ignoredBean");
        return switch (WhenMappings.$EnumSwitchMapping$0[ignoredBean.getType().ordinal()]) {
            case 1 -> {
                Intrinsics.checkNotNull((Object)$vcsContextFactory);
                yield this$0.shouldIgnoreUnderDir(ignoredBean, $untrackedFiles, $ignoreFileRoot, $ignoreFileVcsRoot, $vcsContextFactory);
            }
            case 2 -> {
                Intrinsics.checkNotNull((Object)$vcsContextFactory);
                yield this$0.shouldIgnoreFile(ignoredBean, $untrackedFiles, $ignoreFileRoot, $ignoreFileVcsRoot, $vcsContextFactory);
            }
            case 3 -> this$0.shouldIgnoreByMask(ignoredBean, $untrackedFiles);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final String ignoreBeansToRelativePaths$lambda$1(GitIgnoredFileContentProvider this$0, VirtualFile $ignoreFileRoot, IgnoredFileDescriptor ignoredBean) {
        String string;
        Intrinsics.checkNotNullParameter((Object)ignoredBean, (String)"ignoredBean");
        switch (WhenMappings.$EnumSwitchMapping$0[ignoredBean.getType().ordinal()]) {
            case 3: {
                String string2 = ignoredBean.getMask();
                string = string2;
                Intrinsics.checkNotNull((Object)string2);
                break;
            }
            case 1: {
                string = this$0.buildIgnoreEntryContent($ignoreFileRoot, ignoredBean);
                break;
            }
            case 2: {
                string = this$0.buildIgnoreEntryContent($ignoreFileRoot, ignoredBean);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IgnoreSettingsType.values().length];
            try {
                nArray[IgnoreSettingsType.UNDER_DIR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IgnoreSettingsType.FILE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IgnoreSettingsType.MASK.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

