/*
 * Decompiled with CFR 0.152.
 */
package git4idea.inMemory.rebase;

import com.intellij.openapi.vcs.VcsException;
import com.intellij.platform.util.progress.ContextKt;
import com.intellij.platform.util.progress.SequentialProgressReporter;
import com.intellij.platform.util.progress.SequentialProgressReporterHandle;
import git4idea.i18n.GitBundle;
import git4idea.inMemory.GitObjectRepository;
import git4idea.inMemory.GitObjectRepositoryExtensionsKt;
import git4idea.inMemory.objects.GitObject;
import git4idea.inMemory.objects.Oid;
import git4idea.inMemory.rebase.GitInMemoryInteractiveRebaseProcess;
import git4idea.inMemory.rebase.GitInMemoryRebaseData;
import git4idea.inMemory.rebase.GitRebaseRewordEntryWithMessage;
import git4idea.inMemory.rebase.log.GitInMemoryCommitEditingOperation;
import git4idea.rebase.GitRebaseEntry;
import git4idea.rebase.GitRebaseEntryWithDetails;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0002\u0017\u0018B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000e\u001a\u00020\u000fH\u0094@\u00a2\u0006\u0002\u0010\u0010J$\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u00020\t8\u0014X\u0095D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lgit4idea/inMemory/rebase/GitInMemoryInteractiveRebaseProcess;", "Lgit4idea/inMemory/rebase/log/GitInMemoryCommitEditingOperation;", "objectRepo", "Lgit4idea/inMemory/GitObjectRepository;", "rebaseData", "Lgit4idea/inMemory/rebase/GitInMemoryRebaseData;", "<init>", "(Lgit4idea/inMemory/GitObjectRepository;Lgit4idea/inMemory/rebase/GitInMemoryRebaseData;)V", "reflogMessage", "", "getReflogMessage", "()Ljava/lang/String;", "failureTitle", "getFailureTitle", "editCommits", "Lgit4idea/inMemory/rebase/log/GitInMemoryCommitEditingOperation$CommitEditingResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "processEntry", "Lgit4idea/inMemory/objects/GitObject$Commit;", "baseCommit", "entry", "Lgit4idea/rebase/GitRebaseEntryWithDetails;", "commitToRebase", "Companion", "RebaseActionProcessor", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitInMemoryInteractiveRebaseProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitInMemoryInteractiveRebaseProcess.kt\ngit4idea/inMemory/rebase/GitInMemoryInteractiveRebaseProcess\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 steps.kt\ncom/intellij/platform/util/progress/StepsKt\n*L\n1#1,346:1\n1#2:347\n1586#3:348\n1661#3,3:349\n1915#3,2:354\n32#4,2:352\n*S KotlinDebug\n*F\n+ 1 GitInMemoryInteractiveRebaseProcess.kt\ngit4idea/inMemory/rebase/GitInMemoryInteractiveRebaseProcess\n*L\n53#1:348\n53#1:349,3\n60#1:354,2\n59#1:352,2\n*E\n"})
public final class GitInMemoryInteractiveRebaseProcess
extends GitInMemoryCommitEditingOperation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GitInMemoryRebaseData rebaseData;
    @NonNls
    @NotNull
    private final String reflogMessage;
    @NotNull
    private final String failureTitle;
    @NotNull
    private static final Map<KClass<? extends GitRebaseEntry.Action>, RebaseActionProcessor> actionProcessors;
    @NotNull
    private static final Set<KClass<? extends GitRebaseEntry.Action>> SUPPORTED_ACTIONS;

    public GitInMemoryInteractiveRebaseProcess(@NotNull GitObjectRepository objectRepo, @NotNull GitInMemoryRebaseData rebaseData) {
        Intrinsics.checkNotNullParameter((Object)objectRepo, (String)"objectRepo");
        Intrinsics.checkNotNullParameter((Object)rebaseData, (String)"rebaseData");
        super(objectRepo, rebaseData.getBaseCommit());
        this.rebaseData = rebaseData;
        this.reflogMessage = "interactive in-memory rebase";
        String string = GitBundle.message((String)"in.memory.rebase.log.interactive.failed.title", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.failureTitle = string;
    }

    @Override
    @NotNull
    protected String getReflogMessage() {
        return this.reflogMessage;
    }

    @Override
    @NotNull
    protected String getFailureTitle() {
        return this.failureTitle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    protected Object editCommits(@NotNull Continuation<? super GitInMemoryCommitEditingOperation.CommitEditingResult> $completion) {
        if (!($completion instanceof editCommits.1)) ** GOTO lbl-1000
        var22_2 = $completion;
        if ((var22_2.label & -2147483648) != 0) {
            var22_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ GitInMemoryInteractiveRebaseProcess this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.editCommits((Continuation<? super GitInMemoryCommitEditingOperation.CommitEditingResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var23_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!Intrinsics.areEqual((Object)this.getInitialHeadPosition(), (Object)this.rebaseData.getInitialHead().asString())) {
                    throw new VcsException(GitBundle.message((String)"in.memory.rebase.fail.head.move", (Object[])new Object[0]));
                }
                v0 = baseCommit = new Ref.ObjectRef();
                v1 = (Oid)CollectionsKt.singleOrNull(((GitObject.Commit)CollectionsKt.first(this.getBaseToHeadCommitsRange())).getParentsOids());
                if (v1 != null) {
                    var5_6 = v1;
                    var20_8 = v0;
                    $i$a$-let-GitInMemoryInteractiveRebaseProcess$editCommits$baseCommit$1 = false;
                    v2 = this.getObjectRepo().findCommit((Oid)it);
                    v0 = var20_8;
                } else {
                    v2 = null;
                }
                v0.element = v2;
                $this$map$iv = this.rebaseData.getEntries();
                $i$f$map = false;
                $i$a$-let-GitInMemoryInteractiveRebaseProcess$editCommits$baseCommit$1 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var11_21 = (GitRebaseEntryWithDetails)item$iv$iv;
                    var20_8 = destination$iv$iv;
                    $i$a$-map-GitInMemoryInteractiveRebaseProcess$editCommits$entriesWithCommits$1 = false;
                    var13_25 = this.getBaseToHeadCommitsRange();
                    for (T var15_28 : var13_25) {
                        it = (GitObject.Commit)var15_28;
                        $i$a$-find-GitInMemoryInteractiveRebaseProcess$editCommits$entriesWithCommits$1$commit$1 = false;
                        if (!Intrinsics.areEqual((Object)it.getOid().hex(), (Object)entry.getCommit())) continue;
                        v3 = var15_28;
                        ** GOTO lbl42
                    }
                    v3 = null;
lbl42:
                    // 2 sources

                    if ((GitObject.Commit)v3 == null) {
                        throw new IllegalStateException(("Couldn't find a commit corresponding to entry " + (GitRebaseEntryWithDetails)entry).toString());
                    }
                    var20_8.add(TuplesKt.to((Object)entry, (Object)commit));
                }
                entriesWithCommits = (List)destination$iv$iv;
                size$iv = entriesWithCommits.size();
                $i$f$reportSequentialProgress = 0;
                $continuation.L$0 = baseCommit;
                $continuation.L$1 = entriesWithCommits;
                $continuation.I$0 = size$iv;
                $continuation.I$1 = $i$f$reportSequentialProgress;
                $continuation.label = 1;
                v4 = ContextKt.internalCurrentStepAsSequential((int)size$iv, (Continuation)$continuation);
                if (v4 == var23_4) {
                    return var23_4;
                }
                ** GOTO lbl66
            }
            case 1: {
                $i$f$reportSequentialProgress = $continuation.I$1;
                size$iv = $continuation.I$0;
                entriesWithCommits = (List)$continuation.L$1;
                baseCommit = (Ref.ObjectRef)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl66:
                // 2 sources

                var6_10 = (AutoCloseable)v4;
                var7_13 = null;
                try {
                    it$iv = (SequentialProgressReporterHandle)var6_10;
                    $i$a$-use-StepsKt$reportSequentialProgress$2$iv = false;
                    reporter = it$iv.getReporter();
                    $i$a$-reportSequentialProgress-GitInMemoryInteractiveRebaseProcess$editCommits$2 = false;
                    $this$forEach$iv = entriesWithCommits;
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        var16_29 = (Pair)element$iv;
                        $i$a$-forEach-GitInMemoryInteractiveRebaseProcess$editCommits$2$1 = false;
                        entry = (GitRebaseEntryWithDetails)var16_29.component1();
                        commitToRebase = (GitObject.Commit)var16_29.component2();
                        baseCommit.element = this.processEntry((GitObject.Commit)baseCommit.element, entry, commitToRebase);
                        SequentialProgressReporter.itemStep$default((SequentialProgressReporter)reporter, null, (int)1, null);
                    }
                    var8_15 = Unit.INSTANCE;
                }
                catch (Throwable var9_18) {
                    var7_13 = var9_18;
                    throw var9_18;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)var6_10, (Throwable)var7_13);
                }
                if (baseCommit.element == null) {
                    baseCommit.element = this.getObjectRepo().findCommit(GitObjectRepository.commitTree$default(this.getObjectRepo(), this.getObjectRepo().getEmptyTree().getOid(), CollectionsKt.emptyList(), new byte[0], null, 8, null));
                }
                modifiesTree = Intrinsics.areEqual((Object)((GitObject.Commit)baseCommit.element).getTreeOid(), (Object)((GitObject.Commit)CollectionsKt.last(this.getBaseToHeadCommitsRange())).getTreeOid()) == false;
                return new GitInMemoryCommitEditingOperation.CommitEditingResult(((GitObject.Commit)baseCommit.element).getOid(), modifiesTree != false, null, null, 12, null);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final GitObject.Commit processEntry(GitObject.Commit baseCommit, GitRebaseEntryWithDetails entry, GitObject.Commit commitToRebase) {
        RebaseActionProcessor rebaseActionProcessor = actionProcessors.get(Reflection.getOrCreateKotlinClass(entry.getAction().getClass()));
        if (rebaseActionProcessor == null) {
            throw new UnsupportedOperationException("Action " + entry.getAction() + " not supported in memory rebase");
        }
        RebaseActionProcessor processor = rebaseActionProcessor;
        return processor.process(this.getObjectRepo(), baseCommit, commitToRebase, entry);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(GitRebaseEntry.Action.PICK.class), (Object)Companion.PickActionProcessor.INSTANCE), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(GitRebaseEntry.Action.REWORD.class), (Object)Companion.RewordActionProcessor.INSTANCE), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(GitRebaseEntry.Action.FIXUP.class), (Object)Companion.FixupActionProcessor.INSTANCE), TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(GitRebaseEntry.Action.DROP.class), (Object)Companion.DropActionProcessor.INSTANCE)};
        actionProcessors = MapsKt.mapOf((Pair[])pairArray);
        SUPPORTED_ACTIONS = actionProcessors.keySet();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0004\r\u000e\u000f\u0010B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\"\u0010\u0004\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lgit4idea/inMemory/rebase/GitInMemoryInteractiveRebaseProcess$Companion;", "", "<init>", "()V", "actionProcessors", "", "Lkotlin/reflect/KClass;", "Lgit4idea/rebase/GitRebaseEntry$Action;", "Lgit4idea/inMemory/rebase/GitInMemoryInteractiveRebaseProcess$RebaseActionProcessor;", "SUPPORTED_ACTIONS", "", "getSUPPORTED_ACTIONS", "()Ljava/util/Set;", "PickActionProcessor", "RewordActionProcessor", "FixupActionProcessor", "DropActionProcessor", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<KClass<? extends GitRebaseEntry.Action>> getSUPPORTED_ACTIONS() {
            return SUPPORTED_ACTIONS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lgit4idea/inMemory/rebase/GitInMemoryInteractiveRebaseProcess$Companion$DropActionProcessor;", "Lgit4idea/inMemory/rebase/GitInMemoryInteractiveRebaseProcess$RebaseActionProcessor;", "<init>", "()V", "process", "Lgit4idea/inMemory/objects/GitObject$Commit;", "objectRepo", "Lgit4idea/inMemory/GitObjectRepository;", "baseCommit", "commitToRebase", "entry", "Lgit4idea/rebase/GitRebaseEntryWithDetails;", "intellij.vcs.git"})
        private static final class DropActionProcessor
        implements RebaseActionProcessor {
            @NotNull
            public static final DropActionProcessor INSTANCE = new DropActionProcessor();

            private DropActionProcessor() {
            }

            @Override
            @Nullable
            public GitObject.Commit process(@NotNull GitObjectRepository objectRepo, @Nullable GitObject.Commit baseCommit, @NotNull GitObject.Commit commitToRebase, @NotNull GitRebaseEntryWithDetails entry) {
                Intrinsics.checkNotNullParameter((Object)objectRepo, (String)"objectRepo");
                Intrinsics.checkNotNullParameter((Object)commitToRebase, (String)"commitToRebase");
                Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                return baseCommit;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lgit4idea/inMemory/rebase/GitInMemoryInteractiveRebaseProcess$Companion$FixupActionProcessor;", "Lgit4idea/inMemory/rebase/GitInMemoryInteractiveRebaseProcess$RebaseActionProcessor;", "<init>", "()V", "process", "Lgit4idea/inMemory/objects/GitObject$Commit;", "objectRepo", "Lgit4idea/inMemory/GitObjectRepository;", "baseCommit", "commitToRebase", "entry", "Lgit4idea/rebase/GitRebaseEntryWithDetails;", "intellij.vcs.git"})
        @SourceDebugExtension(value={"SMAP\nGitInMemoryInteractiveRebaseProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitInMemoryInteractiveRebaseProcess.kt\ngit4idea/inMemory/rebase/GitInMemoryInteractiveRebaseProcess$Companion$FixupActionProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,346:1\n1#2:347\n*E\n"})
        private static final class FixupActionProcessor
        implements RebaseActionProcessor {
            @NotNull
            public static final FixupActionProcessor INSTANCE = new FixupActionProcessor();

            private FixupActionProcessor() {
            }

            @Override
            @NotNull
            public GitObject.Commit process(@NotNull GitObjectRepository objectRepo, @Nullable GitObject.Commit baseCommit, @NotNull GitObject.Commit commitToRebase, @NotNull GitRebaseEntryWithDetails entry) {
                Intrinsics.checkNotNullParameter((Object)objectRepo, (String)"objectRepo");
                Intrinsics.checkNotNullParameter((Object)commitToRebase, (String)"commitToRebase");
                Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                if (baseCommit == null) {
                    boolean $i$a$-checkNotNull-GitInMemoryInteractiveRebaseProcess$Companion$FixupActionProcessor$process$22 = false;
                    String $i$a$-checkNotNull-GitInMemoryInteractiveRebaseProcess$Companion$FixupActionProcessor$process$22 = "Can't apply squash as first commit";
                    throw new IllegalStateException($i$a$-checkNotNull-GitInMemoryInteractiveRebaseProcess$Companion$FixupActionProcessor$process$22.toString());
                }
                GitObject.Tree mergedTree = GitObjectRepositoryExtensionsKt.mergeTrees(objectRepo, commitToRebase, baseCommit);
                objectRepo.persistObject(mergedTree);
                GitRebaseEntry.Action action = entry.getAction();
                Intrinsics.checkNotNull((Object)action, (String)"null cannot be cast to non-null type git4idea.rebase.GitRebaseEntry.Action.FIXUP");
                Oid resultCommitOid = ((GitRebaseEntry.Action.FIXUP)action).getOverrideMessage() ? GitObjectRepository.commitTreeWithOverrides$default(objectRepo, baseCommit, mergedTree.getOid(), null, commitToRebase.getMessage(), null, 20, null) : GitObjectRepository.commitTreeWithOverrides$default(objectRepo, baseCommit, mergedTree.getOid(), null, null, null, 28, null);
                return objectRepo.findCommit(resultCommitOid);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lgit4idea/inMemory/rebase/GitInMemoryInteractiveRebaseProcess$Companion$PickActionProcessor;", "Lgit4idea/inMemory/rebase/GitInMemoryInteractiveRebaseProcess$RebaseActionProcessor;", "<init>", "()V", "process", "Lgit4idea/inMemory/objects/GitObject$Commit;", "objectRepo", "Lgit4idea/inMemory/GitObjectRepository;", "baseCommit", "commitToRebase", "entry", "Lgit4idea/rebase/GitRebaseEntryWithDetails;", "intellij.vcs.git"})
        private static final class PickActionProcessor
        implements RebaseActionProcessor {
            @NotNull
            public static final PickActionProcessor INSTANCE = new PickActionProcessor();

            private PickActionProcessor() {
            }

            @Override
            @NotNull
            public GitObject.Commit process(@NotNull GitObjectRepository objectRepo, @Nullable GitObject.Commit baseCommit, @NotNull GitObject.Commit commitToRebase, @NotNull GitRebaseEntryWithDetails entry) {
                Intrinsics.checkNotNullParameter((Object)objectRepo, (String)"objectRepo");
                Intrinsics.checkNotNullParameter((Object)commitToRebase, (String)"commitToRebase");
                Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                GitObject.Commit commit = baseCommit;
                if (Intrinsics.areEqual((Object)CollectionsKt.singleOrNull(commitToRebase.getParentsOids()), (Object)(commit != null ? commit.getOid() : null))) {
                    return commitToRebase;
                }
                return objectRepo.findCommit(GitObjectRepositoryExtensionsKt.rebaseCommit(objectRepo, commitToRebase, baseCommit));
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lgit4idea/inMemory/rebase/GitInMemoryInteractiveRebaseProcess$Companion$RewordActionProcessor;", "Lgit4idea/inMemory/rebase/GitInMemoryInteractiveRebaseProcess$RebaseActionProcessor;", "<init>", "()V", "process", "Lgit4idea/inMemory/objects/GitObject$Commit;", "objectRepo", "Lgit4idea/inMemory/GitObjectRepository;", "baseCommit", "commitToRebase", "entry", "Lgit4idea/rebase/GitRebaseEntryWithDetails;", "intellij.vcs.git"})
        private static final class RewordActionProcessor
        implements RebaseActionProcessor {
            @NotNull
            public static final RewordActionProcessor INSTANCE = new RewordActionProcessor();

            private RewordActionProcessor() {
            }

            @Override
            @NotNull
            public GitObject.Commit process(@NotNull GitObjectRepository objectRepo, @Nullable GitObject.Commit baseCommit, @NotNull GitObject.Commit commitToRebase, @NotNull GitRebaseEntryWithDetails entry) {
                String newMessage;
                Intrinsics.checkNotNullParameter((Object)objectRepo, (String)"objectRepo");
                Intrinsics.checkNotNullParameter((Object)commitToRebase, (String)"commitToRebase");
                Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                String string = newMessage = ((GitRebaseRewordEntryWithMessage)entry).getNewMessage();
                byte[] byArray = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                Oid rewordedCommit = GitObjectRepository.commitTreeWithOverrides$default(objectRepo, commitToRebase, null, null, byArray, null, 22, null);
                return objectRepo.findCommit(GitObjectRepositoryExtensionsKt.rebaseCommit(objectRepo, objectRepo.findCommit(rewordedCommit), baseCommit));
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J,\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lgit4idea/inMemory/rebase/GitInMemoryInteractiveRebaseProcess$RebaseActionProcessor;", "", "process", "Lgit4idea/inMemory/objects/GitObject$Commit;", "objectRepo", "Lgit4idea/inMemory/GitObjectRepository;", "baseCommit", "commitToRebase", "entry", "Lgit4idea/rebase/GitRebaseEntryWithDetails;", "intellij.vcs.git"})
    private static interface RebaseActionProcessor {
        @Nullable
        public GitObject.Commit process(@NotNull GitObjectRepository var1, @Nullable GitObject.Commit var2, @NotNull GitObject.Commit var3, @NotNull GitRebaseEntryWithDetails var4);
    }
}

