/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.vcs.log.impl.VcsLogIndexer;
import git4idea.GitVcs;
import git4idea.history.GitCommitRequirements;
import git4idea.history.GitCompressedDetailsCollector;
import git4idea.history.GitLogUtil;
import git4idea.log.GitLogProvider;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00100\u000fH\u0016J6\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00100\u000fH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lgit4idea/log/GitLogIndexer;", "Lcom/intellij/vcs/log/impl/VcsLogIndexer;", "project", "Lcom/intellij/openapi/project/Project;", "repositoryManager", "Lgit4idea/repo/GitRepositoryManager;", "<init>", "(Lcom/intellij/openapi/project/Project;Lgit4idea/repo/GitRepositoryManager;)V", "readAllFullDetails", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "encoder", "Lcom/intellij/vcs/log/impl/VcsLogIndexer$PathsEncoder;", "commitConsumer", "Lcom/intellij/util/Consumer;", "Lcom/intellij/vcs/log/impl/VcsLogIndexer$CompressedDetails;", "readFullDetails", "hashes", "", "", "getGitCommitRequirements", "Lgit4idea/history/GitCommitRequirements;", "repository", "Lgit4idea/repo/GitRepository;", "getSupportedVcs", "Lcom/intellij/openapi/vcs/VcsKey;", "intellij.vcs.git"})
public final class GitLogIndexer
implements VcsLogIndexer {
    @NotNull
    private final Project project;
    @NotNull
    private final GitRepositoryManager repositoryManager;

    public GitLogIndexer(@NotNull Project project, @NotNull GitRepositoryManager repositoryManager) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)repositoryManager), (String)"repositoryManager");
        this.project = project;
        this.repositoryManager = repositoryManager;
    }

    public void readAllFullDetails(@NotNull VirtualFile root, @NotNull VcsLogIndexer.PathsEncoder encoder, @NotNull Consumer<? super VcsLogIndexer.CompressedDetails> commitConsumer) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter(commitConsumer, (String)"commitConsumer");
        GitRepository gitRepository = GitLogProvider.Companion.getRepository$intellij_vcs_git(this.repositoryManager, root);
        if (gitRepository == null) {
            return;
        }
        GitRepository repository2 = gitRepository;
        GitCommitRequirements requirements = this.getGitCommitRequirements(repository2);
        String[] stringArray = ArrayUtil.toStringArray((Collection)GitLogUtil.LOG_ALL);
        new GitCompressedDetailsCollector(this.project, root, encoder).readFullDetails(arg_0 -> GitLogIndexer.readAllFullDetails$lambda$0((Function1)new Function1<Object, Unit>(commitConsumer){

            public final void invoke(Object p0) {
                ((Consumer)this.receiver).consume(p0);
            }
        }, arg_0), requirements, true, Arrays.copyOf(stringArray, stringArray.length));
    }

    public void readFullDetails(@NotNull VirtualFile root, @NotNull List<String> hashes, @NotNull VcsLogIndexer.PathsEncoder encoder, @NotNull Consumer<? super VcsLogIndexer.CompressedDetails> commitConsumer) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(hashes, (String)"hashes");
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter(commitConsumer, (String)"commitConsumer");
        GitRepository gitRepository = GitLogProvider.Companion.getRepository$intellij_vcs_git(this.repositoryManager, root);
        if (gitRepository == null) {
            return;
        }
        GitRepository repository2 = gitRepository;
        GitCommitRequirements requirements = this.getGitCommitRequirements(repository2);
        new GitCompressedDetailsCollector(this.project, root, encoder).readFullDetailsForHashes(hashes, requirements, true, arg_0 -> GitLogIndexer.readFullDetails$lambda$0((Function1)new Function1<Object, Unit>(commitConsumer){

            public final void invoke(Object p0) {
                ((Consumer)this.receiver).consume(p0);
            }
        }, arg_0));
    }

    private final GitCommitRequirements getGitCommitRequirements(GitRepository repository2) {
        return new GitCommitRequirements(GitLogProvider.Companion.shouldIncludeRootChanges$intellij_vcs_git(repository2), GitCommitRequirements.DiffRenames.Limit.Exact.INSTANCE, GitCommitRequirements.DiffInMergeCommits.DIFF_TO_PARENTS);
    }

    @NotNull
    public VcsKey getSupportedVcs() {
        VcsKey vcsKey = GitVcs.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)vcsKey, (String)"getKey(...)");
        return vcsKey;
    }

    private static final void readAllFullDetails$lambda$0(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void readFullDetails$lambda$0(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

