/*
 * Decompiled with CFR 0.152.
 */
package git4idea.search;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.vcs.log.VcsRef;
import git4idea.branch.GitBranchUtil;
import git4idea.log.GitRefManager;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lgit4idea/search/GitSearchUtils;", "", "<init>", "()V", "getTrackingRemoteBranchName", "", "vcsRef", "Lcom/intellij/vcs/log/VcsRef;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.vcs.git"})
@ApiStatus.Internal
public final class GitSearchUtils {
    @NotNull
    public static final GitSearchUtils INSTANCE = new GitSearchUtils();

    private GitSearchUtils() {
    }

    @NlsSafe
    @Nullable
    public final String getTrackingRemoteBranchName(@NotNull VcsRef vcsRef, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)vcsRef, (String)"vcsRef");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!Intrinsics.areEqual((Object)vcsRef.getType(), (Object)GitRefManager.LOCAL_BRANCH)) {
            return null;
        }
        GitRepository gitRepository = (GitRepository)GitRepositoryManager.getInstance(project).getRepositoryForRootQuick(vcsRef.getRoot());
        if (gitRepository == null) {
            return null;
        }
        GitRepository repository2 = gitRepository;
        GitBranchTrackInfo gitBranchTrackInfo = GitBranchUtil.getTrackInfo(repository2, vcsRef.getName());
        return gitBranchTrackInfo != null && (gitBranchTrackInfo = gitBranchTrackInfo.getRemoteBranch()) != null ? gitBranchTrackInfo.getName() : null;
    }
}

