/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.mergerequest.util;

import com.intellij.collaboration.api.HttpStatusErrorException;
import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.collaboration.ui.codereview.list.error.ErrorStatusPresenter;
import java.net.ConnectException;
import javax.swing.Action;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.api.data.GitLabHttpStatusError;
import org.jetbrains.plugins.gitlab.api.data.GitLabHttpStatusErrorKt;
import org.jetbrains.plugins.gitlab.authentication.GitLabLoginSource;
import org.jetbrains.plugins.gitlab.authentication.accounts.GitLabAccountViewModel;
import org.jetbrains.plugins.gitlab.util.GitLabBundle;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/util/GitLabMergeRequestErrorUtil;", "", "<init>", "()V", "createErrorStatusPresenter", "Lcom/intellij/collaboration/ui/codereview/list/error/ErrorStatusPresenter$Text;", "", "accountVm", "Lorg/jetbrains/plugins/gitlab/authentication/accounts/GitLabAccountViewModel;", "reloadAction", "Ljavax/swing/Action;", "loginSource", "Lorg/jetbrains/plugins/gitlab/authentication/GitLabLoginSource;", "createErrorStatusPresenter$intellij_vcs_gitlab", "intellij.vcs.gitlab"})
public final class GitLabMergeRequestErrorUtil {
    @NotNull
    public static final GitLabMergeRequestErrorUtil INSTANCE = new GitLabMergeRequestErrorUtil();

    private GitLabMergeRequestErrorUtil() {
    }

    @NotNull
    public final ErrorStatusPresenter.Text<Throwable> createErrorStatusPresenter$intellij_vcs_gitlab(@NotNull GitLabAccountViewModel accountVm, @Nullable Action reloadAction, @NotNull GitLabLoginSource loginSource) {
        Intrinsics.checkNotNullParameter((Object)accountVm, (String)"accountVm");
        Intrinsics.checkNotNullParameter((Object)((Object)loginSource), (String)"loginSource");
        return ErrorStatusPresenter.Companion.simple(GitLabBundle.message("merge.request.list.error", new Object[0]), GitLabMergeRequestErrorUtil::createErrorStatusPresenter$lambda$0, arg_0 -> GitLabMergeRequestErrorUtil.createErrorStatusPresenter$lambda$1(accountVm, loginSource, reloadAction, arg_0));
    }

    private static final String createErrorStatusPresenter$lambda$0(Throwable error) {
        Object object;
        block6: {
            block7: {
                Throwable throwable;
                block5: {
                    Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                    throwable = error;
                    if (!(throwable instanceof ConnectException)) break block5;
                    object = CollaborationToolsBundle.message((String)"review.list.connection.error", (Object[])new Object[0]);
                    break block6;
                }
                if (!(throwable instanceof HttpStatusErrorException)) break block7;
                GitLabHttpStatusError gitLabHttpStatusError = GitLabHttpStatusErrorKt.asGitLabStatusError((HttpStatusErrorException)error);
                if (gitLabHttpStatusError == null) {
                    return ((HttpStatusErrorException)error).getLocalizedMessage();
                }
                GitLabHttpStatusError actualError = gitLabHttpStatusError;
                switch (WhenMappings.$EnumSwitchMapping$0[actualError.getStatusErrorType().ordinal()]) {
                    case 1: {
                        object = CollaborationToolsBundle.message((String)"http.status.error.refresh.token", (Object[])new Object[0]);
                        break block6;
                    }
                    case 2: {
                        object = CollaborationToolsBundle.message((String)"http.request.error", (Object[])new Object[0]) + "\n" + actualError.getError();
                        break block6;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            object = error.getLocalizedMessage();
        }
        return object;
    }

    private static final Action createErrorStatusPresenter$lambda$1(GitLabAccountViewModel $accountVm, GitLabLoginSource $loginSource, Action $reloadAction, Throwable error) {
        Action action;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                if (!(error instanceof HttpStatusErrorException)) break block5;
                GitLabHttpStatusError gitLabHttpStatusError = GitLabHttpStatusErrorKt.asGitLabStatusError((HttpStatusErrorException)error);
                if (gitLabHttpStatusError == null) {
                    return null;
                }
                GitLabHttpStatusError actualError = gitLabHttpStatusError;
                switch (WhenMappings.$EnumSwitchMapping$0[actualError.getStatusErrorType().ordinal()]) {
                    case 1: {
                        action = $accountVm.loginAction($loginSource);
                        break block6;
                    }
                    case 2: {
                        action = null;
                        break block6;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            action = $reloadAction;
        }
        return action;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GitLabHttpStatusError.HttpStatusErrorType.values().length];
            try {
                nArray[GitLabHttpStatusError.HttpStatusErrorType.INVALID_TOKEN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GitLabHttpStatusError.HttpStatusErrorType.UNKNOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

