/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.ui.comment;

import com.intellij.collaboration.async.CoroutineUtilKt;
import com.intellij.openapi.project.Project;
import java.net.URL;
import java.util.Date;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.api.GitLabId;
import org.jetbrains.plugins.gitlab.api.dto.GitLabUserDTO;
import org.jetbrains.plugins.gitlab.mergerequest.data.GitLabMergeRequest;
import org.jetbrains.plugins.gitlab.mergerequest.data.GitLabMergeRequestDraftNote;
import org.jetbrains.plugins.gitlab.mergerequest.data.GitLabNotePosition;
import org.jetbrains.plugins.gitlab.mergerequest.data.GitLabProject;
import org.jetbrains.plugins.gitlab.mergerequest.ui.emoji.GitLabReactionsViewModel;
import org.jetbrains.plugins.gitlab.ui.GitLabMarkdownToHtmlConverter;
import org.jetbrains.plugins.gitlab.ui.comment.GitLabDiscussionStateContainer;
import org.jetbrains.plugins.gitlab.ui.comment.GitLabNoteAdminActionsViewModel;
import org.jetbrains.plugins.gitlab.ui.comment.GitLabNoteAdminActionsViewModelImpl;
import org.jetbrains.plugins.gitlab.ui.comment.GitLabNoteViewModel;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B9\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010@\u001a\u00020;H\u0016R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001fR\u0014\u0010 \u001a\u00020!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0016\u0010$\u001a\u0004\u0018\u00010%X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0016\u0010(\u001a\u0004\u0018\u00010)X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u001a\u00101\u001a\b\u0012\u0004\u0012\u00020.0-X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00100R\u001a\u00103\u001a\b\u0012\u0004\u0012\u0002040-X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00100R\u0019\u00106\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001070-\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00100R\u0014\u00109\u001a\b\u0012\u0004\u0012\u00020;0:X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010<\u001a\b\u0012\u0004\u0012\u00020;0=8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010?\u00a8\u0006A"}, d2={"Lorg/jetbrains/plugins/gitlab/ui/comment/GitLabMergeRequestStandaloneDraftNoteViewModelBase;", "Lorg/jetbrains/plugins/gitlab/ui/comment/GitLabNoteViewModel;", "project", "Lcom/intellij/openapi/project/Project;", "parentCs", "Lkotlinx/coroutines/CoroutineScope;", "note", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabMergeRequestDraftNote;", "mr", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabMergeRequest;", "projectData", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabProject;", "htmlConverter", "Lorg/jetbrains/plugins/gitlab/ui/GitLabMarkdownToHtmlConverter;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabMergeRequestDraftNote;Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabMergeRequest;Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabProject;Lorg/jetbrains/plugins/gitlab/ui/GitLabMarkdownToHtmlConverter;)V", "cs", "id", "Lorg/jetbrains/plugins/gitlab/api/GitLabId;", "getId", "()Lorg/jetbrains/plugins/gitlab/api/GitLabId;", "author", "Lorg/jetbrains/plugins/gitlab/api/dto/GitLabUserDTO;", "getAuthor", "()Lorg/jetbrains/plugins/gitlab/api/dto/GitLabUserDTO;", "createdAt", "Ljava/util/Date;", "getCreatedAt", "()Ljava/util/Date;", "isDraft", "", "()Z", "serverUrl", "Ljava/net/URL;", "getServerUrl", "()Ljava/net/URL;", "actionsVm", "Lorg/jetbrains/plugins/gitlab/ui/comment/GitLabNoteAdminActionsViewModel;", "getActionsVm", "()Lorg/jetbrains/plugins/gitlab/ui/comment/GitLabNoteAdminActionsViewModel;", "reactionsVm", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/emoji/GitLabReactionsViewModel;", "getReactionsVm", "()Lorg/jetbrains/plugins/gitlab/mergerequest/ui/emoji/GitLabReactionsViewModel;", "body", "Lkotlinx/coroutines/flow/StateFlow;", "", "getBody", "()Lkotlinx/coroutines/flow/StateFlow;", "bodyHtml", "getBodyHtml", "discussionState", "Lorg/jetbrains/plugins/gitlab/ui/comment/GitLabDiscussionStateContainer;", "getDiscussionState", "position", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabNotePosition;", "getPosition", "_focusRequestsChannel", "Lkotlinx/coroutines/channels/Channel;", "", "focusRequests", "Lkotlinx/coroutines/flow/Flow;", "getFocusRequests", "()Lkotlinx/coroutines/flow/Flow;", "requestFocus", "intellij.vcs.gitlab"})
public final class GitLabMergeRequestStandaloneDraftNoteViewModelBase
implements GitLabNoteViewModel {
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final GitLabId id;
    @NotNull
    private final GitLabUserDTO author;
    @Nullable
    private final Date createdAt;
    private final boolean isDraft;
    @NotNull
    private final URL serverUrl;
    @Nullable
    private final GitLabNoteAdminActionsViewModel actionsVm;
    @Nullable
    private final GitLabReactionsViewModel reactionsVm;
    @NotNull
    private final StateFlow<String> body;
    @NotNull
    private final StateFlow<String> bodyHtml;
    @NotNull
    private final StateFlow<GitLabDiscussionStateContainer> discussionState;
    @NotNull
    private final StateFlow<GitLabNotePosition> position;
    @NotNull
    private final Channel<Unit> _focusRequestsChannel;

    public GitLabMergeRequestStandaloneDraftNoteViewModelBase(@NotNull Project project, @NotNull CoroutineScope parentCs, @NotNull GitLabMergeRequestDraftNote note, @NotNull GitLabMergeRequest mr, @NotNull GitLabProject projectData, @NotNull GitLabMarkdownToHtmlConverter htmlConverter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentCs, (String)"parentCs");
        Intrinsics.checkNotNullParameter((Object)note, (String)"note");
        Intrinsics.checkNotNullParameter((Object)mr, (String)"mr");
        Intrinsics.checkNotNullParameter((Object)projectData, (String)"projectData");
        Intrinsics.checkNotNullParameter((Object)htmlConverter, (String)"htmlConverter");
        this.cs = CoroutineUtilKt.childScope$default((CoroutineScope)parentCs, (KClass)Reflection.getOrCreateKotlinClass(this.getClass()), null, (boolean)false, (int)6, null);
        this.id = note.getId();
        this.author = note.getAuthor();
        this.createdAt = note.getCreatedAt();
        this.isDraft = true;
        this.serverUrl = mr.getGlProject().getServerPath().toURL();
        this.actionsVm = note.getCanAdmin() ? (GitLabNoteAdminActionsViewModel)new GitLabNoteAdminActionsViewModelImpl(this.cs, project, projectData, note) : null;
        this.body = note.getBody();
        this.bodyHtml = CoroutineUtilKt.mapStateInNow(this.getBody(), (CoroutineScope)this.cs, arg_0 -> GitLabMergeRequestStandaloneDraftNoteViewModelBase.bodyHtml$lambda$0(htmlConverter, arg_0));
        this.discussionState = (StateFlow)StateFlowKt.MutableStateFlow((Object)GitLabDiscussionStateContainer.Companion.getDEFAULT());
        this.position = note.getPosition();
        this._focusRequestsChannel = ChannelKt.Channel$default((int)1, (BufferOverflow)BufferOverflow.DROP_OLDEST, null, (int)4, null);
    }

    @Override
    @NotNull
    public GitLabId getId() {
        return this.id;
    }

    @Override
    @NotNull
    public GitLabUserDTO getAuthor() {
        return this.author;
    }

    @Override
    @Nullable
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public boolean isDraft() {
        return this.isDraft;
    }

    @Override
    @NotNull
    public URL getServerUrl() {
        return this.serverUrl;
    }

    @Override
    @Nullable
    public GitLabNoteAdminActionsViewModel getActionsVm() {
        return this.actionsVm;
    }

    @Override
    @Nullable
    public GitLabReactionsViewModel getReactionsVm() {
        return this.reactionsVm;
    }

    @Override
    @NotNull
    public StateFlow<String> getBody() {
        return this.body;
    }

    @Override
    @NotNull
    public StateFlow<String> getBodyHtml() {
        return this.bodyHtml;
    }

    @Override
    @NotNull
    public StateFlow<GitLabDiscussionStateContainer> getDiscussionState() {
        return this.discussionState;
    }

    @NotNull
    public final StateFlow<GitLabNotePosition> getPosition() {
        return this.position;
    }

    @NotNull
    public Flow<Unit> getFocusRequests() {
        return FlowKt.receiveAsFlow((ReceiveChannel)((ReceiveChannel)this._focusRequestsChannel));
    }

    public void requestFocus() {
        this._focusRequestsChannel.trySend-JP2dKIU((Object)Unit.INSTANCE);
    }

    private static final String bodyHtml$lambda$0(GitLabMarkdownToHtmlConverter $htmlConverter, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $htmlConverter.convertToHtml(it);
    }
}

