/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.common;

import ai.grazie.ner.model.SentenceWithNERAnnotations;
import ai.grazie.nlp.langs.alphabet.Alphabet;
import ai.grazie.nlp.similarity.Levenshtein;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.Diacritics;
import ai.grazie.rules.common.KnownPhrases;
import ai.grazie.rules.common.PhraseDiff;
import ai.grazie.rules.tree.Formatter;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.TextRange;
import ai.grazie.rules.tree.TreeCache;
import ai.grazie.rules.util.CharUtil;
import ai.grazie.rules.util.TransformingCharSequence;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.Nullable;

public class MultiWordSpelling {
    private static final NodePattern DEFAULT_ALLOW_TYPO_FIXES = NodePattern.or(CommonPatterns.HYPHEN_NODE, NodePattern.not(NodePattern.PUNCT).andOr(NodePattern.N.noPos(), NodePattern.N.noLemma(".*")));
    private static final int MIN_KEY_LENGTH = 3;
    private static final int HASHING_START_LENGTH = 5;
    private static final int MAX_WORDS = 6;
    private static final String aposLike = "`\u2019'\"";
    private static final NodePattern beforeHyphen = NodePattern.N.noSpaceAfter().directlyBefore(CommonPatterns.HYPHEN_NODE);
    private final Int2ObjectMap<List<Phrase>> byHash = new Int2ObjectOpenHashMap();
    private final int maxKeyLength;
    private final KnownPhrases knownPhrases;
    private NodePattern allowTypoFixes = DEFAULT_ALLOW_TYPO_FIXES;
    private final List<PopularTypo> popularTypos = new ArrayList<PopularTypo>();
    private static final NodePattern lowercaseNamePart = NodePattern.or(NodePattern.N.form("von|zu|de|\u0444\u043e\u043d|\u0446\u0443|\u0434\u0435").directlyBefore(CommonPatterns.capitalized), NodePattern.N.inFormSequence(0, 1, "ob", "der"));
    private static final NodePattern innerEntityPunct = NodePattern.N.form("[.`\u2019'\"]").noSpaceBefore();
    private static final NodePattern validStart = NodePattern.N.form("[\\p{L}\\d].*").andNot(NodePattern.PUNCT).andNot(NodePattern.N.directlyAfter(CommonPatterns.noSpaceHyphen));
    private static final NodePattern globalExclusions = NodePattern.or(NodePattern.N.form("watches|macros|phone"), NodePattern.or(NodePattern.N.noSpaceAfter().directlyBefore(NodePattern.or(CommonPatterns.slash, NodePattern.N.form("[_:]").noSpaceAfter())), NodePattern.N.noSpaceBefore().directlyAfter(NodePattern.or(CommonPatterns.slash, NodePattern.N.form("[_:]").noSpaceBefore())), NodePattern.N.noSpaceAround().andNot(CommonPatterns.firstToken).andNot(CommonPatterns.lastToken)).andNot(CommonPatterns.capitalizedMiddle.andNot(CommonPatterns.quotedWord)), NodePattern.N.directlyAfter(NodePattern.N.form("#").noSpaceAfter()), NodePattern.N.formCaseSensitive("FOX"), NodePattern.N.formCaseSensitive("unicode").noSpaceAfter().directlyBefore(CommonPatterns.openingParen), NodePattern.N.formCaseSensitive("[A-Z]?(jetbrains|youtrack)").inFlatTree(), NodePattern.N.anyPos().directlyBefore(NodePattern.N.form("hub")).noForm("git"), CommonPatterns.lowerCase.inFormSequence(0, "intellij", "-", "idea", "-").withNeighbor(2, CommonPatterns.lowerCase).withNeighbor(4, CommonPatterns.lowerCase), NodePattern.N.formCaseSensitive("youtrack").directlyBefore(NodePattern.N.form("configure|start")));
    private static final NodePattern hasLetterOrDigit = NodePattern.N.form(".*[\\p{L}\\d].*");
    private static final NodePattern matchEnd = NodePattern.or(NodePattern.PUNCT.andNot(innerEntityPunct).andNot(CommonPatterns.dot), CommonPatterns.slash, NodePattern.N.form("\\p{L}.+\\.\\p{L}.+"));
    private final TreeCache<Map<Node, Match>> matches = new TreeCache<Map>("multiWord", tree -> {
        HashMap<Node, Match> results = new HashMap<Node, Match>();
        for (Node start : tree.nodes()) {
            Match result;
            if (!validStart.matches(start) || (result = this.matchFrom(start)) == null) continue;
            results.put(start, result);
        }
        return results;
    });

    public MultiWordSpelling(KnownPhrases knownPhrases) {
        this.knownPhrases = knownPhrases;
        HashSet<Phrase> added = new HashSet<Phrase>();
        for (String file : knownPhrases.multiWordFiles()) {
            for (KnownPhrases.Phrase pair : knownPhrases.phrasesFromFile(file)) {
                String phrase = pair.phrase();
                String line = pair.source();
                String[] words = MultiWordSpelling.splitWords(phrase);
                assert (words.length <= 6) : "Phrases of more than 6 are not yet supported: '" + phrase + "' in line " + line;
                Phrase p = new Phrase(phrase, MultiWordSpelling.multiWordKey(phrase), !file.endsWith("multi-word-no-typos.txt"), MultiWordSpelling.normalizeForDistance(phrase));
                if (!added.add(p)) {
                    throw new AssertionError((Object)("Duplicate phrase: '" + phrase + "' in " + line));
                }
                assert (p.key.length() >= 3) : "Phrases should be long enough: '" + phrase + "' in line " + line;
                int[] hashes = MultiWordSpelling.startHashes(phrase, 0);
                assert (hashes != null) : "Disallowed non-word character in '" + phrase + "' in line " + line;
                for (int hash : hashes) {
                    ((List)this.byHash.computeIfAbsent(hash, __ -> new ArrayList())).add(p);
                }
            }
        }
        this.maxKeyLength = StreamEx.of((Collection)this.byHash.values()).flatCollection(Function.identity()).mapToInt(s -> s.key.length()).max().orElseThrow();
        this.popularTypo("  +", " ");
    }

    public MultiWordSpelling popularTypo(@Language(value="RegExp") String actualRegex, @Language(value="RegExp") String expectedRegex) {
        this.popularTypos.add(new PopularTypo(Pattern.compile(actualRegex), Pattern.compile(expectedRegex)));
        return this;
    }

    private static String[] splitWords(String phrase) {
        return phrase.split("[- ]");
    }

    private static String normalizeForDistance(String text) {
        StringBuilder result = null;
        int prev = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            char normal = MultiWordSpelling.normalizeForDistance(c);
            if (normal == ' ' && prev == 32) {
                normal = '\u0000';
            }
            if (normal != '\u0000') {
                prev = normal;
            }
            if (normal != c && result == null) {
                result = new StringBuilder(text.substring(0, i));
            }
            if (result == null || normal == '\u0000') continue;
            result.append(normal);
        }
        return result == null ? text : result.toString();
    }

    private static char normalizeForDistance(char c) {
        return c == '-' || CharUtil.isAnySpace(c) || MultiWordSpelling.isSeparator(Character.getType(c)) ? (char)' ' : (aposLike.indexOf(c) >= 0 ? (char)'\u0000' : Diacritics.removeDiacritic(c));
    }

    private char normalizeForBigChangeCheck(char c) {
        return (char)(c == '-' || CharUtil.isAnySpace(c) || MultiWordSpelling.isSeparator(Character.getType(c)) ? 32 : (aposLike.indexOf(c) >= 0 ? 8217 : (int)Character.toLowerCase(this.knownPhrases.language.getAlphabet().matchEntire((CharSequence)String.valueOf(c)) ? c : Diacritics.removeDiacritic(c))));
    }

    private static boolean isSeparator(int type) {
        return type == 13 || type == 14;
    }

    public MultiWordSpelling allowTypoFixes(NodePattern ... patterns) {
        this.allowTypoFixes = NodePattern.or((NodePattern[])StreamEx.of((Object)this.allowTypoFixes).append((Object[])patterns).toArray(NodePattern[]::new));
        return this;
    }

    public NodePattern pattern(String typoMsgPattern, String minorMsgPattern) {
        return NodePattern.custom((start, match) -> {
            Match result = start.tree().getCached(this.matches).get(start);
            if (result == null) {
                return null;
            }
            Phrase sug = result.suggestions.getFirst();
            String msg = MultiWordSpelling.rangeWithSignificantTypos(start, result.end, sug) != null ? typoMsgPattern : minorMsgPattern;
            return match.withCorrector(result.corrector()).withMessage(msg.formatted(sug.original));
        });
    }

    public NodePattern diacriticPattern(String wordMsg, String phraseMsg) {
        return NodePattern.custom((start, match) -> {
            Match result = start.tree().getCached(this.matches).get(start);
            if (result == null || !result.changesDiacritics()) {
                return null;
            }
            return match.withCorrector(result.corrector()).withMessage(result.start == result.end ? wordMsg : phraseMsg);
        });
    }

    public NodePattern nonDiacriticPattern(String typoMsgPattern, String minorMsgPattern) {
        return NodePattern.custom((start, match) -> {
            Match result = start.tree().getCached(this.matches).get(start);
            if (result == null || result.isDiacriticOnlyDifference()) {
                return null;
            }
            Phrase sug = result.suggestions.getFirst();
            String msg = MultiWordSpelling.rangeWithSignificantTypos(start, result.end, sug) != null ? typoMsgPattern : minorMsgPattern;
            return match.withCorrector(result.corrector()).withMessage(msg.formatted(sug.original));
        });
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    private Match matchFrom(Node start) {
        candidates = this.candidatePhrases(start);
        if (candidates.isEmpty()) {
            return null;
        }
        sentence = start.tree().text();
        startOffset = start.startOffset();
        lastSuggestionEnd = null;
        longestResult = null;
        end = start;
        while (end != null && end.endOffset() - startOffset <= this.maxKeyLength + 6 && (key = MultiWordSpelling.multiWordKey(phrase = sentence.substring(startOffset, end.endOffset()))).length() <= this.maxKeyLength) {
            actual = new Phrase(phrase, key, false, MultiWordSpelling.normalizeForDistance(phrase));
            suggestions = new ArrayList<PhraseMatcher>();
            toContinue = new ArrayList<PhraseMatcher>();
            for (PhraseMatcher c : candidates) {
                result = c.updatePrefix(key, actual, end);
                if (result == AppendResult.Incompatible) continue;
                (result == AppendResult.CloseMatch ? suggestions : toContinue).add(c);
            }
            if (suggestions.isEmpty() || this.isRangeCoveredByValidPhrase(start, end)) ** GOTO lbl29
            if (MultiWordSpelling.beforeHyphen.matches(end)) {
                candidates = StreamEx.of(toContinue).append(candidates).toList();
            } else {
                filtered = this.filterSignificantTypos(start, end, suggestions, actual);
                if (!filtered.isEmpty()) {
                    if (MultiWordSpelling.globalExclusions.matches(start)) {
                        return null;
                    }
                    if (lastSuggestionEnd == null || this.allowExpansion(start, lastSuggestionEnd, end)) {
                        longestResult = new Match(start, end, MultiWordSpelling.getClosestSuggestions(filtered, actual));
                    }
                }
lbl29:
                // 6 sources

                if ((candidates = toContinue).isEmpty()) break;
                if (!suggestions.isEmpty()) {
                    lastSuggestionEnd = end;
                }
            }
            end = MultiWordSpelling.nextWord(end);
        }
        return longestResult;
    }

    protected boolean allowExpansion(Node start, Node lastSuggestionEnd, Node expandedEnd) {
        return true;
    }

    private boolean isRangeCoveredByValidPhrase(Node start, Node end) {
        return this.knownPhrases.validPhrases(start.tree()).stream().anyMatch(tr -> !tr.strippedDiacritics() && tr.start() <= start.startOffset() && end.endOffset() <= tr.end());
    }

    private static boolean expandForBetterMatch(Node start, Node end, Phrase sug, Phrase actual) {
        Node next = MultiWordSpelling.nextWord(end);
        if (hasLetterOrDigit.matches(next) || CommonPatterns.dot.matches(next)) {
            String sentence = start.tree().text();
            return sug.matchDistance(MultiWordSpelling.normalizeForDistance(sentence.substring(start.startOffset(), next.endOffset())), false) < sug.matchDistance(actual.matchDistanceKey, false);
        }
        return false;
    }

    @Nullable
    private static Node nextWord(Node node) {
        Node next = node.nextNode();
        if (CommonPatterns.HYPHEN_LIKE_NODE.matches(next) && !NodePattern.PUNCT.matches(next.nextNode())) {
            next = next.nextNode();
        }
        return next == null || matchEnd.matches(next) ? null : next;
    }

    private List<PhraseMatcher> candidatePhrases(Node start) {
        int i;
        int[] hashes = MultiWordSpelling.startHashes(start.tree().text(), start.startOffset());
        if (hashes == null) {
            return List.of();
        }
        LinkedHashSet candidates = null;
        boolean mustIncludeFirstChar = start.form().length() == 1;
        int n = i = mustIncludeFirstChar ? 1 : 0;
        while (i < hashes.length) {
            int hash = hashes[i];
            List each = (List)this.byHash.get(hash);
            if (each != null) {
                if (candidates == null) {
                    candidates = new LinkedHashSet(each);
                } else {
                    candidates.addAll(each);
                }
            }
            ++i;
        }
        if (candidates == null) {
            return List.of();
        }
        String key = start.form().length() <= 5 ? null : MultiWordSpelling.multiWordKey(start.form());
        ArrayList<PhraseMatcher> matchers = new ArrayList<PhraseMatcher>();
        for (Phrase phrase : candidates) {
            if (key != null && !phrase.canBePrefix(key)) continue;
            matchers.add(new PhraseMatcher(phrase, start));
        }
        return matchers;
    }

    private List<Phrase> filterSignificantTypos(Node start, Node end, List<PhraseMatcher> suggestions, Phrase actual) {
        ArrayList<Phrase> insignificant = new ArrayList<Phrase>();
        ArrayList<Phrase> allowedSignificant = new ArrayList<Phrase>();
        for (PhraseMatcher suggestion : suggestions) {
            TextRange range = MultiWordSpelling.rangeWithSignificantTypos(start, end, suggestion.phrase);
            if (range == null) {
                insignificant.add(suggestion.phrase);
                continue;
            }
            if (!MultiWordSpelling.spansExactNamedEntity(start, end)) {
                if (!MultiWordSpelling.nodesInRange(start, range).allMatch(this.allowTypoFixes::matches)) continue;
            }
            if (this.hasTooBigDifferences(suggestion.phrase, actual)) continue;
            allowedSignificant.add(suggestion.phrase);
        }
        return !insignificant.isEmpty() ? insignificant : allowedSignificant;
    }

    private boolean hasTooBigDifferences(Phrase expected, Phrase actual) {
        String actualNorm = new TransformingCharSequence(actual.original, this::normalizeForBigChangeCheck).toString();
        String expectedNorm = new TransformingCharSequence(expected.original, this::normalizeForBigChangeCheck).toString();
        PhraseDiff raw = PhraseDiff.build(expectedNorm, actualNorm);
        List reduced = StreamEx.of(raw.spans()).map(r -> this.reduceSignificance(raw, (PhraseDiff.Span)r)).nonNull().toList();
        return new PhraseDiff(raw.expected(), raw.actual(), reduced).hasBigDifferences();
    }

    private PhraseDiff.Span reduceSignificance(PhraseDiff diff, PhraseDiff.Span span) {
        for (int i = 0; i < this.popularTypos.size(); ++i) {
            PopularTypo typo = this.popularTypos.get(i);
            PhraseDiff.Span changed = span.reduce(diff.actual(), diff.expected(), typo.inActual, typo.inExpected);
            if (changed == null) {
                return null;
            }
            if (span.equals(changed)) continue;
            span = changed;
            i = 0;
        }
        return span;
    }

    private static boolean spansExactNamedEntity(Node start, Node end) {
        if (MultiWordSpelling.isCapitalizedInNonCapitalizedContext(start, end)) {
            return true;
        }
        SentenceWithNERAnnotations.Annotation ner = start.nerAnnotation();
        return start != end && ner != null && ner.getRange().getStart() == start.startOffset() && ner.getRange().getEndExclusive() == end.endOffset();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isCapitalizedInNonCapitalizedContext(Node start, Node end) {
        if (start == end) return false;
        if (!CommonPatterns.capitalized.matches(start)) return false;
        if (!CommonPatterns.capitalized.matches(end)) return false;
        Node prev = start.prevNode();
        Node next = end.nextNode();
        if (CommonPatterns.capitalizedMiddle.matches(prev)) return false;
        if (CommonPatterns.capitalized.matches(next)) return false;
        if (CommonPatterns.punctForm.matches(prev)) {
            if (CommonPatterns.punctForm.matches(next)) return false;
        }
        if (!start.nextUntil(end).allMatch(NodePattern.or(NodePattern.PUNCT, CommonPatterns.capitalized, lowercaseNamePart)::matches)) return false;
        return true;
    }

    private static Stream<Node> nodesInRange(Node start, TextRange range) {
        List overlapping = ((StreamEx)((StreamEx)start.forward().dropWhile(n -> n.endOffset() <= range.start())).takeWhile(n -> n.startOffset() < range.end())).toList();
        if (!overlapping.isEmpty()) {
            return overlapping.stream();
        }
        return ((StreamEx)start.forward().dropWhile(n -> n.endOffset() < range.start())).takeWhile(n -> n.startOffset() < range.end());
    }

    private static MatchingPrefix matchPrefix(Phrase suggestion, int start, int end, String sentence) {
        int keyIndex = 0;
        while (start < end && keyIndex < suggestion.key.length()) {
            int significant;
            for (significant = start; significant < end && MultiWordSpelling.skipKeyChar(sentence.charAt(significant)); ++significant) {
            }
            if (significant == end || MultiWordSpelling.normalizeKeyChar(sentence.charAt(significant)) != suggestion.key.charAt(keyIndex++)) break;
            start = significant + 1;
        }
        return new MatchingPrefix(start, keyIndex == suggestion.key.length());
    }

    @Nullable
    private static TextRange rangeWithSignificantTypos(Node startNode, Node endNode, Phrase suggestion) {
        char c;
        String sentence = startNode.tree().text();
        int start = startNode.startOffset();
        int end = endNode.endOffset();
        MatchingPrefix mp = MultiWordSpelling.matchPrefix(suggestion, start, end, sentence);
        if (mp.prefixEnd == end && mp.fullMatch) {
            return null;
        }
        int keyIndex = suggestion.key.length();
        while (end - 1 > mp.prefixEnd && (MultiWordSpelling.skipKeyChar(c = sentence.charAt(end - 1)) || MultiWordSpelling.normalizeKeyChar(c) == suggestion.key.charAt(--keyIndex))) {
            --end;
        }
        return new TextRange(mp.prefixEnd, end);
    }

    private static List<Phrase> getClosestSuggestions(List<Phrase> suggestions, Phrase actual) {
        Comparator<Phrase> caseInsensitiveComparator = MultiWordSpelling.createComparator(actual, false);
        Comparator<Phrase> caseSensitiveComparator = MultiWordSpelling.createComparator(actual, true);
        List sortedList = ((StreamEx)StreamEx.of(suggestions).sorted(caseInsensitiveComparator)).toList();
        List<Phrase> closestMatches = MultiWordSpelling.findClosestMatches(sortedList, caseInsensitiveComparator);
        if (closestMatches.size() > 1) {
            sortedList = ((StreamEx)StreamEx.of(suggestions).sorted(caseSensitiveComparator)).toList();
            closestMatches = MultiWordSpelling.findClosestMatches(sortedList, caseSensitiveComparator);
        }
        return MultiWordSpelling.filterByCapitalization(closestMatches);
    }

    private static Comparator<Phrase> createComparator(Phrase phrase, boolean considerCase) {
        return Comparator.comparingInt(sug -> sug.matchDistance(phrase.matchDistanceKey, considerCase)).thenComparing(sug -> sug.original.length());
    }

    private static List<Phrase> findClosestMatches(List<Phrase> sortedList, Comparator<Phrase> comparator) {
        Phrase firstMatch = sortedList.getFirst();
        return sortedList.stream().takeWhile(sug -> comparator.compare(firstMatch, (Phrase)sug) == 0).collect(Collectors.toList());
    }

    private static List<Phrase> filterByCapitalization(List<Phrase> phrases) {
        Set capitalizedSet = phrases.stream().filter(c -> Character.isLowerCase(c.original.charAt(0))).map(c -> c.original.substring(0, 1).toUpperCase(Locale.ROOT) + c.original.substring(1)).collect(Collectors.toSet());
        return phrases.stream().filter(c -> !capitalizedSet.contains(c.original)).toList();
    }

    private static int @Nullable [] startHashes(String phrase, int offset) {
        int keyIndex = 0;
        int[] hashes = new int[5];
        for (int i = offset; i < phrase.length() && keyIndex < hashes.length; ++i) {
            char c = phrase.charAt(i);
            if (MultiWordSpelling.skipKeyChar(c)) continue;
            if (!Character.isLetterOrDigit(c)) {
                return null;
            }
            char norm = MultiWordSpelling.normalizeKeyChar(c);
            for (int hashIndex = 0; hashIndex < hashes.length; ++hashIndex) {
                if (hashIndex == keyIndex) continue;
                hashes[hashIndex] = hashes[hashIndex] * 239 + norm;
            }
            ++keyIndex;
        }
        return hashes;
    }

    private static String multiWordKey(String phrase) {
        StringBuilder sb = new StringBuilder(phrase.length());
        for (int i = 0; i < phrase.length(); ++i) {
            char c = phrase.charAt(i);
            if (MultiWordSpelling.skipKeyChar(c)) continue;
            sb.append(MultiWordSpelling.normalizeKeyChar(c));
        }
        return sb.toString();
    }

    private static char normalizeKeyChar(char c) {
        return Character.toLowerCase(Diacritics.removeDiacritic(c));
    }

    private static boolean skipKeyChar(char c) {
        return c == '-' || c == '.' || c == '\u2013' || CharUtil.isAnyOf(aposLike, c) || CharUtil.isAnySpace(c);
    }

    private record Phrase(String original, String key, boolean allowSignificantTypos, String matchDistanceKey) {
        private static final int ALLOWED_MISTAKE_RATE = 5;

        private boolean isFullMatch(Phrase actual, int matchDistance) {
            if (matchDistance > this.matchDistanceKey.length() / 5) {
                return false;
            }
            return this.allowSignificantTypos || actual.key.equals(this.key);
        }

        private int matchDistance(String actualMatchDistanceKey, boolean preserveCase) {
            String norm1 = actualMatchDistanceKey;
            String norm2 = this.matchDistanceKey;
            if (!preserveCase) {
                norm1 = norm1.toLowerCase(Locale.ROOT);
                norm2 = norm2.toLowerCase(Locale.ROOT);
            }
            return Levenshtein.WithDamerau.distance(norm1, norm2);
        }

        private boolean canBePrefix(String keyPrefix) {
            int baseLen = Math.min(this.key.length(), keyPrefix.length());
            char lastKeyChar = keyPrefix.charAt(keyPrefix.length() - 1);
            return Phrase.hasAllowedMistakeRate(keyPrefix, this.key.substring(0, baseLen)) || baseLen < this.key.length() && this.key.charAt(baseLen) == lastKeyChar && Phrase.hasAllowedMistakeRate(keyPrefix, this.key.substring(0, baseLen + 1)) || baseLen > 1 && this.key.charAt(baseLen - 2) == lastKeyChar && Phrase.hasAllowedMistakeRate(keyPrefix, this.key.substring(0, baseLen - 1));
        }

        private static boolean hasAllowedMistakeRate(String keyPrefix, String actualPrefix) {
            return Levenshtein.WithDamerau.distance(actualPrefix, keyPrefix) <= actualPrefix.length() / 5 + 1;
        }
    }

    private record PopularTypo(Pattern inActual, Pattern inExpected) {
    }

    private static class PhraseMatcher {
        final Phrase phrase;
        final Node start;
        private int lastDistance = Integer.MAX_VALUE;

        PhraseMatcher(Phrase phrase, Node start) {
            this.phrase = phrase;
            this.start = start;
        }

        AppendResult updatePrefix(String key, Phrase actual, Node end) {
            if (!this.phrase.canBePrefix(key)) {
                return AppendResult.Incompatible;
            }
            int distance = Levenshtein.WithDamerau.distance(this.phrase.key, key);
            if (distance > this.lastDistance) {
                return AppendResult.Incompatible;
            }
            this.lastDistance = distance;
            if (this.phrase.isFullMatch(actual, distance)) {
                if (MultiWordSpelling.expandForBetterMatch(this.start, end, this.phrase, actual)) {
                    return AppendResult.NeedExpansion;
                }
                return AppendResult.CloseMatch;
            }
            return AppendResult.NeedExpansion;
        }

        public String toString() {
            return this.phrase.original;
        }
    }

    private static enum AppendResult {
        CloseMatch,
        NeedExpansion,
        Incompatible;

    }

    private record Match(Node start, Node end, List<Phrase> suggestions) {
        NodeCorrector corrector() {
            return NodeCorrector.replaceNodes(this.start, this.end, (String[])this.suggestions.stream().map(Phrase::original).toArray(String[]::new));
        }

        boolean isDiacriticOnlyDifference() {
            Alphabet alphabet = this.start.tree().treeSupport().getGrazieLanguage().getAlphabet();
            String actual = Diacritics.removeDiacritics(this.start.tree().text().substring(this.start.startOffset(), this.end.endOffset()), alphabet);
            return this.suggestions.stream().allMatch(sug -> Formatter.adjustReplacementCase(this.start, this.end, Diacritics.removeDiacritics(sug.original, alphabet)).equals(actual));
        }

        boolean changesDiacritics() {
            String actual = this.extractDiacritics(this.start.tree().text().substring(this.start.startOffset(), this.end.endOffset()));
            return this.suggestions.stream().noneMatch(sug -> actual.equals(this.extractDiacritics(sug.original)));
        }

        private String extractDiacritics(String s) {
            Alphabet alphabet = this.start.tree().treeSupport().getGrazieLanguage().getAlphabet();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < s.length(); ++i) {
                char c = Character.toLowerCase(s.charAt(i));
                if (!Diacritics.isDiacritic(c) || alphabet.matchEntire((CharSequence)String.valueOf(c))) continue;
                sb.append(c);
            }
            return sb.toString();
        }
    }

    private record MatchingPrefix(int prefixEnd, boolean fullMatch) {
    }
}

