/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.TreeMigration;
import ai.grazie.rules.en.Articles;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.Semantics;
import ai.grazie.rules.en.StyleRules;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import java.util.List;

class PronounForm {
    private static final NodePattern who = NodePattern.N.form("who");
    static final NodePattern whom = NodePattern.N.form("whom");
    static final NodePattern whomever = NodePattern.N.form("whomever");
    static final NodePattern caseWho = who.markAs("Who").withDependent("case", CommonPatterns.possiblySkipDown("fixed", NodePattern.N.directlyBefore("Who")));
    private static final NodePattern toPossessivePronouns = NodePattern.or(NodePattern.N.form("my|me").correct(NodeCorrector.replace("mine")), NodePattern.N.form("your?").correct(NodeCorrector.replace("yours")), NodePattern.N.form("her").correct(NodeCorrector.replace("hers")), NodePattern.N.form("him").correct(NodeCorrector.replace("his")), NodePattern.N.form("us|our").correct(NodeCorrector.replace("ours")), NodePattern.N.form("them|their").correct(NodeCorrector.replace("theirs")));
    private static final NodePattern toAccusativePronouns = NodePattern.or(NodePattern.N.form("my").correct(NodeCorrector.replace("me")), NodePattern.N.form("your").correct(NodeCorrector.replace("you")), NodePattern.N.form("his").correct(NodeCorrector.replace("him")), NodePattern.N.form("its").correct(NodeCorrector.replace("it")), NodePattern.N.form("our").correct(NodeCorrector.replace("us")), NodePattern.N.form("their").correct(NodeCorrector.replace("them")));

    PronounForm() {
    }

    static NodePattern pronounInCompoundSubject() {
        String nsubj = "nsubj.*";
        return NodePattern.or(NodePattern.N.form("me").andNot(CommonPatterns.capitalizedMiddle).andNot(NodePattern.N.directlyBefore(NodePattern.N.form("too"))), NodePattern.N.form("her|him|them"), NodePattern.N.form("us").noPos("NNP")).andOr(NodePattern.N.withHead("conj", NodePattern.N.withHeadRelation(nsubj)), NodePattern.N.withHeadRelation(nsubj).withDependent("conj", NodePattern.N.markAs("Conj")).andNot(NodePattern.N.form("her").and(NodePattern.markedNodeMatches("Conj", NodePattern.N.withDependent("nmod:poss"))))).andNot(CommonPatterns.skipConjUp(NodePattern.N.withHead("nsubj", NodePattern.N.withHeadRelation("advcl|acl").withPhraseStart(NodePattern.N.form("for"))))).correct(NodeCorrector.inflect("PRP_O(.*)", "PRP_S$1")).message("You may have used the object pronoun '$_' in a subject position");
    }

    static NodePattern grammarRulePattern() {
        return NodePattern.or(PronounForm.pronounInCompoundObjects(), PronounForm.whPronouns(), PronounForm.possessivePronouns(), PronounForm.possessiveDeterminers(), PronounForm.doublePossessives(), PronounForm.redundantApostropheS());
    }

    private static NodePattern pronounInCompoundObjects() {
        return NodePattern.or(NodePattern.N.formCaseSensitive("I").and(CommonPatterns.highlightPlusOneChar), NodePattern.N.form("s?he|they|we")).markAs("Pronoun").andOr(NodePattern.N.withHead("conj", NodePattern.or(NodePattern.N.withHeadRelation("i?obj|obl|nmod").andNot(NodePattern.N.withHead(NodePattern.N.withHeadRelation("nsubj.*"))).andNot(NodePattern.N.withDependent("case", NodePattern.N.markAs("Prep")).withNextSibling(NodePattern.N.withDependent("case", NodePattern.N.sameWordAs("Prep")))).noDependents("case", NodePattern.N.form("than")), NodePattern.ROOT.withDependent("case"), NodePattern.ROOT.withDependent("obj", NodePattern.N.withNextSibling(NodePattern.N.alreadyMarkedAs("Pronoun"))))), NodePattern.N.withHeadRelation("i?obj|obl|nmod").withDependent("conj", NodePattern.N.withDependent("cc", NodePattern.N.pos(".*")))).noDependents("punct").correct(NodeCorrector.inflect("PRP_S(.*)", "PRP_O$1")).message("You may have used the subject pronoun '$_' in an object position");
    }

    private static NodePattern whPronouns() {
        NodePattern whomBeforeSubjectInRelClause = NodePattern.N.withHeadRelation("obj").beforeHead().withNextSibling(NodePattern.N.withHead("nsubj", NodePattern.N.pos("VBD").withHeadRelation("acl:relcl")));
        NodePattern afterClauseHead = NodePattern.N.inPhrase(EnglishTreePatterns.clause.markAs("ClauseHead")).after("ClauseHead");
        NodePattern whomAsSubject = whom.withHead("nsubj|obj", EnglishTreePatterns.verbalClause.withDependent("ccomp", NodePattern.or(NodePattern.N.onlyPos("JJ|NN.*").withDependent("cop"), NodePattern.N.pos("VBG").withDependent("cop|aux|aux:pass", NodePattern.N.lemma("be")), NodePattern.N.noDependents("nsubj(:pass|:outer)?|csubj(:pass)?").withDependent("obj")))).andNot(whomBeforeSubjectInRelClause);
        NodePattern whomeverAsSubject = whomever.andOr(NodePattern.N.withHead("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.withHeadRelation("advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis|root")), NodePattern.N.withDependent("case").and(TreeMigration.revise("try leaving only acl:relcl", NodePattern.N.withDependent("acl(:relcl)?", EnglishTreePatterns.verbalClause.noDependents("nsubj(:pass|:outer)?|csubj(:pass)?")))));
        NodePattern whoAfterPreposition = NodePattern.or(caseWho.andNot(NodePattern.N.withHead("obl", NodePattern.N.noPos("VB.*")).withDependent("acl:relcl")).andNot(NodePattern.ROOT.noDependents("cop|advcl:relcl")).andNot(NodePattern.N.withDependent("a(dv)?cl:relcl").withDependent("cop")).andNot(NodePattern.N.withDependent("acl(:relcl)?", NodePattern.N.withDependent("aux").noDependents("nsubj(:pass|:outer)?|csubj(:pass)?"))).andNot(NodePattern.N.inPhrase(NodePattern.ROOT.lemma("be").withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.form("it")))).andNot(afterClauseHead.noDependents(NodePattern.N.afterHead()).noHeadRelation("conj")), who.directlyAfter(NodePattern.N.pos("IN").withHeadRelation("mark")).withHead("obj", EnglishTreePatterns.verbalClause)).andNot(CommonPatterns.capitalizedMiddle).noDependents("det").noDependents("cop|aux|aux:pass|acl:relcl", NodePattern.N.lemma("be").afterHead()).noDependents("amod", NodePattern.N.form("else"));
        return NodePattern.or(whomAsSubject.correct(NodeCorrector.replace("who")).message("Use 'who' instead of 'whom' to refer to the subject of the sentence"), whomeverAsSubject.correct(NodeCorrector.replace("whoever")).message("Use 'whoever' to refer to the subject of the dependent clause"), whoAfterPreposition.correct(NodeCorrector.replace("whom")).message("Use 'whom' instead of 'who' after prepositions"));
    }

    private static NodePattern possessivePronouns() {
        return NodePattern.N.form("my|your|her|our|their").andNot(NodePattern.N.directlyBefore(EnglishTreePatterns.apostropheS)).and(toPossessivePronouns).andNot(CommonPatterns.lastToken).andNot(CommonPatterns.quotedWord).markAs("Pronoun").andOr(CommonPatterns.skipConjUp(NodePattern.or(NodePattern.N.noForm("her").andOr(NodePattern.N.withDependent("cop"), NodePattern.N.withDependent("case", NodePattern.N.form("as|like"))).andOptionally(CommonPatterns.skipUp("xcomp", NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?|expl", NodePattern.N.form("it|that|t?here"))).and(toAccusativePronouns)), NodePattern.N.withHead("nmod:poss", NodePattern.N.onlyPos("NN.*")).withDependent("conj").afterHead())), NodePattern.N.noForm("her").withHead("conj", NodePattern.N.withDependent("nmod:poss")), NodePattern.N.withHead("nsubj", NodePattern.N.withHeadRelation("conj").withDependent("cop"))).message("'$_' usually needs a noun after it; consider using a possessive pronoun instead");
    }

    private static NodePattern possessiveDeterminers() {
        NodePattern couldBeIf = CommonPatterns.firstChildPhrase.withHead("nmod:poss", NodePattern.N.withHead("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.ROOT.withDependent("parataxis")));
        return NodePattern.N.form("I|you|it|she|he|we|they").noFormCaseSensitive("IT").spaceAfter().markAs("Pronoun").andNot(NodePattern.N.directlyBefore(NodePattern.or(EnglishTreePatterns.apostropheS, EnglishTreePatterns.splitApostropheS))).andOr(NodePattern.N.withHeadRelation("det"), NodePattern.N.withHeadRelation("nmod:poss").noDependents("conj")).withHead(NodePattern.N.noForm("ones?|amount").potentialPos("NNS?").noPos("IN|CC").markAs("HeadNoun").noDependents("punct", NodePattern.N.beforeHead()).andNot(Semantics.numberDelegatingGroup).noHeadRelation("parataxis").noDependents("det|nmod:poss", NodePattern.not(NodePattern.N.alreadyMarkedAs("Pronoun")))).andNot(CommonPatterns.insideQuotes).andNot(couldBeIf).andNot(NodePattern.N.form("you").beforeHead().withHead(StyleRules.informalAddressing)).andOptionally(NodePattern.N.form("they|he").correct(NodeCorrector.replace("the"))).and(NodePattern.custom((pronoun, match) -> {
            String possessive = Articles.pronounToPossessiveDeterminer(pronoun.lowForm());
            NodeCorrector persPronounToPossessiveDet = NodeCorrector.replace(pronoun, possessive);
            if (pronoun.hasForm("they|he")) {
                return match.withCorrectors(List.of(NodeCorrector.replace(pronoun, "the"), persPronounToPossessiveDet)).withMessage("Did you mean '" + possessive + "' or 'the'?");
            }
            return match.withCorrector(persPronounToPossessiveDet).withMessage("Did you mean '" + possessive + "'?");
        }));
    }

    private static NodePattern doublePossessives() {
        return NodePattern.or(NodePattern.N.form("me|my|your?|him|her|us|our|them|their").withHead(NodePattern.or(Semantics.kindredRelation, NodePattern.N.lemma("client|customer|friend|user|colleague|teammate|groupmate|citizen|nominee|immigrant|emigrant|migrant|refugee|resident|slave|veteran|patient|employee|subordinate|chief|superior|superordinate|reportee|underboss|boss|subsidiary|managee|manager|leadee|leader"))), NodePattern.N.form("my|your|our|their").withHead(NodePattern.N.onlyPos("NNS?"))).withDependent("case", NodePattern.N.form("of").markAs("Of")).withHead(NodePattern.N.directlyBefore("Of").markAs("Head").withDependent("det", NodePattern.N.noForm("the").markAs("Det"))).andNot(NodePattern.N.directlyBefore(EnglishTreePatterns.apostropheS)).andNot(CommonPatterns.lastToken).and(toPossessivePronouns).message("Use a possessive pronoun after '$Det $Head of'");
    }

    private static NodePattern redundantApostropheS() {
        NodePattern toThere = NodePattern.N.form("their").withHeadRelation("expl").correct(NodeCorrector.replace("there")).message("Did you mean 'there\u2019s'?");
        NodePattern toPossessivePronoun = NodePattern.or(NodePattern.N.noHeadRelation("nmod:poss"), NodePattern.N.directlyBeforeHead().withHead("nmod:poss", NodePattern.N.alreadyMarkedAs("ApostropheS"))).correct(NodeCorrector.replace(NodePointer.marked("ApostropheS"), "s")).and(NodePattern.custom((node, match) -> match.withMessage("Did you mean '" + node.lowForm() + "s'?")));
        NodePattern toPossessiveDeterminer = NodePattern.N.withHeadRelation("nmod:poss").noFormCaseSensitive("HER").andNot(NodePattern.markedNodeMatches("ApostropheS", NodePattern.N.withHeadRelation("cop|aux|aux:pass"))).correct(NodeCorrector.replace(NodePointer.marked("ApostropheS"), "")).message("Did you mean '$_'?");
        return NodePattern.N.form("your|her|our|their").directlyBefore(EnglishTreePatterns.apostropheS.noSpaceBefore().markAs("ApostropheS")).andOr(toThere, toPossessivePronoun, toPossessiveDeterminer);
    }
}

