/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.tree;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.Quotes;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeRange;
import ai.grazie.rules.tree.TextChange;
import ai.grazie.rules.tree.TextRange;
import ai.grazie.rules.tree.Tree;
import ai.grazie.rules.tree.TreeSupport;
import ai.grazie.rules.util.CharUtil;
import com.carrotsearch.hppc.predicates.CharPredicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.languagetool.tools.StringTools;

@ApiStatus.Internal
public class Formatter {
    private static final String LEFT_ATTACHING_PUNCT = ",:;.)]}>!?";
    private static final String RIGHT_ATTACHING_PUNCT = "([{<";
    private static final Set<String> emptyBraces = Set.of("()", "[]", "{}", "<>");
    private static final Pattern mentions = Pattern.compile("@[\\p{L}\\d.]+(\\s+@[\\p{L}\\d.]+)*");
    private final Tree tree;
    private final TreeSupport support;
    private final String text;
    private final List<TextChange.Replacement> formatted = new ArrayList<TextChange.Replacement>();
    private static final Pattern lowerCaseFirstWord = Pattern.compile("iOS|iPad|macOS|iPadOS|tvOS|watchOS|audioOS");

    Formatter(Tree tree) {
        this.tree = tree;
        this.support = tree.treeSupport();
        this.text = tree.text();
    }

    public static TextChange moveFragment(String fragment, NodeRange fragmentRange, TextRange to) {
        Formatter formatter = new Formatter(fragmentRange.start().tree());
        TextChange.Replacement change = new TextChange.Replacement(to, fragment);
        return new TextChange(formatter.formatChange(change, fragmentRange.start().startOffset(), formatter.text.length()));
    }

    TextChange formatChanges(List<TextRange> rangesToFormat, List<TextChange.Replacement> unformatted) {
        TextChange.Replacement prev = null;
        for (int i = 0; i < unformatted.size(); ++i) {
            TextChange.Replacement each = unformatted.get(i);
            TextRange range = each.range();
            if (prev != null && prev.range().overlaps(range)) {
                if (!TextChange.diagnoseIntersections) continue;
                throw new IllegalArgumentException("Intersecting changes: " + String.valueOf(prev) + " and " + String.valueOf(each) + "; text='" + this.text + "'");
            }
            TextChange.Replacement result = rangesToFormat.stream().anyMatch(r -> r.containsInclusive(range.start()) && r.containsInclusive(range.end())) ? this.formatChange(each, null, this.nextChangeStart(unformatted, i)) : each;
            this.formatted.add(result);
            prev = each;
        }
        return TextChange.mergeReplacements(this.tree.text(), (StreamEx<TextChange.Replacement>)StreamEx.of(this.formatted));
    }

    private int nextChangeStart(List<TextChange.Replacement> changes, int index) {
        TextChange.Replacement c;
        int end = changes.get(index).range().end();
        while (++index < changes.size() && (c = changes.get(index)).replacement().isEmpty() && c.range().start() <= end) {
        }
        return index < changes.size() ? changes.get(index).range().start() : this.text.length();
    }

    private TextChange.Replacement formatChange(TextChange.Replacement change, @Nullable Integer movedFrom, int nextChangeStart) {
        return this.fixCase(this.fixSpace(change), movedFrom, nextChangeStart);
    }

    private int prevChangeEnd() {
        return this.formatted.isEmpty() ? 0 : this.formatted.getLast().range().end();
    }

    public static String adjustReplacementCase(Node start, Node end, String replacement) {
        Tree tree = start.tree();
        TextChange.Replacement change = new TextChange.Replacement(new TextRange(start.startOffset(), end.endOffset()), replacement);
        return new Formatter(tree).fixCase(change, null, tree.text().length()).replacement();
    }

    private TextChange.Replacement fixCase(TextChange.Replacement change, @Nullable Integer movedFrom, int nextChangeStart) {
        if (this.text.chars().noneMatch(Character::isLowerCase)) {
            return change.withString(change.replacement().toUpperCase(Locale.ROOT));
        }
        Capitalization capitalization = this.guessCapitalization(change);
        if (capitalization == Capitalization.NeedUpper) {
            if (!(StringTools.isCapitalizedWord((String)change.replacement()) || lowerCaseFirstWord.matcher(change.replacement()).lookingAt() || this.possiblyNeedsLowerCaseAfterAbbreviation(change.range()))) {
                change = change.withString(StringTools.uppercaseFirstChar((String)change.replacement()));
            }
            if (change.range().length() == 0 && this.isTrulyLowerCase(change.range().start()) && !this.support.hasAllCapitalizedStyle(this.tree) && !change.replacement().isBlank()) {
                change = change.growRange(0, 1).withString(change.replacement() + Character.toLowerCase(this.text.charAt(change.range().start())));
            } else if (change.replacement().isEmpty() && change.range().end() < nextChangeStart) {
                change = change.growRange(0, 1).withString(change.replacement() + Character.toUpperCase(this.text.charAt(change.range().end())));
            }
        } else if (capitalization == Capitalization.PreferLower && (movedFrom == null || this.mightNeedSentenceStartCapitalization(movedFrom) && this.isTrulyLowerCase(movedFrom)) && !Formatter.isCustomCaseFirstWord(change.replacement())) {
            String prevText = change.range().substring(this.text);
            if (this.support.shouldPreserveCase(change, this.tree, prevText)) {
                change = change.withString(TreeSupport.preserveCase(prevText, change.replacement(), this.support.language()));
            } else if (movedFrom != null) {
                change = change.withString(StringTools.lowercaseFirstChar((String)change.replacement()));
            }
        }
        return change;
    }

    private boolean possiblyNeedsLowerCaseAfterAbbreviation(TextRange range) {
        int start = range.start();
        if (!this.text.substring(0, start).strip().endsWith(".")) {
            return false;
        }
        if (this.isDigitAt(start)) {
            return true;
        }
        if (range.length() == 0) {
            Node node = this.tree.findBestNodeAt(start);
            return node != null && !this.support.isTrulyLowerCase(node);
        }
        return false;
    }

    private boolean isDigitAt(int offset) {
        return offset < this.text.length() && Character.isDigit(this.text.charAt(offset));
    }

    private Capitalization guessCapitalization(TextChange.Replacement change) {
        TextChange.Replacement prev;
        int offset = change.range().start();
        for (int nonEmptyChange = this.formatted.size() - 1; nonEmptyChange >= 0 && (prev = this.formatted.get(nonEmptyChange)).replacement().isBlank(); --nonEmptyChange) {
            offset = prev.range().start();
        }
        while (offset < change.range().length() && !Character.isLetterOrDigit(this.text.charAt(offset))) {
            ++offset;
        }
        if (offset >= this.text.length()) {
            return Capitalization.Unknown;
        }
        if (!this.mightNeedSentenceStartCapitalization(offset)) {
            return Capitalization.PreferLower;
        }
        if (Character.isUpperCase(this.text.charAt(offset))) {
            return Capitalization.NeedUpper;
        }
        if (this.isDigitAt(offset)) {
            if (this.text.substring(0, offset).trim().endsWith(":")) {
                return Capitalization.Unknown;
            }
            return Capitalization.NeedUpper;
        }
        return Capitalization.Unknown;
    }

    private static boolean isCustomCaseFirstWord(String s) {
        String[] words = s.split("\\s+");
        return words.length > 0 && CommonPatterns.isCustomCase(words[0]);
    }

    private boolean mightNeedSentenceStartCapitalization(int offset) {
        String textBefore = this.text.substring(0, offset);
        if (TreeSupport.hasOnlyPunctuationBefore(textBefore, textBefore.length())) {
            return true;
        }
        return Formatter.possiblyEndsWithSentenceBoundary(textBefore) || this.allQuotes().canBeOpeningQuote(textBefore.substring(textBefore.length() - 1)) && this.isTrulyLowerCase(offset) || mentions.matcher(textBefore.strip()).matches();
    }

    public static boolean possiblyEndsWithSentenceBoundary(CharSequence textBefore) {
        String stripped = textBefore.toString().stripTrailing();
        return !stripped.isEmpty() && CharUtil.isAnyOf(":.!?", stripped.charAt(stripped.length() - 1));
    }

    private boolean isTrulyLowerCase(int offset) {
        Node node = this.tree.findBestNodeAt(offset);
        return node == null || this.support.isTrulyLowerCase(node);
    }

    private TextChange.Replacement fixSpace(TextChange.Replacement change) {
        return change.replacement().isEmpty() ? this.adjustEmptyReplacement(change) : this.ensureSingleSpaceAround(change);
    }

    private TextChange.Replacement adjustEmptyReplacement(TextChange.Replacement change) {
        boolean atStart = (change = this.removeLonePunctuation(change)).range().start() == 0;
        int prevChangeEnd = this.prevChangeEnd();
        if (atStart || this.isInlineSpaceAt(change.range().start() - 1) || this.isRightAttachedPunctuation(change.range().start() - 1)) {
            int end;
            int start;
            if (prevChangeEnd > 0 && prevChangeEnd < start && this.isInlineSpaceAt(start - 1)) {
                for (start = change.range().start(); prevChangeEnd < start && this.isInlineSpaceAt(start - 1); --start) {
                }
            } else {
                for (end = change.range().end(); end < this.text.length() - 1 && (this.isInlineSpaceAt(end) || atStart && this.isLeftAttachedPunctuation(end)); ++end) {
                }
            }
            change = change.growRange(start - change.range().start(), end - change.range().end());
        }
        if (change.range().end() < this.text.length() && this.isLeftAttachedPunctuation(change.range().end()) || change.range().end() <= this.text.length() && this.text.substring(change.range().end()).isBlank()) {
            change = change.growRange(-this.countBackward(change.range().start(), CharUtil::isInlineSpace), 0);
        }
        return change;
    }

    private TextChange.Replacement removeLonePunctuation(TextChange.Replacement change) {
        TextRange range = change.range();
        if (range.start() > 0 && range.end() < this.text.length()) {
            char prev = this.text.charAt(range.start() - 1);
            char next = this.text.charAt(range.end());
            if (range.substring(this.text).equals(",") && Character.isLetterOrDigit(prev) && Character.isLetterOrDigit(next)) {
                return change.withString(" ");
            }
            if (emptyBraces.contains("" + prev + next)) {
                return change.growRange(-1, 1);
            }
        }
        return change;
    }

    private TextChange.Replacement ensureSingleSpaceAround(TextChange.Replacement change) {
        String replacement = change.replacement();
        int start = change.range().start();
        int wsBefore = Math.min(start - this.prevChangeEnd(), this.countBackward(start, CharUtil::isInlineSpace));
        char repl0 = replacement.charAt(0);
        int growBefore = CharUtil.isInlineSpace(repl0) || CharUtil.isAnyOf(LEFT_ATTACHING_PUNCT, repl0) ? wsBefore : Math.max(0, wsBefore - 1);
        int wsAfter = this.countForward(change.range().end(), CharUtil::isInlineSpace);
        int growAfter = CharUtil.isInlineSpace(replacement.charAt(replacement.length() - 1)) ? wsAfter : Math.max(0, wsAfter - 1);
        return change.growRange(-growBefore, growAfter);
    }

    private boolean isLeftAttachedPunctuation(int index) {
        if (index > 0 && !this.isInlineSpaceAt(index - 1)) {
            char c = this.text.charAt(index);
            return CharUtil.isAnyOf(LEFT_ATTACHING_PUNCT, c) || this.allQuotes().canBeClosingQuote(String.valueOf(c)) && (index == this.text.length() - 1 || this.isInlineSpaceAt(index + 1) || this.isPunctAt(index + 1));
        }
        return false;
    }

    private boolean isRightAttachedPunctuation(int index) {
        if (index < this.text.length() - 1 && !this.isInlineSpaceAt(index + 1)) {
            char c = this.text.charAt(index);
            return CharUtil.isAnyOf(RIGHT_ATTACHING_PUNCT, c) || this.allQuotes().canBeOpeningQuote(String.valueOf(c)) && (index == 0 || this.isInlineSpaceAt(index - 1));
        }
        return false;
    }

    private Quotes allQuotes() {
        return this.support.getAllQuotes();
    }

    private int countForward(int pos, CharPredicate charCondition) {
        int count = 0;
        while (pos + count < this.text.length() - 1 && charCondition.apply(this.text.charAt(pos + count))) {
            ++count;
        }
        return count;
    }

    private int countBackward(int pos, CharPredicate charCondition) {
        int count = 0;
        while (pos - 1 - count >= 0 && charCondition.apply(this.text.charAt(pos - 1 - count))) {
            ++count;
        }
        return count;
    }

    private boolean isInlineSpaceAt(int index) {
        return CharUtil.isInlineSpace(this.text.charAt(index));
    }

    private boolean isPunctAt(int index) {
        return StringTools.isPunctuationMark((String)String.valueOf(this.text.charAt(index)));
    }

    private static enum Capitalization {
        NeedUpper,
        PreferLower,
        Unknown;

    }
}

