/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flyway.orm;

import com.intellij.flyway.orm.FlywayCallbackEvent;
import com.intellij.flyway.orm.JavaCallbackModel;
import com.intellij.flyway.orm.JavaMigrationModel;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.jpa.jpb.model.backend.events.ExceptionEvent;
import com.intellij.jpa.jpb.model.model.SourceLanguage;
import com.intellij.jpa.jpb.model.util.HProjectUtils;
import com.intellij.jpa.jpb.model.util.JpaUtils;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ \u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0002J&\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/intellij/flyway/orm/FlywayJavaCreator;", "", "<init>", "()V", "createJavaMigrationFile", "Lcom/intellij/psi/PsiFile;", "model", "Lcom/intellij/flyway/orm/JavaMigrationModel;", "targetDirectory", "Lcom/intellij/psi/PsiDirectory;", "generationLanguage", "Lcom/intellij/jpa/jpb/model/model/SourceLanguage;", "createJavaCallbackFile", "callbackModel", "Lcom/intellij/flyway/orm/JavaCallbackModel;", "getFlywayCallbackTemplate", "", "getFlywayJavaMigrationTemplate", "convertEvents", "eventParamName", "events", "", "Lcom/intellij/flyway/orm/FlywayCallbackEvent;", "intellij.flyway.orm"})
public final class FlywayJavaCreator {
    @NotNull
    public static final FlywayJavaCreator INSTANCE = new FlywayJavaCreator();

    private FlywayJavaCreator() {
    }

    @Nullable
    public final PsiFile createJavaMigrationFile(@NotNull JavaMigrationModel model, @NotNull PsiDirectory targetDirectory, @NotNull SourceLanguage generationLanguage) {
        PsiFile psiFile;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        Intrinsics.checkNotNullParameter((Object)generationLanguage, (String)"generationLanguage");
        Project project = targetDirectory.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        FileTemplateManager templateManager = FileTemplateManager.getInstance((Project)project2);
        Properties properties = templateManager.getDefaultProperties();
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"getDefaultProperties(...)");
        Properties props = properties;
        props.setProperty("NAME", model.getClassName());
        props.setProperty("PACKAGE_NAME", model.getPackageName());
        boolean hasJdbcTemplate = HProjectUtils.isClassAvailableInLibraries((Project)project2, null, (String)"org.springframework.jdbc.core.JdbcTemplate");
        props.setProperty("HAS_JDBC_TEMPLATE", String.valueOf(hasJdbcTemplate));
        props.setProperty("IS_COMMUNITY_IDEA", String.valueOf(!JpaUtils.isUltimate()));
        FileTemplate fileTemplate = templateManager.getJ2eeTemplate(this.getFlywayJavaMigrationTemplate(generationLanguage));
        Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"getJ2eeTemplate(...)");
        FileTemplate template = fileTemplate;
        try {
            PsiElement psiElement = FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)model.getClassName(), (Properties)props, (PsiDirectory)targetDirectory);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"createFromTemplate(...)");
            PsiElement element = psiElement;
            psiFile = element.getContainingFile();
        }
        catch (Exception e) {
            new ExceptionEvent((Object)("Exception while trying to create Flyway java migration: '" + model.getClassName() + "'"), (Throwable)e).post(project2);
            psiFile = null;
        }
        return psiFile;
    }

    @Nullable
    public final PsiFile createJavaCallbackFile(@NotNull JavaCallbackModel callbackModel, @NotNull PsiDirectory targetDirectory, @NotNull SourceLanguage generationLanguage) {
        PsiFile psiFile;
        Intrinsics.checkNotNullParameter((Object)callbackModel, (String)"callbackModel");
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        Intrinsics.checkNotNullParameter((Object)generationLanguage, (String)"generationLanguage");
        Project project = targetDirectory.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        FileTemplateManager templateManager = FileTemplateManager.getInstance((Project)project2);
        Properties properties = templateManager.getDefaultProperties();
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"getDefaultProperties(...)");
        Properties props = properties;
        props.setProperty("NAME", callbackModel.getClassName());
        props.setProperty("PACKAGE_NAME", callbackModel.getPackageName());
        props.setProperty("CALLBACK_NAME", callbackModel.getCallbackName());
        props.setProperty("CAN_HANDLE_IN_TRANSACTION", String.valueOf(callbackModel.getCanHandleInTransaction()));
        String eventParamName = "event";
        props.setProperty("EVENT_PARAM_NAME", eventParamName);
        props.setProperty("EVENTS", this.convertEvents(eventParamName, generationLanguage, callbackModel.getEvents()));
        FileTemplate fileTemplate = templateManager.getJ2eeTemplate(this.getFlywayCallbackTemplate(generationLanguage));
        Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"getJ2eeTemplate(...)");
        FileTemplate template = fileTemplate;
        try {
            PsiElement psiElement = FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)callbackModel.getClassName(), (Properties)props, (PsiDirectory)targetDirectory);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"createFromTemplate(...)");
            PsiElement element = psiElement;
            psiFile = element.getContainingFile();
        }
        catch (Exception e) {
            new ExceptionEvent((Object)("Exception while trying to create Flyway java callback: '" + callbackModel.getClassName() + "'"), (Throwable)e).post(project2);
            psiFile = null;
        }
        return psiFile;
    }

    private final String getFlywayCallbackTemplate(SourceLanguage generationLanguage) {
        return generationLanguage == SourceLanguage.KOTLIN ? "com.intellij.jpb.FlywayCallback.kt" : "com.intellij.jpb.FlywayCallback.java";
    }

    private final String getFlywayJavaMigrationTemplate(SourceLanguage generationLanguage) {
        return generationLanguage == SourceLanguage.KOTLIN ? "com.intellij.jpb.FlywayMigration.kt" : "com.intellij.jpb.FlywayMigration.java";
    }

    private final String convertEvents(String eventParamName, SourceLanguage generationLanguage, List<? extends FlywayCallbackEvent> events) {
        return CollectionsKt.joinToString$default((Iterable)events, (CharSequence)" || ", null, null, (int)0, null, arg_0 -> FlywayJavaCreator.convertEvents$lambda$0(generationLanguage, eventParamName, arg_0), (int)30, null);
    }

    private static final CharSequence convertEvents$lambda$0(SourceLanguage $generationLanguage, String $eventParamName, FlywayCallbackEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return $generationLanguage == SourceLanguage.KOTLIN ? (CharSequence)($eventParamName + " == Event." + it.name()) : (CharSequence)($eventParamName + ".equals(Event." + it.name() + ")");
    }
}

