/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.logging.resolve;

import com.intellij.analysis.logging.resolve.LoggingArgumentSymbolReference;
import com.intellij.codeInspection.logging.LoggingPlaceholderUtilKt;
import com.intellij.codeInspection.logging.LoggingStringPartEvaluator;
import com.intellij.codeInspection.logging.PlaceholderContext;
import com.intellij.codeInspection.logging.PlaceholderCountResult;
import com.intellij.codeInspection.logging.PlaceholderEscapeSymbolStrategy;
import com.intellij.codeInspection.logging.PlaceholderLoggerType;
import com.intellij.codeInspection.logging.PlaceholderRanges;
import com.intellij.codeInspection.logging.PlaceholdersStatus;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u001a\u0016\u0010\u0000\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a,\u0010\u0007\u001a\n\u0012\u0004\u0012\u0002H\b\u0018\u00010\u0001\"\u0004\b\u0000\u0010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\u00012\u0006\u0010\n\u001a\u00020\u0006H\u0000\u001a\u0018\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\u0006H\u0000\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0002\u001a\u0018\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"getLogArgumentReferences", "", "Lcom/intellij/model/psi/PsiSymbolReference;", "uExpression", "Lorg/jetbrains/uast/UExpression;", "getContext", "Lcom/intellij/codeInspection/logging/PlaceholderContext;", "getAdjustedPlaceholderList", "T", "placeholderList", "context", "getPlaceholderRanges", "Lcom/intellij/codeInspection/logging/PlaceholderRanges;", "isKotlinString", "", "logString", "isKotlinMultilineString", "text", "", "intellij.jvm.analysis.impl"})
@SourceDebugExtension(value={"SMAP\nLoggingArgumentSymbolReferenceProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoggingArgumentSymbolReferenceProvider.kt\ncom/intellij/analysis/logging/resolve/LoggingArgumentSymbolReferenceProviderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n*L\n1#1,121:1\n3590#2,5:122\n1586#2:127\n1661#2,3:128\n3596#2:131\n18#3:132\n*S KotlinDebug\n*F\n+ 1 LoggingArgumentSymbolReferenceProvider.kt\ncom/intellij/analysis/logging/resolve/LoggingArgumentSymbolReferenceProviderKt\n*L\n31#1:122,5\n33#1:127\n33#1:128,3\n31#1:131\n49#1:132\n*E\n"})
public final class LoggingArgumentSymbolReferenceProviderKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final List<PsiSymbolReference> getLogArgumentReferences(@NotNull UExpression uExpression) {
        void $this$zip$iv;
        Intrinsics.checkNotNullParameter((Object)uExpression, (String)"uExpression");
        PlaceholderContext placeholderContext = LoggingArgumentSymbolReferenceProviderKt.getContext(uExpression);
        if (placeholderContext == null) {
            return null;
        }
        PlaceholderContext context = placeholderContext;
        List<PlaceholderRanges> list = LoggingArgumentSymbolReferenceProviderKt.getPlaceholderRanges(context);
        if (list == null) {
            return null;
        }
        List<PlaceholderRanges> ranges = list;
        PsiElement psiElement = uExpression.getSourcePsi();
        if (psiElement == null) {
            return null;
        }
        PsiElement psiLiteralExpression = psiElement;
        Iterable iterable = ranges;
        Iterable other$iv = context.getPlaceholderParameters();
        boolean $i$f$zip = false;
        Iterator first$iv = $this$zip$iv.iterator();
        Iterator second$iv = other$iv.iterator();
        ArrayList<List> list$iv = new ArrayList<List>(Math.min(CollectionsKt.collectionSizeOrDefault((Iterable)$this$zip$iv, (int)10), CollectionsKt.collectionSizeOrDefault((Iterable)other$iv, (int)10)));
        while (first$iv.hasNext() && second$iv.hasNext()) {
            void $this$mapTo$iv$iv;
            void placeholderRanges;
            void parameter;
            UExpression uExpression2 = (UExpression)second$iv.next();
            PlaceholderRanges placeholderRanges2 = (PlaceholderRanges)first$iv.next();
            ArrayList<List> arrayList = list$iv;
            boolean bl = false;
            if (parameter.getSourcePsi() == null) {
                return null;
            }
            Iterable $this$map$iv = placeholderRanges.getRanges();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                PsiElement parameterPsi;
                void range;
                TextRange textRange = (TextRange)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                if (range == null) {
                    return null;
                }
                collection.add(new LoggingArgumentSymbolReference(psiLiteralExpression, (TextRange)range, parameterPsi));
            }
            arrayList.add((List)destination$iv$iv);
        }
        List loggerReferenceList = CollectionsKt.flatten((Iterable)list$iv);
        return LoggingArgumentSymbolReferenceProviderKt.getAdjustedPlaceholderList(loggerReferenceList, context);
    }

    @Nullable
    public static final PlaceholderContext getContext(@NotNull UExpression uExpression) {
        PlaceholderContext context;
        Intrinsics.checkNotNullParameter((Object)uExpression, (String)"uExpression");
        UElement $this$getParentOfType_u24default$iv = (UElement)uExpression;
        boolean strict$iv = true;
        boolean $i$f$getParentOfType = false;
        UCallExpression uCallExpression = (UCallExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UCallExpression.class, (boolean)strict$iv);
        if (uCallExpression == null) {
            return null;
        }
        UCallExpression uCallExpression2 = uCallExpression;
        UCallExpression uCallExpression3 = LoggingPlaceholderUtilKt.detectLoggerMethod(uCallExpression2);
        if (uCallExpression3 == null) {
            return null;
        }
        UCallExpression logMethod = uCallExpression3;
        PlaceholderContext placeholderContext = context = LoggingPlaceholderUtilKt.getPlaceholderContext$default(logMethod, LoggingPlaceholderUtilKt.getLOGGER_RESOLVE_TYPE_SEARCHERS(), null, 4, null);
        if (!Intrinsics.areEqual((Object)uExpression, (Object)(placeholderContext != null ? placeholderContext.getLogStringArgument() : null)) || context.getPartHolderList().size() != 1) {
            return null;
        }
        return context;
    }

    @Nullable
    public static final <T> List<T> getAdjustedPlaceholderList(@NotNull List<? extends T> placeholderList, @NotNull PlaceholderContext context) {
        Intrinsics.checkNotNullParameter(placeholderList, (String)"placeholderList");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int placeholderParametersSize = context.getPlaceholderParameters().size();
        return switch (WhenMappings.$EnumSwitchMapping$0[context.getLoggerType().ordinal()]) {
            case 1 -> CollectionsKt.take((Iterable)placeholderList, (int)(context.getLastArgumentIsException() ? placeholderParametersSize - 1 : placeholderParametersSize));
            case 2, 3 -> {
                if (context.getLastArgumentIsException() && placeholderParametersSize == 1) {
                    yield CollectionsKt.emptyList();
                }
                yield placeholderList;
            }
            case 4, 5 -> placeholderList;
            default -> null;
        };
    }

    @Nullable
    public static final List<PlaceholderRanges> getPlaceholderRanges(@NotNull PlaceholderContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getLogStringArgument().getSourcePsi();
        if (object == null || (object = object.getText()) == null) {
            return null;
        }
        Object logStringText = object;
        PlaceholderEscapeSymbolStrategy type = LoggingArgumentSymbolReferenceProviderKt.isKotlinMultilineString(context.getLogStringArgument(), (String)logStringText) ? PlaceholderEscapeSymbolStrategy.KOTLIN_RAW_MULTILINE_STRING : PlaceholderEscapeSymbolStrategy.RAW_STRING;
        List partHolders = CollectionsKt.listOf((Object)new LoggingStringPartEvaluator.PartHolder((String)logStringText, true, null, 4, null));
        PlaceholderCountResult placeholderCountResult = LoggingPlaceholderUtilKt.solvePlaceholderCount(context.getLoggerType(), context.getPlaceholderParameters().size(), partHolders, type);
        if (placeholderCountResult.getStatus() != PlaceholdersStatus.EXACTLY) {
            return null;
        }
        return placeholderCountResult.getPlaceholderRangesList();
    }

    private static final boolean isKotlinString(UExpression logString) {
        return logString instanceof UPolyadicExpression;
    }

    private static final boolean isKotlinMultilineString(UExpression logString, String text) {
        return LoggingArgumentSymbolReferenceProviderKt.isKotlinString(logString) && StringsKt.startsWith$default((String)text, (String)"\"\"\"", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)text, (String)"\"\"\"", (boolean)false, (int)2, null) && text.length() >= 6;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PlaceholderLoggerType.values().length];
            try {
                nArray[PlaceholderLoggerType.SLF4J.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlaceholderLoggerType.LOG4J_OLD_STYLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlaceholderLoggerType.LOG4J_FORMATTED_STYLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlaceholderLoggerType.SLF4J_EQUAL_PLACEHOLDERS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PlaceholderLoggerType.LOG4J_EQUAL_PLACEHOLDERS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

