/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.test;

import com.intellij.analysis.JvmAnalysisBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.InconvertibleTypesChecker;
import com.siyeh.ig.psiutils.StreamApiUtil;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.testFrameworks.UAssertHint;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UastErrorType;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u0000 &2\u00020\u0001:\u0001&B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\tH\u0002J \u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J8\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0015H\u0002J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\tH\u0002J\u001a\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00152\b\u0010\u001d\u001a\u0004\u0018\u00010\u0015H\u0002J%\u0010\u001e\u001a\u00070\u001f\u00a2\u0006\u0002\b 2\u0006\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u0015H\u0002J\u0010\u0010$\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u001fH\u0002J\u0010\u0010%\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u001fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/codeInspection/test/AssertEqualsBetweenInconvertibleTypesVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastNonRecursiveVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;)V", "visitCallExpression", "", "node", "Lorg/jetbrains/uast/UCallExpression;", "processAssertHint", "", "assertHint", "Lcom/siyeh/ig/testFrameworks/UAssertHint;", "expression", "checkConvertibleTypes", "firstArgument", "Lorg/jetbrains/uast/UExpression;", "secondArgument", "checkMismatch", "firstType", "Lcom/intellij/psi/PsiType;", "secondType", "originalSourceType", "originalCheckType", "processAssertJ", "call", "normalizeType", "sourceType", "receiverType", "buildErrorString", "", "Lorg/jetbrains/annotations/Nls;", "methodName", "left", "right", "isAssertNotEqualsMethod", "isAssertNotSameMethod", "Companion", "intellij.jvm.analysis.impl"})
@SourceDebugExtension(value={"SMAP\nAssertBetweenInconvertibleTypesInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AssertBetweenInconvertibleTypesInspection.kt\ncom/intellij/codeInspection/test/AssertEqualsBetweenInconvertibleTypesVisitor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,190:1\n13225#2,2:191\n3279#2,11:193\n*S KotlinDebug\n*F\n+ 1 AssertBetweenInconvertibleTypesInspection.kt\ncom/intellij/codeInspection/test/AssertEqualsBetweenInconvertibleTypesVisitor\n*L\n112#1:191,2\n114#1:193,11\n*E\n"})
final class AssertEqualsBetweenInconvertibleTypesVisitor
extends AbstractUastNonRecursiveVisitor {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ProblemsHolder holder;
    @NotNull
    private static final String ASSERTJ_ASSERT = "org.assertj.core.api.Assert";
    @NotNull
    private static final CallMatcher ASSERTJ_IS_EQUALS_MATCHER;
    @NotNull
    private static final CallMatcher ASSERTJ_ASSERT_THAT_MATCHER;

    public AssertEqualsBetweenInconvertibleTypesVisitor(@NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.holder = holder;
    }

    public boolean visitCallExpression(@NotNull UCallExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.processAssertHint(UAssertHint.Companion.createAssertEqualsHint(node), node);
        this.processAssertHint(UAssertHint.Companion.createAssertNotEqualsHint(node), node);
        this.processAssertHint(UAssertHint.Companion.createAssertSameHint(node), node);
        this.processAssertHint(UAssertHint.Companion.createAssertNotSameHint(node), node);
        this.processAssertJ(node);
        return true;
    }

    private final void processAssertHint(UAssertHint assertHint, UCallExpression expression) {
        if (assertHint == null) {
            return;
        }
        UExpression firstArgument = assertHint.getFirstArgument();
        UExpression secondArgument = assertHint.getSecondArgument();
        PsiParameter firstParameter = UastUtils.getParameterForArgument((UCallExpression)expression, (UExpression)firstArgument);
        if (firstParameter == null || !TypeUtils.isJavaLangObject((PsiType)firstParameter.getType())) {
            return;
        }
        PsiParameter secondParameter = UastUtils.getParameterForArgument((UCallExpression)expression, (UExpression)secondArgument);
        if (secondParameter == null || !TypeUtils.isJavaLangObject((PsiType)secondParameter.getType())) {
            return;
        }
        this.checkConvertibleTypes(expression, firstArgument, secondArgument);
    }

    private final void checkConvertibleTypes(UCallExpression expression, UExpression firstArgument, UExpression secondArgument) {
        if (UastLiteralUtils.isNullLiteral((UElement)((UElement)firstArgument)) || UastLiteralUtils.isNullLiteral((UElement)((UElement)secondArgument))) {
            return;
        }
        PsiType psiType = firstArgument.getExpressionType();
        if (psiType == null) {
            return;
        }
        PsiType type1 = psiType;
        PsiType psiType2 = secondArgument.getExpressionType();
        if (psiType2 == null) {
            return;
        }
        PsiType type2 = psiType2;
        boolean isKotlin = Intrinsics.areEqual((Object)expression.getLang(), (Object)Language.findLanguageByID((String)"kotlin"));
        if (isKotlin && (type1.equalsToText("java.lang.Void") || type2.equalsToText("java.lang.Void"))) {
            return;
        }
        AssertEqualsBetweenInconvertibleTypesVisitor.checkMismatch$default(this, expression, type1, type2, null, null, 24, null);
    }

    private final void checkMismatch(UCallExpression expression, PsiType firstType, PsiType secondType, PsiType originalSourceType, PsiType originalCheckType) {
        InconvertibleTypesChecker.TypeMismatch mismatch = InconvertibleTypesChecker.checkTypes((PsiType)firstType, (PsiType)secondType, (InconvertibleTypesChecker.LookForMutualSubclass)InconvertibleTypesChecker.LookForMutualSubclass.IF_CHEAP);
        if (mismatch != null) {
            UIdentifier uIdentifier = expression.getMethodIdentifier();
            if (uIdentifier == null || (uIdentifier = uIdentifier.getSourcePsi()) == null) {
                return;
            }
            UIdentifier name = uIdentifier;
            if (mismatch.isConvertible() == InconvertibleTypesChecker.Convertible.CONVERTIBLE_MUTUAL_SUBCLASS_UNKNOWN) {
                this.holder.registerPossibleProblem((PsiElement)name);
            } else {
                PsiType psiType;
                String string = expression.getMethodName();
                if (string == null) {
                    return;
                }
                String methodName = string;
                ProblemHighlightType highlightType = this.isAssertNotEqualsMethod(methodName) ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                PsiType psiType2 = originalSourceType;
                if (psiType2 == null) {
                    PsiType psiType3 = mismatch.getLeft();
                    psiType2 = psiType3;
                    Intrinsics.checkNotNullExpressionValue((Object)psiType3, (String)"getLeft(...)");
                }
                if ((psiType = originalCheckType) == null) {
                    PsiType psiType4 = mismatch.getRight();
                    psiType = psiType4;
                    Intrinsics.checkNotNullExpressionValue((Object)psiType4, (String)"getRight(...)");
                }
                String errorString = this.buildErrorString(methodName, psiType2, psiType);
                this.holder.registerProblem((PsiElement)name, errorString, highlightType, new LocalQuickFix[0]);
            }
        }
    }

    static /* synthetic */ void checkMismatch$default(AssertEqualsBetweenInconvertibleTypesVisitor assertEqualsBetweenInconvertibleTypesVisitor, UCallExpression uCallExpression, PsiType psiType, PsiType psiType2, PsiType psiType3, PsiType psiType4, int n, Object object) {
        if ((n & 8) != 0) {
            psiType3 = null;
        }
        if ((n & 0x10) != 0) {
            psiType4 = null;
        }
        assertEqualsBetweenInconvertibleTypesVisitor.checkMismatch(uCallExpression, psiType, psiType2, psiType3, psiType4);
    }

    private final void processAssertJ(UCallExpression call) {
        PsiClass sourceClass;
        PsiType streamElementType;
        UCallExpression isEqualsCall;
        Object object;
        Object var4_11;
        block14: {
            Object v0;
            List expressions;
            if (!ASSERTJ_ASSERT_THAT_MATCHER.uCallMatches(call)) {
                return;
            }
            List list = expressions = UastUtils.getQualifiedChain((UExpression)((UExpression)UastUtils.getOutermostQualified((UExpression)((UExpression)call))));
            ListIterator listIterator = list.listIterator(list.size());
            while (listIterator.hasPrevious()) {
                Object e = listIterator.previous();
                UExpression it = (UExpression)e;
                boolean bl = false;
                if (!(it instanceof UCallExpression && ASSERTJ_IS_EQUALS_MATCHER.uCallMatches((UCallExpression)it))) continue;
                v0 = e;
                break block14;
            }
            v0 = var4_11 = null;
        }
        if ((object = (isEqualsCall = var4_11 instanceof UCallExpression ? (UCallExpression)var4_11 : null)) == null || (object = object.getValueArguments()) == null || (object = (UExpression)CollectionsKt.firstOrNull((List)object)) == null || (object = object.getExpressionType()) == null) {
            return;
        }
        Object checkType = object;
        if (checkType instanceof UastErrorType) {
            return;
        }
        PsiType receiverType = GenericsUtil.getVariableTypeByExpressionType((PsiType)isEqualsCall.getReceiverType());
        PsiType psiType = GenericsUtil.getVariableTypeByExpressionType((PsiType)PsiUtil.substituteTypeParameter((PsiType)receiverType, (String)ASSERTJ_ASSERT, (int)1, (boolean)false));
        if (psiType == null) {
            return;
        }
        PsiType sourceType = psiType;
        if ((sourceType = this.normalizeType(sourceType, receiverType)) instanceof PsiClassType) {
            boolean bl;
            PsiAnnotation[] sourceClass2;
            PsiAnnotation[] psiAnnotationArray = sourceClass2 = ((PsiClassType)sourceType).resolve();
            if (sourceClass2 != null && (psiAnnotationArray = psiAnnotationArray.getAnnotations()) != null) {
                boolean bl2;
                block15: {
                    PsiAnnotation[] $this$any$iv = psiAnnotationArray;
                    boolean $i$f$any = false;
                    int n = $this$any$iv.length;
                    for (int i = 0; i < n; ++i) {
                        PsiAnnotation element$iv;
                        PsiAnnotation it = element$iv = $this$any$iv[i];
                        boolean bl3 = false;
                        if (!it.hasQualifiedName("kotlin.jvm.JvmInline")) continue;
                        bl2 = true;
                        break block15;
                    }
                    bl2 = false;
                }
                bl = bl2;
            } else {
                bl = false;
            }
            if (bl) {
                PsiField psiField;
                Object object2;
                block16: {
                    PsiField[] psiFieldArray = sourceClass2.getFields();
                    Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray, (String)"getFields(...)");
                    Object[] $this$singleOrNull$iv = psiFieldArray;
                    boolean $i$f$singleOrNull = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (Object element$iv : $this$singleOrNull$iv) {
                        PsiField it = (PsiField)element$iv;
                        boolean bl4 = false;
                        if (!(!it.hasModifierProperty("static"))) continue;
                        if (found$iv) {
                            object2 = null;
                            break block16;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    object2 = !found$iv ? null : single$iv;
                }
                if ((psiField = (PsiField)object2) == null || (psiField = psiField.getType()) == null) {
                    psiField = sourceType = sourceType;
                }
            }
        }
        if ((streamElementType = StreamApiUtil.getStreamElementType((PsiType)checkType)) != null && sourceType instanceof PsiClassType && (sourceClass = ((PsiClassType)sourceType).resolve()) != null && Intrinsics.areEqual((Object)sourceClass.getQualifiedName(), (Object)"java.util.List")) {
            PsiType single$iv = streamElementType;
            PsiPrimitiveType psiPrimitiveType = single$iv instanceof PsiPrimitiveType ? (PsiPrimitiveType)single$iv : null;
            PsiType boxedElementType = psiPrimitiveType != null && (psiPrimitiveType = psiPrimitiveType.getBoxedType((PsiElement)sourceClass)) != null ? (PsiType)psiPrimitiveType : streamElementType;
            Object originalCheckType = checkType;
            PsiClassType psiClassType = JavaPsiFacade.getElementFactory((Project)sourceClass.getProject()).createType(sourceClass, boxedElementType);
            Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"createType(...)");
            checkType = (PsiType)psiClassType;
            UExpression uExpression = (UExpression)CollectionsKt.firstOrNull((List)call.getValueArguments());
            PsiType originalStreamSourceType = uExpression != null ? uExpression.getExpressionType() : null;
            this.checkMismatch(isEqualsCall, sourceType, (PsiType)checkType, originalStreamSourceType, (PsiType)originalCheckType);
            return;
        }
        UExpression uExpression = (UExpression)CollectionsKt.firstOrNull((List)call.getValueArguments());
        PsiType originalStreamSourceType = uExpression != null ? uExpression.getExpressionType() : null;
        boolean sourceTypeWasStream = StreamApiUtil.getStreamElementType((PsiType)originalStreamSourceType) != null;
        PsiType originalSourceType = sourceTypeWasStream ? originalStreamSourceType : null;
        AssertEqualsBetweenInconvertibleTypesVisitor.checkMismatch$default(this, isEqualsCall, sourceType, (PsiType)checkType, originalSourceType, null, 16, null);
    }

    private final PsiType normalizeType(PsiType sourceType, PsiType receiverType) {
        PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)sourceType);
        if (unboxedType != null && InheritanceUtil.isInheritor((PsiType)receiverType, (String)("org.assertj.core.api.Abstract" + sourceType.getPresentableText() + "Assert"))) {
            return (PsiType)unboxedType;
        }
        return sourceType;
    }

    private final String buildErrorString(String methodName, PsiType left, PsiType right) {
        String string;
        String string2 = left.getPresentableText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPresentableText(...)");
        String comparedTypeText = string2;
        String string3 = right.getPresentableText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPresentableText(...)");
        String comparisonTypeText = string3;
        if (this.isAssertNotEqualsMethod(methodName)) {
            Object[] objectArray = new Object[]{comparedTypeText, comparisonTypeText};
            String string4 = JvmAnalysisBundle.message("jvm.inspections.assertnotequals.between.inconvertible.types.problem.descriptor", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
            return string4;
        }
        if (this.isAssertNotSameMethod(methodName)) {
            Object[] objectArray = new Object[]{comparedTypeText, comparisonTypeText};
            String string5 = JvmAnalysisBundle.message("jvm.inspections.assertnotsame.between.inconvertible.types.problem.descriptor", objectArray);
            Intrinsics.checkNotNull((Object)string5);
            string = string5;
        } else {
            Object[] objectArray = new Object[]{StringUtil.escapeXmlEntities((String)comparedTypeText), StringUtil.escapeXmlEntities((String)comparisonTypeText)};
            String string6 = JvmAnalysisBundle.message("jvm.inspections.assertequals.between.inconvertible.types.problem.descriptor", objectArray);
            string = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
        }
        return string;
    }

    private final boolean isAssertNotEqualsMethod(String methodName) {
        return Intrinsics.areEqual((Object)"assertNotEquals", (Object)methodName) || Intrinsics.areEqual((Object)"isNotEqualTo", (Object)methodName);
    }

    private final boolean isAssertNotSameMethod(String methodName) {
        return Intrinsics.areEqual((Object)"assertNotSame", (Object)methodName) || Intrinsics.areEqual((Object)"isNotSameAs", (Object)methodName);
    }

    static {
        String[] stringArray = new String[]{"isEqualTo", "isSameAs", "isNotEqualTo", "isNotSameAs"};
        CallMatcher.Simple simple = CallMatcher.instanceCall((String)ASSERTJ_ASSERT, (String[])stringArray);
        stringArray = new String[]{"java.lang.Object"};
        CallMatcher.Simple simple2 = simple.parameterTypes(stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)simple2, (String)"parameterTypes(...)");
        ASSERTJ_IS_EQUALS_MATCHER = (CallMatcher)simple2;
        stringArray = new String[]{"assertThat"};
        CallMatcher.Simple simple3 = CallMatcher.staticCall((String)"org.assertj.core.api.Assertions", (String[])stringArray).parameterCount(1);
        Intrinsics.checkNotNullExpressionValue((Object)simple3, (String)"parameterCount(...)");
        ASSERTJ_ASSERT_THAT_MATCHER = (CallMatcher)simple3;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/codeInspection/test/AssertEqualsBetweenInconvertibleTypesVisitor$Companion;", "", "<init>", "()V", "ASSERTJ_ASSERT", "", "ASSERTJ_IS_EQUALS_MATCHER", "Lcom/siyeh/ig/callMatcher/CallMatcher;", "ASSERTJ_ASSERT_THAT_MATCHER", "intellij.jvm.analysis.impl"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

