/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.dependency.BackDependencyIndex;
import org.jetbrains.jps.dependency.Node;
import org.jetbrains.jps.dependency.NodeSource;
import org.jetbrains.jps.dependency.ReferenceID;
import org.jetbrains.jps.util.Iterators;

public interface Graph {
    public Iterable<BackDependencyIndex> getIndices();

    @Nullable
    public BackDependencyIndex getIndex(String var1);

    @NotNull
    public Iterable<ReferenceID> getDependingNodes(@NotNull ReferenceID var1);

    public Iterable<NodeSource> getSources(@NotNull ReferenceID var1);

    public Iterable<ReferenceID> getRegisteredNodes();

    public Iterable<NodeSource> getSources();

    public Iterable<Node<?, ?>> getNodes(@NotNull NodeSource var1);

    default public <T extends Node<T, ?>> Iterable<T> getNodes(NodeSource src, Class<T> nodeSelector) {
        return Graph.getNodesOfType(this.getNodes(src), nodeSelector);
    }

    public static <T extends Node<T, ?>> Iterable<T> getNodesOfType(Iterable<? extends Node<?, ?>> nodes, Class<T> nodeSelector) {
        return Iterators.filter((Iterable)Iterators.map(nodes, n -> nodeSelector.isInstance(n) ? (Node)nodeSelector.cast(n) : null), Objects::nonNull);
    }
}

