/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.impl;

import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.dependency.DifferentiateParameters;
import org.jetbrains.jps.dependency.LogConsumer;
import org.jetbrains.jps.dependency.NodeSource;

public final class DifferentiateParametersBuilder
implements DifferentiateParameters {
    private final String mySessionName;
    private boolean calculateAffected = true;
    private boolean processConstantsIncrementally = true;
    private boolean compiledWithErrors = false;
    private Predicate<? super NodeSource> myAffectionFilter = __ -> true;
    private Predicate<? super NodeSource> myScopeFilter = __ -> true;
    private Predicate<? super NodeSource> myCurrentChunkFilter = __ -> true;
    private LogConsumer myLogConsumer = LogConsumer.EMPTY;

    private DifferentiateParametersBuilder(String sessionName) {
        this.mySessionName = sessionName;
    }

    @Override
    public String getSessionName() {
        return this.mySessionName;
    }

    @Override
    public boolean isCalculateAffected() {
        return this.calculateAffected;
    }

    @Override
    public boolean isProcessConstantsIncrementally() {
        return this.processConstantsIncrementally;
    }

    @Override
    public boolean isCompiledWithErrors() {
        return this.compiledWithErrors;
    }

    @Override
    @NotNull
    public Predicate<? super NodeSource> scopeFilter() {
        Predicate<? super NodeSource> predicate = this.myScopeFilter;
        if (predicate == null) {
            DifferentiateParametersBuilder.$$$reportNull$$$0(0);
        }
        return predicate;
    }

    @Override
    @NotNull
    public Predicate<? super NodeSource> affectionFilter() {
        Predicate<? super NodeSource> predicate = this.myAffectionFilter;
        if (predicate == null) {
            DifferentiateParametersBuilder.$$$reportNull$$$0(1);
        }
        return predicate;
    }

    @Override
    @NotNull
    public Predicate<? super NodeSource> belongsToCurrentCompilationChunk() {
        Predicate<? super NodeSource> predicate = this.myCurrentChunkFilter;
        if (predicate == null) {
            DifferentiateParametersBuilder.$$$reportNull$$$0(2);
        }
        return predicate;
    }

    @Override
    @NotNull
    public LogConsumer logConsumer() {
        LogConsumer logConsumer = this.myLogConsumer;
        if (logConsumer == null) {
            DifferentiateParametersBuilder.$$$reportNull$$$0(3);
        }
        return logConsumer;
    }

    public DifferentiateParameters get() {
        return this;
    }

    public static DifferentiateParametersBuilder create() {
        return DifferentiateParametersBuilder.create("");
    }

    public static DifferentiateParametersBuilder create(String sessionName) {
        return new DifferentiateParametersBuilder(sessionName);
    }

    public static DifferentiateParametersBuilder create(DifferentiateParameters params) {
        return new DifferentiateParametersBuilder(params.getSessionName()).compiledWithErrors(params.isCompiledWithErrors()).processConstantsIncrementally(params.isProcessConstantsIncrementally()).calculateAffected(params.isCalculateAffected()).withScopeFilter(params.scopeFilter()).withAffectionFilter(params.affectionFilter()).withChunkStructureFilter(params.belongsToCurrentCompilationChunk()).withLogConsumer(params.logConsumer());
    }

    public static DifferentiateParameters withDefaultSettings() {
        return DifferentiateParametersBuilder.withDefaultSettings("");
    }

    public static DifferentiateParameters withDefaultSettings(String sessionName) {
        return DifferentiateParametersBuilder.create(sessionName).get();
    }

    public DifferentiateParametersBuilder calculateAffected(boolean value) {
        this.calculateAffected = value;
        return this;
    }

    public DifferentiateParametersBuilder processConstantsIncrementally(boolean value) {
        this.processConstantsIncrementally = value;
        return this;
    }

    public DifferentiateParametersBuilder compiledWithErrors(boolean value) {
        this.compiledWithErrors = value;
        return this;
    }

    public DifferentiateParametersBuilder withScopeFilter(Predicate<? super NodeSource> filter) {
        this.myScopeFilter = filter;
        return this;
    }

    public DifferentiateParametersBuilder withAffectionFilter(Predicate<? super NodeSource> filter) {
        this.myAffectionFilter = filter;
        return this;
    }

    public DifferentiateParametersBuilder withChunkStructureFilter(Predicate<? super NodeSource> filter) {
        this.myCurrentChunkFilter = filter;
        return this;
    }

    public DifferentiateParametersBuilder withLogConsumer(LogConsumer logConsumer) {
        this.myLogConsumer = logConsumer;
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/jps/dependency/impl/DifferentiateParametersBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "scopeFilter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "affectionFilter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "belongsToCurrentCompilationChunk";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "logConsumer";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

