/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.ColoredText;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SimpleColoredText
implements ColoredTextContainer {
    private final ArrayList<@Nls String> myTexts;
    private final ArrayList<SimpleTextAttributes> myAttributes;
    @NlsSafe
    private String myCachedToString;

    public SimpleColoredText() {
        this.myCachedToString = null;
        this.myTexts = new ArrayList(3);
        this.myAttributes = new ArrayList(3);
    }

    public SimpleColoredText(@NlsContexts.Label @NotNull String fragment, @NotNull SimpleTextAttributes attributes) {
        if (fragment == null) {
            SimpleColoredText.$$$reportNull$$$0(0);
        }
        if (attributes == null) {
            SimpleColoredText.$$$reportNull$$$0(1);
        }
        this();
        this.append(fragment, attributes);
    }

    @Override
    public void append(@NotNull @Nls String fragment, @NotNull SimpleTextAttributes attributes) {
        if (fragment == null) {
            SimpleColoredText.$$$reportNull$$$0(2);
        }
        if (attributes == null) {
            SimpleColoredText.$$$reportNull$$$0(3);
        }
        this.myTexts.add(fragment);
        this.myCachedToString = null;
        this.myAttributes.add(attributes);
    }

    public void insert(int index, @NotNull @Nls String fragment, @NotNull SimpleTextAttributes attributes) {
        if (fragment == null) {
            SimpleColoredText.$$$reportNull$$$0(4);
        }
        if (attributes == null) {
            SimpleColoredText.$$$reportNull$$$0(5);
        }
        this.myTexts.add(index, fragment);
        this.myCachedToString = null;
        this.myAttributes.add(index, attributes);
    }

    public void clear() {
        this.myTexts.clear();
        this.myCachedToString = null;
        this.myAttributes.clear();
    }

    public void appendToComponent(@NotNull ColoredTextContainer component2) {
        if (component2 == null) {
            SimpleColoredText.$$$reportNull$$$0(6);
        }
        int size = this.myTexts.size();
        for (int i = 0; i < size; ++i) {
            String text = this.myTexts.get(i);
            SimpleTextAttributes attribute = this.myAttributes.get(i);
            component2.append(text, attribute);
        }
    }

    @Nls
    public String toString() {
        if (this.myCachedToString == null) {
            this.myCachedToString = String.join((CharSequence)"", this.myTexts);
        }
        return this.myCachedToString;
    }

    public ArrayList<@Nls String> getTexts() {
        return this.myTexts;
    }

    public ArrayList<SimpleTextAttributes> getAttributes() {
        return this.myAttributes;
    }

    public SimpleColoredText derive(SimpleTextAttributes attributes, boolean override) {
        SimpleColoredText result = new SimpleColoredText();
        for (int i = 0; i < this.myTexts.size(); ++i) {
            SimpleTextAttributes overridden = override ? SimpleTextAttributes.merge(this.myAttributes.get(i), attributes) : SimpleTextAttributes.merge(attributes, this.myAttributes.get(i));
            result.append(this.myTexts.get(i), overridden);
        }
        return result;
    }

    @NotNull
    public ColoredText toColoredText() {
        if (this.myTexts.isEmpty()) {
            ColoredText coloredText = ColoredText.empty();
            if (coloredText == null) {
                SimpleColoredText.$$$reportNull$$$0(7);
            }
            return coloredText;
        }
        if (this.myTexts.size() == 1) {
            ColoredText coloredText = ColoredText.singleFragment(this.myTexts.get(0), this.myAttributes.get(0));
            if (coloredText == null) {
                SimpleColoredText.$$$reportNull$$$0(8);
            }
            return coloredText;
        }
        ColoredText.Builder builder = ColoredText.builder();
        for (int i = 0; i < this.myTexts.size(); ++i) {
            builder.append(this.myTexts.get(i), this.myAttributes.get(i));
        }
        ColoredText coloredText = builder.build();
        if (coloredText == null) {
            SimpleColoredText.$$$reportNull$$$0(9);
        }
        return coloredText;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/SimpleColoredText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/SimpleColoredText";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "toColoredText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "insert";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "appendToComponent";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

