/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.icons;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.DeferredIcon;
import com.intellij.ui.icons.CompositeIcon;
import java.lang.invoke.MethodHandles;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\u0018\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0002\"\u0018\u0010\u0006\u001a\u00020\u0001*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0018\u0010\t\u001a\u00020\u0001*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\"\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"deferredMask", "", "icon", "Lcom/intellij/ui/icons/CompositeIcon;", "", "initialMask", "mask", "getMask", "(J)I", "count", "getCount", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.core.ui"})
@SourceDebugExtension(value={"SMAP\nCompositeIconUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompositeIconUtil.kt\ncom/intellij/ui/icons/CompositeIconUtilKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,57:1\n57#2:58\n35#2,2:59\n*S KotlinDebug\n*F\n+ 1 CompositeIconUtil.kt\ncom/intellij/ui/icons/CompositeIconUtilKt\n*L\n56#1:58\n56#1:59,2\n*E\n"})
public final class CompositeIconUtilKt {
    @NotNull
    private static final Logger LOG;

    public static final int deferredMask(@NotNull CompositeIcon icon) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        return CompositeIconUtilKt.getMask(CompositeIconUtilKt.deferredMask(icon, 0L));
    }

    private static final long deferredMask(CompositeIcon icon, long initialMask) {
        int mask = CompositeIconUtilKt.getMask(initialMask);
        int count = CompositeIconUtilKt.getCount(initialMask);
        int n = icon.getIconCount();
        for (int i = 0; i < n; ++i) {
            Icon component2 = icon.getIcon(i);
            if (component2 instanceof CompositeIcon) {
                long componentResult = CompositeIconUtilKt.deferredMask((CompositeIcon)component2, CompositeIconUtilKt.mask(mask, count));
                int componentMask = CompositeIconUtilKt.getMask(componentResult);
                int componentCount = CompositeIconUtilKt.getCount(componentResult);
                if (count + componentCount > 32) {
                    LOG.warn("Icon has too many nested components, likely a bug in the icon structure: " + icon);
                    break;
                }
                mask |= componentMask << count;
                count += componentCount;
                continue;
            }
            if (!(component2 instanceof DeferredIcon)) continue;
            if (count + 1 > 32) {
                LOG.warn("Icon has too many components, likely a bug in the icon structure: " + icon);
                break;
            }
            if (!((DeferredIcon)((Object)component2)).isDone()) {
                mask |= 1 << count;
            }
            ++count;
        }
        return CompositeIconUtilKt.mask(mask, count);
    }

    private static final int getMask(long $this$mask) {
        return (int)$this$mask;
    }

    private static final int getCount(long $this$count) {
        return (int)($this$count >>> 32);
    }

    private static final long mask(int mask, int count) {
        return (long)count << 32 | (long)mask & 0xFFFFFFFFL;
    }

    static {
        boolean $i$f$fileLogger = false;
        boolean $i$f$currentClassLogger = false;
        Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
        Logger logger = Logger.getInstance(clazz$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

