/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.statistics;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.ShortenCommandLine;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.StatisticsUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.run.SpringBootAdditionalParameter;
import com.intellij.spring.boot.run.SpringBootApplicationConfigurationTypeBase;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class SpringBootRunFeatureUsagesCollector
extends ProjectUsagesCollector {
    private static final List<Integer> steps = Arrays.asList(1, 2, 3, 4, 5, 10, 100, 200, 500, 1000);
    private static final EventLogGroup GROUP = new EventLogGroup("spring.boot.run", 4);
    private static final EventId1<Boolean> CONFIG_ACTIVE_PROFILES_SET = GROUP.registerEvent("config.active.profiles.set", (EventField)EventFields.Enabled);
    private static final EventId1<Boolean> CONFIG_HIDE_BANNER = GROUP.registerEvent("config.hide.banner", (EventField)EventFields.Enabled);
    private static final EventId1<Boolean> CONFIG_DEBUG_MODE = GROUP.registerEvent("config.debug.mode", (EventField)EventFields.Enabled);
    private static final EventId1<Boolean> CONFIG_ENABLE_LAUNCH_OPTIMIZATION = GROUP.registerEvent("config.enable.launch.optimization", (EventField)EventFields.Enabled);
    public static final EventId1<Boolean> CONFIG_ENABLE_JMX_AGENT = GROUP.registerEvent("config.enable.jmx.agent", (EventField)EventFields.Enabled);
    private static final EventId1<Boolean> CONFIG_LOG_FILES = GROUP.registerEvent("config.log.files", (EventField)EventFields.Enabled);
    private static final EventId1<Boolean> RUN_DASHBOARD = GROUP.registerEvent("run.dashboard", (EventField)EventFields.Enabled);
    private static final EventId1<Boolean> ENDPOINTS_BEANS_DIAGRAM = GROUP.registerEvent("endpoints.beans.diagram", (EventField)EventFields.Enabled);
    private static final EventId1<Boolean> CONFIG_VM_OPTIONS = GROUP.registerEvent("config.vm.options", (EventField)EventFields.Enabled);
    private static final EventId1<Boolean> CONFIG_PROGRAM_ARGUMENTS = GROUP.registerEvent("config.program.arguments", (EventField)EventFields.Enabled);
    private static final EventId1<Boolean> CONFIG_WORKING_DIRECTORY = GROUP.registerEvent("config.working.directory", (EventField)EventFields.Enabled);
    private static final EventId1<Boolean> CONFIG_ENVIRONMENT_VARIABLES = GROUP.registerEvent("config.environment.variables", (EventField)EventFields.Enabled);
    private static final EventId1<Boolean> CONFIG_INCLUDE_PROVIDED_SCOPE = GROUP.registerEvent("config.include.provided.scope", (EventField)EventFields.Enabled);
    private static final EventId1<Boolean> CONFIG_ALTERNATIVE_JRE_PATH_ENABLED = GROUP.registerEvent("config.alternative.jre.path.enabled", (EventField)EventFields.Enabled);
    private static final EventField<String> COUNT_GROUP = new StringEventField("count_group"){

        @NotNull
        public List<String> getValidationRule() {
            List<String> list = List.of("{regexp#count}", "{enum:<1}");
            if (list == null) {
                1.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/run/statistics/SpringBootRunFeatureUsagesCollector$1", "getValidationRule"));
        }
    };
    private static final EventId2<Integer, String> SPRING_BOOT_RUN_CONFIGS = GROUP.registerEvent("spring.boot.run.configs", (EventField)EventFields.Count, COUNT_GROUP);
    public static final StringEventField UPDATE_POLICY = EventFields.String((String)"value", List.of("Nothing", "third.party", "UpdateClassesAndResources", "UpdateClassesAndTriggerFile", "UpdateResources", "UpdateTriggerFile"));
    public static final EventId1<String> CONFIG_UPDATE_ACTION_UPDATE_POLICY = GROUP.registerEvent("config.update.action.update.policy", (EventField)UPDATE_POLICY);
    public static final EventId1<String> CONFIG_FRAME_DEACTIVATION_UPDATE_POLICY = GROUP.registerEvent("config.frame.deactivation.update.policy", (EventField)UPDATE_POLICY);
    private static final EventId2<Integer, String> CONFIG_ADDITIONAL_PARAMS_TOTAL = GROUP.registerEvent("config.additional.params.total", (EventField)EventFields.Count, COUNT_GROUP);
    private static final EventId1<Long> CONFIG_ADDITIONAL_PARAMS_ENABLED = GROUP.registerEvent("config.additional.params.enabled", (EventField)EventFields.Long((String)"params"));
    private static final EventId1<Long> CONFIG_ADDITIONAL_PARAMS_DISABLED = GROUP.registerEvent("config.additional.params.disabled", (EventField)EventFields.Long((String)"params"));
    private static final EventId2<Integer, String> CONFIGS_MAIN_CLASS = GROUP.registerEvent("configs.main.class", (EventField)EventFields.Count, COUNT_GROUP);
    private static final EventId1<ShortenCommandLine> CONFIG_SHORTEN_COMMAND_LINE = GROUP.registerEvent("config.shorten.command.line", (EventField)EventFields.Enum((String)"value", ShortenCommandLine.class));

    public EventLogGroup getGroup() {
        return GROUP;
    }

    protected boolean requiresReadAccess() {
        return true;
    }

    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project) {
        if (project == null) {
            SpringBootRunFeatureUsagesCollector.$$$reportNull$$$0(0);
        }
        if (!SpringBootLibraryUtil.hasSpringBootLibrary((Project)project)) {
            Set<MetricEvent> set = Collections.emptySet();
            if (set == null) {
                SpringBootRunFeatureUsagesCollector.$$$reportNull$$$0(1);
            }
            return set;
        }
        LinkedHashSet<MetricEvent> metrics = new LinkedHashSet<MetricEvent>();
        List runnerAndConfigurationSettings = RunManager.getInstance((Project)project).getConfigurationSettingsList((ConfigurationType)SpringBootApplicationConfigurationTypeBase.getInstance());
        metrics.add(SPRING_BOOT_RUN_CONFIGS.metric((Object)runnerAndConfigurationSettings.size(), (Object)StatisticsUtil.INSTANCE.getCountingStepName(runnerAndConfigurationSettings.size(), steps)));
        HashMap<String, Integer> mainClassCounter = new HashMap<String, Integer>();
        for (RunnerAndConfigurationSettings settings : runnerAndConfigurationSettings) {
            ProgressManager.checkCanceled();
            RunConfiguration configuration = settings.getConfiguration();
            if (!(configuration instanceof SpringBootApplicationRunConfiguration)) continue;
            SpringBootApplicationRunConfiguration sbRunConfig = (SpringBootApplicationRunConfiguration)configuration;
            mainClassCounter.merge(sbRunConfig.getSpringBootMainClass(), 1, (integer, integer2) -> integer + 1);
            metrics.add(CONFIG_ACTIVE_PROFILES_SET.metric((Object)StringUtil.isNotEmpty((String)sbRunConfig.getActiveProfiles())));
            metrics.add(CONFIG_HIDE_BANNER.metric((Object)sbRunConfig.isHideBanner()));
            metrics.add(CONFIG_DEBUG_MODE.metric((Object)sbRunConfig.isDebugMode()));
            metrics.add(CONFIG_ENABLE_LAUNCH_OPTIMIZATION.metric((Object)sbRunConfig.isEnableLaunchOptimization()));
            sbRunConfig.getExtender().reportStatistic(metrics);
            List parameters = sbRunConfig.getAdditionalParameters();
            int additionalParamsSize = parameters.size();
            metrics.add(CONFIG_ADDITIONAL_PARAMS_TOTAL.metric((Object)additionalParamsSize, (Object)StatisticsUtil.INSTANCE.getCountingStepName(additionalParamsSize, steps)));
            if (additionalParamsSize > 0) {
                long enabledParams = parameters.stream().filter(SpringBootAdditionalParameter::getEnabled).count();
                long disabledParams = (long)parameters.size() - enabledParams;
                metrics.add(CONFIG_ADDITIONAL_PARAMS_ENABLED.metric((Object)enabledParams));
                metrics.add(CONFIG_ADDITIONAL_PARAMS_DISABLED.metric((Object)disabledParams));
            }
            SpringBootRunFeatureUsagesCollector.addConfigEnvironmentMetrics(metrics, sbRunConfig);
            metrics.add(CONFIG_LOG_FILES.metric((Object)(!sbRunConfig.getLogFiles().isEmpty() ? 1 : 0)));
        }
        boolean showRunDashboard = RunDashboardManager.getInstance((Project)project).getTypes().contains(SpringBootApplicationConfigurationTypeBase.getInstance().getId());
        metrics.add(RUN_DASHBOARD.metric((Object)showRunDashboard));
        for (Integer integer3 : mainClassCounter.values()) {
            metrics.add(CONFIGS_MAIN_CLASS.metric((Object)integer3, (Object)StatisticsUtil.INSTANCE.getCountingStepName(integer3.intValue(), steps)));
        }
        LinkedHashSet<MetricEvent> linkedHashSet = metrics;
        if (linkedHashSet == null) {
            SpringBootRunFeatureUsagesCollector.$$$reportNull$$$0(2);
        }
        return linkedHashSet;
    }

    private static void addConfigEnvironmentMetrics(Set<MetricEvent> metrics, SpringBootApplicationRunConfiguration sbRunConfig) {
        metrics.add(CONFIG_VM_OPTIONS.metric((Object)StringUtil.isNotEmpty((String)sbRunConfig.getVMParameters())));
        metrics.add(CONFIG_PROGRAM_ARGUMENTS.metric((Object)StringUtil.isNotEmpty((String)sbRunConfig.getProgramParameters())));
        metrics.add(CONFIG_WORKING_DIRECTORY.metric((Object)StringUtil.isNotEmpty((String)sbRunConfig.getWorkingDirectory())));
        metrics.add(CONFIG_ENVIRONMENT_VARIABLES.metric((Object)(!sbRunConfig.getEnvs().isEmpty() ? 1 : 0)));
        metrics.add(CONFIG_INCLUDE_PROVIDED_SCOPE.metric((Object)sbRunConfig.isProvidedScopeIncluded()));
        metrics.add(CONFIG_ALTERNATIVE_JRE_PATH_ENABLED.metric((Object)sbRunConfig.isAlternativeJrePathEnabled()));
        ShortenCommandLine shortenCommandLine = sbRunConfig.getShortenCommandLine();
        if (shortenCommandLine == null) {
            shortenCommandLine = ShortenCommandLine.NONE;
        }
        metrics.add(CONFIG_SHORTEN_COMMAND_LINE.metric((Object)shortenCommandLine));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/run/statistics/SpringBootRunFeatureUsagesCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/run/statistics/SpringBootRunFeatureUsagesCollector";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

