/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.Platform;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.UnixSignal;
import com.intellij.ide.IdeCoreBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.util.system.OS;
import org.jetbrains.annotations.NotNull;

public final class ProcessTerminatedListener
extends ProcessAdapter {
    private static final String EXIT_CODE_ENTRY = "$EXIT_CODE$";
    private static final String EXIT_CODE_REGEX = "\\$EXIT_CODE\\$";
    private static final Key<ProcessTerminatedListener> KEY = new Key("processTerminatedListener");
    private final String myProcessFinishedMessage;
    private final Project myProject;

    private ProcessTerminatedListener(Project project, String processFinishedMessage) {
        this.myProject = project;
        this.myProcessFinishedMessage = processFinishedMessage;
    }

    public static void attach(ProcessHandler processHandler, Project project, String message) {
        ProcessTerminatedListener previousListener = (ProcessTerminatedListener)((Object)processHandler.getUserData(KEY));
        if (previousListener != null) {
            processHandler.removeProcessListener((ProcessListener)previousListener);
            if (project == null) {
                project = previousListener.myProject;
            }
        }
        ProcessTerminatedListener listener = new ProcessTerminatedListener(project, message);
        processHandler.addProcessListener((ProcessListener)listener);
        processHandler.putUserData(KEY, (Object)listener);
    }

    public static void attach(ProcessHandler processHandler, Project project) {
        String message = IdeCoreBundle.message("finished.with.exit.code.text.message", EXIT_CODE_ENTRY);
        ProcessTerminatedListener.attach(processHandler, project, "\n" + message + "\n");
    }

    public static void attach(ProcessHandler processHandler) {
        ProcessTerminatedListener.attach(processHandler, null);
    }

    public void processTerminated(@NotNull ProcessEvent event) {
        if (event == null) {
            ProcessTerminatedListener.$$$reportNull$$$0(0);
        }
        ProcessHandler processHandler = event.getProcessHandler();
        processHandler.removeProcessListener((ProcessListener)this);
        @NlsSafe String message = this.myProcessFinishedMessage.replaceAll(EXIT_CODE_REGEX, ProcessTerminatedListener.stringifyExitCode(event.getExitCode()));
        processHandler.notifyTextAvailable(message, ProcessOutputTypes.SYSTEM);
        if (this.myProject != null) {
            ApplicationManager.getApplication().invokeLater(() -> StatusBar.Info.set(message, this.myProject), this.myProject.getDisposed());
        }
    }

    @NotNull
    public static String stringifyExitCode(int exitCode) {
        return ProcessTerminatedListener.stringifyExitCode(OS.CURRENT, exitCode);
    }

    @NotNull
    public static String stringifyExitCode(@NotNull OS os, int exitCode) {
        boolean isDarwin;
        UnixSignal signal;
        if (os == null) {
            ProcessTerminatedListener.$$$reportNull$$$0(1);
        }
        StringBuilder result = new StringBuilder();
        result.append(exitCode);
        if (os.getPlatform() == Platform.WINDOWS && exitCode >= -1073741824 && exitCode < -805306368) {
            result.append(" (0x").append(StringUtil.toUpperCase((String)Integer.toHexString(exitCode)));
            if (exitCode == -1073741510) {
                result.append(": interrupted by Ctrl+C");
            }
            result.append(')');
        } else if (os.getPlatform() == Platform.UNIX && (signal = UnixSignal.fromExitCode(isDarwin = os == OS.macOS, exitCode)) != null) {
            result.append(" (interrupted by signal ").append(signal.getSignalNumber(isDarwin)).append(":").append(signal.name()).append(')');
        }
        String string = result.toString();
        if (string == null) {
            ProcessTerminatedListener.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "os";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/process/ProcessTerminatedListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/process/ProcessTerminatedListener";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "stringifyExitCode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processTerminated";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "stringifyExitCode";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

