/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.GeneralLocalState;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.GeneralSettingsState;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.SimplePersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.SystemInfoRt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@State(name="GeneralLocalSettings", storages={@Storage(value="ide.general.local.xml", roamingType=RoamingType.DISABLED)})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0007\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0002R.\u0010\u000b\u001a\u00070\t\u00a2\u0006\u0002\b\n2\u000b\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0010\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR$\u0010\u0014\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\u00138F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ide/GeneralLocalSettings;", "Lcom/intellij/openapi/components/SimplePersistentStateComponent;", "Lcom/intellij/ide/GeneralLocalState;", "<init>", "()V", "noStateLoaded", "", "migrateFromGeneralSettings", "value", "", "Lorg/jetbrains/annotations/SystemDependent;", "defaultProjectDirectory", "getDefaultProjectDirectory", "()Ljava/lang/String;", "setDefaultProjectDirectory", "(Ljava/lang/String;)V", "browserPath", "getBrowserPath", "setBrowserPath", "", "useDefaultBrowser", "getUseDefaultBrowser", "()Z", "setUseDefaultBrowser", "(Z)V", "Companion", "intellij.platform.ide.core"})
public final class GeneralLocalSettings
extends SimplePersistentStateComponent<GeneralLocalState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String MIGRATED_FROM_GENERAL_SETTINGS = "migrated.non.roamable.values.from.general.settings";

    public GeneralLocalSettings() {
        super((BaseState)new GeneralLocalState());
    }

    public void noStateLoaded() {
        this.migrateFromGeneralSettings();
    }

    private final void migrateFromGeneralSettings() {
        PropertiesComponent propertyManager = PropertiesComponent.getInstance();
        if (propertyManager.getBoolean(MIGRATED_FROM_GENERAL_SETTINGS, false)) {
            return;
        }
        propertyManager.setValue(MIGRATED_FROM_GENERAL_SETTINGS, true);
        GeneralSettingsState generalSettingsState = GeneralSettings.Companion.getInstance().getState();
        String string = generalSettingsState.defaultProjectDirectory;
        if (string == null) {
            string = "";
        }
        this.setDefaultProjectDirectory(string);
        this.setUseDefaultBrowser(generalSettingsState.useDefaultBrowser);
        String string2 = generalSettingsState.browserPath;
        if (string2 == null) {
            string2 = "";
        }
        this.setBrowserPath(string2);
        generalSettingsState.defaultProjectDirectory = "";
        generalSettingsState.useDefaultBrowser = true;
        generalSettingsState.browserPath = "";
    }

    @NotNull
    public final String getDefaultProjectDirectory() {
        String string = ((GeneralLocalState)this.getState()).getDefaultProjectDirectory();
        if (string == null) {
            string = "";
        }
        return string;
    }

    public final void setDefaultProjectDirectory(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ((GeneralLocalState)this.getState()).setDefaultProjectDirectory(value);
    }

    @NotNull
    public final String getBrowserPath() {
        String string = ((GeneralLocalState)this.getState()).getBrowserPath();
        if (string == null) {
            string = GeneralLocalSettings.Companion.getDefaultAlternativeBrowserPath();
        }
        return string;
    }

    public final void setBrowserPath(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ((GeneralLocalState)this.getState()).setBrowserPath(value);
    }

    public final boolean getUseDefaultBrowser() {
        return ((GeneralLocalState)this.getState()).getUseDefaultBrowser();
    }

    public final void setUseDefaultBrowser(boolean value) {
        ((GeneralLocalState)this.getState()).setUseDefaultBrowser(value);
    }

    @JvmStatic
    @NotNull
    public static final GeneralLocalSettings getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\b\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/ide/GeneralLocalSettings$Companion;", "", "<init>", "()V", "MIGRATED_FROM_GENERAL_SETTINGS", "", "getInstance", "Lcom/intellij/ide/GeneralLocalSettings;", "getDefaultAlternativeBrowserPath", "intellij.platform.ide.core"})
    @SourceDebugExtension(value={"SMAP\nGeneralLocalSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeneralLocalSettings.kt\ncom/intellij/ide/GeneralLocalSettings$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,77:1\n30#2,2:78\n*S KotlinDebug\n*F\n+ 1 GeneralLocalSettings.kt\ncom/intellij/ide/GeneralLocalSettings$Companion\n*L\n19#1:78,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final GeneralLocalSettings getInstance() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            ComponentManager $this$service$iv = (ComponentManager)application;
            boolean $i$f$service = false;
            Class<GeneralLocalSettings> serviceClass$iv = GeneralLocalSettings.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (GeneralLocalSettings)((Object)object);
        }

        private final String getDefaultAlternativeBrowserPath() {
            return SystemInfoRt.isWindows ? "C:\\Program Files\\Internet Explorer\\IExplore.exe" : (SystemInfoRt.isMac ? "open" : (SystemInfoRt.isUnix ? "/usr/bin/firefox" : ""));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

