/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.RequiredElement;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryKeyBean;
import com.intellij.openapi.util.registry.RegistryKeyDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Property(style=Property.Style.ATTRIBUTE)
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/util/registry/RegistryKeyBean;", "", "<init>", "()V", "key", "", "description", "defaultValue", "restartRequired", "", "overrides", "Companion", "intellij.platform.ide.core"})
public final class RegistryKeyBean {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @RequiredElement
    @Attribute(value="key")
    @JvmField
    @NotNull
    public String key = "";
    @RequiredElement
    @Attribute(value="description")
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @JvmField
    @NotNull
    public String description = "";
    @RequiredElement(allowEmpty=true)
    @Attribute(value="defaultValue")
    @JvmField
    @NotNull
    public String defaultValue = "";
    @Attribute(value="restartRequired")
    @JvmField
    public boolean restartRequired;
    @Attribute(value="overrides")
    @JvmField
    public boolean overrides;
    @NonNls
    @NotNull
    private static final Regex CONSECUTIVE_SPACES_REGEX = new Regex("\\s{2,}");
    @ApiStatus.Internal
    @NotNull
    public static final String KEY_CONFLICT_LOG_CATEGORY = "com.intellij.openapi.util.registry.overrides";

    private RegistryKeyBean() {
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J,\u0010\u0010\u001a\u00020\t2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/util/registry/RegistryKeyBean$Companion;", "", "<init>", "()V", "CONSECUTIVE_SPACES_REGEX", "Lkotlin/text/Regex;", "KEY_CONFLICT_LOG_CATEGORY", "", "addKeysFromPlugins", "", "createRegistryKeyDescriptor", "Lcom/intellij/openapi/util/registry/RegistryKeyDescriptor;", "extension", "Lcom/intellij/openapi/util/registry/RegistryKeyBean;", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "putNewDescriptorConsideringOverrides", "map", "", "newDescriptor", "isDynamic", "", "intellij.platform.ide.core"})
    @SourceDebugExtension(value={"SMAP\nRegistryKeyBean.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegistryKeyBean.kt\ncom/intellij/openapi/util/registry/RegistryKeyBean$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,179:1\n1#2:180\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @ApiStatus.Internal
        public final void addKeysFromPlugins() {
            void mutator;
            ExtensionPoint extensionPoint = ApplicationManager.getApplication().getExtensionArea().getExtensionPoint("com.intellij.registryKey");
            Intrinsics.checkNotNull((Object)extensionPoint, (String)"null cannot be cast to non-null type com.intellij.openapi.extensions.impl.ExtensionPointImpl<com.intellij.openapi.util.registry.RegistryKeyBean>");
            ExtensionPointImpl point = (ExtensionPointImpl)extensionPoint;
            HashMap hashMap = new HashMap();
            Registry.Companion companion = Registry.Companion;
            boolean bl = false;
            point.processUnsortedWithPluginDescriptor((arg_0, arg_1) -> Companion.addKeysFromPlugins$lambda$0$0((HashMap)mutator, arg_0, arg_1));
            Map map = Map.copyOf((Map)mutator);
            Intrinsics.checkNotNullExpressionValue(map, (String)"let(...)");
            companion.setContributedKeys(map);
            point.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<RegistryKeyBean>(){

                public void extensionAdded(RegistryKeyBean extension, PluginDescriptor pluginDescriptor) {
                    Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
                    Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                    RegistryKeyDescriptor descriptor = RegistryKeyBean.Companion.createRegistryKeyDescriptor(extension, pluginDescriptor);
                    Registry.Companion.mutateContributedKeys(arg_0 -> addKeysFromPlugins.2.extensionAdded$lambda$0(descriptor, arg_0));
                }

                private static final Map extensionAdded$lambda$0(RegistryKeyDescriptor $descriptor, Map oldMap) {
                    Intrinsics.checkNotNullParameter((Object)oldMap, (String)"oldMap");
                    HashMap<K, V> newMap = new HashMap<K, V>(oldMap.size() + 1);
                    newMap.putAll(oldMap);
                    RegistryKeyBean.Companion.putNewDescriptorConsideringOverrides((Map<String, RegistryKeyDescriptor>)newMap, $descriptor, true);
                    Map<K, V> map = Map.copyOf((Map)newMap);
                    Intrinsics.checkNotNullExpressionValue(map, (String)"copyOf(...)");
                    return map;
                }
            }, false, null);
            ApplicationManager.getApplication().getMessageBus().connect().subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

                public void pluginUnloaded(IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                    Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                    Registry.Companion.mutateContributedKeys(arg_0 -> addKeysFromPlugins.3.pluginUnloaded$lambda$0(pluginDescriptor, arg_0));
                }

                private static final Map pluginUnloaded$lambda$0(IdeaPluginDescriptor $pluginDescriptor, Map oldMap) {
                    Intrinsics.checkNotNullParameter((Object)oldMap, (String)"oldMap");
                    HashMap<K, V> newMap = new HashMap<K, V>(oldMap.size());
                    for (Map.Entry<K, V> entry : oldMap.entrySet()) {
                        if (Intrinsics.areEqual((Object)((RegistryKeyDescriptor)entry.getValue()).getPluginId(), (Object)$pluginDescriptor.getPluginId().getIdString())) continue;
                        newMap.put(entry.getKey(), entry.getValue());
                    }
                    Map<K, V> map = Map.copyOf((Map)newMap);
                    Intrinsics.checkNotNullExpressionValue(map, (String)"copyOf(...)");
                    return map;
                }
            });
        }

        @ApiStatus.Internal
        @NotNull
        public final RegistryKeyDescriptor createRegistryKeyDescriptor(@NotNull RegistryKeyBean extension, @NotNull PluginDescriptor pluginDescriptor) {
            Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
            Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
            String pluginId = pluginDescriptor.getPluginId().getIdString();
            IdeaPluginDescriptor ideaPluginDescriptor = pluginDescriptor instanceof IdeaPluginDescriptor ? (IdeaPluginDescriptor)pluginDescriptor : null;
            String descriptorPath = ideaPluginDescriptor != null ? ideaPluginDescriptor.getDescriptorPath() : null;
            CharSequence charSequence = extension.description;
            Regex regex = CONSECUTIVE_SPACES_REGEX;
            String string = " ";
            return new RegistryKeyDescriptor(extension.key, StringUtil.unescapeStringCharacters((String)regex.replace(charSequence, string)), extension.defaultValue, extension.restartRequired, extension.overrides, pluginId, descriptorPath);
        }

        @ApiStatus.Internal
        public final void putNewDescriptorConsideringOverrides(@NotNull Map<String, RegistryKeyDescriptor> map, @NotNull RegistryKeyDescriptor newDescriptor, boolean isDynamic) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            Intrinsics.checkNotNullParameter((Object)newDescriptor, (String)"newDescriptor");
            RegistryKeyDescriptor oldDescriptor = map.get(newDescriptor.getName());
            if (oldDescriptor == null) {
                String string = newDescriptor.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                map.put(string, newDescriptor);
                return;
            }
            Logger logger = Logger.getInstance((String)RegistryKeyBean.KEY_CONFLICT_LOG_CATEGORY);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            Logger logger2 = logger;
            Pair pair = TuplesKt.to((Object)oldDescriptor.isOverrides(), (Object)newDescriptor.isOverrides());
            if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)false, (Object)true))) {
                if (isDynamic) {
                    com.intellij.openapi.util.registry.RegistryKeyBean$Companion.putNewDescriptorConsideringOverrides$emitRegistryKeyWarning(logger2, "A dynamically-loaded plugin " + com.intellij.openapi.util.registry.RegistryKeyBean$Companion.putNewDescriptorConsideringOverrides$presentPlugin(newDescriptor) + " is forbidden to override the registry key " + newDescriptor.getName() + " introduced by " + com.intellij.openapi.util.registry.RegistryKeyBean$Companion.putNewDescriptorConsideringOverrides$presentPlugin(oldDescriptor) + ". Consider implementing the functionality in another way, e.g. declare and implement an extension to customize the required behavior dynamically.");
                } else {
                    String overrider = com.intellij.openapi.util.registry.RegistryKeyBean$Companion.putNewDescriptorConsideringOverrides$presentPlugin(newDescriptor);
                    String overridden = com.intellij.openapi.util.registry.RegistryKeyBean$Companion.putNewDescriptorConsideringOverrides$presentPlugin(oldDescriptor);
                    logger2.info("Plugin " + overrider + " overrides the registry key " + newDescriptor.getName() + " declared by plugin " + overridden + ".");
                    String string = newDescriptor.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    map.put(string, newDescriptor);
                }
            } else if (!Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)true, (Object)false))) {
                if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)false, (Object)false))) {
                    String string = newDescriptor.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    map.put(string, newDescriptor);
                    com.intellij.openapi.util.registry.RegistryKeyBean$Companion.putNewDescriptorConsideringOverrides$emitRegistryKeyWarning(logger2, "Conflicting registry key definition for key " + oldDescriptor.getName() + ": it was defined by plugin " + com.intellij.openapi.util.registry.RegistryKeyBean$Companion.putNewDescriptorConsideringOverrides$presentPlugin(oldDescriptor) + " but redefined by plugin " + com.intellij.openapi.util.registry.RegistryKeyBean$Companion.putNewDescriptorConsideringOverrides$presentPlugin(newDescriptor) + ". Consider adding overrides=\"true\" for one of the plugins, see the documentation for com.intellij.openapi.util.registry.RegistryKeyBean.overrides for more details.");
                } else if (Intrinsics.areEqual((Object)pair, (Object)TuplesKt.to((Object)true, (Object)true)) && !Intrinsics.areEqual((Object)oldDescriptor.getDefaultValue(), (Object)newDescriptor.getDefaultValue())) {
                    com.intellij.openapi.util.registry.RegistryKeyBean$Companion.putNewDescriptorConsideringOverrides$emitRegistryKeyWarning(logger2, "Incorrect registry key override for key " + oldDescriptor.getName() + ": both plugins " + com.intellij.openapi.util.registry.RegistryKeyBean$Companion.putNewDescriptorConsideringOverrides$presentPlugin(oldDescriptor) + " and " + com.intellij.openapi.util.registry.RegistryKeyBean$Companion.putNewDescriptorConsideringOverrides$presentPlugin(newDescriptor) + " claim to override it to different defaults.");
                }
            }
        }

        private static final Unit addKeysFromPlugins$lambda$0$0(HashMap $mutator, RegistryKeyBean bean, PluginDescriptor pluginDescriptor) {
            Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
            Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
            RegistryKeyDescriptor descriptor = Companion.createRegistryKeyDescriptor(bean, pluginDescriptor);
            Companion.putNewDescriptorConsideringOverrides($mutator, descriptor, false);
            return Unit.INSTANCE;
        }

        private static final void putNewDescriptorConsideringOverrides$emitRegistryKeyWarning(Logger logger, String message) {
            logger.warn(message);
        }

        private static final String putNewDescriptorConsideringOverrides$presentPlugin(RegistryKeyDescriptor descriptor) {
            StringBuilder description = new StringBuilder();
            String string = descriptor.getPluginId();
            if (string == null) {
                string = "unknown";
            }
            description.append(string);
            String string2 = descriptor.getPluginDescriptorPath();
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                description.append(" (").append(it).append(")");
            }
            String string3 = description.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            return string3;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

