/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.plugin.common.telephony;

import com.intellij.codeWithMe.ClientId;
import com.intellij.cwm.plugin.common.CodeWithMeCommonBundle;
import com.intellij.cwm.plugin.common.telephony.TelephonySession;
import com.intellij.cwm.plugin.common.telephony.TelephonySessionListener;
import com.intellij.cwm.plugin.common.users.UserManager;
import com.intellij.cwm.plugin.common.users.UserManagerKt;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionButtonUtil;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.remoteDev.util.LifetimeExKt;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.GotItComponentBuilder;
import com.intellij.ui.awt.RelativePoint;
import com.jetbrains.codeWithMe.model.RdUserModel;
import com.jetbrains.codeWithMe.model.RdUserProperties;
import com.jetbrains.codeWithMe.model.TelephonyProperties;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.Maybe;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.IMutablePropertyBase;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.IPropertyView;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rd.util.reactive.SourceExKt;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 &2\u00020\u0001:\u0001&B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0013J\b\u0010\u001b\u001a\u0004\u0018\u00010\u000bJ\u0006\u0010\u001c\u001a\u00020\u0017J\u0006\u0010\u001d\u001a\u00020\u0017J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH&J\n\u0010!\u001a\u0004\u0018\u00010\"H$J\u0012\u0010#\u001a\u0004\u0018\u00010\u000b2\u0006\u0010$\u001a\u00020%H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\"\u0010\b\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0019\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0015\u00a8\u0006'"}, d2={"Lcom/intellij/cwm/plugin/common/telephony/TelephonyManager;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "telephonySessionWithLifetime", "Lcom/jetbrains/rd/util/reactive/Property;", "Lkotlin/Pair;", "Lcom/intellij/cwm/plugin/common/telephony/TelephonySession;", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "telephonySession", "telephonySessionView", "Lcom/jetbrains/rd/util/reactive/IPropertyView;", "getTelephonySessionView", "()Lcom/jetbrains/rd/util/reactive/IPropertyView;", "joinCallOnStart", "", "getJoinCallOnStart", "()Z", "joinCall", "", "canJoinCall", "shouldShowCallInToolwindow", "getShouldShowCallInToolwindow", "getSession", "terminateSession", "adviseOnCount", "getUserCount", "Lcom/jetbrains/rd/util/reactive/IOptPropertyView;", "", "getJitsiRoomUrl", "", "createSession", "parentLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "Companion", "intellij.cwm.plugin.common"})
@SourceDebugExtension(value={"SMAP\nTelephonyManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TelephonyManager.kt\ncom/intellij/cwm/plugin/common/telephony/TelephonyManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,157:1\n1915#2,2:158\n13#3:160\n*S KotlinDebug\n*F\n+ 1 TelephonyManager.kt\ncom/intellij/cwm/plugin/common/telephony/TelephonyManager\n*L\n90#1:158,2\n26#1:160\n*E\n"})
public abstract class TelephonyManager
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Property<Pair<TelephonySession, LifetimeDefinition>> telephonySessionWithLifetime;
    @NotNull
    private final Property<TelephonySession> telephonySession;
    @NotNull
    private final IPropertyView<TelephonySession> telephonySessionView;
    @NotNull
    private static final Logger LOG;

    public TelephonyManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.telephonySessionWithLifetime = new Property(null);
        this.telephonySession = new Property(null);
        this.telephonySessionView = (IPropertyView)this.telephonySession;
        SourceExKt.flowInto((ISource)((ISource)this.telephonySessionWithLifetime), (Lifetime)this.getServiceLifetime(), (IMutablePropertyBase)((IMutablePropertyBase)this.telephonySession), TelephonyManager::_init_$lambda$0);
        InterfacesKt.viewNotNull((IViewable)((IViewable)this.telephonySessionWithLifetime), (Lifetime)this.getServiceLifetime(), (arg_0, arg_1) -> TelephonyManager._init_$lambda$1(this, arg_0, arg_1));
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    public final IPropertyView<TelephonySession> getTelephonySessionView() {
        return this.telephonySessionView;
    }

    public final boolean getJoinCallOnStart() {
        return !ExperimentalUI.Companion.isNewUI();
    }

    public final void joinCall() {
        TelephonySession telephonySession = this.getSession();
        if (telephonySession == null) {
            TelephonyManager $this$joinCall_u24lambda_u240 = this;
            boolean bl = false;
            if (!$this$joinCall_u24lambda_u240.getJoinCallOnStart()) {
                $this$joinCall_u24lambda_u240.createSession($this$joinCall_u24lambda_u240.getServiceLifetime());
            }
            return;
        }
        TelephonySession telephonySession2 = telephonySession;
        telephonySession2.joinConference(true);
    }

    public final boolean canJoinCall() {
        Property<Boolean> session = this.getSession();
        Property<Boolean> property = session;
        boolean conferenceJoined = property != null && (property = property.getConferenceJoined()) != null ? ((Boolean)property.getValue()).booleanValue() : false;
        return !conferenceJoined && (session != null || !this.getJoinCallOnStart() && this.getJitsiRoomUrl() != null);
    }

    public final boolean getShouldShowCallInToolwindow() {
        return !ExperimentalUI.Companion.isNewUI();
    }

    @Nullable
    public final TelephonySession getSession() {
        return (TelephonySession)this.telephonySession.getValue();
    }

    public final void terminateSession() {
        LifetimeDefinition sessionLt;
        Pair pair = (Pair)this.telephonySessionWithLifetime.getValue();
        Object object = sessionLt = pair != null ? (LifetimeDefinition)pair.getSecond() : null;
        if (sessionLt != null) {
            LOG.info("Terminating telephony session");
            LifetimeDefinition.terminate$default((LifetimeDefinition)sessionLt, (boolean)false, (int)1, null);
        }
    }

    public final void adviseOnCount() {
        Ref.ObjectRef ballon = new Ref.ObjectRef();
        SourceExKt.adviseWithPrev((ISource)((ISource)this.getUserCount()), (Lifetime)this.getServiceLifetime(), (arg_0, arg_1) -> TelephonyManager.adviseOnCount$lambda$0(ballon, this, arg_0, arg_1));
    }

    @NotNull
    public abstract IOptPropertyView<Integer> getUserCount();

    @Nullable
    protected abstract String getJitsiRoomUrl();

    @Nullable
    public TelephonySession createSession(@NotNull Lifetime parentLifetime) {
        TelephonySession telephonySession;
        Intrinsics.checkNotNullParameter((Object)parentLifetime, (String)"parentLifetime");
        LOG.info("Session creation requested");
        String jitsiRoomUrl = this.getJitsiRoomUrl();
        if (jitsiRoomUrl == null) {
            LOG.info("Didn't get jitsi room url, will not create session");
            return null;
        }
        try {
            LifetimeDefinition sessionLifetime = parentLifetime.createNested();
            RLifetimeKt.throwIfNotAlive((Lifetime)((Lifetime)sessionLifetime));
            TelephonySession session = new TelephonySession((Lifetime)sessionLifetime, this.project, jitsiRoomUrl);
            this.telephonySessionWithLifetime.set((Object)TuplesKt.to((Object)session, (Object)sessionLifetime));
            LOG.info("Session created");
            LifetimeExKt.onTerminationOrNow((Lifetime)((Lifetime)sessionLifetime), () -> TelephonyManager.createSession$lambda$0(this));
            telephonySession = session;
        }
        catch (Throwable e) {
            LOG.error("Failed to create session", e);
            telephonySession = null;
        }
        return telephonySession;
    }

    private static final TelephonySession _init_$lambda$0(Pair it) {
        Pair pair = it;
        return pair != null ? (TelephonySession)pair.getFirst() : null;
    }

    private static final Unit _init_$lambda$1(TelephonyManager this$0, Lifetime lt, Pair session) {
        Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        ((TelephonySessionListener)this$0.project.getMessageBus().syncPublisher(TelephonySessionListener.Companion.getTOPIC())).telephonySessionCreated(RLifetimeKt.intersect((Lifetime)lt, (Lifetime)((Lifetime)session.getSecond())), (TelephonySession)session.getFirst());
        return Unit.INSTANCE;
    }

    private static final Unit adviseOnCount$lambda$0$0$0$0$0$0(TelephonyManager this$0) {
        this$0.joinCall();
        return Unit.INSTANCE;
    }

    private static final BalloonBuilder adviseOnCount$lambda$0$0$0$0$0$1(BalloonBuilder $this$build) {
        Intrinsics.checkNotNullParameter((Object)$this$build, (String)"$this$build");
        $this$build.setCloseButtonEnabled(true);
        BalloonBuilder balloonBuilder = $this$build.setHideOnCloseClick(true);
        Intrinsics.checkNotNullExpressionValue((Object)balloonBuilder, (String)"setHideOnCloseClick(...)");
        return balloonBuilder;
    }

    private static final Balloon adviseOnCount$lambda$0$0$0$0$0(RdUserModel $user, TelephonyManager this$0) {
        Object[] objectArray = new Object[]{$user.getName()};
        return new GotItComponentBuilder(CodeWithMeCommonBundle.INSTANCE.message("notification.user.joined.call.message", objectArray)).withHeader(CodeWithMeCommonBundle.INSTANCE.message("notification.telephonyEnabled.message", new Object[0])).withButtonLabel(CodeWithMeCommonBundle.INSTANCE.message("action.JoinCallAction.text", new Object[0])).onButtonClick(() -> TelephonyManager.adviseOnCount$lambda$0$0$0$0$0$0(this$0)).build(LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)this$0.getServiceLifetime(), null, (int)1, null), TelephonyManager::adviseOnCount$lambda$0$0$0$0$0$1);
    }

    private static final Unit adviseOnCount$lambda$0$0$0$0(LifetimeDefinition $lt, RdUserModel $user, TelephonyManager this$0, Ref.ObjectRef $ballon, boolean isJoinedToCall) {
        block5: {
            if (!isJoinedToCall || !RLifetimeKt.isAlive((Lifetime)((Lifetime)$lt))) break block5;
            LifetimeDefinition.terminate$default((LifetimeDefinition)$lt, (boolean)false, (int)1, null);
            if (UserManagerKt.isMe($user)) {
                return Unit.INSTANCE;
            }
            IdeFrame ideFrame = WindowManager.getInstance().getIdeFrame(this$0.project);
            if (ideFrame == null) {
                return Unit.INSTANCE;
            }
            IdeFrame frame = ideFrame;
            JComponent jComponent = frame.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
            ActionButton actionButton = ActionButtonUtil.findActionButtonById((JComponent)jComponent, (String)"JoinCallAction");
            if (actionButton == null) {
                return Unit.INSTANCE;
            }
            ActionButton button = actionButton;
            $ballon.element = ClientId.Companion.withExplicitClientId(ClientId.Companion.getLocalId(), () -> TelephonyManager.adviseOnCount$lambda$0$0$0$0$0($user, this$0));
            Balloon balloon2 = (Balloon)$ballon.element;
            if (balloon2 != null) {
                balloon2.addListener(new JBPopupListener((Ref.ObjectRef<Balloon>)$ballon){
                    final /* synthetic */ Ref.ObjectRef<Balloon> $ballon;
                    {
                        this.$ballon = $ballon;
                    }

                    public void onClosed(LightweightWindowEvent event) {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        this.$ballon.element = null;
                    }
                });
            }
            Balloon balloon3 = (Balloon)$ballon.element;
            if (balloon3 != null) {
                balloon3.show(RelativePoint.getSouthOf((JComponent)((JComponent)button)), Balloon.Position.below);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit adviseOnCount$lambda$0$0$0(LifetimeDefinition $lt, RdUserModel $user, TelephonyManager this$0, Ref.ObjectRef $ballon, TelephonyProperties it) {
        block0: {
            TelephonyProperties telephonyProperties = it;
            if (telephonyProperties == null || (telephonyProperties = telephonyProperties.isJoinedToCall()) == null) break block0;
            telephonyProperties.advise((Lifetime)$lt, arg_0 -> TelephonyManager.adviseOnCount$lambda$0$0$0$0($lt, $user, this$0, $ballon, arg_0));
        }
        return Unit.INSTANCE;
    }

    private static final Unit adviseOnCount$lambda$0(Ref.ObjectRef $ballon, TelephonyManager this$0, Maybe prev, int current) {
        Intrinsics.checkNotNullParameter((Object)prev, (String)"prev");
        if (current == 0 || ClientId.Companion.isCurrentlyUnderLocalId()) {
            Balloon balloon2 = (Balloon)$ballon.element;
            if (balloon2 != null) {
                balloon2.hideImmediately();
            }
            $ballon.element = null;
        }
        Integer previous = (Integer)prev.getAsNullable();
        if (current != 1) {
            return Unit.INSTANCE;
        }
        if (previous != null && previous != 0) {
            return Unit.INSTANCE;
        }
        UserManager userManager = UserManager.Companion.getInstance(this$0.project);
        LifetimeDefinition lt = this$0.getServiceLifetime().createNested();
        Iterable $this$forEach$iv = (Iterable)userManager.getUsers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RdUserModel user = (RdUserModel)element$iv;
            boolean bl = false;
            RdUserProperties properties = userManager.getUserProperties(user);
            RdUserProperties rdUserProperties = properties;
            if (rdUserProperties == null || (rdUserProperties = rdUserProperties.getTelephonyProperty()) == null) continue;
            rdUserProperties.advise((Lifetime)lt, arg_0 -> TelephonyManager.adviseOnCount$lambda$0$0$0(lt, user, this$0, $ballon, arg_0));
        }
        return Unit.INSTANCE;
    }

    private static final Unit createSession$lambda$0(TelephonyManager this$0) {
        this$0.telephonySessionWithLifetime.set(null);
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TelephonyManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/cwm/plugin/common/telephony/TelephonyManager$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/intellij/cwm/plugin/common/telephony/TelephonyManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.cwm.plugin.common"})
    @SourceDebugExtension(value={"SMAP\nTelephonyManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TelephonyManager.kt\ncom/intellij/cwm/plugin/common/telephony/TelephonyManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,157:1\n30#2,2:158\n*S KotlinDebug\n*F\n+ 1 TelephonyManager.kt\ncom/intellij/cwm/plugin/common/telephony/TelephonyManager$Companion\n*L\n27#1:158,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TelephonyManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<TelephonyManager> serviceClass$iv = TelephonyManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (TelephonyManager)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

