/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.dupLocator.iterators.SingleNodeIterator;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.MatchResultSink;
import com.intellij.structuralsearch.MatchingProcess;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchException;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.UnsupportedPatternException;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.MatcherImplUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.compiler.PatternCompiler;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.TopLevelMatchingHandler;
import com.intellij.structuralsearch.impl.matcher.iterators.SsrFilteringNodeIterator;
import com.intellij.structuralsearch.impl.matcher.strategies.MatchingStrategy;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.structuralsearch.plugin.util.CollectingMatchResultSink;
import com.intellij.structuralsearch.plugin.util.DuplicateFilteringResultSink;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class Matcher {
    public static final Matcher EMPTY = new Matcher();
    private static final Logger LOG = Logger.getInstance(Matcher.class);
    private static final ThreadLocal<Set<String>> ourRecursionGuard = ThreadLocal.withInitial(() -> new HashSet());
    private final Project project;
    private boolean isTesting;
    private final GlobalMatchingVisitor visitor;
    private TaskScheduler scheduler;
    private int totalFilesToScan;
    private int scannedFilesCount;

    private Matcher() {
        this.visitor = new GlobalMatchingVisitor();
        this.project = null;
    }

    public Matcher(@NotNull Project project, @NotNull MatchOptions matchOptions) {
        if (project == null) {
            Matcher.$$$reportNull$$$0(0);
        }
        if (matchOptions == null) {
            Matcher.$$$reportNull$$$0(1);
        }
        this(project, matchOptions, PatternCompiler.compilePattern(project, matchOptions, false, true));
    }

    public Matcher(@NotNull Project project, @NotNull MatchOptions matchOptions, @NotNull CompiledPattern compiledPattern) {
        if (project == null) {
            Matcher.$$$reportNull$$$0(2);
        }
        if (matchOptions == null) {
            Matcher.$$$reportNull$$$0(3);
        }
        if (compiledPattern == null) {
            Matcher.$$$reportNull$$$0(4);
        }
        this.visitor = new GlobalMatchingVisitor();
        this.project = project;
        MatchContext matchContext = this.getMatchContext();
        matchContext.setOptions(matchOptions);
        matchContext.setPattern(compiledPattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Matcher buildMatcher(@NotNull Project project, @NotNull LanguageFileType fileType, @NotNull String constraint) {
        if (project == null) {
            Matcher.$$$reportNull$$$0(5);
        }
        if (fileType == null) {
            Matcher.$$$reportNull$$$0(6);
        }
        if (constraint == null) {
            Matcher.$$$reportNull$$$0(7);
        }
        if (StringUtil.isQuotedString((String)constraint)) {
            MatchOptions matchOptions = new MatchOptions();
            matchOptions.setFileType(fileType);
            matchOptions.fillSearchCriteria(StringUtil.unquoteString((String)constraint));
            return new Matcher(project, matchOptions);
        }
        Set<String> set = ourRecursionGuard.get();
        if (!set.add(constraint)) {
            throw new MalformedPatternException(SSRBundle.message("error.pattern.recursively.references.itself", new Object[0]));
        }
        try {
            Configuration configuration = ConfigurationManager.getInstance(project).findConfigurationByName(constraint);
            if (configuration == null) {
                throw new MalformedPatternException(SSRBundle.message("error.configuration.0.not.found", constraint));
            }
            Matcher matcher = new Matcher(project, configuration.getMatchOptions());
            return matcher;
        }
        finally {
            set.remove(constraint);
            if (set.isEmpty()) {
                ourRecursionGuard.remove();
            }
        }
    }

    public static void validate(Project project, MatchOptions options) {
        PatternCompiler.compilePattern(project, options, true, true);
    }

    public boolean checkIfShouldAttemptToMatch(@NotNull NodeIterator matchedNodes) {
        if (matchedNodes == null) {
            Matcher.$$$reportNull$$$0(8);
        }
        MatchContext matchContext = this.getMatchContext();
        CompiledPattern pattern = matchContext.getPattern();
        NodeIterator patternNodes = pattern.getNodes();
        try {
            while (true) {
                PsiElement patternNode;
                if ((patternNode = patternNodes.current()) == null) {
                    boolean bl = true;
                    return bl;
                }
                PsiElement matchedNode = matchedNodes.current();
                if (matchedNode == null) {
                    boolean bl = false;
                    return bl;
                }
                MatchingHandler matchingHandler = pattern.getHandler(patternNode);
                if (!matchingHandler.canMatch(patternNode, matchedNode, matchContext)) {
                    boolean bl = false;
                    return bl;
                }
                matchedNodes.advance();
                patternNodes.advance();
            }
        }
        finally {
            patternNodes.reset();
            matchedNodes.reset();
        }
    }

    public void processMatchesInElement(NodeIterator matchedNodes) {
        try {
            this.visitor.matchContext(matchedNodes);
        }
        finally {
            matchedNodes.reset();
        }
    }

    public boolean matchNode(@NotNull PsiElement element) {
        if (element == null) {
            Matcher.$$$reportNull$$$0(9);
        }
        MatchContext matchContext = this.getMatchContext();
        matchContext.clear();
        CollectingMatchResultSink sink = new CollectingMatchResultSink();
        matchContext.setSink(new DuplicateFilteringResultSink(sink));
        CompiledPattern compiledPattern = matchContext.getPattern();
        if (compiledPattern == null) {
            return false;
        }
        matchContext.setShouldRecursivelyMatch(false);
        this.visitor.matchContext((NodeIterator)SingleNodeIterator.create((PsiElement)element));
        return !sink.getMatches().isEmpty();
    }

    public void findMatches(MatchResultSink sink) throws MalformedPatternException, UnsupportedPatternException {
        MatchContext matchContext = this.getMatchContext();
        matchContext.clear();
        matchContext.setSink(new DuplicateFilteringResultSink(sink));
        CompiledPattern compiledPattern = matchContext.getPattern();
        if (compiledPattern == null) {
            return;
        }
        if (this.isTesting) {
            LocalSearchScope scope = (LocalSearchScope)matchContext.getOptions().getScope();
            assert (scope != null);
            PsiElement[] elements = scope.getScope();
            PsiElement parent = elements[0].getParent();
            if (matchContext.getPattern().getStrategy().continueMatching(parent != null ? parent : elements[0])) {
                this.visitor.matchContext(SsrFilteringNodeIterator.create(elements));
            } else {
                for (PsiElement element : elements) {
                    this.match(element);
                }
            }
            matchContext.getSink().matchingFinished();
        } else {
            if (this.scheduler == null) {
                this.scheduler = new TaskScheduler();
            }
            matchContext.getSink().setMatchingProcess(this.scheduler);
            this.scheduler.init();
            PsiManager.getInstance((Project)this.project).runInBatchFilesMode(() -> {
                this.findMatches();
                if (this.scheduler.getTaskQueueEndAction() == null) {
                    this.scheduler.setTaskQueueEndAction(() -> matchContext.getSink().matchingFinished());
                }
                this.scheduler.executeNext();
                return null;
            });
        }
    }

    private void findMatches() {
        boolean ourOptimizedScope;
        MatchContext matchContext = this.getMatchContext();
        MatchOptions options = matchContext.getOptions();
        CompiledPattern compiledPattern = matchContext.getPattern();
        SearchScope searchScope = compiledPattern.getScope();
        boolean bl = ourOptimizedScope = searchScope != null;
        if (!ourOptimizedScope) {
            searchScope = options.getScope();
        }
        if (searchScope instanceof GlobalSearchScope) {
            GlobalSearchScope scope = (GlobalSearchScope)searchScope;
            ContentIterator ci = fileOrDir -> {
                if (!fileOrDir.isDirectory() && scope.contains(fileOrDir) && !FileTypeRegistry.getInstance().isFileOfType(fileOrDir, FileTypes.UNKNOWN)) {
                    ++this.totalFilesToScan;
                    this.scheduler.addOneTask(new MatchOneVirtualFile(fileOrDir));
                }
                return true;
            };
            ProgressIndicator progress = matchContext.getSink().getProgressIndicator();
            ReadAction.run(() -> FileBasedIndex.getInstance().iterateIndexableFiles(ci, this.project, progress));
            if (progress != null) {
                progress.setText2("");
            }
        } else {
            LocalSearchScope scope = (LocalSearchScope)searchScope;
            assert (scope != null);
            PsiElement[] elementsToScan = scope.getScope();
            this.totalFilesToScan = elementsToScan.length;
            for (int i = 0; i < elementsToScan.length; ++i) {
                PsiElement psiElement = elementsToScan[i];
                if (psiElement == null) continue;
                this.scheduler.addOneTask(new MatchOnePsiFile(this, psiElement));
                if (!ourOptimizedScope) continue;
                elementsToScan[i] = null;
            }
        }
    }

    @NotNull
    public MatchContext getMatchContext() {
        MatchContext matchContext = this.visitor.getMatchContext();
        if (matchContext == null) {
            Matcher.$$$reportNull$$$0(10);
        }
        return matchContext;
    }

    public Project getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MatchResult> testFindMatches(String source, boolean fileContext, LanguageFileType sourceFileType, boolean physicalSourceFile) throws MalformedPatternException, UnsupportedPatternException {
        CollectingMatchResultSink sink = new CollectingMatchResultSink();
        MatchOptions options = this.getMatchContext().getOptions();
        try {
            if (options.getScope() == null) {
                PsiElement[] elements = MatcherImplUtil.createSourceTreeFromText(source, fileContext ? PatternTreeContext.File : PatternTreeContext.Block, sourceFileType, this.project, physicalSourceFile);
                options.setScope((SearchScope)new LocalSearchScope(elements));
            }
            this.testFindMatches(sink);
        }
        finally {
            options.setScope(null);
        }
        return sink.getMatches();
    }

    public void testFindMatches(MatchResultSink sink) throws MalformedPatternException, UnsupportedPatternException {
        this.isTesting = true;
        try {
            this.findMatches(sink);
        }
        finally {
            this.isTesting = false;
        }
    }

    private void match(@NotNull PsiElement element) {
        MatchContext context;
        MatchingStrategy strategy;
        if (element == null) {
            Matcher.$$$reportNull$$$0(11);
        }
        if ((strategy = (context = this.getMatchContext()).getPattern().getStrategy()).continueMatching(element)) {
            this.visitor.matchContext((NodeIterator)SingleNodeIterator.create((PsiElement)element));
            return;
        }
        if (context.getOptions().isSearchInjectedCode()) {
            for (PsiElement el = element.getFirstChild(); el != null; el = el.getNextSibling()) {
                this.match(el);
            }
            if (element instanceof PsiLanguageInjectionHost) {
                InjectedLanguageManager.getInstance((Project)this.project).enumerateEx(element, element.getContainingFile(), false, (injectedPsi, places) -> this.match((PsiElement)injectedPsi));
            }
        }
    }

    @NotNull
    public List<MatchResult> matchByDownUp(PsiElement element) throws MalformedPatternException, UnsupportedPatternException {
        MatchContext matchContext = this.getMatchContext();
        matchContext.clear();
        CollectingMatchResultSink sink = new CollectingMatchResultSink();
        matchContext.setSink(new DuplicateFilteringResultSink(sink));
        CompiledPattern compiledPattern = matchContext.getPattern();
        matchContext.setShouldRecursivelyMatch(false);
        PsiElement targetNode = compiledPattern.getTargetNode();
        PsiElement elementToStartMatching = null;
        if (targetNode == null) {
            targetNode = compiledPattern.getNodes().current();
            if (targetNode != null) {
                compiledPattern.getNodes().advance();
                assert (!compiledPattern.getNodes().hasNext());
                compiledPattern.getNodes().rewind();
                element = element.getParent();
                if (element == null) {
                    List<MatchResult> list = Collections.emptyList();
                    if (list == null) {
                        Matcher.$$$reportNull$$$0(12);
                    }
                    return list;
                }
                while (element.getClass() != targetNode.getClass()) {
                    if ((element = element.getParent()) != null) continue;
                    List<MatchResult> list = Collections.emptyList();
                    if (list == null) {
                        Matcher.$$$reportNull$$$0(13);
                    }
                    return list;
                }
                elementToStartMatching = element;
            }
        } else {
            StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement(element);
            if (profile == null) {
                List<MatchResult> list = Collections.emptyList();
                if (list == null) {
                    Matcher.$$$reportNull$$$0(14);
                }
                return list;
            }
            targetNode = profile.extendMatchedByDownUp(targetNode);
            MatchOptions options = matchContext.getOptions();
            MatchingHandler handler = null;
            while (element.getClass() == targetNode.getClass() || compiledPattern.isTypedVar(targetNode) && compiledPattern.getHandler(targetNode).canMatch(targetNode, element, matchContext)) {
                handler = compiledPattern.getHandler(targetNode);
                handler.setPinnedElement(element);
                elementToStartMatching = element;
                if (handler instanceof TopLevelMatchingHandler) break;
                element = element.getParent();
                targetNode = targetNode.getParent();
                if (!options.isLooseMatching()) continue;
                element = profile.updateCurrentNode(element);
                targetNode = profile.updateCurrentNode(targetNode);
            }
            if (!(handler instanceof TopLevelMatchingHandler)) {
                List<MatchResult> list = Collections.emptyList();
                if (list == null) {
                    Matcher.$$$reportNull$$$0(15);
                }
                return list;
            }
        }
        assert (targetNode != null) : "Could not match down up when no target node";
        this.visitor.matchContext((NodeIterator)SingleNodeIterator.create(elementToStartMatching));
        matchContext.getSink().matchingFinished();
        List<MatchResult> list = sink.getMatches();
        if (list == null) {
            Matcher.$$$reportNull$$$0(16);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 12, 13, 14, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchOptions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compiledPattern";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraint";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchedNodes";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/Matcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/Matcher";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMatchContext";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "matchByDownUp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildMatcher";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkIfShouldAttemptToMatch";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "matchNode";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 12, 13, 14, 15, 16 -> new IllegalStateException(string);
        };
    }

    class TaskScheduler
    implements MatchingProcess {
        private List<Runnable> tasks = new SmartList();
        private boolean ended;
        private Runnable taskQueueEndAction;
        private boolean suspended;

        TaskScheduler() {
        }

        @Override
        public void stop() {
            this.ended = true;
        }

        @Override
        public void pause() {
            this.suspended = true;
        }

        @Override
        public void resume() {
            if (!this.suspended) {
                return;
            }
            this.suspended = false;
            PsiManager.getInstance((Project)Matcher.this.project).runInBatchFilesMode(() -> {
                this.executeNext();
                return null;
            });
        }

        @Override
        public boolean isSuspended() {
            return this.suspended;
        }

        @Override
        public boolean isEnded() {
            return this.ended;
        }

        void setTaskQueueEndAction(Runnable taskQueueEndAction) {
            this.taskQueueEndAction = taskQueueEndAction;
        }

        Runnable getTaskQueueEndAction() {
            return this.taskQueueEndAction;
        }

        void addOneTask(Runnable runnable) {
            this.tasks.add(runnable);
        }

        void executeNext() {
            while (!this.suspended && !this.ended) {
                if (this.tasks.isEmpty()) {
                    this.ended = true;
                    break;
                }
                Runnable task = this.tasks.remove(this.tasks.size() - 1);
                try {
                    task.run();
                }
                catch (ProcessCanceledException | StructuralSearchException e) {
                    this.ended = true;
                    this.clearSchedule();
                    throw e;
                }
                catch (Throwable th) {
                    LOG.error(th);
                }
            }
            if (this.ended) {
                this.clearSchedule();
            }
        }

        void init() {
            assert (Matcher.this.project != null);
            this.ended = false;
            this.suspended = false;
        }

        private void clearSchedule() {
            assert (Matcher.this.project != null);
            if (this.tasks != null) {
                this.taskQueueEndAction.run();
                this.tasks = null;
            }
        }
    }

    private class MatchOnePsiFile
    extends MatchOneFile {
        private PsiElement file;

        MatchOnePsiFile(Matcher matcher, PsiElement file) {
            this.file = file;
        }

        @Override
        @NotNull
        protected List<PsiElement> getPsiElementsToProcess() {
            PsiElement file = this.file;
            this.file = null;
            return new SmartList((Object)file);
        }
    }

    private class MatchOneVirtualFile
    extends MatchOneFile {
        private final VirtualFile myFile;

        MatchOneVirtualFile(VirtualFile file) {
            this.myFile = file;
        }

        @Override
        @NotNull
        protected List<PsiElement> getPsiElementsToProcess() {
            assert (Matcher.this.project != null);
            List list = (List)ReadAction.compute(() -> {
                if (!this.myFile.isValid()) {
                    return Collections.emptyList();
                }
                PsiFile file = PsiManager.getInstance((Project)Matcher.this.project).findFile(this.myFile);
                if (file == null) {
                    return Collections.emptyList();
                }
                FileViewProvider viewProvider = file.getViewProvider();
                SmartList elementsToProcess = new SmartList();
                for (Language lang : viewProvider.getLanguages()) {
                    elementsToProcess.add(viewProvider.getPsi(lang));
                }
                return elementsToProcess;
            });
            if (list == null) {
                MatchOneVirtualFile.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/structuralsearch/Matcher$MatchOneVirtualFile", "getPsiElementsToProcess"));
        }
    }

    private abstract class MatchOneFile
    implements Runnable {
        private MatchOneFile() {
        }

        @Override
        public void run() {
            assert (Matcher.this.project != null);
            List<PsiElement> files = this.getPsiElementsToProcess();
            MatchContext matchContext = Matcher.this.getMatchContext();
            ProgressIndicator progress = matchContext.getSink().getProgressIndicator();
            if (progress != null) {
                progress.setFraction((double)Matcher.this.scannedFilesCount / (double)Matcher.this.totalFilesToScan);
            }
            ++Matcher.this.scannedFilesCount;
            if (files.isEmpty()) {
                return;
            }
            for (PsiElement file : files) {
                if (file instanceof PsiFile) {
                    matchContext.getSink().processFile((PsiFile)file);
                }
                ReadAction.nonBlocking(() -> {
                    if (!file.isValid()) {
                        return;
                    }
                    Matcher.this.match(file);
                }).inSmartMode(Matcher.this.project).executeSynchronously();
            }
        }

        @NotNull
        protected abstract List<PsiElement> getPsiElementsToProcess();
    }
}

